/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.checks.WearDetector;
import com.android.tools.lint.detector.api.BinaryResourceScanner;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.XmlUtils;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 !2\u00020\u00012\u00020\u00022\u00020\u0003:\u0002!\"B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u001c\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u001c\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0014H\u0002J\u0018\u0010 \u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0014H\u0002R\u001a\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/android/tools/lint/checks/TileProviderDetector;", "Lcom/android/tools/lint/checks/WearDetector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "Lcom/android/tools/lint/detector/api/BinaryResourceScanner;", "<init>", "()V", "foundIcons", "", "", "Lcom/android/tools/lint/checks/TileProviderDetector$IconInfo;", "beforeCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "afterCheckRootProject", "getApplicableElements", "", "visitElement", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "getImageDimensions", "Lkotlin/Pair;", "", "checkBinaryResource", "Lcom/android/tools/lint/detector/api/ResourceContext;", "checkResourcesWithIcons", "service", "checkTileProvider", "Issues", "IconInfo", "android.sdktools.lint-checks"})
public final class TileProviderDetector
extends WearDetector
implements XmlScanner,
BinaryResourceScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @NotNull
    private final Map<String, IconInfo> foundIcons = new LinkedHashMap();
    public static final int MIN_PREVIEW_SIZE = 384;
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(TileProviderDetector.class, EnumSet.of((Enum)Scope.BINARY_RESOURCE_FILE, (Enum)Scope.MANIFEST));
    @JvmField
    @NotNull
    public static final Issue TILE_PROVIDER_PERMISSIONS;
    @JvmField
    @NotNull
    public static final Issue SQUARE_AND_ROUND_TILE_PREVIEWS;
    @JvmField
    @NotNull
    public static final Issue TILE_PREVIEW_IMAGE_FORMAT;
    @NotNull
    public static final String BIND_TILE_PROVIDER_PERMISSION = "com.google.android.wearable.permission.BIND_TILE_PROVIDER";
    @NotNull
    public static final String TILES_PREVIEW_ATTR_NAME = "androidx.wear.tiles.PREVIEW";
    @NotNull
    public static final String BIND_TILE_PROVIDER_ACTION = "androidx.wear.tiles.action.BIND_TILE_PROVIDER";

    @Override
    public void beforeCheckRootProject(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        super.beforeCheckRootProject(context2);
        this.foundIcons.clear();
    }

    @Override
    public void afterCheckRootProject(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Iterator<Map.Entry<String, IconInfo>> iterator = this.foundIcons.entrySet().iterator();
        while (iterator.hasNext()) {
            IconInfo metadata = iterator.next().getValue();
            if (metadata.getFoundRoundPreview() ^ metadata.getFoundSquarePreview()) {
                context2.report(new Incident(SQUARE_AND_ROUND_TILE_PREVIEWS, metadata.getIssueScope(), metadata.getIssueLocation(), "Tiles need a preview asset in both drawable-round and drawable"));
            }
            if (metadata.getWrongAspectRatio()) {
                context2.report(new Incident(TILE_PREVIEW_IMAGE_FORMAT, metadata.getIssueScope(), metadata.getIssueLocation(), "Tile previews should have 1:1 aspect ratio"));
            }
            if (!metadata.getSmallImageSize()) continue;
            context2.report(new Incident(TILE_PREVIEW_IMAGE_FORMAT, metadata.getIssueScope(), metadata.getIssueLocation(), "Tile previews should be at least 384px by 384px"));
        }
    }

    @NotNull
    public List<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"service");
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Iterator iterator = TileProviderDetector.Issues.subElementsByTag(element, "intent-filter");
        while (iterator.hasNext()) {
            Element intentFilter = (Element)iterator.next();
            Iterator iterator2 = TileProviderDetector.Issues.subElementsByTag(intentFilter, "action");
            while (iterator2.hasNext()) {
                Element action = (Element)iterator2.next();
                if (!Intrinsics.areEqual((Object)action.getAttributeNS("http://schemas.android.com/apk/res/android", "name"), (Object)BIND_TILE_PROVIDER_ACTION)) continue;
                this.checkTileProvider(context2, element);
                this.checkResourcesWithIcons(context2, element);
            }
        }
    }

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return this.isWearProject() && folderType == ResourceFolderType.DRAWABLE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final Pair<Integer, Integer> getImageDimensions(Context context2) {
        Iterator<ImageReader> readers = ImageIO.getImageReadersBySuffix(FilesKt.getExtension((File)context2.file));
        while (readers.hasNext()) {
            ImageReader reader = readers.next();
            try {
                reader.setInput(ImageIO.createImageInputStream(context2.file));
                int width = reader.getWidth(reader.getMinIndex());
                int height = reader.getHeight(reader.getMinIndex());
                Pair pair2 = new Pair((Object)width, (Object)height);
                return pair2;
            }
            catch (IOException e) {
                context2.log(e, "Error reading file: " + context2.file.getName(), new Object[0]);
            }
            finally {
                reader.dispose();
            }
        }
        return new Pair((Object)0, (Object)0);
    }

    @Override
    public void checkBinaryResource(@NotNull ResourceContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        String iconName = FilesKt.getNameWithoutExtension((File)context2.file);
        IconInfo iconInfo = this.foundIcons.get(iconName);
        if (iconInfo == null) {
            return;
        }
        IconInfo metadata = iconInfo;
        Pair<Integer, Integer> size = this.getImageDimensions(context2);
        if (((Number)size.getFirst()).intValue() != ((Number)size.getSecond()).intValue()) {
            metadata.setWrongAspectRatio(true);
        }
        if (((Number)size.getFirst()).intValue() < 384 || ((Number)size.getSecond()).intValue() < 384) {
            metadata.setSmallImageSize(true);
        }
        String dirName = context2.file.getParentFile().getName();
        Intrinsics.checkNotNull((Object)dirName);
        if (StringsKt.startsWith$default((String)dirName, (String)"drawable", (boolean)false, (int)2, null)) {
            if (StringsKt.contains$default((CharSequence)dirName, (CharSequence)"round", (boolean)false, (int)2, null)) {
                metadata.setFoundRoundPreview(true);
            } else {
                metadata.setFoundSquarePreview(true);
            }
        }
    }

    private final void checkResourcesWithIcons(XmlContext context2, Element service) {
        Element foundMetaData = null;
        Iterator iterator = TileProviderDetector.Issues.subElementsByTag(service, "meta-data");
        while (iterator.hasNext()) {
            String iconName;
            Attr iconAttr;
            Element metaData = (Element)iterator.next();
            if (!Intrinsics.areEqual((Object)metaData.getAttributeNS("http://schemas.android.com/apk/res/android", "name"), (Object)TILES_PREVIEW_ATTR_NAME) || (foundMetaData = metaData).getAttributeNodeNS("http://schemas.android.com/apk/res/android", "resource") == null) continue;
            String iconUrl = iconAttr.getValue();
            Intrinsics.checkNotNull((Object)iconUrl);
            if (!StringsKt.startsWith$default((String)iconUrl, (String)"@drawable/", (boolean)false, (int)2, null)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)iconUrl.substring(10), (String)"substring(...)");
            this.foundIcons.put(iconName, new IconInfo(foundMetaData, context2.getValueLocation(iconAttr), false, false, false, false, 60, null));
        }
        if (foundMetaData == null) {
            context2.report(new Incident(SQUARE_AND_ROUND_TILE_PREVIEWS, service, context2.getLocation(service), "Tiles need preview assets"));
        }
    }

    private final void checkTileProvider(XmlContext context2, Element service) {
        String permission = service.getAttributeNS("http://schemas.android.com/apk/res/android", "permission");
        if (!Intrinsics.areEqual((Object)permission, (Object)BIND_TILE_PROVIDER_PERMISSION)) {
            LintFix.SetAttributeBuilder setAttributeBuilder = this.fix().set().attribute("permission").value(BIND_TILE_PROVIDER_PERMISSION).android();
            Intrinsics.checkNotNull((Object)permission);
            LintFix fix2 = setAttributeBuilder.name(((CharSequence)permission).length() == 0 ? "Add BIND_TILE_PROVIDER permission" : "Change permission to BIND_TILE_PROVIDER").build();
            context2.report(new Incident(TILE_PROVIDER_PERMISSIONS, service, context2.getNameLocation(service), "TileProvider does not specify BIND_TILE_PROVIDER permission", fix2));
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.SECURITY;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(TileProviderDetector.class, Scope.MANIFEST_SCOPE);
        TILE_PROVIDER_PERMISSIONS = Issue.Companion.create$default(companion, "TileProviderPermissions", "TileProvider does not set permission", "\n                TileProviders should require the `com.google.android.wearable.permission.BIND_TILE_PROVIDER` \\\n                permission to prevent arbitrary apps from binding to it.\n            ", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
        companion = Issue.Companion;
        category = Category.ICONS;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        SQUARE_AND_ROUND_TILE_PREVIEWS = Issue.Companion.create$default(companion, "SquareAndRoundTilePreviews", "TileProvider does not have round and square previews", "\n                Tile projects should specify preview resources for different screen shapes. \\\n                The preview resource is specified in the manifest under tile service. \\\n                And you have to make sure they have resources for different screen shapes.\n            ", implementation, null, category, 6, severity, false, true, null, null, 3344, null).addMoreInfo("https://developer.android.com/design/ui/wear/guides/surfaces/tiles#tile-previews");
        companion = Issue.Companion;
        category = Category.ICONS;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        TILE_PREVIEW_IMAGE_FORMAT = Issue.Companion.create$default(companion, "TilePreviewImageFormat", "Tile preview is not compliant with standards", "\n                Tile projects should specify preview resources with aspect ratio 1:1 and at least 384px by 384px in size.\n            ", implementation, null, category, 6, severity, false, true, null, null, 3344, null).addMoreInfo("https://developer.android.com/design/ui/wear/guides/surfaces/tiles#tile-previews");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u001d\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B?\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007\u0012\b\b\u0002\u0010\t\u001a\u00020\u0007\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u00a2\u0006\u0004\b\u000b\u0010\fJ\t\u0010\u001b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001d\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001e\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001f\u001a\u00020\u0007H\u00c6\u0003J\t\u0010 \u001a\u00020\u0007H\u00c6\u0003JE\u0010!\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\u00072\b\b\u0002\u0010\n\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\"\u001a\u00020\u00072\b\u0010#\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010$\u001a\u00020%H\u00d6\u0001J\t\u0010&\u001a\u00020'H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u001a\u0010\b\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0012\"\u0004\b\u0016\u0010\u0014R\u001a\u0010\t\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0012\"\u0004\b\u0018\u0010\u0014R\u001a\u0010\n\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u0012\"\u0004\b\u001a\u0010\u0014\u00a8\u0006("}, d2={"Lcom/android/tools/lint/checks/TileProviderDetector$IconInfo;", "", "issueScope", "Lorg/w3c/dom/Node;", "issueLocation", "Lcom/android/tools/lint/detector/api/Location;", "foundRoundPreview", "", "foundSquarePreview", "wrongAspectRatio", "smallImageSize", "<init>", "(Lorg/w3c/dom/Node;Lcom/android/tools/lint/detector/api/Location;ZZZZ)V", "getIssueScope", "()Lorg/w3c/dom/Node;", "getIssueLocation", "()Lcom/android/tools/lint/detector/api/Location;", "getFoundRoundPreview", "()Z", "setFoundRoundPreview", "(Z)V", "getFoundSquarePreview", "setFoundSquarePreview", "getWrongAspectRatio", "setWrongAspectRatio", "getSmallImageSize", "setSmallImageSize", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "", "android.sdktools.lint-checks"})
    public static final class IconInfo {
        @NotNull
        private final Node issueScope;
        @NotNull
        private final Location issueLocation;
        private boolean foundRoundPreview;
        private boolean foundSquarePreview;
        private boolean wrongAspectRatio;
        private boolean smallImageSize;

        public IconInfo(@NotNull Node issueScope, @NotNull Location issueLocation, boolean foundRoundPreview, boolean foundSquarePreview, boolean wrongAspectRatio, boolean smallImageSize) {
            Intrinsics.checkNotNullParameter((Object)issueScope, (String)"issueScope");
            Intrinsics.checkNotNullParameter((Object)issueLocation, (String)"issueLocation");
            this.issueScope = issueScope;
            this.issueLocation = issueLocation;
            this.foundRoundPreview = foundRoundPreview;
            this.foundSquarePreview = foundSquarePreview;
            this.wrongAspectRatio = wrongAspectRatio;
            this.smallImageSize = smallImageSize;
        }

        public /* synthetic */ IconInfo(Node node, Location location, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                bl2 = false;
            }
            if ((n & 0x10) != 0) {
                bl3 = false;
            }
            if ((n & 0x20) != 0) {
                bl4 = false;
            }
            this(node, location, bl, bl2, bl3, bl4);
        }

        @NotNull
        public final Node getIssueScope() {
            return this.issueScope;
        }

        @NotNull
        public final Location getIssueLocation() {
            return this.issueLocation;
        }

        public final boolean getFoundRoundPreview() {
            return this.foundRoundPreview;
        }

        public final void setFoundRoundPreview(boolean bl) {
            this.foundRoundPreview = bl;
        }

        public final boolean getFoundSquarePreview() {
            return this.foundSquarePreview;
        }

        public final void setFoundSquarePreview(boolean bl) {
            this.foundSquarePreview = bl;
        }

        public final boolean getWrongAspectRatio() {
            return this.wrongAspectRatio;
        }

        public final void setWrongAspectRatio(boolean bl) {
            this.wrongAspectRatio = bl;
        }

        public final boolean getSmallImageSize() {
            return this.smallImageSize;
        }

        public final void setSmallImageSize(boolean bl) {
            this.smallImageSize = bl;
        }

        @NotNull
        public final Node component1() {
            return this.issueScope;
        }

        @NotNull
        public final Location component2() {
            return this.issueLocation;
        }

        public final boolean component3() {
            return this.foundRoundPreview;
        }

        public final boolean component4() {
            return this.foundSquarePreview;
        }

        public final boolean component5() {
            return this.wrongAspectRatio;
        }

        public final boolean component6() {
            return this.smallImageSize;
        }

        @NotNull
        public final IconInfo copy(@NotNull Node issueScope, @NotNull Location issueLocation, boolean foundRoundPreview, boolean foundSquarePreview, boolean wrongAspectRatio, boolean smallImageSize) {
            Intrinsics.checkNotNullParameter((Object)issueScope, (String)"issueScope");
            Intrinsics.checkNotNullParameter((Object)issueLocation, (String)"issueLocation");
            return new IconInfo(issueScope, issueLocation, foundRoundPreview, foundSquarePreview, wrongAspectRatio, smallImageSize);
        }

        public static /* synthetic */ IconInfo copy$default(IconInfo iconInfo, Node node, Location location, boolean bl, boolean bl2, boolean bl3, boolean bl4, int n, Object object) {
            if ((n & 1) != 0) {
                node = iconInfo.issueScope;
            }
            if ((n & 2) != 0) {
                location = iconInfo.issueLocation;
            }
            if ((n & 4) != 0) {
                bl = iconInfo.foundRoundPreview;
            }
            if ((n & 8) != 0) {
                bl2 = iconInfo.foundSquarePreview;
            }
            if ((n & 0x10) != 0) {
                bl3 = iconInfo.wrongAspectRatio;
            }
            if ((n & 0x20) != 0) {
                bl4 = iconInfo.smallImageSize;
            }
            return iconInfo.copy(node, location, bl, bl2, bl3, bl4);
        }

        @NotNull
        public String toString() {
            return "IconInfo(issueScope=" + this.issueScope + ", issueLocation=" + this.issueLocation + ", foundRoundPreview=" + this.foundRoundPreview + ", foundSquarePreview=" + this.foundSquarePreview + ", wrongAspectRatio=" + this.wrongAspectRatio + ", smallImageSize=" + this.smallImageSize + ")";
        }

        public int hashCode() {
            int result2 = this.issueScope.hashCode();
            result2 = result2 * 31 + this.issueLocation.hashCode();
            result2 = result2 * 31 + Boolean.hashCode(this.foundRoundPreview);
            result2 = result2 * 31 + Boolean.hashCode(this.foundSquarePreview);
            result2 = result2 * 31 + Boolean.hashCode(this.wrongAspectRatio);
            result2 = result2 * 31 + Boolean.hashCode(this.smallImageSize);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IconInfo)) {
                return false;
            }
            IconInfo iconInfo = (IconInfo)other;
            if (!Intrinsics.areEqual((Object)this.issueScope, (Object)iconInfo.issueScope)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.issueLocation, (Object)iconInfo.issueLocation)) {
                return false;
            }
            if (this.foundRoundPreview != iconInfo.foundRoundPreview) {
                return false;
            }
            if (this.foundSquarePreview != iconInfo.foundSquarePreview) {
                return false;
            }
            if (this.wrongAspectRatio != iconInfo.wrongAspectRatio) {
                return false;
            }
            return this.smallImageSize == iconInfo.smallImageSize;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u0016B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013*\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u000fH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000fX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/lint/checks/TileProviderDetector$Issues;", "", "<init>", "()V", "MIN_PREVIEW_SIZE", "", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "getIMPLEMENTATION", "()Lcom/android/tools/lint/detector/api/Implementation;", "TILE_PROVIDER_PERMISSIONS", "Lcom/android/tools/lint/detector/api/Issue;", "SQUARE_AND_ROUND_TILE_PREVIEWS", "TILE_PREVIEW_IMAGE_FORMAT", "BIND_TILE_PROVIDER_PERMISSION", "", "TILES_PREVIEW_ATTR_NAME", "BIND_TILE_PROVIDER_ACTION", "subElementsByTag", "", "Lorg/w3c/dom/Element;", "tag", "TagIterator", "android.sdktools.lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        @NotNull
        public final Implementation getIMPLEMENTATION() {
            return IMPLEMENTATION;
        }

        private final Iterator<Element> subElementsByTag(Element $this$subElementsByTag, String tag) {
            return new TagIterator($this$subElementsByTag, tag);
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010(\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000b\u001a\u00020\fH\u0096\u0002J\t\u0010\r\u001a\u00020\u0002H\u0096\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u0004\u0018\u00010\u0002X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/TileProviderDetector$Issues$TagIterator;", "", "Lorg/w3c/dom/Element;", "element", "tag", "", "<init>", "(Lorg/w3c/dom/Element;Ljava/lang/String;)V", "getTag", "()Ljava/lang/String;", "subElement", "hasNext", "", "next", "android.sdktools.lint-checks"})
        public static final class TagIterator
        implements Iterator<Element>,
        KMappedMarker {
            @NotNull
            private final String tag;
            @Nullable
            private Element subElement;

            public TagIterator(@NotNull Element element, @NotNull String tag) {
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
                this.tag = tag;
                this.subElement = XmlUtils.getFirstSubTagByName((Node)element, (String)this.tag);
            }

            @NotNull
            public final String getTag() {
                return this.tag;
            }

            @Override
            public boolean hasNext() {
                return this.subElement != null;
            }

            @Override
            @NotNull
            public Element next() {
                Element tmp = this.subElement;
                this.subElement = XmlUtils.getNextTagByName((Node)this.subElement, (String)this.tag);
                Element element = tmp;
                Intrinsics.checkNotNull((Object)element);
                return element;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Operation is not supported for read-only collection");
            }
        }
    }
}

