/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.CharsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\u0018\u0010\u0011\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0010H\u0002J(\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0016\u001a\u00020\u0006H\u0002\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/lint/checks/StringEscapeDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "<init>", "()V", "getApplicableElements", "", "", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "findTextNode", "parent", "checkXmlEscapes", "textNode", "Lorg/w3c/dom/Node;", "string", "Issues", "android.sdktools.lint-checks"})
public final class StringEscapeDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @JvmField
    @NotNull
    public static final Issue STRING_ESCAPING = Issue.Companion.create("StringEscaping", "Invalid string escapes", "\n                Apostrophes (') must always be escaped (with a \\\\\\\\), unless they appear \\\n                in a string which is itself escaped in double quotes (\\\").\n                ", Category.MESSAGES, 9, Severity.ERROR, new Implementation(StringEscapeDetector.class, Scope.RESOURCE_FILE_SCOPE));

    @NotNull
    public List<String> getApplicableElements() {
        Object[] objectArray = new String[]{"string", "string-array", "plurals"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.VALUES;
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        block13: {
            Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            String string2 = element.getTagName();
            if (string2 == null) break block13;
            int n = -1;
            switch (string2.hashCode()) {
                case -1024600675: {
                    if (string2.equals("string-array")) {
                        n = 1;
                    }
                    break;
                }
                case -891985903: {
                    if (string2.equals("string")) {
                        n = 2;
                    }
                    break;
                }
                case -475309713: {
                    if (string2.equals("plurals")) {
                        n = 1;
                    }
                    break;
                }
            }
            switch (n) {
                case 2: {
                    this.findTextNode(context2, element);
                    break;
                }
                case 1: {
                    int n2 = element.getChildNodes().getLength();
                    for (int index2 = 0; index2 < n2; ++index2) {
                        Node child = element.getChildNodes().item(index2);
                        if (child.getNodeType() != 1) continue;
                        Intrinsics.checkNotNull((Object)child, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                        this.findTextNode(context2, (Element)child);
                    }
                    break;
                }
            }
        }
    }

    private final void findTextNode(XmlContext context2, Element parent) {
        int n = parent.getChildNodes().getLength();
        for (int index2 = 0; index2 < n; ++index2) {
            Node child = parent.getChildNodes().item(index2);
            if (child.getNodeType() != 3 && child.getNodeType() != 4) continue;
            Intrinsics.checkNotNull((Object)child);
            String string2 = child.getNodeValue();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getNodeValue(...)");
            this.checkXmlEscapes(context2, child, parent, string2);
            return;
        }
    }

    private final void checkXmlEscapes(XmlContext context2, Node textNode, Element element, String string2) {
        int len;
        int s = 0;
        int n = len = string2.length();
        while (len > 0 && CharsKt.isWhitespace((char)string2.charAt(s))) {
            ++s;
            --len;
        }
        while (len > 0 && CharsKt.isWhitespace((char)string2.charAt(s + len - 1))) {
            --len;
        }
        if (len > 0 && string2.charAt(s + len - 1) == '\\' && s + len < n) {
            ++len;
        }
        char quoted = '\u0000';
        int p = s;
        while (p < s + len) {
            char c;
            while (p < s + len && (c = string2.charAt(p)) != '\\' && (quoted != '\u0000' || !CharsKt.isWhitespace((char)c) || c == ' ' && p != n - 1 && !CharsKt.isWhitespace((char)string2.charAt(p + 1))) && (c != '\"' || quoted != '\u0000' && quoted != '\"')) {
                if (c == '\'' && (quoted == '\u0000' || quoted == '\'')) {
                    Location location = context2.getLocation(textNode, p, len);
                    LintFix fix2 = this.fix().name("Escape Apostrophe").replace().pattern("[^\\\\]?(')").with("\\'").build();
                    context2.report(STRING_ESCAPING, element, location, "Apostrophe not preceded by \\\\", fix2);
                    return;
                }
                ++p;
            }
            if (p >= s + len) continue;
            char cp = string2.charAt(p);
            if (cp == '\"' || cp == '\'') {
                quoted = quoted == '\u0000' ? cp : (char)'\u0000';
                ++p;
            } else if (CharsKt.isWhitespace((char)cp)) {
                ++p;
                while (p < s + len && CharsKt.isWhitespace((char)string2.charAt(p))) {
                    ++p;
                }
            } else if (cp == '\\' && ++p < s + len) {
                switch (string2.charAt(p)) {
                    case '\"': 
                    case '#': 
                    case '\'': 
                    case '?': 
                    case '@': 
                    case '\\': 
                    case 'n': 
                    case 't': {
                        break;
                    }
                    case 'u': {
                        for (int i = 0; i < 4 && p + 1 < len; ++i) {
                            char h;
                            if (Intrinsics.compare((int)(h = string2.charAt(++p)), (int)48) >= 0 && Intrinsics.compare((int)h, (int)57) <= 0 || Intrinsics.compare((int)h, (int)97) >= 0 && Intrinsics.compare((int)h, (int)102) <= 0 || Intrinsics.compare((int)h, (int)65) >= 0 && Intrinsics.compare((int)h, (int)70) <= 0) continue;
                            Location location = context2.getLocation(textNode, p, p + 1);
                            XmlContext.report$default(context2, STRING_ESCAPING, element, location, "Bad character in \\\\u unicode escape sequence", null, 16, null);
                            return;
                        }
                        break;
                    }
                }
                ++p;
            }
            len -= p - s;
            s = p;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/lint/checks/StringEscapeDetector$Issues;", "", "<init>", "()V", "STRING_ESCAPING", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

