/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.sdklib.AndroidVersion;
import com.android.tools.lint.checks.AbstractAnnotationDetector;
import com.android.tools.lint.checks.AnnotationDetectorKt;
import com.android.tools.lint.checks.NotificationPermissionDetector;
import com.android.tools.lint.checks.PermissionFinder;
import com.android.tools.lint.checks.PermissionHolder;
import com.android.tools.lint.checks.PermissionRequirement;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Constraint;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Project;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.utils.XmlUtils;
import com.google.common.collect.Sets;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.InheritanceUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UCatchClause;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UastUtils;
import org.jetbrains.uast.util.UastExpressionUtils;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 C2\u00020\u00012\u00020\u0002:\u0002BCB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J(\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J(\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\"\u0010\u0018\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\"\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J\f\u0010\u001d\u001a\u00020\u0019*\u00020\u001bH\u0002J4\u0010\u001e\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\r2\b\u0010\u0014\u001a\u0004\u0018\u00010\u00152\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J<\u0010\"\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001f\u001a\u00020\r2\b\u0010 \u001a\u0004\u0018\u00010!2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0002J(\u0010%\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020$2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\rH\u0002J \u0010&\u001a\u00020\u00072\u0006\u0010'\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010(\u001a\u00020$H\u0002J \u0010)\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.H\u0016J\u001e\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001b0\u00062\u0006\u0010\u001f\u001a\u00020\r2\u0006\u00100\u001a\u00020\u0019H\u0002J\u001e\u00101\u001a\u00020$2\u0006\u0010(\u001a\u00020$2\f\u00102\u001a\b\u0012\u0004\u0012\u00020\u001b0\u0006H\u0002J\u0010\u00103\u001a\u00020\u00192\u0006\u0010\u001f\u001a\u00020\rH\u0002J\u001a\u00105\u001a\u00020$2\u0006\u0010\n\u001a\u00020*2\b\b\u0002\u00106\u001a\u00020\u0019H\u0002J\u0010\u00107\u001a\u00020$2\u0006\u0010\n\u001a\u00020*H\u0002J\u0010\u00108\u001a\u00020$2\u0006\u0010\n\u001a\u00020*H\u0002J\"\u00109\u001a\u00020$2\b\u0010:\u001a\u0004\u0018\u00010;2\u0006\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020=H\u0002J\u0010\u0010A\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020*H\u0002R\u0010\u00104\u001a\u0004\u0018\u00010$X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010?\u001a\u0004\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010@\u00a8\u0006D"}, d2={"Lcom/android/tools/lint/checks/PermissionDetector;", "Lcom/android/tools/lint/checks/AbstractAnnotationDetector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "applicableAnnotations", "", "", "visitAnnotationUsage", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "element", "Lorg/jetbrains/uast/UElement;", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "checkParameterPermission", "signature", "method", "Lcom/intellij/psi/PsiMethod;", "argument", "Lorg/jetbrains/uast/UExpression;", "conditionMet", "", "requirement", "Lcom/android/tools/lint/checks/PermissionRequirement;", "isExactAlarmRequirement", "needsNotifyPermission", "checkPermission", "node", "result", "Lcom/android/tools/lint/checks/PermissionFinder$Result;", "checkMissingManifestPermission", "manifestPermissions", "Lcom/android/tools/lint/checks/PermissionHolder;", "checkMissingPermissionCheck", "getMissingMessage", "messageFormat", "permissions", "filterIncident", "Lcom/android/tools/lint/detector/api/Context;", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "getLocalPermissions", "isNotifyPermission", "mergePermissions", "requirements", "handlesSecurityException", "mPermissions", "getPermissions", "accessMergedManifest", "createLocalPermissionHolder", "createMergedManifestPermissionHolder", "createManifestPermissionHolder", "manifest", "Lorg/w3c/dom/Document;", "minSdkVersion", "Lcom/android/sdklib/AndroidVersion;", "targetSdkVersion", "mIsAndroidThingsProject", "Ljava/lang/Boolean;", "isAndroidThingsProject", "CheckPermissionVisitor", "Companion", "android.sdktools.lint-checks"})
@SourceDebugExtension(value={"SMAP\nPermissionDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PermissionDetector.kt\ncom/android/tools/lint/checks/PermissionDetector\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,787:1\n1#2:788\n1321#3,2:789\n1563#4:791\n1634#4,3:792\n*S KotlinDebug\n*F\n+ 1 PermissionDetector.kt\ncom/android/tools/lint/checks/PermissionDetector\n*L\n449#1:789,2\n486#1:791\n486#1:792,3\n*E\n"})
public final class PermissionDetector
extends AbstractAnnotationDetector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private PermissionHolder mPermissions;
    @Nullable
    private Boolean mIsAndroidThingsProject;
    @NotNull
    public static final String KEY_MISSING_PERMISSIONS = "missing";
    @NotNull
    public static final String KEY_LAST_API = "lastApi";
    @NotNull
    public static final String KEY_REQUIREMENT = "requirement";
    @NotNull
    public static final String KEY_LOCAL_PERMISSION = "local";
    @NotNull
    public static final String KEY_MESSAGE = "message";
    @NotNull
    public static final String KEY_OPERATOR = "operator";
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(PermissionDetector.class, Scope.JAVA_FILE_SCOPE);
    @NotNull
    private static final String THINGS_LIBRARY = "com.google.android.things";
    @NotNull
    public static final String AOSP_PERMISSION_ANNOTATION = "android.annotation.RequiresPermission";
    @NotNull
    private static final List<String> TARGET_33_CONDITIONAL_PERMISSIONS;
    @JvmField
    @NotNull
    public static final Issue MISSING_PERMISSION;

    @Override
    @NotNull
    public List<String> applicableAnnotations() {
        Object[] objectArray = new String[]{AnnotationDetectorKt.PERMISSION_ANNOTATION.oldName(), AnnotationDetectorKt.PERMISSION_ANNOTATION.newName(), AnnotationDetectorKt.PERMISSION_ANNOTATION_READ.oldName(), AnnotationDetectorKt.PERMISSION_ANNOTATION_READ.newName(), AnnotationDetectorKt.PERMISSION_ANNOTATION_WRITE.oldName(), AnnotationDetectorKt.PERMISSION_ANNOTATION_WRITE.newName()};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitAnnotationUsage(@NotNull JavaContext context2, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        PsiMethod method;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        AnnotationUsageType type = usageInfo.getType();
        PsiElement psiElement = usageInfo.getReferenced();
        PsiMethod psiMethod = method = psiElement instanceof PsiMethod ? (PsiMethod)psiElement : null;
        if (type == AnnotationUsageType.METHOD_CALL) {
            PermissionRequirement permissionRequirement = PermissionRequirement.create(annotationInfo.getAnnotation());
            Intrinsics.checkNotNullExpressionValue((Object)permissionRequirement, (String)"create(...)");
            PermissionRequirement requirement = permissionRequirement;
            this.checkPermission(context2, element, method, null, requirement);
        } else if (element instanceof UExpression && method != null) {
            this.checkParameterPermission(context2, annotationInfo.getQualifiedName(), method, (UExpression)element);
        }
    }

    private final void checkParameterPermission(JavaContext context2, String signature, PsiMethod method, UExpression argument) {
        PermissionFinder.Operation operation = null;
        if (AnnotationDetectorKt.PERMISSION_ANNOTATION_READ.isEquals(signature)) {
            operation = PermissionFinder.Operation.READ;
        } else if (AnnotationDetectorKt.PERMISSION_ANNOTATION_WRITE.isEquals(signature)) {
            operation = PermissionFinder.Operation.WRITE;
        } else {
            PsiType type = argument.getExpressionType();
            if (type != null && Intrinsics.areEqual((Object)"android.content.Intent", (Object)type.getCanonicalText())) {
                operation = PermissionFinder.Operation.ACTION;
            }
        }
        if (operation == null) {
            return;
        }
        PermissionFinder.Result result2 = PermissionFinder.findRequiredPermissions(context2, operation, (UElement)argument);
        if (result2 != null) {
            UElement uElement = (UElement)argument;
            PermissionRequirement permissionRequirement = result2.requirement;
            Intrinsics.checkNotNullExpressionValue((Object)permissionRequirement, (String)KEY_REQUIREMENT);
            this.checkPermission(context2, uElement, method, result2, permissionRequirement);
        }
    }

    private final boolean conditionMet(JavaContext context2, PermissionRequirement requirement, PsiMethod method) {
        if (method == null) {
            return false;
        }
        if (this.isExactAlarmRequirement(requirement, context2, method)) {
            return true;
        }
        for (String permission : TARGET_33_CONDITIONAL_PERMISSIONS) {
            if (!requirement.contains(permission)) continue;
            return true;
        }
        return false;
    }

    private final boolean isExactAlarmRequirement(PermissionRequirement requirement, JavaContext context2, PsiMethod method) {
        return requirement.isSingle() && Intrinsics.areEqual((Object)requirement.toString(), (Object)"android.permission.SCHEDULE_EXACT_ALARM") && context2.getEvaluator().isMemberInClass((PsiMember)method, "android.app.AlarmManager");
    }

    private final boolean needsNotifyPermission(PermissionRequirement $this$needsNotifyPermission) {
        return $this$needsNotifyPermission.contains("android.permission.POST_NOTIFICATIONS");
    }

    private final void checkPermission(JavaContext context2, UElement node, PsiMethod method, PermissionFinder.Result result2, PermissionRequirement requirement) {
        if (requirement.isConditional() && !this.conditionMet(context2, requirement, method)) {
            return;
        }
        PermissionHolder manifestPermissions = PermissionDetector.getPermissions$default(this, context2, false, 2, null);
        this.checkMissingManifestPermission(context2, requirement, manifestPermissions, node, result2, method);
        this.checkMissingPermissionCheck(requirement, manifestPermissions, context2, node);
    }

    private final void checkMissingManifestPermission(JavaContext context2, PermissionRequirement requirement, PermissionHolder manifestPermissions, UElement node, PermissionFinder.Result result2, PsiMethod method) {
        block27: {
            Incident incident;
            String messageFormat;
            Constraint constraint;
            List<PermissionRequirement> localPermissionRequirements;
            PermissionHolder permissions;
            block31: {
                Set<String> missingPermissions;
                block28: {
                    Object object;
                    block30: {
                        block29: {
                            String string2;
                            UIdentifier callIdentifier;
                            UCallExpression expressionNode;
                            permissions = manifestPermissions;
                            if (requirement.isSatisfied(permissions) || requirement.isSatisfied(permissions = this.mergePermissions(permissions, localPermissionRequirements = this.getLocalPermissions(node, this.needsNotifyPermission(requirement))))) break block27;
                            PermissionFinder.Operation operation = null;
                            Object name = null;
                            if (result2 != null) {
                                String string3 = result2.name;
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"name");
                                name = string3;
                                PermissionFinder.Operation operation2 = result2.operation;
                                Intrinsics.checkNotNullExpressionValue((Object)((Object)operation2), (String)"operation");
                                operation = operation2;
                            } else {
                                boolean bl;
                                boolean bl2 = bl = method != null;
                                if (_Assertions.ENABLED && !bl) {
                                    String string4 = "Assertion failed";
                                    throw new AssertionError((Object)string4);
                                }
                                PsiMethod psiMethod = method;
                                Intrinsics.checkNotNull((Object)psiMethod);
                                PsiClass containingClass = psiMethod.getContainingClass();
                                if (containingClass != null) {
                                    v4 = containingClass.getName() + "." + method.getName();
                                } else {
                                    String string5 = method.getName();
                                    Intrinsics.checkNotNull((Object)string5);
                                    v4 = name = string5;
                                }
                                if (Intrinsics.areEqual((Object)name, (Object)"Builder.setPersisted") && node instanceof UCallExpression && ((UCallExpression)node).getValueArguments().size() == 1 && Intrinsics.areEqual((Object)ConstantEvaluator.evaluate(context2, (UElement)((UCallExpression)node).getValueArguments().get(0)), (Object)false)) {
                                    return;
                                }
                                operation = PermissionFinder.Operation.CALL;
                            }
                            Location location = context2.getLocation(node);
                            UCallExpression uCallExpression = expressionNode = node instanceof UCallExpression ? (UCallExpression)node : (UCallExpression)UastUtils.getParentOfType((UElement)node, UCallExpression.class, (boolean)true);
                            if (expressionNode != null && node != expressionNode && (callIdentifier = expressionNode.getMethodIdentifier()) != null && !Intrinsics.areEqual((Object)callIdentifier, (Object)node)) {
                                location = context2.getRangeLocation((UElement)callIdentifier, 0, node, 0);
                            }
                            missingPermissions = requirement.getMissingPermissions(permissions);
                            constraint = null;
                            PsiMethod psiMethod = method;
                            if (Intrinsics.areEqual((Object)(psiMethod != null ? psiMethod.getName() : null), (Object)"getAllCellInfo") && missingPermissions.size() == 1) {
                                Intrinsics.checkNotNull(missingPermissions);
                                if (Intrinsics.areEqual((Object)CollectionsKt.first((Iterable)missingPermissions), (Object)"android.permission.ACCESS_COARSE_LOCATION") && permissions.hasPermission("android.permission.ACCESS_FINE_LOCATION")) {
                                    return;
                                }
                            }
                            messageFormat = "Missing permissions required " + operation.prefix() + " " + (String)name + ": %1$s";
                            IElementType op = requirement.getOperator();
                            if (op == null || Intrinsics.areEqual((Object)op, (Object)JavaTokenType.ANDAND)) {
                                string2 = "&";
                            } else if (Intrinsics.areEqual((Object)op, (Object)JavaTokenType.OROR)) {
                                string2 = "|";
                            } else if (Intrinsics.areEqual((Object)op, (Object)JavaTokenType.XOR)) {
                                string2 = "^";
                            } else {
                                throw new IllegalArgumentException("Unsupported operator type: " + op);
                            }
                            String operator = string2;
                            LintFix.Builder builder = this.fix();
                            Object[] objectArray = new Object[8];
                            objectArray[0] = KEY_MESSAGE;
                            objectArray[1] = messageFormat;
                            objectArray[2] = KEY_MISSING_PERMISSIONS;
                            Intrinsics.checkNotNull(missingPermissions);
                            objectArray[3] = CollectionsKt.toList((Iterable)missingPermissions);
                            objectArray[4] = KEY_LAST_API;
                            objectArray[5] = requirement.getLastApplicableApi();
                            objectArray[6] = KEY_OPERATOR;
                            objectArray[7] = operator;
                            incident = new Incident(MISSING_PERMISSION, node, location, "", builder.data(objectArray));
                            if (!this.isExactAlarmRequirement(requirement, context2, method)) break block28;
                            constraint = Constraints.targetSdkAtLeast(31);
                            incident.overrideSeverity(Severity.WARNING);
                            object = method;
                            if (object == null || (object = object.getName()) == null) break block29;
                            Object it = object;
                            boolean bl = false;
                            String string6 = " with `" + (String)it + "`";
                            object = string6;
                            if (string6 != null) break block30;
                        }
                        object = "";
                    }
                    Object where = object;
                    messageFormat = "Setting Exact alarms" + (String)where + " requires the `SCHEDULE_EXACT_ALARM` permission or power exemption from user; it is intended for applications where the user knowingly schedules actions to happen at a precise time such as alarms, clocks, calendars, etc. Check out the javadoc on this permission to make sure your use case is valid.";
                    break block31;
                }
                if (requirement.isConditional()) {
                    if (missingPermissions.size() == 1 && TARGET_33_CONDITIONAL_PERMISSIONS.contains(CollectionsKt.first((Iterable)missingPermissions))) {
                        constraint = Constraints.targetSdkAtLeast(33);
                    } else {
                        return;
                    }
                }
            }
            if (context2.isGlobalAnalysis()) {
                Constraint constraint2 = constraint;
                boolean bl = constraint2 != null ? !constraint2.accept(context2, incident) : false;
                if (bl) {
                    return;
                }
                incident.setMessage(this.getMissingMessage(messageFormat, requirement, permissions));
                context2.report(incident);
            } else {
                LintMap map2 = this.map();
                String string7 = requirement.serialize();
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"serialize(...)");
                map2.put(KEY_REQUIREMENT, string7);
                map2.put(KEY_MESSAGE, messageFormat);
                Constraint constraint3 = constraint;
                if (constraint3 != null) {
                    Constraint it = constraint3;
                    boolean bl = false;
                    map2.put("_condition_", it);
                }
                if (!((Collection)localPermissionRequirements).isEmpty()) {
                    map2.put(KEY_LOCAL_PERMISSION, CollectionsKt.joinToString$default((Iterable)localPermissionRequirements, (CharSequence)";", null, null, (int)0, null, PermissionDetector::checkMissingManifestPermission$lambda$2, (int)30, null));
                }
                context2.report(incident, map2);
            }
            return;
        }
    }

    private final void checkMissingPermissionCheck(PermissionRequirement requirement, PermissionHolder manifestPermissions, JavaContext context2, UElement node) {
        if (requirement.isRevocable(manifestPermissions) && requirement.getLastApplicableApi() >= 23) {
            if (context2.getDriver().isGlobalAnalysis() && context2.getMainProject().getTargetSdkVersion().getFeatureLevel() < 23) {
                return;
            }
            boolean handlesMissingPermission = this.handlesSecurityException(node);
            if (!handlesMissingPermission) {
                List<PermissionRequirement> localPermissionRequirements = this.getLocalPermissions(node, this.needsNotifyPermission(requirement));
                PermissionHolder localRequirements = this.mergePermissions(new PermissionHolder.SetPermissionLookup(new LinkedHashSet(), new LinkedHashSet(), manifestPermissions.getMinSdkVersion(), manifestPermissions.getTargetSdkVersion()), localPermissionRequirements);
                if (requirement.isSatisfied(localRequirements)) {
                    return;
                }
                UMethod methodNode = (UMethod)UastUtils.getParentOfType((UElement)node, UMethod.class, (boolean)true);
                if (methodNode != null) {
                    CheckPermissionVisitor visitor2 = new CheckPermissionVisitor(node);
                    methodNode.accept((UastVisitor)visitor2);
                    handlesMissingPermission = visitor2.checksPermission();
                }
            }
            if (!handlesMissingPermission) {
                String message = "Call requires permission which may be rejected by user: code should explicitly check to see if permission is available (with `checkPermission`) or explicitly handle a potential `SecurityException`";
                Location location = context2.getLocation(node);
                LintFix.Builder builder = this.fix();
                Object[] objectArray = new Object[4];
                objectArray[0] = KEY_MISSING_PERMISSIONS;
                Set<String> set2 = requirement.getRevocablePermissions(manifestPermissions);
                Intrinsics.checkNotNullExpressionValue(set2, (String)"getRevocablePermissions(...)");
                objectArray[1] = CollectionsKt.toList((Iterable)set2);
                objectArray[2] = KEY_REQUIREMENT;
                objectArray[3] = requirement.serialize();
                Incident incident = new Incident(MISSING_PERMISSION, node, location, message, builder.data(objectArray));
                context2.report(incident, this.map());
            }
        }
    }

    private final String getMissingMessage(String messageFormat, PermissionRequirement requirement, PermissionHolder permissions) {
        Object[] objectArray = new Object[]{requirement.describeMissingPermissions(permissions)};
        String string2 = String.format(messageFormat, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        return StringsKt.replace$default((String)string2, (String)"carrier privileges", (String)"carrier privileges (see TelephonyManager#hasCarrierPrivileges)", (boolean)false, (int)4, null);
    }

    @Override
    public boolean filterIncident(@NotNull Context context2, @NotNull Incident incident, @NotNull LintMap map2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
        String requirementString = map2.getString(KEY_REQUIREMENT, null);
        if (requirementString == null) {
            if (context2.getProject().getTargetSdkVersion().getFeatureLevel() < 23) {
                return false;
            }
            return !this.isAndroidThingsProject(context2);
        }
        PermissionRequirement permissionRequirement = PermissionRequirement.deserialize(requirementString);
        Intrinsics.checkNotNullExpressionValue((Object)permissionRequirement, (String)"deserialize(...)");
        PermissionRequirement requirement = permissionRequirement;
        PermissionHolder permissions = null;
        permissions = this.getPermissions(context2, true);
        if (requirement.isSatisfied(permissions)) {
            return false;
        }
        String string2 = map2.getString(KEY_LOCAL_PERMISSION, null);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            char[] cArray = new char[]{';'};
            Sequence $this$forEach$iv = StringsKt.splitToSequence$default((CharSequence)it, (char[])cArray, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                PermissionRequirement r2;
                String serialized = (String)element$iv;
                boolean bl2 = false;
                Intrinsics.checkNotNullExpressionValue((Object)PermissionRequirement.deserialize(serialized), (String)"deserialize(...)");
                permissions = this.mergePermissions(permissions, CollectionsKt.listOf((Object)r2));
            }
            if (requirement.isSatisfied(permissions)) {
                return false;
            }
        }
        Constraint constraint = map2.getConstraint("_condition_");
        boolean bl = constraint != null ? !constraint.accept(context2, incident) : false;
        if (bl) {
            return false;
        }
        String string3 = map2.getString(KEY_MESSAGE, "");
        Intrinsics.checkNotNull((Object)string3);
        String messageFormat = string3;
        incident.setMessage(this.getMissingMessage(messageFormat, requirement, permissions));
        return true;
    }

    /*
     * WARNING - void declaration
     */
    private final List<PermissionRequirement> getLocalPermissions(UElement node, boolean isNotifyPermission) {
        List list2;
        UClass classAnnotation;
        UAnnotation methodAnnotation;
        block14: {
            UAnnotation uAnnotation;
            UClass containingClass;
            Object object;
            block13: {
                UMethod uMethod = (UMethod)UastUtils.getParentOfType((UElement)node, UMethod.class, (boolean)true);
                if (uMethod == null) {
                    return CollectionsKt.emptyList();
                }
                UMethod method = uMethod;
                String string2 = AnnotationDetectorKt.PERMISSION_ANNOTATION.oldName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"oldName(...)");
                UAnnotation uAnnotation2 = method.findAnnotation(string2);
                if (uAnnotation2 == null) {
                    String string3 = AnnotationDetectorKt.PERMISSION_ANNOTATION.newName();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"newName(...)");
                    uAnnotation2 = method.findAnnotation(string3);
                    if (uAnnotation2 == null) {
                        uAnnotation2 = methodAnnotation = method.findAnnotation(AOSP_PERMISSION_ANNOTATION);
                    }
                }
                if ((object = (containingClass = UastUtils.getContainingUClass((UElement)((UElement)method)))) == null) break block13;
                String string4 = AnnotationDetectorKt.PERMISSION_ANNOTATION.oldName();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"oldName(...)");
                if ((object = object.findAnnotation(string4)) != null) break block14;
            }
            UClass uClass = containingClass;
            if (uClass != null) {
                String string5 = AnnotationDetectorKt.PERMISSION_ANNOTATION.newName();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"newName(...)");
                uAnnotation = uClass.findAnnotation(string5);
            } else {
                uAnnotation = object = null;
            }
            if (uAnnotation == null) {
                UClass uClass2 = containingClass;
                object = classAnnotation = uClass2 != null ? uClass2.findAnnotation(AOSP_PERMISSION_ANNOTATION) : null;
            }
        }
        if (methodAnnotation == null && classAnnotation == null) {
            list2 = CollectionsKt.emptyList();
        } else {
            void $this$mapTo$iv$iv;
            Object[] objectArray = new UAnnotation[]{methodAnnotation, classAnnotation};
            Iterable $this$map$iv = CollectionsKt.listOfNotNull((Object[])objectArray);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                UAnnotation uAnnotation = (UAnnotation)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(PermissionRequirement.create((UAnnotation)it));
            }
            list2 = (List)destination$iv$iv;
        }
        List requirements = list2;
        if (isNotifyPermission && NotificationPermissionDetector.Issues.isNotificationPermissionChecked(node)) {
            return CollectionsKt.plus((Collection)requirements, (Object)PermissionRequirement.create("android.permission.POST_NOTIFICATIONS"));
        }
        return requirements;
    }

    private final PermissionHolder mergePermissions(PermissionHolder permissions, List<? extends PermissionRequirement> requirements) {
        PermissionHolder merged = permissions;
        for (PermissionRequirement permissionRequirement : requirements) {
            Intrinsics.checkNotNullExpressionValue((Object)PermissionHolder.SetPermissionLookup.join(merged, permissionRequirement), (String)"join(...)");
        }
        return merged;
    }

    private final boolean handlesSecurityException(UElement node) {
        return Companion.handlesException(node, null, false, "java.lang.SecurityException");
    }

    private final PermissionHolder getPermissions(Context context2, boolean accessMergedManifest) {
        PermissionHolder permissionHolder = this.mPermissions;
        if (permissionHolder == null) {
            if (accessMergedManifest || context2.isGlobalAnalysis()) {
                PermissionHolder permissionHolder2;
                PermissionHolder it = permissionHolder2 = this.createMergedManifestPermissionHolder(context2);
                boolean bl = false;
                this.mPermissions = it;
                permissionHolder = permissionHolder2;
            } else {
                PermissionHolder permissionHolder3;
                PermissionHolder it = permissionHolder3 = this.createLocalPermissionHolder(context2);
                boolean bl = false;
                this.mPermissions = it;
                permissionHolder = permissionHolder3;
            }
        }
        return permissionHolder;
    }

    static /* synthetic */ PermissionHolder getPermissions$default(PermissionDetector permissionDetector, Context context2, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return permissionDetector.getPermissions(context2, bl);
    }

    private final PermissionHolder createLocalPermissionHolder(Context context2) {
        PermissionHolder permissionHolder;
        Project project = context2.getProject();
        AndroidVersion minSdkVersion = project.getMinSdkVersion();
        AndroidVersion targetSdkVersion = project.getTargetSdkVersion();
        Document dom = project.getManifestDom();
        if (dom != null) {
            Intrinsics.checkNotNull((Object)minSdkVersion);
            Intrinsics.checkNotNull((Object)targetSdkVersion);
            permissionHolder = this.createManifestPermissionHolder(dom, minSdkVersion, targetSdkVersion);
        } else {
            permissionHolder = new PermissionHolder.SetPermissionLookup(SetsKt.emptySet(), SetsKt.emptySet(), minSdkVersion, targetSdkVersion);
        }
        return permissionHolder;
    }

    private final PermissionHolder createMergedManifestPermissionHolder(Context context2) {
        Project mainProject = context2.getMainProject();
        Document mergedManifest = mainProject.getMergedManifest();
        AndroidVersion minSdkVersion = mainProject.getMinSdkVersion();
        AndroidVersion targetSdkVersion = mainProject.getTargetSdkVersion();
        Intrinsics.checkNotNull((Object)minSdkVersion);
        Intrinsics.checkNotNull((Object)targetSdkVersion);
        return this.createManifestPermissionHolder(mergedManifest, minSdkVersion, targetSdkVersion);
    }

    private final PermissionHolder createManifestPermissionHolder(Document manifest, AndroidVersion minSdkVersion, AndroidVersion targetSdkVersion) {
        HashSet permissions = Sets.newHashSetWithExpectedSize((int)30);
        HashSet revocable = Sets.newHashSetWithExpectedSize((int)4);
        if (manifest != null) {
            for (Element element : XmlUtils.getSubTags((Node)manifest.getDocumentElement())) {
                String protectionLevel;
                String nodeName = element.getNodeName();
                if (Intrinsics.areEqual((Object)"uses-permission", (Object)nodeName) || Intrinsics.areEqual((Object)"uses-permission-sdk-23", (Object)nodeName) || Intrinsics.areEqual((Object)"uses-permission-sdk-m", (Object)nodeName)) {
                    String name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                    Intrinsics.checkNotNull((Object)name);
                    if (!(((CharSequence)name).length() > 0)) continue;
                    permissions.add(name);
                    continue;
                }
                if (!Intrinsics.areEqual((Object)nodeName, (Object)"permission") || !Intrinsics.areEqual((Object)"dangerous", (Object)(protectionLevel = element.getAttributeNS("http://schemas.android.com/apk/res/android", "protectionLevel")))) continue;
                String name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                Intrinsics.checkNotNull((Object)name);
                if (!(((CharSequence)name).length() > 0)) continue;
                revocable.add(name);
            }
        }
        return new PermissionHolder.SetPermissionLookup(permissions, revocable, minSdkVersion, targetSdkVersion);
    }

    private final boolean isAndroidThingsProject(Context context2) {
        if (this.mIsAndroidThingsProject == null) {
            Project project = context2.getMainProject();
            Document document = project.getMergedManifest();
            if (document == null) {
                return false;
            }
            Document mergedManifest = document;
            Element element = mergedManifest.getDocumentElement();
            if (element == null) {
                return false;
            }
            Element manifest = element;
            Element element2 = XmlUtils.getFirstSubTagByName((Node)manifest, (String)"application");
            if (element2 == null) {
                return false;
            }
            Element application = element2;
            Element usesLibrary = XmlUtils.getFirstSubTagByName((Node)application, (String)"uses-library");
            while (usesLibrary != null && this.mIsAndroidThingsProject == null) {
                String name = usesLibrary.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                boolean isThingsLibraryRequired = true;
                String required = usesLibrary.getAttributeNS("http://schemas.android.com/apk/res/android", "required");
                if (Intrinsics.areEqual((Object)"false", (Object)required)) {
                    isThingsLibraryRequired = false;
                }
                if (Intrinsics.areEqual((Object)THINGS_LIBRARY, (Object)name) && isThingsLibraryRequired) {
                    this.mIsAndroidThingsProject = true;
                }
                usesLibrary = XmlUtils.getNextTagByName((Node)usesLibrary, (String)"uses-library");
            }
            if (this.mIsAndroidThingsProject == null) {
                this.mIsAndroidThingsProject = false;
            }
        }
        Boolean bl = this.mIsAndroidThingsProject;
        Intrinsics.checkNotNull((Object)bl);
        return bl;
    }

    private static final CharSequence checkMissingManifestPermission$lambda$2(PermissionRequirement it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        String string2 = it.serialize();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"serialize(...)");
        return string2;
    }

    static {
        Object object = new String[]{"android.permission.NEARBY_WIFI_DEVICES", "android.permission.BODY_SENSORS_BACKGROUND"};
        TARGET_33_CONDITIONAL_PERMISSIONS = CollectionsKt.listOf((Object[])object);
        object = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        MISSING_PERMISSION = Issue.Companion.create$default((Issue.Companion)object, "MissingPermission", "Missing Permissions", "\n                This check scans through your code and libraries and looks at the APIs being \\\n                used, and checks this against the set of permissions required to access \\\n                those APIs. If the code using those APIs is called at runtime, then the \\\n                program will crash.\n\n                Furthermore, for permissions that are revocable (with `targetSdkVersion` 23), \\\n                client code must also be prepared to handle the calls throwing an exception \\\n                if the user rejects the request for permission at runtime.", implementation, null, category, 9, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\t\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u0003H\u0016J\u0010\u0010\u000b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\n\u001a\u00020\fH\u0002J\u0006\u0010\u000f\u001a\u00020\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/lint/checks/PermissionDetector$CheckPermissionVisitor;", "Lorg/jetbrains/uast/visitor/AbstractUastVisitor;", "mTarget", "Lorg/jetbrains/uast/UElement;", "<init>", "(Lorg/jetbrains/uast/UElement;)V", "mChecksPermission", "", "mDone", "visitElement", "node", "visitCallExpression", "Lorg/jetbrains/uast/UCallExpression;", "visitMethodCallExpression", "", "checksPermission", "android.sdktools.lint-checks"})
    private static final class CheckPermissionVisitor
    extends AbstractUastVisitor {
        @NotNull
        private final UElement mTarget;
        private boolean mChecksPermission;
        private boolean mDone;

        public CheckPermissionVisitor(@NotNull UElement mTarget) {
            Intrinsics.checkNotNullParameter((Object)mTarget, (String)"mTarget");
            this.mTarget = mTarget;
        }

        public boolean visitElement(@NotNull UElement node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            return this.mDone || super.visitElement(node);
        }

        public boolean visitCallExpression(@NotNull UCallExpression node) {
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            if (UastExpressionUtils.isMethodCall((UElement)((UElement)node))) {
                this.visitMethodCallExpression(node);
            }
            return super.visitCallExpression(node);
        }

        private final void visitMethodCallExpression(UCallExpression node) {
            String name;
            if (node == this.mTarget) {
                this.mDone = true;
            }
            if ((name = node.getMethodName()) != null && (StringsKt.startsWith$default((String)name, (String)"check", (boolean)false, (int)2, null) || StringsKt.startsWith$default((String)name, (String)"enforce", (boolean)false, (int)2, null)) && StringsKt.endsWith$default((String)name, (String)"Permission", (boolean)false, (int)2, null)) {
                this.mChecksPermission = true;
                this.mDone = true;
            }
        }

        public final boolean checksPermission() {
            return this.mChecksPermission;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u001a\u001a\u00020\u0005J2\u0010\u001b\u001a\u00020\u00142\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001d0\u00102\b\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\u00142\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u00020\u00128\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/lint/checks/PermissionDetector$Companion;", "", "<init>", "()V", "KEY_MISSING_PERMISSIONS", "", "KEY_LAST_API", "KEY_REQUIREMENT", "KEY_LOCAL_PERMISSION", "KEY_MESSAGE", "KEY_OPERATOR", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "THINGS_LIBRARY", "AOSP_PERMISSION_ANNOTATION", "TARGET_33_CONDITIONAL_PERMISSIONS", "", "MISSING_PERMISSION", "Lcom/android/tools/lint/detector/api/Issue;", "handlesException", "", "node", "Lorg/jetbrains/uast/UElement;", "exceptionClass", "Lcom/intellij/psi/PsiClass;", "allowSuperClass", "exceptionClassName", "containsException", "types", "Lcom/intellij/psi/PsiType;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public final boolean handlesException(@NotNull UElement node, @Nullable PsiClass exceptionClass, boolean allowSuperClass, @NotNull String exceptionClassName) {
            UTryExpression tryCatch;
            Intrinsics.checkNotNullParameter((Object)node, (String)"node");
            Intrinsics.checkNotNullParameter((Object)exceptionClassName, (String)"exceptionClassName");
            UElement parent = node;
            while ((tryCatch = (UTryExpression)UastUtils.getParentOfType((UElement)parent, UTryExpression.class, (boolean)true)) != null) {
                for (UCatchClause catchClause : tryCatch.getCatchClauses()) {
                    if (!this.containsException(catchClause.getTypes(), exceptionClass, allowSuperClass, exceptionClassName)) continue;
                    return true;
                }
                parent = (UElement)tryCatch;
            }
            UMethod declaration = (UMethod)UastUtils.getParentOfType((UElement)parent, UMethod.class, (boolean)false);
            if (declaration != null) {
                PsiClassType[] psiClassTypeArray = declaration.getJavaPsi().getThrowsList().getReferencedTypes();
                Intrinsics.checkNotNullExpressionValue((Object)psiClassTypeArray, (String)"getReferencedTypes(...)");
                PsiClassType[] thrownTypes = psiClassTypeArray;
                if (this.containsException(CollectionsKt.listOf((Object[])Arrays.copyOf(thrownTypes, thrownTypes.length)), exceptionClass, allowSuperClass, exceptionClassName)) {
                    return true;
                }
            }
            return false;
        }

        private final boolean containsException(List<? extends PsiType> types, PsiClass exceptionClass, boolean allowSuperClass, String exceptionClassName) {
            for (PsiType psiType : types) {
                if (!(psiType instanceof PsiClassType)) continue;
                Object object = ((PsiClassType)psiType).resolve();
                if (object == null || (object = object.getQualifiedName()) == null) {
                    return true;
                }
                Object cls = object;
                if (allowSuperClass && exceptionClass != null) {
                    return InheritanceUtil.isInheritor((PsiClass)exceptionClass, (boolean)false, (String)cls);
                }
                if (!Intrinsics.areEqual((Object)exceptionClassName, (Object)cls)) continue;
                return true;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

