/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.AnalysisApiLintUtilsKt;
import com.android.tools.lint.checks.CheckResultDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.client.api.UElementHandler;
import com.android.tools.lint.detector.api.AnnotationInfo;
import com.android.tools.lint.detector.api.AnnotationUsageInfo;
import com.android.tools.lint.detector.api.AnnotationUsageType;
import com.android.tools.lint.detector.api.BooleanOption;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtils;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.api.KaSession;
import org.jetbrains.kotlin.analysis.api.session.KaSessionProvider;
import org.jetbrains.kotlin.analysis.api.symbols.KaFunctionSymbol;
import org.jetbrains.kotlin.asJava.LightClassUtilsKt;
import org.jetbrains.kotlin.asJava.classes.KtLightClass;
import org.jetbrains.kotlin.asJava.elements.KtLightMember;
import org.jetbrains.kotlin.asJava.elements.KtLightMethod;
import org.jetbrains.kotlin.name.CallableId;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtObjectDeclaration;
import org.jetbrains.kotlin.psi.KtParameter;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UBinaryExpression;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIfExpression;
import org.jetbrains.uast.UInstanceExpression;
import org.jetbrains.uast.ULiteralExpression;
import org.jetbrains.uast.ULoopExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParenthesizedExpression;
import org.jetbrains.uast.UPolyadicExpression;
import org.jetbrains.uast.UPrefixExpression;
import org.jetbrains.uast.UQualifiedReferenceExpression;
import org.jetbrains.uast.UReferenceExpression;
import org.jetbrains.uast.UReturnExpression;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.jetbrains.uast.USuperExpression;
import org.jetbrains.uast.UThisExpression;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UTryExpression;
import org.jetbrains.uast.UUnaryExpression;
import org.jetbrains.uast.UastBinaryOperator;
import org.jetbrains.uast.UastFacade;
import org.jetbrains.uast.UastOperator;
import org.jetbrains.uast.UastPostfixOperator;
import org.jetbrains.uast.UastPrefixOperator;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u0000 72\u00020\u00012\u00020\u0002:\u00017B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0016\u0010\u0005\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\b0\u00070\u0006H\u0016J\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u0004\u0018\u00010\u000e*\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011*\u0004\u0018\u00010\u000fH\u0002J\f\u0010\u0012\u001a\u00020\u0013*\u00020\u000eH\u0002J\u0012\u0010\u0014\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u000fH\u0002J\u0012\u0010\u0016\u001a\u00020\u00132\b\u0010\u0015\u001a\u0004\u0018\u00010\u000fH\u0002J4\u0010\u0017\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001e\u001a\u0004\u0018\u00010\u001dH\u0002J\u001e\u0010\u001f\u001a\u00020\u0013*\u0004\u0018\u00010\u001b2\u0006\u0010 \u001a\u00020\u001d2\u0006\u0010\u000b\u001a\u00020\fH\u0002J\u000e\u0010!\u001a\b\u0012\u0004\u0012\u00020\u001d0\u0006H\u0016J\u0010\u0010\"\u001a\u00020\u00132\u0006\u0010#\u001a\u00020$H\u0016J\u0010\u0010%\u001a\u00020\u00132\u0006\u0010&\u001a\u00020\u001dH\u0016J(\u0010'\u001a\u00020(2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010)\u001a\u00020\b2\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-H\u0016J\u001a\u0010.\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J\u0016\u0010/\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010)\u001a\u00020\bJ\u0012\u00100\u001a\u00020\u00132\b\u00101\u001a\u0004\u0018\u00010\u001bH\u0002J\u0012\u00102\u001a\u00020\u00132\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0002J\u001a\u00103\u001a\u00020\u00132\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u001a\u001a\u0004\u0018\u00010\u001bH\u0002J \u00104\u001a\u00020(2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u00105\u001a\u00020\b2\u0006\u00106\u001a\u00020\u001dH\u0002\u00a8\u00068"}, d2={"Lcom/android/tools/lint/checks/NoOpDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableUastTypes", "", "Ljava/lang/Class;", "Lorg/jetbrains/uast/UElement;", "createUastHandler", "Lcom/android/tools/lint/client/api/UElementHandler;", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "getProperty", "Lorg/jetbrains/kotlin/psi/KtProperty;", "Lcom/intellij/psi/PsiElement;", "getParameter", "Lorg/jetbrains/kotlin/psi/KtParameter;", "hasSideEffect", "", "isComplexPropertyMethod", "resolved", "isUnit", "isPureMethod", "node", "Lorg/jetbrains/uast/UExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "methodName", "", "containingClassFqName", "isIn", "containingClass", "applicableAnnotations", "isApplicableAnnotationUsage", "type", "Lcom/android/tools/lint/detector/api/AnnotationUsageType;", "inheritAnnotation", "annotation", "visitAnnotationUsage", "", "element", "annotationInfo", "Lcom/android/tools/lint/detector/api/AnnotationInfo;", "usageInfo", "Lcom/android/tools/lint/detector/api/AnnotationUsageInfo;", "isAnnotatedCheckResult", "expectsSideEffect", "isGetter", "psiMethod", "isGetterBody", "isBufferMethod", "report", "expression", "name", "Issues", "android.sdktools.lint-checks"})
@SourceDebugExtension(value={"SMAP\nNoOpDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NoOpDetector.kt\ncom/android/tools/lint/checks/NoOpDetector\n+ 2 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 5 psiUtils.kt\norg/jetbrains/kotlin/psi/psiUtil/PsiUtilsKt\n*L\n1#1,750:1\n18#2:751\n12637#3,2:752\n19652#3,2:754\n1761#4,3:756\n1761#4,3:759\n1563#4:763\n1634#4,3:764\n196#5:762\n*S KotlinDebug\n*F\n+ 1 NoOpDetector.kt\ncom/android/tools/lint/checks/NoOpDetector\n*L\n534#1:751\n551#1:752,2\n574#1:754,2\n642#1:756,3\n663#1:759,3\n278#1:763\n278#1:764,3\n670#1:762\n*E\n"})
public final class NoOpDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues;
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @NotNull
    private static final BooleanOption ASSUME_PURE_GETTERS;
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    private static final int MAX_CALL_DEPTH;
    private static final int MAX_RECURSION_DEPTH;
    private static final int MAX_STATEMENT_COUNT;
    @NotNull
    private static final List<String> KOTLIN_PRIMITIVES;

    @Override
    @NotNull
    public List<Class<? extends UElement>> getApplicableUastTypes() {
        Object[] objectArray = new Class[]{USimpleNameReferenceExpression.class, UQualifiedReferenceExpression.class, UBinaryExpression.class, ULiteralExpression.class, UPolyadicExpression.class};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @Nullable
    public UElementHandler createUastHandler(@NotNull JavaContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.isTestSource()) {
            return null;
        }
        return new UElementHandler(this, context2){
            final /* synthetic */ NoOpDetector this$0;
            final /* synthetic */ JavaContext $context;
            {
                this.this$0 = $receiver;
                this.$context = $context;
            }

            public void visitSimpleNameReferenceExpression(USimpleNameReferenceExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                UElement parent = UastUtils.skipParenthesizedExprUp((UElement)node.getUastParent());
                if (parent instanceof UBlockExpression) {
                    PsiElement psiElement = node.resolve();
                    if (psiElement == null) {
                        return;
                    }
                    PsiElement resolved = psiElement;
                    if (resolved instanceof KtLightMember) {
                        KtProperty property = NoOpDetector.access$getProperty(this.this$0, resolved);
                        if (property == null || NoOpDetector.access$hasSideEffect(this.this$0, property)) {
                            return;
                        }
                    } else {
                        PsiElement ktClass;
                        if (resolved instanceof PsiMethod && NoOpDetector.access$getParameter(this.this$0, resolved) == null) {
                            return;
                        }
                        if (resolved instanceof KtLightClass && (ktClass = LightClassUtilsKt.getUnwrapped((PsiElement)resolved)) instanceof KtObjectDeclaration) {
                            return;
                        }
                    }
                    if (CheckResultDetector.Companion.isExpressionValueUnused((UElement)node) && !this.this$0.expectsSideEffect(this.$context, (UElement)node) && !NoOpDetector.access$isUnit(this.this$0, resolved)) {
                        NoOpDetector.access$report(this.this$0, this.$context, (UElement)node, node.getIdentifier());
                    }
                }
            }

            public void visitQualifiedReferenceExpression(UQualifiedReferenceExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                UExpression selector = node.getSelector();
                if (selector instanceof UCallExpression) {
                    if (node.getReceiver() instanceof UInstanceExpression) {
                        return;
                    }
                    this.checkCall((UCallExpression)selector, node);
                } else if (selector instanceof USimpleNameReferenceExpression) {
                    PsiElement psiElement = ((USimpleNameReferenceExpression)selector).resolve();
                    if (psiElement == null) {
                        return;
                    }
                    PsiElement resolved = psiElement;
                    if (NoOpDetector.access$isComplexPropertyMethod(this.this$0, resolved)) {
                        return;
                    }
                    if (resolved instanceof PsiMethod) {
                        PsiClass psiClass = ((PsiMethod)resolved).getContainingClass();
                        this.checkCall(null, node, ((USimpleNameReferenceExpression)selector).getIdentifier(), (PsiMethod)resolved, psiClass != null ? psiClass.getQualifiedName() : null);
                    } else if (CheckResultDetector.Companion.isExpressionValueUnused((UElement)selector) && !this.this$0.expectsSideEffect(this.$context, (UElement)selector)) {
                        NoOpDetector.access$report(this.this$0, this.$context, (UElement)selector, ((USimpleNameReferenceExpression)selector).getIdentifier());
                    }
                }
            }

            public void visitLiteralExpression(ULiteralExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (CheckResultDetector.Companion.isExpressionValueUnused((UElement)node) && !this.this$0.expectsSideEffect(this.$context, (UElement)node)) {
                    UElement uElement = (UElement)node;
                    Object object = node.getSourcePsi();
                    if (object == null || (object = object.getText()) == null) {
                        Object object2 = node.getValue();
                        object = object2 != null ? object2.toString() : node.asSourceString();
                    }
                    NoOpDetector.access$report(this.this$0, this.$context, uElement, (String)object);
                }
            }

            public void visitPolyadicExpression(UPolyadicExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Object object = CollectionsKt.singleOrNull((List)node.getOperands());
                ULiteralExpression uLiteralExpression = object instanceof ULiteralExpression ? (ULiteralExpression)object : null;
                if (uLiteralExpression == null) {
                    return;
                }
                ULiteralExpression operand = uLiteralExpression;
                if (CheckResultDetector.Companion.isExpressionValueUnused((UElement)node) && !this.this$0.expectsSideEffect(this.$context, (UElement)node)) {
                    UElement uElement = (UElement)operand;
                    Object object2 = operand.getSourcePsi();
                    if (object2 == null || (object2 = object2.getText()) == null) {
                        object2 = operand.asSourceString();
                    }
                    NoOpDetector.access$report(this.this$0, this.$context, uElement, (String)object2);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             * Converted monitor instructions to comments
             * Lifted jumps to return sites
             */
            private final void checkCall(UCallExpression call2, UQualifiedReferenceExpression node) {
                Object object;
                KaFunctionSymbol symbol;
                KaSession analysisSession$iv$iv;
                void this_$iv$iv;
                KtElement useSiteElement$iv$iv;
                block14: {
                    block13: {
                        Object lock$iv$iv;
                        KtElement sourcePsi;
                        PsiMethod method = call2.resolve();
                        Object object2 = method;
                        if (object2 != null && (object2 = object2.getName()) != null) {
                            Object object3 = object2;
                            boolean bl2 = false;
                            Object object4 = call2.getMethodIdentifier();
                            if (object4 == null || (object4 = object4.getName()) == null) {
                                object4 = object3;
                            }
                            PsiClass psiClass = method.getContainingClass();
                            this.checkCall(call2, node, (String)object4, method, psiClass != null ? psiClass.getQualifiedName() : null);
                        }
                        if (method != null) return;
                        PsiElement psiElement = call2.getSourcePsi();
                        if (!(psiElement instanceof KtElement)) return;
                        KtElement ktElement = (KtElement)psiElement;
                        if (ktElement == null) {
                            return;
                        }
                        KtElement useSiteElement$iv = sourcePsi = ktElement;
                        boolean bl = false;
                        Project project = useSiteElement$iv.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                        KaSessionProvider bl2 = KaSessionProvider.Companion.getInstance(project);
                        useSiteElement$iv$iv = useSiteElement$iv;
                        boolean $i$f$analyze = false;
                        analysisSession$iv$iv = this_$iv$iv.getAnalysisSession(useSiteElement$iv$iv);
                        this_$iv$iv.beforeEnteringAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
                        Object object5 = lock$iv$iv = new Object();
                        // MONITORENTER : object5
                        boolean bl3 = false;
                        KaSession $this$checkCall_u24lambda_u241 = analysisSession$iv$iv;
                        boolean bl4 = false;
                        if (AnalysisApiLintUtilsKt.getFunctionLikeSymbol($this$checkCall_u24lambda_u241, sourcePsi) != null) break block13;
                        // MONITOREXIT : object5
                        this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
                        return;
                    }
                    try {
                        KaFunctionSymbol kaFunctionSymbol;
                        symbol = kaFunctionSymbol;
                        object = symbol.getCallableId();
                        if (object != null && (object = object.getCallableName()) != null && (object = object.asString()) != null) break block14;
                        // MONITOREXIT : object5
                    }
                    catch (Throwable throwable$iv$iv) {
                        this_$iv$iv.handleAnalysisException(throwable$iv$iv, analysisSession$iv$iv, useSiteElement$iv$iv);
                        throw new KotlinNothingValueException();
                    }
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
                    return;
                }
                try {
                    Object object6 = object;
                    CallableId callableId = symbol.getCallableId();
                    this.checkCall(call2, node, (String)object6, null, callableId != null && (callableId = callableId.getClassId()) != null ? callableId.asFqNameString() : null);
                    Unit unit = Unit.INSTANCE;
                    // MONITOREXIT : object5
                    Unit unit2 = unit;
                    return;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    this_$iv$iv.afterLeavingAnalysis(analysisSession$iv$iv, useSiteElement$iv$iv);
                }
            }

            private final void checkCall(UCallExpression call2, UQualifiedReferenceExpression node, String callName, PsiMethod method, String containingClassFqName) {
                UCallExpression uCallExpression = call2;
                if (uCallExpression == null) {
                    uCallExpression = node;
                }
                UExpression uExpression = (UExpression)uCallExpression;
                Object object = method;
                if (object == null || (object = object.getName()) == null) {
                    object = callName;
                }
                if (!NoOpDetector.access$isPureMethod(this.this$0, this.$context, uExpression, method, (String)object, containingClassFqName)) {
                    return;
                }
                if (!CheckResultDetector.Companion.isExpressionValueUnused((UElement)node)) {
                    return;
                }
                if (NoOpDetector.access$isAnnotatedCheckResult(this.this$0, this.$context, method)) {
                    return;
                }
                if (this.this$0.expectsSideEffect(this.$context, (UElement)node)) {
                    return;
                }
                UCallExpression uCallExpression2 = call2;
                NoOpDetector.access$report(this.this$0, this.$context, (UElement)(uCallExpression2 != null ? (UExpression)uCallExpression2 : node.getSelector()), callName);
            }

            public void visitBinaryExpression(UBinaryExpression node) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                if (node.getOperator() instanceof UastBinaryOperator.AssignOperator) {
                    return;
                }
                if (node.resolveOperator() != null) {
                    return;
                }
                if (CheckResultDetector.Companion.isExpressionValueUnused((UElement)node) && !this.this$0.expectsSideEffect(this.$context, (UElement)node) && !com.android.tools.lint.checks.NoOpDetector$Issues.hasSideEffect$default(NoOpDetector.Issues, node.getLeftOperand(), 0, 0, 6, null) && !com.android.tools.lint.checks.NoOpDetector$Issues.hasSideEffect$default(NoOpDetector.Issues, node.getRightOperand(), 0, 0, 6, null)) {
                    UElement uElement = (UElement)node;
                    Object object = node.getSourcePsi();
                    if (object == null || (object = object.getText()) == null) {
                        object = node.asSourceString();
                    }
                    NoOpDetector.access$report(this.this$0, this.$context, uElement, (String)object);
                }
            }
        };
    }

    private final KtProperty getProperty(PsiElement $this$getProperty) {
        KtLightMember ktLightMember = $this$getProperty instanceof KtLightMember ? (KtLightMember)$this$getProperty : null;
        PsiElement psiElement = ktLightMember != null ? LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)ktLightMember)) : null;
        return psiElement instanceof KtProperty ? (KtProperty)psiElement : null;
    }

    private final KtParameter getParameter(PsiElement $this$getParameter) {
        KtLightMethod ktLightMethod = $this$getParameter instanceof KtLightMethod ? (KtLightMethod)$this$getParameter : null;
        PsiElement psiElement = ktLightMethod != null ? LightClassUtilsKt.getUnwrapped((PsiElement)((PsiElement)ktLightMethod)) : null;
        return psiElement instanceof KtParameter ? (KtParameter)psiElement : null;
    }

    private final boolean hasSideEffect(KtProperty $this$hasSideEffect) {
        return $this$hasSideEffect.getGetter() != null || $this$hasSideEffect.hasDelegate() || $this$hasSideEffect.hasDelegateExpression();
    }

    private final boolean isComplexPropertyMethod(PsiElement resolved) {
        KtProperty ktProperty = this.getProperty(resolved);
        if (ktProperty == null) {
            return false;
        }
        KtProperty property = ktProperty;
        return this.hasSideEffect(property);
    }

    private final boolean isUnit(PsiElement resolved) {
        PsiClass psiClass = resolved instanceof PsiClass ? (PsiClass)resolved : null;
        return Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)"kotlin.Unit");
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isPureMethod(JavaContext context2, UExpression node, PsiMethod method, String methodName, String containingClassFqName) {
        String string2;
        switch (methodName) {
            case "valueOf": 
            case "equals": {
                PsiMethod psiMethod = method;
                PsiMethod psiMethod2 = psiMethod;
                if (psiMethod == null) return false;
                PsiParameterList psiParameterList = psiMethod2.getParameterList();
                psiMethod2 = psiParameterList;
                if (psiParameterList == null) return false;
                if (psiMethod2.getParametersCount() != 1) return false;
                return true;
            }
            case "getText": 
            case "hashCode": 
            case "clone": 
            case "toString": {
                PsiMethod psiMethod = method;
                PsiMethod psiMethod3 = psiMethod;
                if (psiMethod == null) return false;
                PsiParameterList psiParameterList = psiMethod3.getParameterList();
                psiMethod3 = psiParameterList;
                if (psiParameterList == null) return false;
                if (psiMethod3.getParametersCount() != 0) return false;
                return true;
            }
            case "getClass": 
            case "getResourceResolver": 
            case "getAvailableFontFamilyNames": 
            case "getPreferredSize": 
            case "getInstance": {
                return false;
            }
            case "getComponent": {
                if (!this.isIn(method, "com.intellij.execution.ui.RunnerLayoutUi", context2)) break;
                return false;
            }
            case "isActive": {
                if (!this.isIn(method, "android.view.inputmethod.InputMethodManager", context2)) break;
                return false;
            }
            case "getDecorView": {
                if (!this.isIn(method, "android.view.Window", context2)) break;
                return false;
            }
            case "getValue": {
                if (this.isIn(method, "androidx.compose.runtime.State", context2)) return false;
                if (!this.isIn(method, "androidx.compose.runtime.MutableState", context2)) break;
                return false;
            }
            case "getCount": {
                if (!this.isIn(method, "android.database.Cursor", context2)) break;
                return false;
            }
        }
        if (StringsKt.startsWith$default((String)methodName, (String)"parse", (boolean)false, (int)2, null)) {
            void $this$getParentOfType$iv;
            UElement uElement = (UElement)node;
            boolean strict$iv = true;
            boolean $i$f$getParentOfType = false;
            UTryExpression uTryExpression = (UTryExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UTryExpression.class, (boolean)strict$iv);
            if (uTryExpression != null) {
                UTryExpression it = uTryExpression;
                boolean bl = false;
                if (!((Collection)it.getCatchClauses()).isEmpty()) {
                    return false;
                }
                boolean bl2 = false;
                if (bl2) {
                    return false;
                }
            }
        }
        if (Intrinsics.areEqual((Object)(string2 = containingClassFqName), (Object)"java.lang.String") || Intrinsics.areEqual((Object)string2, (Object)"java.lang.CharSequence") || Intrinsics.areEqual((Object)string2, (Object)"kotlin.text.StringsKt__StringsKt") || Intrinsics.areEqual((Object)string2, (Object)"kotlin.text.StringsKt")) {
            if ((Intrinsics.areEqual((Object)methodName, (Object)"getChars") || Intrinsics.areEqual((Object)methodName, (Object)"getBytes")) && method != null) {
                PsiParameter[] psiParameterArray = method.getParameterList().getParameters();
                Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
                Object[] $this$any$iv = psiParameterArray;
                boolean $i$f$any = false;
                for (Object element$iv : $this$any$iv) {
                    PsiParameter it = (PsiParameter)element$iv;
                    boolean bl = false;
                    if (!(it.getType() instanceof PsiArrayType)) continue;
                    return false;
                }
                boolean bl = false;
                if (bl) {
                    return false;
                }
            }
            if (method == null) return true;
            PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = method.getThrowsList().getReferenceElements();
            Intrinsics.checkNotNullExpressionValue((Object)psiJavaCodeReferenceElementArray, (String)"getReferenceElements(...)");
            if (((Object[])psiJavaCodeReferenceElementArray).length != 0) return false;
            return true;
        }
        if (Intrinsics.areEqual((Object)string2, (Object)"java.lang.Boolean")) return true;
        if (Intrinsics.areEqual((Object)string2, (Object)"java.lang.Long")) return true;
        if (Intrinsics.areEqual((Object)string2, (Object)"java.lang.Integer")) return true;
        if (Intrinsics.areEqual((Object)string2, (Object)"java.lang.Short")) return true;
        if (Intrinsics.areEqual((Object)string2, (Object)"java.lang.Byte")) return true;
        if (Intrinsics.areEqual((Object)string2, (Object)"java.lang.Float")) return true;
        if (Intrinsics.areEqual((Object)string2, (Object)"java.lang.Double")) return true;
        if (Intrinsics.areEqual((Object)string2, (Object)"java.lang.Number")) {
            return true;
        }
        if (Intrinsics.areEqual((Object)string2, (Object)"java.lang.Character")) {
            if (!Intrinsics.areEqual((Object)methodName, (Object)"toChars")) return true;
            if (method == null) return false;
            PsiParameter[] psiParameterArray = method.getParameterList().getParameters();
            Intrinsics.checkNotNullExpressionValue((Object)psiParameterArray, (String)"getParameters(...)");
            Object[] $this$none$iv = psiParameterArray;
            boolean $i$f$none = false;
            int n = 0;
            int n2 = $this$none$iv.length;
            while (n < n2) {
                Object element$iv = $this$none$iv[n];
                PsiParameter it = (PsiParameter)element$iv;
                boolean bl = false;
                if (it.getType() instanceof PsiArrayType) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        if (Intrinsics.areEqual((Object)string2, (Object)"java.net.URI")) {
            return true;
        }
        if (Intrinsics.areEqual((Object)string2, (Object)"java.net.URL")) {
            if (Intrinsics.areEqual((Object)methodName, (Object)"getContent")) return false;
            if (StringsKt.startsWith$default((String)methodName, (String)"set", (boolean)false, (int)2, null)) return false;
            if (StringsKt.startsWith$default((String)methodName, (String)"open", (boolean)false, (int)2, null)) return false;
            return true;
        }
        if (Intrinsics.areEqual((Object)string2, (Object)"android.database.sqlite.SQLiteOpenHelper")) return false;
        if (Intrinsics.areEqual((Object)string2, (Object)"androidx.sqlite.db.SupportSQLiteOpenHelper")) {
            return false;
        }
        if (CollectionsKt.contains((Iterable)KOTLIN_PRIMITIVES, (Object)string2)) {
            return true;
        }
        if (!NoOpDetector.Issues.isGetterName(methodName)) return false;
        if (!this.isGetter(method)) return false;
        if (ASSUME_PURE_GETTERS.getValue(context2.getConfiguration()) == false) return false;
        if (context2.getEvaluator().isStatic((PsiModifierListOwner)method)) {
            return false;
        }
        if (!this.isBufferMethod(context2, method)) return true;
        return false;
    }

    private final boolean isIn(PsiMethod $this$isIn, String containingClass, JavaContext context2) {
        return context2.getEvaluator().isMemberInClass((PsiMember)$this$isIn, containingClass);
    }

    @Override
    @NotNull
    public List<String> applicableAnnotations() {
        return CollectionsKt.listOf((Object)"org.jetbrains.annotations.Contract");
    }

    @Override
    public boolean isApplicableAnnotationUsage(@NotNull AnnotationUsageType type) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        return type == AnnotationUsageType.METHOD_CALL;
    }

    @Override
    public boolean inheritAnnotation(@NotNull String annotation) {
        Intrinsics.checkNotNullParameter((Object)annotation, (String)"annotation");
        return true;
    }

    @Override
    public void visitAnnotationUsage(@NotNull JavaContext context2, @NotNull UElement element, @NotNull AnnotationInfo annotationInfo, @NotNull AnnotationUsageInfo usageInfo) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)annotationInfo, (String)"annotationInfo");
        Intrinsics.checkNotNullParameter((Object)usageInfo, (String)"usageInfo");
        boolean pure = UastLintUtils.Companion.getAnnotationBooleanValue(annotationInfo.getAnnotation(), "pure", false);
        if (!pure) {
            return;
        }
        if (CheckResultDetector.Companion.isExpressionValueUnused(element)) {
            PsiElement psiElement = usageInfo.getReferenced();
            Object object = psiElement instanceof PsiNamedElement ? (PsiNamedElement)psiElement : null;
            if (object == null || (object = object.getName()) == null) {
                object = "?";
            }
            this.report(context2, element, (String)object);
        }
    }

    private final boolean isAnnotatedCheckResult(JavaContext context2, PsiMethod method) {
        boolean bl;
        block4: {
            Iterable $this$any$iv = JavaEvaluator.getAnnotations$default(context2.getEvaluator(), (PsiModifierListOwner)method, false, null, 6, null);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    String name;
                    UAnnotation it = (UAnnotation)element$iv;
                    boolean bl2 = false;
                    String string2 = it.getQualifiedName();
                    if (string2 == null) {
                        string2 = "";
                    }
                    if (!(StringsKt.endsWith$default((String)(name = string2), (String)"CheckResult", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)name, (String)"CheckReturnValue", (boolean)false, (int)2, null))) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public final boolean expectsSideEffect(@NotNull JavaContext context2, @NotNull UElement element) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        if (CheckResultDetector.Companion.expectsSideEffect(context2, element)) {
            return true;
        }
        UMethod containingMethod = (UMethod)UastUtils.getParentOfType$default((UElement)element, UMethod.class, (boolean)false, (int)2, null);
        if (containingMethod != null) {
            boolean bl;
            block11: {
                if (containingMethod.isConstructor() && containingMethod.getSourcePsi() instanceof KtClass) {
                    return true;
                }
                Iterable $this$any$iv = containingMethod.getUAnnotations();
                boolean $i$f$any = false;
                if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                    bl = false;
                } else {
                    for (Object element$iv : $this$any$iv) {
                        UAnnotation it = (UAnnotation)element$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getQualifiedName(), (Object)"androidx.compose.runtime.Composable")) continue;
                        bl = true;
                        break block11;
                    }
                    bl = false;
                }
            }
            if (bl) {
                return true;
            }
        } else {
            PsiClassInitializer psiClassInitializer;
            PsiElement psiElement = element.getSourcePsi();
            if (psiElement != null) {
                void $this$getParentOfType$iv;
                PsiElement $i$f$any = psiElement;
                boolean strict$iv = true;
                boolean $i$f$getParentOfType = false;
                psiClassInitializer = (PsiClassInitializer)PsiTreeUtil.getParentOfType((PsiElement)$this$getParentOfType$iv, PsiClassInitializer.class, (boolean)strict$iv);
            } else {
                psiClassInitializer = null;
            }
            if (psiClassInitializer != null) {
                return true;
            }
        }
        return false;
    }

    private final boolean isGetter(PsiMethod psiMethod) {
        if (psiMethod == null) {
            return false;
        }
        if (psiMethod.isConstructor() || psiMethod.hasParameters() || Intrinsics.areEqual((Object)psiMethod.getReturnType(), (Object)PsiTypes.voidType())) {
            return false;
        }
        PsiJavaCodeReferenceElement[] psiJavaCodeReferenceElementArray = psiMethod.getThrowsList().getReferenceElements();
        Intrinsics.checkNotNullExpressionValue((Object)psiJavaCodeReferenceElementArray, (String)"getReferenceElements(...)");
        if (!(((Object[])psiJavaCodeReferenceElementArray).length == 0)) {
            return false;
        }
        UExpression body = UastFacade.INSTANCE.getMethodBody(psiMethod);
        if (body != null) {
            return this.isGetterBody(body);
        }
        KtProperty property = this.getProperty((PsiElement)psiMethod);
        if (property != null) {
            return !this.hasSideEffect(property);
        }
        KtParameter parameter = this.getParameter((PsiElement)psiMethod);
        if (parameter != null) {
            return true;
        }
        return psiMethod instanceof PsiCompiledElement;
    }

    private final boolean isGetterBody(UExpression node) {
        UExpression expression;
        List expressions;
        if (node == null) {
            return true;
        }
        UExpression uExpression = node;
        if (uExpression instanceof UReferenceExpression || uExpression instanceof ULiteralExpression) {
            return true;
        }
        if (uExpression instanceof UBinaryExpression) {
            return !(((UBinaryExpression)node).getOperator() instanceof UastBinaryOperator.AssignOperator);
        }
        if (uExpression instanceof UPrefixExpression) {
            return !Intrinsics.areEqual((Object)((UPrefixExpression)node).getOperator(), (Object)UastPrefixOperator.DEC) && !Intrinsics.areEqual((Object)((UPrefixExpression)node).getOperator(), (Object)UastPrefixOperator.INC);
        }
        if (uExpression instanceof UBlockExpression && (expressions = ((UBlockExpression)node).getExpressions()).size() == 1 && (expression = (UExpression)expressions.get(0)) instanceof UReturnExpression) {
            return this.isGetterBody(((UReturnExpression)expression).getReturnExpression());
        }
        return false;
    }

    private final boolean isBufferMethod(JavaContext context2, PsiMethod method) {
        return method != null && JavaEvaluator.isMemberInSubClassOf$default(context2.getEvaluator(), (PsiMember)method, "java.nio.Buffer", false, 4, null);
    }

    private final void report(JavaContext context2, UElement expression, String name) {
        String message = "This " + (expression instanceof UCallExpression ? "call result" : "reference") + " is unused: " + name;
        JavaContext.report$default(context2, ISSUE, expression, context2.getLocation(expression), message, null, 16, null);
    }

    public static final /* synthetic */ KtProperty access$getProperty(NoOpDetector $this, PsiElement $receiver) {
        return $this.getProperty($receiver);
    }

    public static final /* synthetic */ boolean access$hasSideEffect(NoOpDetector $this, KtProperty $receiver) {
        return $this.hasSideEffect($receiver);
    }

    public static final /* synthetic */ KtParameter access$getParameter(NoOpDetector $this, PsiElement $receiver) {
        return $this.getParameter($receiver);
    }

    public static final /* synthetic */ boolean access$isUnit(NoOpDetector $this, PsiElement resolved) {
        return $this.isUnit(resolved);
    }

    public static final /* synthetic */ void access$report(NoOpDetector $this, JavaContext context2, UElement expression, String name) {
        $this.report(context2, expression, name);
    }

    public static final /* synthetic */ boolean access$isComplexPropertyMethod(NoOpDetector $this, PsiElement resolved) {
        return $this.isComplexPropertyMethod(resolved);
    }

    public static final /* synthetic */ boolean access$isPureMethod(NoOpDetector $this, JavaContext context2, UExpression node, PsiMethod method, String methodName, String containingClassFqName) {
        return $this.isPureMethod(context2, node, method, methodName, containingClassFqName);
    }

    public static final /* synthetic */ boolean access$isAnnotatedCheckResult(NoOpDetector $this, JavaContext context2, PsiMethod method) {
        return $this.isAnnotatedCheckResult(context2, method);
    }

    /*
     * WARNING - void declaration
     */
    static {
        void $this$mapTo$iv$iv;
        Issues = new Issues(null);
        IMPLEMENTATION = new Implementation(NoOpDetector.class, Scope.JAVA_FILE_SCOPE);
        ASSUME_PURE_GETTERS = new BooleanOption("pure-getters", "Whether to assume methods with getter-names have no side effects", false, "\n                Getter methods (where names start with `get` or `is`, and have non-void \\\n                return types, and no arguments) should not have side effects. With this \\\n                option turned on, lint will assume that is the case and will list any \\\n                getter calls whose results are ignored as suspicious code.\n                ");
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Object object = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        ISSUE = Issue.Companion.create$default(companion, "NoOp", "NoOp Code", "\n                This check looks for code which looks like it's a no-op -- usually \\\n                leftover expressions from interactive debugging, but in some cases \\\n                bugs where you had intended to do something with the expression such \\\n                as assign it to a field.\n                ", implementation, null, category, 0, object, false, null, null, null, 3664, null).setAliases(CollectionsKt.listOf((Object)"ResultOfMethodCallIgnored")).setOptions(CollectionsKt.listOf((Object)ASSUME_PURE_GETTERS));
        MAX_CALL_DEPTH = LintClient.Companion.isStudio() ? 1 : 2;
        MAX_RECURSION_DEPTH = LintClient.Companion.isStudio() ? 5 : 10;
        MAX_STATEMENT_COUNT = LintClient.Companion.isStudio() ? 8 : 20;
        Iterable $this$map$iv = StandardClassIds.INSTANCE.getPrimitiveTypes();
        boolean $i$f$map = false;
        object = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ClassId classId = (ClassId)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.asFqNameString());
        }
        KOTLIN_PRIMITIVES = (List)((Object)implementation);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J&\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\b\u0002\u0010\u0014\u001a\u00020\r2\b\b\u0002\u0010\u0015\u001a\u00020\rH\u0002J\u0010\u0010\u0016\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0013H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00180\u001cX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lcom/android/tools/lint/checks/NoOpDetector$Issues;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "ASSUME_PURE_GETTERS", "Lcom/android/tools/lint/detector/api/BooleanOption;", "getASSUME_PURE_GETTERS", "()Lcom/android/tools/lint/detector/api/BooleanOption;", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "MAX_CALL_DEPTH", "", "MAX_RECURSION_DEPTH", "MAX_STATEMENT_COUNT", "hasSideEffect", "", "node", "Lorg/jetbrains/uast/UExpression;", "depth", "callDepth", "isGetterName", "name", "", "isLocal", "lhs", "KOTLIN_PRIMITIVES", "", "android.sdktools.lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        @NotNull
        public final BooleanOption getASSUME_PURE_GETTERS() {
            return ASSUME_PURE_GETTERS;
        }

        private final boolean hasSideEffect(UExpression node, int depth, int callDepth) {
            if (node == null) {
                return false;
            }
            if (depth == MAX_RECURSION_DEPTH) {
                return true;
            }
            UExpression uExpression = node;
            if (uExpression instanceof UUnaryExpression) {
                UastOperator operator = ((UUnaryExpression)node).getOperator();
                if (Intrinsics.areEqual((Object)operator, (Object)UastPrefixOperator.INC) || Intrinsics.areEqual((Object)operator, (Object)UastPrefixOperator.DEC) || Intrinsics.areEqual((Object)operator, (Object)UastPostfixOperator.INC) || Intrinsics.areEqual((Object)operator, (Object)UastPostfixOperator.DEC)) {
                    return callDepth <= 0 || !this.isLocal(((UUnaryExpression)node).getOperand());
                }
                return this.hasSideEffect(((UUnaryExpression)node).getOperand(), depth + 1, callDepth);
            }
            if (uExpression instanceof UPolyadicExpression) {
                if (node instanceof UBinaryExpression && ((UBinaryExpression)node).getOperator() instanceof UastBinaryOperator.AssignOperator && (callDepth == 0 || !this.isLocal(((UBinaryExpression)node).getLeftOperand()))) {
                    return true;
                }
                for (UExpression operand : ((UPolyadicExpression)node).getOperands()) {
                    if (!this.hasSideEffect(operand, depth + 1, callDepth)) continue;
                    return true;
                }
            } else {
                if (uExpression instanceof UQualifiedReferenceExpression) {
                    return this.hasSideEffect(((UQualifiedReferenceExpression)node).getSelector(), depth + 1, callDepth);
                }
                if (uExpression instanceof UParenthesizedExpression) {
                    return this.hasSideEffect(((UParenthesizedExpression)node).getExpression(), depth + 1, callDepth);
                }
                if (uExpression instanceof UCallExpression) {
                    if (callDepth >= MAX_CALL_DEPTH) {
                        return true;
                    }
                    PsiMethod psiMethod = ((UCallExpression)node).resolve();
                    if (psiMethod == null) {
                        return true;
                    }
                    PsiMethod called = psiMethod;
                    if (called instanceof PsiCompiledElement) {
                        String string2 = called.getName();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                        return !this.isGetterName(string2) && !Intrinsics.areEqual((Object)called.getName(), (Object)"toString");
                    }
                    UMethod uMethod = Lint.getUMethod(called);
                    if (uMethod == null || (uMethod = uMethod.getUastBody()) == null) {
                        return true;
                    }
                    UMethod body = uMethod;
                    if (this.hasSideEffect((UExpression)body, depth + 1, callDepth + 1)) {
                        return true;
                    }
                } else {
                    if (uExpression instanceof UReturnExpression) {
                        return callDepth == 0 || this.hasSideEffect(((UReturnExpression)node).getReturnExpression(), depth + 1, callDepth);
                    }
                    if (uExpression instanceof UIfExpression) {
                        if (this.hasSideEffect(((UIfExpression)node).getCondition(), depth + 1, callDepth) || this.hasSideEffect(((UIfExpression)node).getThenExpression(), depth + 1, callDepth) || this.hasSideEffect(((UIfExpression)node).getElseExpression(), depth + 1, callDepth)) {
                            return true;
                        }
                    } else if (uExpression instanceof UTryExpression) {
                        if (this.hasSideEffect(((UTryExpression)node).getTryClause(), depth + 1, callDepth) || this.hasSideEffect(((UTryExpression)node).getFinallyClause(), depth + 1, callDepth)) {
                            return true;
                        }
                    } else if (uExpression instanceof UBlockExpression) {
                        List expressions = ((UBlockExpression)node).getExpressions();
                        if (expressions.size() >= MAX_STATEMENT_COUNT) {
                            return true;
                        }
                        for (UExpression expression : expressions) {
                            if (!this.hasSideEffect(expression, depth + 1, callDepth)) continue;
                            return true;
                        }
                    } else {
                        if (uExpression instanceof ULoopExpression) {
                            return this.hasSideEffect(((ULoopExpression)node).getBody(), depth + 1, callDepth);
                        }
                        if (uExpression instanceof UThisExpression || uExpression instanceof USuperExpression) {
                            return true;
                        }
                        if (uExpression instanceof UThrowExpression) {
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        static /* synthetic */ boolean hasSideEffect$default(Issues issues, UExpression uExpression, int n, int n2, int n3, Object object) {
            if ((n3 & 2) != 0) {
                n = 0;
            }
            if ((n3 & 4) != 0) {
                n2 = 0;
            }
            return issues.hasSideEffect(uExpression, n, n2);
        }

        private final boolean isGetterName(String name) {
            int length = name.length();
            if (StringsKt.startsWith$default((String)name, (String)"is", (boolean)false, (int)2, null) && length > 2 && Character.isUpperCase(name.charAt(2))) {
                return true;
            }
            if (StringsKt.startsWith$default((String)name, (String)"get", (boolean)false, (int)2, null) && length > 3 && Character.isUpperCase(name.charAt(3))) {
                return !StringsKt.startsWith$default((String)name, (String)"getAnd", (boolean)false, (int)2, null) || length <= 6 || !Character.isUpperCase(name.charAt(6));
            }
            return false;
        }

        private final boolean isLocal(UExpression lhs) {
            PsiElement resolved = UastUtils.tryResolve((UElement)((UElement)lhs));
            return resolved instanceof PsiLocalVariable || resolved instanceof PsiParameter;
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

