/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.gradle.Version;
import com.android.tools.lint.checks.GradleDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.model.LintModelExternalLibrary;
import com.android.tools.lint.model.LintModelLibrary;
import com.android.tools.lint.model.LintModelMavenName;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UClass;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000e2\u00020\u00012\u00020\u0002:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/MediaBrowserServiceCompatVersionDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "applicableSuperClasses", "", "", "visitClass", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "declaration", "Lorg/jetbrains/uast/UClass;", "Issues", "android.sdktools.lint-checks"})
public final class MediaBrowserServiceCompatVersionDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Issues Issues = new Issues(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final Version MIN_SUPPORT_V4_VERSION;
    @NotNull
    public static final String MEDIA_BROWSER_SERVICE_COMPAT = "android.support.v4.media.MediaBrowserServiceCompat";

    @Override
    @NotNull
    public List<String> applicableSuperClasses() {
        return CollectionsKt.listOf((Object)MEDIA_BROWSER_SERVICE_COMPAT);
    }

    @Override
    public void visitClass(@NotNull JavaContext context2, @NotNull UClass declaration) {
        Version libVersion;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (!context2.getEvaluator().extendsClass(declaration.getJavaPsi(), MEDIA_BROWSER_SERVICE_COMPAT, true)) {
            return;
        }
        Object object = context2.getProject().getBuildVariant();
        LintModelLibrary lintModelLibrary = object != null && (object = object.getMainArtifact()) != null ? object.findCompileDependency("com.android.support:support-v4") : null;
        LintModelExternalLibrary lintModelExternalLibrary = lintModelLibrary instanceof LintModelExternalLibrary ? (LintModelExternalLibrary)lintModelLibrary : null;
        if (lintModelExternalLibrary == null) {
            return;
        }
        LintModelExternalLibrary library2 = lintModelExternalLibrary;
        LintModelMavenName mc = library2.getResolvedCoordinates();
        if (!StringsKt.isBlank((CharSequence)mc.getVersion()) && (libVersion = Version.Companion.parse(mc.getVersion())).compareTo(MIN_SUPPORT_V4_VERSION) < 0) {
            Location location = GradleDetector.Companion.getDependencyLocation(context2, mc);
            String message = "Using a version of the class that is not forward compatible";
            Context.report$default(context2, ISSUE, location, message, null, 8, null);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(MediaBrowserServiceCompatVersionDetector.class, Scope.JAVA_FILE_SCOPE);
        ISSUE = Issue.Companion.create$default(companion, "IncompatibleMediaBrowserServiceCompatVersion", "Obsolete version of MediaBrowserServiceCompat", "\n            `MediaBrowserServiceCompat` from version 23.2.0 to 23.4.0 of the Support v4 Library \\\n            used private APIs and will not be compatible with future versions of Android beyond Android N. \\\n            Please upgrade to version 24.0.0 or higher of the Support Library.", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
        MIN_SUPPORT_V4_VERSION = Version.Companion.parse("24.0.0");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/lint/checks/MediaBrowserServiceCompatVersionDetector$Issues;", "", "<init>", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "MIN_SUPPORT_V4_VERSION", "Lcom/android/ide/common/gradle/Version;", "getMIN_SUPPORT_V4_VERSION", "()Lcom/android/ide/common/gradle/Version;", "MEDIA_BROWSER_SERVICE_COMPAT", "", "android.sdktools.lint-checks"})
    public static final class Issues {
        private Issues() {
        }

        @NotNull
        public final Version getMIN_SUPPORT_V4_VERSION() {
            return MIN_SUPPORT_V4_VERSION;
        }

        public /* synthetic */ Issues(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

