/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.DomExtensions;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u00012\u00020\u0002:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lcom/android/tools/lint/checks/LeanbackWifiUsageDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "<init>", "()V", "checkMergedProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "Companion", "android.sdktools.lint-checks"})
public final class LeanbackWifiUsageDetector
extends Detector
implements XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String LEANBACK_ATTR_NAME = "android.software.leanback";
    @NotNull
    private static final String WIFI_FEATURE_NAME = "android.hardware.wifi";
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @Override
    public void checkMergedProject(@NotNull Context context2) {
        boolean wifiFeatureNodeRequired;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Element wifiFeatureNode = null;
        Node node = context2.getMainProject().getMergedManifest();
        if (node == null || (node = node.getDocumentElement()) == null) {
            return;
        }
        Node document = node;
        Element wifiPermissionsNode = null;
        boolean hasLeanBack = false;
        Iterator iterator = DomExtensions.iterator((Element)document);
        while (iterator.hasNext()) {
            String name;
            Element element = (Element)iterator.next();
            String string2 = element.getTagName();
            if (Intrinsics.areEqual((Object)string2, (Object)"uses-feature")) {
                name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
                if (Intrinsics.areEqual((Object)name, (Object)LEANBACK_ATTR_NAME)) {
                    hasLeanBack = true;
                    continue;
                }
                if (!Intrinsics.areEqual((Object)name, (Object)WIFI_FEATURE_NAME)) continue;
                wifiFeatureNode = element;
                continue;
            }
            if (!Intrinsics.areEqual((Object)string2, (Object)"uses-permission")) continue;
            name = element.getAttributeNS("http://schemas.android.com/apk/res/android", "name");
            Intrinsics.checkNotNull((Object)name);
            if (!LeanbackWifiUsageDetector.Companion.isWifiStatePermission(name)) continue;
            wifiPermissionsNode = element;
        }
        if (!hasLeanBack) {
            return;
        }
        Element element = wifiFeatureNode;
        if (element != null) {
            Element wifiNode = element;
            boolean bl = false;
            v2 = !Intrinsics.areEqual((Object)wifiNode.getAttributeNS("http://schemas.android.com/apk/res/android", "required"), (Object)"false");
        } else {
            v2 = wifiFeatureNodeRequired = false;
        }
        if (wifiFeatureNode != null) {
            if (wifiFeatureNodeRequired) {
                Context.report$default(context2, ISSUE, Context.getLocation$default(context2, wifiFeatureNode, null, 2, null), "Requiring `android.hardware.wifi` limits app availability on TVs that support only Ethernet", null, 8, null);
            }
        } else if (wifiPermissionsNode != null) {
            Context.report$default(context2, ISSUE, Context.getLocation$default(context2, wifiPermissionsNode, null, 2, null), "Requiring Wifi permissions limits app availability on TVs that support only Ethernet", null, 8, null);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(LeanbackWifiUsageDetector.class, Scope.MANIFEST_SCOPE);
        ISSUE = Issue.Companion.create$default(companion, "LeanbackUsesWifi", "Using android.hardware.wifi on TV", "\n                WiFi is not required for Android TV and many devices connect to the internet via \\\n                alternative methods e.g. Ethernet.\n\n                If your app is not focused specifically on WiFi functionality and only wishes to \\\n                connect to the internet, please modify your Manifest to contain: \\\n                `<uses-feature android:name=\"android.hardware.wifi\" android:required=\"false\" />`\n\n                Un-metered or non-roaming connections can be detected in software using \\\n                `NetworkCapabilities#NET_CAPABILITY_NOT_METERED` and \\\n                `NetworkCapabilities#NET_CAPABILITY_NOT_ROAMING.`\n                ", implementation, null, category, 5, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/lint/checks/LeanbackWifiUsageDetector$Companion;", "", "<init>", "()V", "LEANBACK_ATTR_NAME", "", "WIFI_FEATURE_NAME", "isWifiStatePermission", "", "s", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isWifiStatePermission(String s) {
            String string2 = s;
            switch (string2.hashCode()) {
                case 272779126: {
                    if (string2.equals("android.permission.CHANGE_WIFI_STATE")) return true;
                    return false;
                }
                case -743947761: {
                    if (string2.equals("android.permission.CHANGE_WIFI_MULTICAST_STATE")) return true;
                    return false;
                }
                case 1675316546: {
                    if (!string2.equals("android.permission.ACCESS_WIFI_STATE")) return false;
                    return true;
                }
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

