/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.Api;
import com.android.tools.lint.checks.ApiClassBase;
import com.android.tools.lint.checks.ApiDatabase;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.checks.ApiMember;
import com.android.tools.lint.checks.ApiParser;
import com.android.utils.Pair;
import com.google.common.collect.Iterables;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class ApiClass
extends ApiClassBase {
    public static final boolean STRIP_MEMBERS = true;
    public static final boolean USE_HASH_CODES = true;
    public static final int USING_HASH_CODE_MASK = Integer.MIN_VALUE;
    private final String mSdks;
    private final int mSince;
    private final int mDeprecatedIn;
    private final int mRemovedIn;
    private final List<Pair<String, Integer>> mSuperClasses = new ArrayList<Pair<String, Integer>>();
    private final List<Pair<String, Integer>> mInterfaces = new ArrayList<Pair<String, Integer>>();
    private final Map<String, Integer> mFields = new HashMap<String, Integer>();
    private final Map<String, Integer> mMethods = new HashMap<String, Integer>();
    private final Map<String, String> mMemberSdks = new HashMap<String, String>();
    private Map<String, Integer> mMembersDeprecatedIn;
    private Map<String, Integer> mElementsRemovedIn;

    ApiClass(String name, String sdks, int since, int deprecatedIn, int removedIn) {
        super(name);
        if (name.equals("android/os/ext/SdkExtensions") && since == 8448) {
            since = ApiParser.toVersionInt(30, 0);
        }
        this.mSdks = sdks;
        this.mSince = since;
        this.mDeprecatedIn = deprecatedIn;
        this.mRemovedIn = removedIn;
    }

    public String getSdks() {
        return this.mSdks;
    }

    int getSince() {
        return this.mSince;
    }

    int getDeprecatedIn() {
        return this.mDeprecatedIn;
    }

    int getRemovedIn() {
        return this.mRemovedIn;
    }

    int getFieldSince(String name, Api<? extends ApiClassBase> info) {
        int apiLevel = this.getValueWithDefault(this.mFields, name, 0);
        ApiClassBase maxFrom = null;
        for (Pair superClassPair : Iterables.concat(this.mSuperClasses, this.mInterfaces)) {
            int i;
            ApiClassBase superClass = info.getClass((String)superClassPair.getFirst());
            if (!(superClass instanceof ApiClass) || (i = ((ApiClass)superClass).getFieldSince(name, info)) == 0) continue;
            int tmp = Math.max((Integer)superClassPair.getSecond(), i);
            if (apiLevel != 0 && tmp >= apiLevel) continue;
            apiLevel = tmp;
            maxFrom = superClass;
        }
        if (apiLevel > this.mSince && this.mSdks != null && maxFrom != null && ((ApiClass)maxFrom).getMemberSdks(name, info) == null) {
            this.mMemberSdks.put(name, "0:" + ApiParser.getMajorVersion(apiLevel) + "." + ApiParser.getMinorVersion(apiLevel));
        }
        return apiLevel;
    }

    int getMemberDeprecatedIn(String name, Api info) {
        int apiLevel = this.getValueWithDefault(this.mMembersDeprecatedIn, name, 0);
        return apiLevel == 0 ? this.mDeprecatedIn : (this.mDeprecatedIn == 0 ? apiLevel : Math.min(apiLevel, this.mDeprecatedIn));
    }

    String getMemberSdks(String name, Api info) {
        String sdks = this.mMemberSdks.get(name);
        if (sdks == null) {
            sdks = this.mSdks;
        }
        return sdks;
    }

    int getMemberRemovedIn(String name, Api info) {
        int removedIn = this.getMemberRemovedInInternal(name, info);
        return removedIn == Integer.MAX_VALUE ? this.mRemovedIn : (removedIn > 0 ? removedIn : 0);
    }

    private int getMemberRemovedInInternal(String name, Api<ApiClass> info) {
        int apiLevel = this.getValueWithDefault(this.mElementsRemovedIn, name, Integer.MAX_VALUE);
        if (apiLevel == Integer.MAX_VALUE) {
            if (this.mMethods.containsKey(name) || this.mFields.containsKey(name)) {
                return this.mRemovedIn == 0 ? Integer.MAX_VALUE : this.mRemovedIn;
            }
            apiLevel = -1;
        }
        for (Pair superClassPair : Iterables.concat(this.mSuperClasses, this.mInterfaces)) {
            int tmp;
            int i;
            ApiClass superClass;
            String superClassName = (String)superClassPair.getFirst();
            int superClassRemovedIn = this.getValueWithDefault(this.mElementsRemovedIn, superClassName, Integer.MAX_VALUE);
            if (superClassRemovedIn <= apiLevel || (superClass = info.getClass(superClassName)) == null || (i = superClass.getMemberRemovedInInternal(name, info)) == -1 || (tmp = Math.min(superClassRemovedIn, i)) <= apiLevel) continue;
            apiLevel = tmp;
        }
        return apiLevel;
    }

    private int getValueWithDefault(Map<String, Integer> map2, String key, int defaultValue) {
        if (map2 == null) {
            return defaultValue;
        }
        Integer value = map2.get(key);
        return value == null ? defaultValue : value;
    }

    int getMethodSince(String methodSignature, Api<? extends ApiClassBase> info) {
        int apiLevel = this.getValueWithDefault(this.mMethods, methodSignature, 0);
        if (!methodSignature.startsWith("<init>")) {
            ApiClassBase maxFrom = null;
            for (Pair pair2 : Iterables.concat(this.mSuperClasses, this.mInterfaces)) {
                int i;
                ApiClassBase superClass = info.getClass((String)pair2.getFirst());
                if (!(superClass instanceof ApiClass) || (i = ((ApiClass)superClass).getMethodSince(methodSignature, info)) == 0) continue;
                int tmp = Math.max((Integer)pair2.getSecond(), i);
                if (apiLevel != 0 && tmp >= apiLevel) continue;
                maxFrom = superClass;
                apiLevel = tmp;
            }
            if (apiLevel > this.mSince && this.mSdks != null && maxFrom != null && ((ApiClass)maxFrom).getMemberSdks(methodSignature, info) == null) {
                this.mMemberSdks.put(methodSignature, "0:" + ApiParser.getMajorVersion(apiLevel) + "." + ApiParser.getMinorVersion(apiLevel));
            }
        }
        return apiLevel;
    }

    void addField(String name, String sdks, int since, int deprecatedIn, int removedIn) {
        this.mFields.put(name, since);
        this.mMemberSdks.put(name, sdks);
        this.addToDeprecated(name, deprecatedIn);
        this.addToRemoved(name, removedIn);
    }

    void addMethod(String name, String sdks, int since, int deprecatedIn, int removedIn) {
        int index2 = name.indexOf(41);
        if (index2 != -1) {
            name = name.substring(0, index2 + 1);
        }
        this.mMethods.put(name, since);
        this.mMemberSdks.put(name, sdks);
        this.addToDeprecated(name, deprecatedIn);
        this.addToRemoved(name, removedIn);
    }

    void addSuperClass(String superClass, int since, int removedIn) {
        ApiClass.addToArray(this.mSuperClasses, superClass, since);
        this.addToRemoved(superClass, removedIn);
    }

    void addInterface(String interfaceClass, int since, int removedIn) {
        ApiClass.addToArray(this.mInterfaces, interfaceClass, since);
        this.addToRemoved(interfaceClass, removedIn);
    }

    public Collection<String> getMethods() {
        return this.mMethods.keySet();
    }

    public Collection<String> getFields() {
        return this.mFields.keySet();
    }

    static void addToArray(List<Pair<String, Integer>> list2, String name, int value) {
        for (Pair<String, Integer> pair2 : list2) {
            if (!name.equals(pair2.getFirst())) continue;
            assert (false);
            return;
        }
        list2.add((Pair<String, Integer>)Pair.of((Object)name, (Object)value));
    }

    private void addToDeprecated(String name, int deprecatedIn) {
        if (deprecatedIn > 0) {
            if (this.mMembersDeprecatedIn == null) {
                this.mMembersDeprecatedIn = new HashMap<String, Integer>();
            }
            this.mMembersDeprecatedIn.put(name, deprecatedIn);
        }
    }

    private void addToRemoved(String name, int removedIn) {
        if (removedIn > 0) {
            if (this.mElementsRemovedIn == null) {
                this.mElementsRemovedIn = new HashMap<String, Integer>();
            }
            this.mElementsRemovedIn.put(name, removedIn);
        }
    }

    Set<String> getAllMethods(Api info) {
        HashSet<String> members = new HashSet<String>(100);
        this.addAllMethods(info, members, true);
        return members;
    }

    List<Pair<String, Integer>> getInterfaces() {
        return this.mInterfaces;
    }

    public List<Pair<String, Integer>> getAllInterfaces(Api<? extends ApiClassBase> info) {
        if (!this.mInterfaces.isEmpty()) {
            ArrayList<Pair<String, Integer>> interfaces = new ArrayList<Pair<String, Integer>>();
            this.addAllInterfaces(info, interfaces, this.getSince(), new HashMap<String, Integer>());
            return interfaces;
        }
        return this.mInterfaces;
    }

    private void addAllInterfaces(Api<? extends ApiClassBase> info, List<Pair<String, Integer>> list2, int since, Map<String, Integer> processed) {
        processed.put(this.getName(), since);
        since = Math.max(since, this.getSince());
        this.addAllInterfaces(info, list2, since, processed, this.mInterfaces, true);
        this.addAllInterfaces(info, list2, since, processed, this.mSuperClasses, false);
    }

    private void addAllInterfaces(Api<? extends ApiClassBase> info, List<Pair<String, Integer>> list2, int since, Map<String, Integer> processed, List<Pair<String, Integer>> classes, boolean isInterface) {
        for (Pair<String, Integer> classAndVersion : classes) {
            ApiClassBase cls;
            Integer processedSince;
            String className = (String)classAndVersion.getFirst();
            if (className.equals("java/lang/Object")) continue;
            int sinceMax = Math.max(since, (Integer)classAndVersion.getSecond());
            if (isInterface) {
                this.addInterface(className, sinceMax, list2);
            }
            if ((processedSince = processed.get(className)) != null && processedSince <= sinceMax || !((cls = info.getClass(className)) instanceof ApiClass)) continue;
            ((ApiClass)cls).addAllInterfaces(info, list2, sinceMax, processed);
        }
    }

    private void addInterface(String interfaceName, int since, List<Pair<String, Integer>> list2) {
        int n = list2.size();
        for (int i = 0; i < n; ++i) {
            Pair<String, Integer> pair2 = list2.get(i);
            if (!((String)pair2.getFirst()).equals(interfaceName)) continue;
            if (since < (Integer)pair2.getSecond()) {
                list2.set(i, (Pair<String, Integer>)Pair.of((Object)interfaceName, (Object)since));
            }
            return;
        }
        list2.add((Pair<String, Integer>)Pair.of((Object)interfaceName, (Object)since));
    }

    List<Pair<String, Integer>> getSuperClasses() {
        return this.mSuperClasses;
    }

    private void addAllMethods(Api<ApiClass> info, Set<String> set2, boolean includeConstructors) {
        if (includeConstructors) {
            set2.addAll(this.mMethods.keySet());
        } else {
            for (String method : this.mMethods.keySet()) {
                if (method.startsWith("<init>")) continue;
                set2.add(method);
            }
        }
        for (Pair superClass : Iterables.concat(this.mSuperClasses, this.mInterfaces)) {
            ApiClass cls = info.getClass((String)superClass.getFirst());
            if (cls == null) continue;
            cls.addAllMethods(info, set2, false);
        }
    }

    Set<String> getAllFields(Api info) {
        HashSet<String> members = new HashSet<String>(100);
        this.addAllFields(info, members);
        return members;
    }

    private void addAllFields(Api<ApiClass> info, Set<String> set2) {
        set2.addAll(this.mFields.keySet());
        for (Pair superClass : Iterables.concat(this.mSuperClasses, this.mInterfaces)) {
            ApiClass cls = info.getClass((String)superClass.getFirst());
            if (cls == null) {
                throw new RuntimeException("Incomplete database file: could not resolve super class " + (String)superClass.getFirst() + " from " + this.getName());
            }
            cls.addAllFields(info, set2);
        }
    }

    Collection<ApiMember> getAllRemovedFields(Api info) {
        Set<String> fields = this.getAllFields(info);
        if (fields.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<ApiMember> removedFields = new ArrayList<ApiMember>();
        for (String fieldName : fields) {
            int removedIn = this.getMemberRemovedIn(fieldName, info);
            if (removedIn <= 0) continue;
            int since = this.getFieldSince(fieldName, info);
            assert (since > 0);
            int deprecatedIn = this.getMemberDeprecatedIn(fieldName, info);
            removedFields.add(new ApiMember(fieldName, since, deprecatedIn, removedIn));
        }
        return removedFields;
    }

    Collection<ApiMember> getAllRemovedMethods(Api info) {
        Set<String> methods = this.getAllMethods(info);
        if (methods.isEmpty()) {
            return Collections.emptySet();
        }
        ArrayList<ApiMember> removedMethods = new ArrayList<ApiMember>();
        for (String methodSignature : methods) {
            int removedIn = this.getMemberRemovedIn(methodSignature, info);
            if (removedIn <= 0) continue;
            int since = this.getMethodSince(methodSignature, info);
            assert (since > 0);
            int deprecatedIn = this.getMemberDeprecatedIn(methodSignature, info);
            removedMethods.add(new ApiMember(methodSignature, since, deprecatedIn, removedIn));
        }
        return removedMethods;
    }

    @Override
    void writeSuperInterfaces(Api<? extends ApiClassBase> info, ByteBuffer buffer) {
        int api2;
        List<Pair<String, Integer>> supers;
        int since = this.getSince();
        int deprecatedIn = this.getDeprecatedIn();
        int removedIn = this.getRemovedIn();
        String sdks = this.getSdks();
        ApiClass.writeSinceDeprecatedInRemovedIn(info, buffer, since, deprecatedIn, removedIn, sdks);
        List<Pair<String, Integer>> interfaces = this.getAllInterfaces(info);
        int count = 0;
        if (!interfaces.isEmpty()) {
            for (Pair<String, Integer> pair2 : interfaces) {
                int api3 = (Integer)pair2.getSecond();
                if (api3 <= this.getSince()) continue;
                ++count;
            }
        }
        if (!(supers = this.getSuperClasses()).isEmpty()) {
            for (Pair<String, Integer> pair3 : supers) {
                api2 = (Integer)pair3.getSecond();
                if (api2 <= this.getSince()) continue;
                ++count;
            }
        }
        buffer.put((byte)count);
        if (count > 0) {
            for (Pair<String, Integer> pair4 : supers) {
                api2 = (Integer)pair4.getSecond();
                if (api2 <= this.getSince()) continue;
                ApiClassBase superClass = info.getClasses().get(pair4.getFirst());
                assert (superClass != null) : this;
                ApiDatabase.put3ByteInt(buffer, superClass.index);
                ApiClass.writeConstraintReference(info.getSdkIndex(api2), buffer, false);
            }
            for (Pair<String, Integer> pair5 : interfaces) {
                api2 = (Integer)pair5.getSecond();
                if (api2 <= this.getSince()) continue;
                ApiClassBase interfaceClass = info.getClasses().get(pair5.getFirst());
                assert (interfaceClass != null) : this;
                ApiDatabase.put3ByteInt(buffer, interfaceClass.index);
                ApiClass.writeConstraintReference(info.getSdkIndex(api2), buffer, false);
            }
        }
    }

    private static void writeConstraintReference(int index2, ByteBuffer buffer, boolean hasExtraByte) {
        boolean isShort;
        boolean bl = isShort = index2 >= 64;
        if (isShort) {
            int left = index2 >> 8 | 0x40;
            if (hasExtraByte) {
                left |= 0x80;
            }
            buffer.put((byte)left);
            buffer.put((byte)(index2 & 0xFF));
        } else {
            if (hasExtraByte) {
                index2 |= 0x80;
            }
            buffer.put((byte)index2);
        }
    }

    @Override
    int computeExtraStorageNeeded(Api<? extends ApiClassBase> info) {
        int estimatedSize = 0;
        this.initializeMembers(info);
        estimatedSize += 6;
        if (this.getSuperClasses().size() > 1) {
            estimatedSize += 2 + 4 * this.getSuperClasses().size();
        }
        for (String member : this.members) {
            estimatedSize += member.length();
            estimatedSize += 16;
        }
        return estimatedSize;
    }

    void initializeMembers(Api<? extends ApiClassBase> info) {
        Set<String> allMethods = this.getAllMethods(info);
        Set<String> allFields = this.getAllFields(info);
        ArrayList<String> members = new ArrayList<String>(allMethods.size() + allFields.size());
        for (String member : allMethods) {
            if (this.getMethodSince(member, info) == this.getSince() && this.getMemberDeprecatedIn(member, info) == this.getDeprecatedIn() && this.getMemberRemovedIn(member, info) == this.getRemovedIn() && this.getMemberSdks(member, info) == null) continue;
            members.add(member);
        }
        for (String member : allFields) {
            if (this.getFieldSince(member, info) == this.getSince() && this.getMemberDeprecatedIn(member, info) == this.getDeprecatedIn() && this.getMemberRemovedIn(member, info) == this.getRemovedIn() && this.getMemberSdks(member, info) == null) continue;
            members.add(member);
        }
        this.includeNames = this.getName().equals("android/Manifest$permission");
        HashSet<Integer> hashCodes = new HashSet<Integer>();
        if (!this.includeNames) {
            for (String member : members) {
                if (hashCodes.add(ApiLookup.signatureHashCode(member, null))) continue;
                this.includeNames = true;
                break;
            }
        }
        if (this.includeNames) {
            Collections.sort(members);
        } else {
            members.sort(Comparator.comparingInt(o -> ApiLookup.signatureHashCode(o, null)));
        }
        this.members = members;
    }

    @Override
    void writeMemberData(Api<? extends ApiClassBase> info, String member, ByteBuffer buffer) {
        int since = member.indexOf(40) >= 0 ? this.getMethodSince(member, info) : this.getFieldSince(member, info);
        if (since == 0) {
            assert (false) : this.getName() + ":" + member;
            since = 1;
        }
        int deprecatedIn = this.getMemberDeprecatedIn(member, info);
        assert (deprecatedIn >= 0) : "Invalid deprecatedIn " + deprecatedIn + " for " + member;
        int removedIn = this.getMemberRemovedIn(member, info);
        assert (removedIn >= 0) : "Invalid removedIn " + removedIn + " for " + member;
        String sdks = this.getMemberSdks(member, info);
        if (!this.includeNames) {
            int hashCode = ApiLookup.signatureHashCode(member, null);
            buffer.putInt(hashCode);
        } else {
            byte[] signature;
            for (byte b : signature = member.getBytes(StandardCharsets.UTF_8)) {
                assert (b == (b & 0x7F)) : member;
                buffer.put(b);
                if (b == 41) break;
            }
            buffer.put((byte)0);
        }
        ApiClass.writeSinceDeprecatedInRemovedIn(info, buffer, since, deprecatedIn, removedIn, sdks);
    }

    private static void writeSinceDeprecatedInRemovedIn(Api<? extends ApiClassBase> info, ByteBuffer buffer, int since, int deprecatedIn, int removedIn, String sdks) {
        boolean sinceShort;
        assert (deprecatedIn == (deprecatedIn & 0xFFFFFF7F));
        assert (removedIn == (removedIn & 0xFFFFFF7F));
        boolean isDeprecated = deprecatedIn > 0;
        boolean isRemoved = removedIn > 0;
        short sinceIndex = sdks != null ? info.getSdkIndex(sdks) : info.getSdkIndex(since);
        boolean bl = sinceShort = sinceIndex >= 64;
        if (sinceShort) {
            int left = sinceIndex >> 8 | 0x40;
            if (isDeprecated || isRemoved) {
                left |= 0x80;
            }
            buffer.put((byte)left);
            buffer.put((byte)(sinceIndex & 0xFF));
        } else {
            if (isDeprecated || isRemoved) {
                sinceIndex = (short)(sinceIndex | 0x80);
            }
            buffer.put((byte)sinceIndex);
        }
        if (isDeprecated || isRemoved) {
            short deprecatedIndex = info.getSdkIndex(deprecatedIn);
            ApiClass.writeConstraintReference(deprecatedIndex, buffer, isRemoved);
            if (isRemoved) {
                short removedIndex = info.getSdkIndex(removedIn);
                ApiClass.writeConstraintReference(removedIndex, buffer, false);
            }
        }
    }
}

