/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceFolderType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.checks.IconDetector;
import com.android.tools.lint.detector.api.BinaryResourceScanner;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.ResourceContext;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlContext;
import com.android.tools.lint.detector.api.XmlScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import java.awt.image.BufferedImage;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.util.UtilKt;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.w3c.dom.Attr;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 #2\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004:\u0002#$B\u0007\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0016J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0016H\u0016J \u0010\u0017\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u000e\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\t0\u001eH\u0016J\u0018\u0010\u001f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0016R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/lint/checks/ActivityIconColorDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "Lcom/android/tools/lint/detector/api/BinaryResourceScanner;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "<init>", "()V", "iconSetCalls", "", "", "Lcom/android/tools/lint/checks/ActivityIconColorDetector$IconSetterInfo;", "afterCheckRootProject", "", "context", "Lcom/android/tools/lint/detector/api/Context;", "getApplicableMethodNames", "", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "checkBinaryResource", "Lcom/android/tools/lint/detector/api/ResourceContext;", "visitMethodCall", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "getApplicableAttributes", "", "visitAttribute", "Lcom/android/tools/lint/detector/api/XmlContext;", "attribute", "Lorg/w3c/dom/Attr;", "Companion", "IconSetterInfo", "android.sdktools.lint-checks"})
public final class ActivityIconColorDetector
extends Detector
implements SourceCodeScanner,
BinaryResourceScanner,
XmlScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, IconSetterInfo> iconSetCalls = new LinkedHashMap();
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final Regex COLOR_REGEX;
    @NotNull
    public static final String BLACK = "#000000";
    @NotNull
    public static final String WHITE = "#ffffff";
    @NotNull
    public static final String ONGOING_ACTIVITY_BUILDER_METHOD = "androidx.wear.ongoing.OngoingActivity.Builder";

    @Override
    public void afterCheckRootProject(@NotNull Context context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.getPhase() == 1 && !this.iconSetCalls.isEmpty()) {
            context2.requestRepeat(this, EnumSet.of((Enum)Scope.BINARY_RESOURCE_FILE, (Enum)Scope.ALL_RESOURCE_FILES));
        }
    }

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"setAnimatedIcon", "setStaticIcon"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.DRAWABLE || folderType == ResourceFolderType.MIPMAP;
    }

    @Override
    public void checkBinaryResource(@NotNull ResourceContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (context2.getPhase() != 2) {
            return;
        }
        String iconFileName = context2.file.getName();
        Intrinsics.checkNotNull((Object)iconFileName);
        String iconName = StringsKt.substringBeforeLast$default((String)iconFileName, (String)".", null, (int)2, null);
        IconSetterInfo iconSetterInfo = this.iconSetCalls.get(iconName);
        if (iconSetterInfo == null) {
            return;
        }
        IconSetterInfo iconInfo = iconSetterInfo;
        if (StringsKt.endsWith$default((String)iconFileName, (String)".xml", (boolean)false, (int)2, null) || StringsKt.endsWith$default((String)iconFileName, (String)".json", (boolean)false, (int)2, null)) {
            return;
        }
        BufferedImage bufferedImage = ImageIO.read(context2.file);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"read(...)");
        BufferedImage image = bufferedImage;
        if (!IconDetector.isWhite(image)) {
            Context.report$default(context2, ISSUE, iconInfo.getLocation(), iconInfo.getMessage(), null, 8, null);
        }
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (context2.getPhase() != 1) {
            return;
        }
        PsiClass psiClass = method.getContainingClass();
        if (!Intrinsics.areEqual((Object)(psiClass != null ? psiClass.getQualifiedName() : null), (Object)ONGOING_ACTIVITY_BUILDER_METHOD)) {
            return;
        }
        UExpression uExpression = node.getArgumentForParameter(0);
        if (uExpression == null) {
            return;
        }
        UExpression iconResource = uExpression;
        ResourceUrl resourceUrl = ResourceEvaluator.getResource(context2.getEvaluator(), (UElement)iconResource);
        if (resourceUrl == null) {
            return;
        }
        ResourceUrl url = resourceUrl;
        String iconKind = Intrinsics.areEqual((Object)method.getName(), (Object)"setAnimatedIcon") ? "animated icon" : "static icon";
        this.iconSetCalls.put(url.name, new IconSetterInfo(url, (UElement)node, context2.getLocation((UElement)iconResource), "The " + iconKind + " for an ongoing activity should be white with a transparent background"));
    }

    @Override
    @NotNull
    public Collection<String> getApplicableAttributes() {
        Object[] objectArray = new String[]{"fillColor", "strokeColor", "color"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitAttribute(@NotNull XmlContext context2, @NotNull Attr attribute) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attribute, (String)"attribute");
        if (context2.getPhase() != 2) {
            return;
        }
        String string2 = context2.file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
        String iconName = UtilKt.removeSuffixIfPresent((String)string2, (String)".xml");
        IconSetterInfo iconSetterInfo = this.iconSetCalls.get(iconName);
        if (iconSetterInfo == null) {
            return;
        }
        IconSetterInfo iconSetterInfo2 = iconSetterInfo;
        String string3 = attribute.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getValue(...)");
        String string4 = string3.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"toLowerCase(...)");
        String fillColor = string4;
        if (COLOR_REGEX.matches((CharSequence)fillColor) && !Intrinsics.areEqual((Object)fillColor, (Object)BLACK) && !Intrinsics.areEqual((Object)fillColor, (Object)WHITE)) {
            Context.report$default(context2, ISSUE, context2.getValueLocation(attribute), iconSetterInfo2.getMessage(), null, 8, null);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.ICONS;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(ActivityIconColorDetector.class, EnumSet.of((Enum)Scope.JAVA_FILE, (Enum)Scope.BINARY_RESOURCE_FILE, (Enum)Scope.RESOURCE_FILE));
        ISSUE = Issue.Companion.create$default(companion, "ActivityIconColor", "Ongoing activity icon is not white", "\n            The resources passed to `setAnimatedIcon` and `setStaticIcon` should be white \\\n            with a transparent background, preferably a VectorDrawable or AnimatedVectorDrawable.\n            ", implementation, "https://developer.android.com/training/wearables/ongoing-activity#best-practices", category, 4, severity, false, null, null, null, 3840, null);
        COLOR_REGEX = new Regex("#[a-fA-F\\d]{6}");
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000bX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/android/tools/lint/checks/ActivityIconColorDetector$Companion;", "", "<init>", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "COLOR_REGEX", "Lkotlin/text/Regex;", "getCOLOR_REGEX", "()Lkotlin/text/Regex;", "BLACK", "", "WHITE", "ONGOING_ACTIVITY_BUILDER_METHOD", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Regex getCOLOR_REGEX() {
            return COLOR_REGEX;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\tH\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001J\t\u0010\u001e\u001a\u00020\tH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006\u001f"}, d2={"Lcom/android/tools/lint/checks/ActivityIconColorDetector$IconSetterInfo;", "", "url", "Lcom/android/resources/ResourceUrl;", "element", "Lorg/jetbrains/uast/UElement;", "location", "Lcom/android/tools/lint/detector/api/Location;", "message", "", "<init>", "(Lcom/android/resources/ResourceUrl;Lorg/jetbrains/uast/UElement;Lcom/android/tools/lint/detector/api/Location;Ljava/lang/String;)V", "getUrl", "()Lcom/android/resources/ResourceUrl;", "getElement", "()Lorg/jetbrains/uast/UElement;", "getLocation", "()Lcom/android/tools/lint/detector/api/Location;", "getMessage", "()Ljava/lang/String;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "android.sdktools.lint-checks"})
    public static final class IconSetterInfo {
        @NotNull
        private final ResourceUrl url;
        @NotNull
        private final UElement element;
        @NotNull
        private final Location location;
        @NotNull
        private final String message;

        public IconSetterInfo(@NotNull ResourceUrl url, @NotNull UElement element, @NotNull Location location, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.url = url;
            this.element = element;
            this.location = location;
            this.message = message;
        }

        @NotNull
        public final ResourceUrl getUrl() {
            return this.url;
        }

        @NotNull
        public final UElement getElement() {
            return this.element;
        }

        @NotNull
        public final Location getLocation() {
            return this.location;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final ResourceUrl component1() {
            return this.url;
        }

        @NotNull
        public final UElement component2() {
            return this.element;
        }

        @NotNull
        public final Location component3() {
            return this.location;
        }

        @NotNull
        public final String component4() {
            return this.message;
        }

        @NotNull
        public final IconSetterInfo copy(@NotNull ResourceUrl url, @NotNull UElement element, @NotNull Location location, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            Intrinsics.checkNotNullParameter((Object)element, (String)"element");
            Intrinsics.checkNotNullParameter((Object)location, (String)"location");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new IconSetterInfo(url, element, location, message);
        }

        public static /* synthetic */ IconSetterInfo copy$default(IconSetterInfo iconSetterInfo, ResourceUrl resourceUrl, UElement uElement, Location location, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                resourceUrl = iconSetterInfo.url;
            }
            if ((n & 2) != 0) {
                uElement = iconSetterInfo.element;
            }
            if ((n & 4) != 0) {
                location = iconSetterInfo.location;
            }
            if ((n & 8) != 0) {
                string2 = iconSetterInfo.message;
            }
            return iconSetterInfo.copy(resourceUrl, uElement, location, string2);
        }

        @NotNull
        public String toString() {
            return "IconSetterInfo(url=" + this.url + ", element=" + this.element + ", location=" + this.location + ", message=" + this.message + ")";
        }

        public int hashCode() {
            int result2 = this.url.hashCode();
            result2 = result2 * 31 + this.element.hashCode();
            result2 = result2 * 31 + this.location.hashCode();
            result2 = result2 * 31 + this.message.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof IconSetterInfo)) {
                return false;
            }
            IconSetterInfo iconSetterInfo = (IconSetterInfo)other;
            if (!Intrinsics.areEqual((Object)this.url, (Object)iconSetterInfo.url)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.element, (Object)iconSetterInfo.element)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.location, (Object)iconSetterInfo.location)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.message, (Object)iconSetterInfo.message);
        }
    }
}

