/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.internal;

import com.android.tools.apk.analyzer.dex.ProguardMappings;
import com.android.tools.apk.analyzer.internal.AbstractArchive;
import com.android.tools.proguard.ProguardMap;
import com.android.utils.FileUtils;
import com.android.utils.XmlUtils;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.text.ParseException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AppBundleArchive
extends AbstractArchive {
    public static String BUNDLE_BASELINE_PROFILE_PATH = String.format("/BUNDLE-METADATA/%s/%s", "com.android.tools.build.profiles", "baseline.prof");
    public static String BUNDLE_BASELINE_PROFILE_METADATA_PATH = String.format("/BUNDLE-METADATA/%s/%s", "com.android.tools.build.profiles", "baseline.profm");
    private static final String BUNDLE_PROGUARD_MAPPING_PATh = "/BUNDLE-METADATA/com.android.tools.build.obfuscation/proguard.map";
    @NotNull
    private final FileSystem zipFileSystem;

    private AppBundleArchive(@NotNull Path path) throws IOException {
        super(path);
        this.zipFileSystem = FileUtils.createZipFilesystem((Path)path);
    }

    @NotNull
    public static AppBundleArchive fromBundleFile(@NotNull Path artifact) throws IOException {
        return new AppBundleArchive(artifact);
    }

    @Override
    @NotNull
    public Path getContentRoot() {
        return this.zipFileSystem.getPath("/", new String[0]);
    }

    @Override
    public void close() throws IOException {
        this.zipFileSystem.close();
    }

    @Override
    public boolean isProtoXml(@NotNull Path p, @NotNull byte[] content) {
        boolean xmlResource;
        if (!p.toString().endsWith(".xml")) {
            return false;
        }
        Path name = p.getFileName();
        if (name == null) {
            return false;
        }
        boolean manifest = AppBundleArchive.isManifestFile(p);
        boolean insideResFolder = AppBundleArchive.isInsideResFolder(p);
        boolean insideResRaw = AppBundleArchive.isInsiderResRawFolder(p);
        boolean bl = xmlResource = insideResFolder && !insideResRaw;
        if (!manifest && !xmlResource) {
            return false;
        }
        return XmlUtils.isProtoXml((byte[])content);
    }

    @Override
    public boolean isBaselineProfile(@NotNull Path p, @NotNull byte[] content) {
        String path = p.toString();
        return path.equals(BUNDLE_BASELINE_PROFILE_PATH) || path.equals(BUNDLE_BASELINE_PROFILE_METADATA_PATH);
    }

    @Override
    @Nullable
    public ProguardMappings loadProguardMapping() {
        ProguardMappings proguardMappings;
        Path path = this.getContentRoot().resolve(BUNDLE_PROGUARD_MAPPING_PATh);
        InputStreamReader reader = new InputStreamReader(Files.newInputStream(path, new OpenOption[0]));
        try {
            ProguardMap proguardMap = new ProguardMap();
            proguardMap.readFromReader((Reader)reader);
            proguardMappings = new ProguardMappings(proguardMap, null, null);
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                return null;
            }
            catch (ParseException e) {
                throw new RuntimeException("Invalid Proguard mapping file", e);
            }
        }
        reader.close();
        return proguardMappings;
    }

    private static boolean isManifestFile(@NotNull Path p) {
        return AppBundleArchive.matchPathPrefix(p, PathEntry.any(), PathEntry.FD_MANIFEST, PathEntry.FN_ANDROID_MANIFEST_XML);
    }

    private static boolean isInsideResFolder(@NotNull Path p) {
        return AppBundleArchive.matchPathPrefix(p, PathEntry.any(), PathEntry.name("res"));
    }

    private static boolean isInsiderResRawFolder(@NotNull Path p) {
        return AppBundleArchive.matchPathPrefix(p, PathEntry.any(), PathEntry.FD_RES, PathEntry.FD_RES_RAW);
    }

    private static boolean matchPathPrefix(@NotNull Path path, PathEntry ... prefixEntries) {
        int index2 = 0;
        for (PathEntry entry : prefixEntries) {
            if (!entry.matches(path.getName(index2))) {
                return false;
            }
            ++index2;
        }
        return true;
    }

    public static abstract class PathEntry {
        @NotNull
        public static final PathEntry FD_RES = PathEntry.name("res");
        @NotNull
        public static final PathEntry FD_RES_RAW = PathEntry.name("raw");
        @NotNull
        public static final PathEntry FN_ANDROID_MANIFEST_XML = PathEntry.name("AndroidManifest.xml");
        @NotNull
        public static final PathEntry FD_MANIFEST = PathEntry.name("manifest");

        public abstract boolean matches(@NotNull Path var1);

        @NotNull
        public static PathEntry any() {
            return AnyPathEntry.instance;
        }

        @NotNull
        public static PathEntry name(@NotNull String name) {
            return new NamePathEntry(name);
        }
    }

    public static class NamePathEntry
    extends PathEntry {
        private final String name;

        public NamePathEntry(@NotNull String name) {
            this.name = name;
        }

        @Override
        public boolean matches(@NotNull Path name) {
            return name.toString().equals(this.name);
        }
    }

    public static class AnyPathEntry
    extends PathEntry {
        @NotNull
        public static AnyPathEntry instance = new AnyPathEntry();

        @Override
        public boolean matches(@NotNull Path name) {
            return true;
        }
    }
}

