/*
 * Decompiled with CFR 0.152.
 */
package com.android.resources.aar;

import com.android.ProgressManagerAdapter;
import com.android.annotations.TestOnly;
import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.configuration.FolderConfiguration;
import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.ide.common.util.PathString;
import com.android.io.CancellableFileIo;
import com.android.resources.ResourceType;
import com.android.resources.aar.AarSourceResourceRepository;
import com.android.resources.aar.CachingData;
import com.android.resources.base.BasicResourceItem;
import com.android.resources.base.BasicResourceItemBase;
import com.android.resources.base.BasicValueResourceItemBase;
import com.android.resources.base.NamespaceResolver;
import com.android.resources.base.RepositoryConfiguration;
import com.android.resources.base.RepositoryLoader;
import com.android.resources.base.ResourceSerializationUtil;
import com.android.tools.environment.Logger;
import com.android.utils.Base128InputStream;
import com.android.utils.Base128OutputStream;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public final class FrameworkResourceRepository
extends AarSourceResourceRepository {
    public static final String OVERLAYS_DIR = "overlays/";
    private static final ResourceNamespace ANDROID_NAMESPACE = ResourceNamespace.ANDROID;
    private static final Map<String, String> LANGUAGE_TO_GROUP = ImmutableMap.of((Object)"rm", (Object)"it");
    private static final String RESOURCES_TABLE_PREFIX = "resources_";
    private static final String RESOURCE_TABLE_SUFFIX = ".bin";
    private static final String COMPILED_9PNG_EXTENSION = ".compiled.9.png";
    private static final Logger LOG = Logger.getInstance(FrameworkResourceRepository.class);
    private final Set<String> myLanguageGroups = new TreeSet<String>();
    private int myNumberOfLanguageGroupsLoadedFromCache;
    private final boolean myUseCompiled9Patches;
    private final String myResourceSubDir;

    private FrameworkResourceRepository(RepositoryLoader<FrameworkResourceRepository> loader, boolean useCompiled9Patches) {
        this(loader, "", useCompiled9Patches);
    }

    private FrameworkResourceRepository(RepositoryLoader<FrameworkResourceRepository> loader, String overlaySubDir, boolean useCompiled9Patches) {
        super(loader, null);
        this.myResourceSubDir = overlaySubDir;
        this.myUseCompiled9Patches = useCompiled9Patches;
    }

    public static FrameworkResourceRepository create(Path resourceDirectoryOrFile, Set<String> languagesToLoad, CachingData cachingData, boolean useCompiled9Patches) {
        long start2 = LOG.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        Set<String> languageGroups = languagesToLoad == null ? null : FrameworkResourceRepository.getLanguageGroups(languagesToLoad);
        Loader loader = new Loader(resourceDirectoryOrFile, languageGroups);
        FrameworkResourceRepository repository2 = new FrameworkResourceRepository(loader, useCompiled9Patches);
        repository2.load(null, cachingData, loader, languageGroups, loader.myLoadedLanguageGroups);
        if (LOG.isDebugEnabled()) {
            String source = repository2.getNumberOfLanguageGroupsLoadedFromOrigin() == 0 ? "cache" : (repository2.myNumberOfLanguageGroupsLoadedFromCache == 0 ? resourceDirectoryOrFile.toString() : "cache and " + String.valueOf(resourceDirectoryOrFile));
            LOG.debug("Loaded from " + source + " with " + (repository2.myLanguageGroups.size() - 1) + " languages in " + (double)(System.currentTimeMillis() - start2) / 1000.0 + " sec");
        }
        return repository2;
    }

    public static FrameworkResourceRepository createForOverlay(Path resourceDirectoryOrFile, String overlayName, Set<String> languagesToLoad, CachingData cachingData, boolean useCompiled9Patches) {
        long start2 = LOG.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        Set<String> languageGroups = languagesToLoad == null ? null : FrameworkResourceRepository.getLanguageGroups(languagesToLoad);
        String overlaySubDir = OVERLAYS_DIR + overlayName + "/";
        Loader loader = new Loader(resourceDirectoryOrFile, overlaySubDir, languageGroups);
        FrameworkResourceRepository repository2 = new FrameworkResourceRepository(loader, overlaySubDir, useCompiled9Patches);
        repository2.load(null, cachingData, loader, languageGroups, loader.myLoadedLanguageGroups);
        if (LOG.isDebugEnabled()) {
            String source = repository2.getNumberOfLanguageGroupsLoadedFromOrigin() == 0 ? "cache" : (repository2.myNumberOfLanguageGroupsLoadedFromCache == 0 ? resourceDirectoryOrFile.toString() : "cache and " + String.valueOf(resourceDirectoryOrFile));
            LOG.debug("Loaded from " + source + " with " + (repository2.myLanguageGroups.size() - 1) + " languages in " + (double)(System.currentTimeMillis() - start2) / 1000.0 + " sec");
        }
        return repository2;
    }

    public boolean containsLanguages(Set<String> languages) {
        for (String language : languages) {
            if (this.myLanguageGroups.contains(FrameworkResourceRepository.getLanguageGroup(language))) continue;
            return false;
        }
        return true;
    }

    public FrameworkResourceRepository loadMissingLanguages(Set<String> languagesToLoad, CachingData cachingData) {
        Set<String> languageGroups;
        Set<String> set2 = languageGroups = languagesToLoad == null ? null : FrameworkResourceRepository.getLanguageGroups(languagesToLoad);
        if (languageGroups != null && this.myLanguageGroups.containsAll(languageGroups)) {
            return this;
        }
        long start2 = LOG.isDebugEnabled() ? System.currentTimeMillis() : 0L;
        Loader loader = new Loader(this, languageGroups);
        FrameworkResourceRepository newRepository = new FrameworkResourceRepository(loader, this.myResourceSubDir, this.myUseCompiled9Patches);
        newRepository.load(this, cachingData, loader, languageGroups, loader.myLoadedLanguageGroups);
        if (LOG.isDebugEnabled()) {
            String source = newRepository.getNumberOfLanguageGroupsLoadedFromOrigin() == this.getNumberOfLanguageGroupsLoadedFromOrigin() ? "cache" : (newRepository.myNumberOfLanguageGroupsLoadedFromCache == this.myNumberOfLanguageGroupsLoadedFromCache ? this.myResourceDirectoryOrFile.toString() : "cache and " + String.valueOf(this.myResourceDirectoryOrFile));
            LOG.debug("Loaded " + (newRepository.myLanguageGroups.size() - this.myLanguageGroups.size()) + " additional languages from " + source + " in " + (double)(System.currentTimeMillis() - start2) / 1000.0 + " sec");
        }
        return newRepository;
    }

    private void load(FrameworkResourceRepository sourceRepository, CachingData cachingData, Loader loader, Set<String> languageGroups, Set<String> languageGroupsLoadedFromSourceRepositoryOrCache) {
        Executor executor;
        ImmutableSet configurationsToTakeOver;
        HashMap stringCache = Maps.newHashMapWithExpectedSize((int)10000);
        HashMap<NamespaceResolver, NamespaceResolver> namespaceResolverCache = new HashMap<NamespaceResolver, NamespaceResolver>();
        Object object = configurationsToTakeOver = sourceRepository == null ? ImmutableSet.of() : this.copyFromRepository(sourceRepository, stringCache, namespaceResolverCache);
        if (!loader.isLoadingFromZipArchive() && cachingData != null) {
            this.loadFromPersistentCache(cachingData, languageGroups, languageGroupsLoadedFromSourceRepositoryOrCache, stringCache, namespaceResolverCache);
        }
        this.myLanguageGroups.addAll(languageGroupsLoadedFromSourceRepositoryOrCache);
        if (languageGroups == null || !languageGroupsLoadedFromSourceRepositoryOrCache.containsAll(languageGroups)) {
            loader.loadRepositoryContents(this);
        }
        this.myLoadedFromCache = this.myNumberOfLanguageGroupsLoadedFromCache == this.myLanguageGroups.size();
        this.populatePublicResourcesMap();
        this.freezeResources();
        this.takeOverConfigurations((Set<RepositoryConfiguration>)configurationsToTakeOver);
        if (!loader.isLoadingFromZipArchive() && cachingData != null && (executor = cachingData.getCacheCreationExecutor()) != null && !languageGroupsLoadedFromSourceRepositoryOrCache.containsAll(this.myLanguageGroups)) {
            executor.execute(() -> this.createPersistentCache(cachingData, languageGroupsLoadedFromSourceRepositoryOrCache));
        }
    }

    @Override
    public String getPackageName() {
        return ANDROID_NAMESPACE.getPackageName();
    }

    public Set<ResourceType> getResourceTypes(ResourceNamespace namespace) {
        return namespace == ANDROID_NAMESPACE ? Sets.immutableEnumSet(this.myResources.keySet()) : ImmutableSet.of();
    }

    private Set<RepositoryConfiguration> copyFromRepository(FrameworkResourceRepository sourceRepository, Map<String, String> stringCache, Map<NamespaceResolver, NamespaceResolver> namespaceResolverCache) {
        Collection resourceMaps = sourceRepository.myResources.values();
        Set sourceConfigurations = Sets.newIdentityHashSet();
        for (ListMultimap resourceMap : resourceMaps) {
            for (ResourceItem item : resourceMap.values()) {
                this.addResourceItem(item);
                sourceConfigurations.add(((BasicResourceItemBase)item).getRepositoryConfiguration());
                if (item instanceof BasicValueResourceItemBase) {
                    ResourceNamespace.Resolver resolver = ((BasicValueResourceItemBase)item).getNamespaceResolver();
                    NamespaceResolver namespaceResolver = resolver == ResourceNamespace.Resolver.EMPTY_RESOLVER ? NamespaceResolver.EMPTY : (NamespaceResolver)resolver;
                    namespaceResolverCache.put(namespaceResolver, namespaceResolver);
                }
                String name = item.getName();
                stringCache.put(name, name);
            }
        }
        this.myNumberOfLanguageGroupsLoadedFromCache += sourceRepository.myNumberOfLanguageGroupsLoadedFromCache;
        return sourceConfigurations;
    }

    private void loadFromPersistentCache(CachingData cachingData, Set<String> languagesToLoad, Set<String> loadedLanguages, Map<String, String> stringCache, Map<NamespaceResolver, NamespaceResolver> namespaceResolverCache) {
        CacheFileNameGenerator fileNameGenerator = new CacheFileNameGenerator(cachingData);
        Set<String> languages = languagesToLoad == null ? fileNameGenerator.getAllCacheFileLanguages() : languagesToLoad;
        for (String language : languages) {
            if (loadedLanguages.contains(language)) continue;
            Path cacheFile = fileNameGenerator.getCacheFile(language);
            try (Base128InputStream stream = new Base128InputStream(cacheFile);){
                byte[] header = ResourceSerializationUtil.getCacheFileHeader(s -> this.writeCacheHeaderContent(cachingData, language, s));
                if (!stream.validateContents(header)) {
                    if (!language.isEmpty()) continue;
                    break;
                }
                this.loadFromStream(stream, stringCache, namespaceResolverCache);
                loadedLanguages.add(language);
                ++this.myNumberOfLanguageGroupsLoadedFromCache;
            }
            catch (NoSuchFileException e) {
                if (!language.isEmpty()) continue;
                break;
            }
            catch (Throwable e) {
                this.cleanupAfterFailedLoadingFromCache();
                loadedLanguages.clear();
                ProgressManagerAdapter.throwIfCancellation((Throwable)e);
                LOG.warn("Failed to load from cache file " + cacheFile.toString(), e);
                break;
            }
        }
    }

    @Override
    protected void cleanupAfterFailedLoadingFromCache() {
        super.cleanupAfterFailedLoadingFromCache();
        this.myNumberOfLanguageGroupsLoadedFromCache = 0;
    }

    private void createPersistentCache(CachingData cachingData, Set<String> languagesToSkip) {
        CacheFileNameGenerator fileNameGenerator = new CacheFileNameGenerator(cachingData);
        for (String language : this.myLanguageGroups) {
            if (languagesToSkip.contains(language)) continue;
            Path cacheFile = fileNameGenerator.getCacheFile(language);
            byte[] header = ResourceSerializationUtil.getCacheFileHeader(stream -> this.writeCacheHeaderContent(cachingData, language, stream));
            ResourceSerializationUtil.createPersistentCache(cacheFile, header, stream -> this.writeToStream(stream, config -> language.equals(FrameworkResourceRepository.getLanguageGroup(config))));
        }
    }

    private void writeCacheHeaderContent(CachingData cachingData, String language, Base128OutputStream stream) throws IOException {
        this.writeCacheHeaderContent(cachingData, stream);
        stream.writeString(language);
    }

    static String getResourceTableNameForLanguage(String language) {
        return language.isEmpty() ? "resources.bin" : RESOURCES_TABLE_PREFIX + language + RESOURCE_TABLE_SUFFIX;
    }

    static String getLanguageGroup(FolderConfiguration config) {
        LocaleQualifier locale = config.getLocaleQualifier();
        return locale == null ? "" : FrameworkResourceRepository.getLanguageGroup(Strings.nullToEmpty((String)locale.getLanguage()));
    }

    private static String getLanguageGroup(String language) {
        return LANGUAGE_TO_GROUP.getOrDefault(language, language);
    }

    private static Set<String> getLanguageGroups(Set<String> languages) {
        TreeSet<String> result2 = new TreeSet<String>();
        result2.add("");
        for (String language : languages) {
            result2.add(FrameworkResourceRepository.getLanguageGroup(language));
        }
        return result2;
    }

    Set<String> getLanguageGroups() {
        TreeSet<String> languages = new TreeSet<String>();
        for (ListMultimap resourceMap : this.myResources.values()) {
            for (ResourceItem item : resourceMap.values()) {
                FolderConfiguration config = item.getConfiguration();
                languages.add(FrameworkResourceRepository.getLanguageGroup(config));
            }
        }
        return languages;
    }

    private int getNumberOfLanguageGroupsLoadedFromOrigin() {
        return this.myLanguageGroups.size() - this.myNumberOfLanguageGroupsLoadedFromCache;
    }

    @TestOnly
    int getNumberOfLanguageGroupsLoadedFromCache() {
        return this.myNumberOfLanguageGroupsLoadedFromCache;
    }

    private String updateResourcePath(String relativeResourcePath) {
        if (this.myUseCompiled9Patches && relativeResourcePath.endsWith(".9.png")) {
            return relativeResourcePath.substring(0, relativeResourcePath.length() - ".9.png".length()) + COMPILED_9PNG_EXTENSION;
        }
        return relativeResourcePath;
    }

    @Override
    public String getResourceUrl(String relativeResourcePath) {
        return super.getResourceUrl(this.updateResourcePath(relativeResourcePath));
    }

    @Override
    public PathString getSourceFile(String relativeResourcePath, boolean forFileResource) {
        return super.getSourceFile(this.updateResourcePath(relativeResourcePath), forFileResource);
    }

    private void takeOverConfigurations(Set<RepositoryConfiguration> sourceConfigurations) {
        for (RepositoryConfiguration configuration : sourceConfigurations) {
            configuration.transferOwnershipTo(this);
        }
    }

    private static class Loader
    extends RepositoryLoader<FrameworkResourceRepository> {
        private final List<String> myPublicFileNames = ImmutableList.of((Object)"public.xml", (Object)"public-final.xml", (Object)"public-staging.xml");
        private final Set<String> myLoadedLanguageGroups;
        private final String myResourceSubDir;
        private Set<String> myLanguageGroups;

        Loader(Path resourceDirectoryOrFile, Set<String> languageGroups) {
            super(resourceDirectoryOrFile, null, ANDROID_NAMESPACE);
            this.myLanguageGroups = languageGroups;
            this.myLoadedLanguageGroups = new TreeSet<String>();
            this.myResourceSubDir = "";
        }

        Loader(Path resourceDirectoryOrFile, String subDir, Set<String> languageGroups) {
            super(resourceDirectoryOrFile, null, ANDROID_NAMESPACE);
            this.myLanguageGroups = languageGroups;
            this.myLoadedLanguageGroups = new TreeSet<String>();
            this.myResourceSubDir = subDir;
        }

        Loader(FrameworkResourceRepository sourceRepository, Set<String> languageGroups) {
            super(sourceRepository.myResourceDirectoryOrFile, null, ANDROID_NAMESPACE);
            this.myLanguageGroups = languageGroups;
            this.myLoadedLanguageGroups = new TreeSet<String>(sourceRepository.myLanguageGroups);
            this.myResourceSubDir = sourceRepository.myResourceSubDir;
        }

        @Override
        public List<String> getPublicXmlFileNames() {
            return this.myPublicFileNames;
        }

        @Override
        protected void loadFromZip(FrameworkResourceRepository repository2) {
            try (ZipFile zipFile = new ZipFile(this.myResourceDirectoryOrFile.toFile());){
                if (this.myLanguageGroups == null) {
                    this.myLanguageGroups = Loader.readLanguageGroups(zipFile, this.myResourceSubDir);
                }
                HashMap stringCache = Maps.newHashMapWithExpectedSize((int)10000);
                HashMap<NamespaceResolver, NamespaceResolver> namespaceResolverCache = new HashMap<NamespaceResolver, NamespaceResolver>();
                for (String language : this.myLanguageGroups) {
                    if (this.myLoadedLanguageGroups.contains(language)) continue;
                    String entryName = this.myResourceSubDir + FrameworkResourceRepository.getResourceTableNameForLanguage(language);
                    ZipEntry zipEntry = zipFile.getEntry(entryName);
                    if (zipEntry == null) {
                        if (!language.isEmpty()) continue;
                        throw new IOException("\"" + entryName + "\" not found in " + this.myResourceDirectoryOrFile.toString());
                    }
                    try (Base128InputStream stream = new Base128InputStream(zipFile.getInputStream(zipEntry));){
                        repository2.loadFromStream(stream, stringCache, namespaceResolverCache);
                    }
                }
                repository2.populatePublicResourcesMap();
                repository2.freezeResources();
            }
            catch (Exception e) {
                ProgressManagerAdapter.throwIfCancellation((Throwable)e);
                LOG.error("Failed to load resources from " + this.myResourceDirectoryOrFile.toString(), (Throwable)e);
            }
        }

        @Override
        public String getResourcePathPrefix() {
            if (this.isLoadingFromZipArchive()) {
                return Loader.portableFileName(this.myResourceDirectoryOrFile.toString()) + "!/" + this.myResourceSubDir + "res/";
            }
            return Loader.portableFileName(this.myResourceDirectoryOrFile.toString()) + "/";
        }

        @Override
        public String getResourceUrlPrefix() {
            if (this.isLoadingFromZipArchive()) {
                return "jar://" + Loader.portableFileName(this.myResourceDirectoryOrFile.toString()) + "!/" + this.myResourceSubDir + "res/";
            }
            return Loader.portableFileName(this.myResourceDirectoryOrFile.toString()) + "/";
        }

        private static Set<String> readLanguageGroups(ZipFile zipFile, String subDir) {
            ImmutableSortedSet.Builder result2 = ImmutableSortedSet.naturalOrder();
            result2.add((Object)"");
            String prefix = subDir + FrameworkResourceRepository.RESOURCES_TABLE_PREFIX;
            zipFile.stream().forEach(entry -> {
                String name = entry.getName();
                if (name.startsWith(prefix) && name.endsWith(FrameworkResourceRepository.RESOURCE_TABLE_SUFFIX) && name.length() == prefix.length() + FrameworkResourceRepository.RESOURCE_TABLE_SUFFIX.length() + 2 && Character.isLetter(name.charAt(prefix.length())) && Character.isLetter(name.charAt(prefix.length() + 1))) {
                    result2.add((Object)name.substring(prefix.length(), prefix.length() + 2));
                }
            });
            return result2.build();
        }

        @Override
        public void loadRepositoryContents(FrameworkResourceRepository repository2) {
            super.loadRepositoryContents(repository2);
            Set<String> languageGroups = this.myLanguageGroups == null ? repository2.getLanguageGroups() : this.myLanguageGroups;
            repository2.myLanguageGroups.addAll(languageGroups);
        }

        @Override
        public boolean isIgnored(Path fileOrDirectory, BasicFileAttributes attrs) {
            if (fileOrDirectory.equals(this.myResourceDirectoryOrFile)) {
                return false;
            }
            if (super.isIgnored(fileOrDirectory, attrs)) {
                return true;
            }
            String fileName = fileOrDirectory.getFileName().toString();
            if (attrs.isDirectory()) {
                if (fileName.startsWith("values-mcc") || fileName.startsWith("raw") && (fileName.length() == "raw".length() || fileName.charAt("raw".length()) == '-')) {
                    return true;
                }
                if (this.myLanguageGroups != null || !this.myLoadedLanguageGroups.isEmpty()) {
                    FolderConfiguration config = FolderConfiguration.getConfigForFolder((String)fileName);
                    if (config == null) {
                        return true;
                    }
                    String language = FrameworkResourceRepository.getLanguageGroup(config);
                    if (this.myLanguageGroups != null && !this.myLanguageGroups.contains(language) || this.myLoadedLanguageGroups.contains(language)) {
                        return true;
                    }
                    this.myFolderConfigCache.put(config.getQualifierString(), config);
                }
            } else {
                if ((this.myPublicFileNames.contains(fileName) || fileName.equals("symbols.xml")) && "values".equals(new PathString(fileOrDirectory).getParentFileName())) {
                    return true;
                }
                if (fileName.endsWith(FrameworkResourceRepository.COMPILED_9PNG_EXTENSION)) {
                    return true;
                }
            }
            return false;
        }

        @Override
        protected final void addResourceItem(BasicResourceItem item, FrameworkResourceRepository repository2) {
            repository2.addResourceItem((ResourceItem)item);
        }

        @Override
        protected String getKeyForVisibilityLookup(String resourceName) {
            return resourceName;
        }
    }

    private static class CacheFileNameGenerator {
        private final Path myLanguageNeutralFile;
        private final String myPrefix;
        private final String mySuffix;

        CacheFileNameGenerator(CachingData cachingData) {
            this.myLanguageNeutralFile = cachingData.getCacheFile();
            String fileName = this.myLanguageNeutralFile.getFileName().toString();
            int dotPos = fileName.lastIndexOf(46);
            this.myPrefix = dotPos >= 0 ? fileName.substring(0, dotPos) : fileName;
            this.mySuffix = dotPos >= 0 ? fileName.substring(dotPos) : "";
        }

        Path getCacheFile(String language) {
            return language.isEmpty() ? this.myLanguageNeutralFile : this.myLanguageNeutralFile.resolveSibling(this.myPrefix + "_" + language + this.mySuffix);
        }

        String getLanguage(String cacheFileName) {
            if (!cacheFileName.startsWith(this.myPrefix) || !cacheFileName.endsWith(this.mySuffix)) {
                return null;
            }
            int baseLength = this.myPrefix.length() + this.mySuffix.length();
            if (cacheFileName.length() == baseLength) {
                return "";
            }
            if (cacheFileName.length() != baseLength + 3 || cacheFileName.charAt(this.myPrefix.length()) != '_') {
                return null;
            }
            String language = cacheFileName.substring(this.myPrefix.length() + 1, this.myPrefix.length() + 3);
            if (!CacheFileNameGenerator.isLowerCaseLatinLetter(language.charAt(0)) || !CacheFileNameGenerator.isLowerCaseLatinLetter(language.charAt(1))) {
                return null;
            }
            return language;
        }

        public Set<String> getAllCacheFileLanguages() {
            TreeSet<String> result2 = new TreeSet<String>();
            try (Stream stream = CancellableFileIo.list((Path)this.myLanguageNeutralFile.getParent());){
                stream.forEach(file -> {
                    String language = this.getLanguage(file.getFileName().toString());
                    if (language != null) {
                        result2.add(language);
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return result2;
        }

        private static boolean isLowerCaseLatinLetter(char c) {
            return 'a' <= c && c <= 'z';
        }
    }
}

