/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwppacket.MessageReader;
import com.android.jdwppacket.ModKind;
import com.android.jdwppacket.SuspendPolicy;
import com.android.jdwppacket.eventrequest.SetCmd;
import com.android.jdwppacket.eventrequest.SetReply;
import com.android.jdwptracer.CmdSet;
import com.android.jdwptracer.JsonLocation;
import com.android.jdwptracer.Message;
import com.android.jdwptracer.Session;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;

class CmdSetEventRequest
extends CmdSet {
    protected CmdSetEventRequest() {
        super(15, "EVENT_REQ");
        this.add(1, "Set", CmdSetEventRequest::parseCmd, CmdSetEventRequest::parseReply);
        this.add(2, "Clear");
        this.add(3, "ClearAllBreakpoints");
    }

    private static Message parseReply(MessageReader reader, Session session2) {
        Message message = new Message(reader);
        SetReply reply = SetReply.parse(reader);
        message.addArg("requestID", reply.getRequestID());
        return message;
    }

    private static Message parseCmd(MessageReader reader, Session session2) {
        Message message = new Message(reader);
        SetCmd cmd = SetCmd.parse(reader);
        message.addArg("eventKind", cmd.getKind().name());
        message.addArg("suspendPolicy", SuspendPolicy.fromID(cmd.getSuspendPolicy()).name());
        message.addArg("numModifiers", cmd.getModifiers().size());
        JsonArray modifiers = new JsonArray();
        message.addArg("modifiers", (JsonElement)modifiers);
        for (SetCmd.Modifier modifier : cmd.getModifiers()) {
            ModKind kind = modifier.getKind();
            JsonObject modJson = new JsonObject();
            modifiers.add((JsonElement)modJson);
            modJson.addProperty("modKind", kind.name());
            switch (kind) {
                case COUNT: {
                    SetCmd.Modifier mod2 = (SetCmd.ModifierCount)modifier;
                    modJson.addProperty("count", (Number)((SetCmd.ModifierCount)mod2).getCount());
                    break;
                }
                case CONDITIONAL: {
                    SetCmd.Modifier mod2 = (SetCmd.ModifierConditional)modifier;
                    modJson.addProperty("exprID", (Number)((SetCmd.ModifierConditional)mod2).getExprID());
                    break;
                }
                case THREAD_ONLY: {
                    SetCmd.Modifier mod2 = (SetCmd.ModifierThreadOnly)modifier;
                    modJson.addProperty("threadID", (Number)((SetCmd.ModifierThreadOnly)mod2).getThreadID());
                    break;
                }
                case CLASS_ONLY: {
                    SetCmd.Modifier mod2 = (SetCmd.ModifierClassOnly)modifier;
                    modJson.addProperty("clazz", (Number)((SetCmd.ModifierClassOnly)mod2).getReferenceTypeID());
                    break;
                }
                case CLASS_MATCH: {
                    SetCmd.Modifier mod2 = (SetCmd.ModifierClassMatch)modifier;
                    modJson.addProperty("classMatch", ((SetCmd.ModifierClassMatch)mod2).getPattern());
                    break;
                }
                case CLASS_EXCLUDE: {
                    SetCmd.Modifier mod2 = (SetCmd.ModifierClassExclude)modifier;
                    modJson.addProperty("classExclude", ((SetCmd.ModifierClassExclude)mod2).getPattern());
                    break;
                }
                case LOCATION_ONLY: {
                    SetCmd.Modifier mod2 = (SetCmd.ModifierLocationOnly)modifier;
                    modJson.add("loc", (JsonElement)JsonLocation.get(((SetCmd.ModifierLocationOnly)mod2).getLocation()));
                    break;
                }
                case EXCEPTION_ONLY: {
                    SetCmd.Modifier mod2 = (SetCmd.ModifierExceptionOnly)modifier;
                    modJson.addProperty("exceptionOrNull", (Number)((SetCmd.ModifierExceptionOnly)mod2).getExceptionOrNull());
                    modJson.addProperty("caught", Boolean.valueOf(((SetCmd.ModifierExceptionOnly)mod2).getCaught()));
                    modJson.addProperty("uncaught", Boolean.valueOf(((SetCmd.ModifierExceptionOnly)mod2).getUncaught()));
                    break;
                }
                case FIELD_ONLY: {
                    SetCmd.Modifier mod2 = (SetCmd.ModifierFieldOnly)modifier;
                    modJson.addProperty("declaring", (Number)((SetCmd.ModifierFieldOnly)mod2).getDeclaring());
                    modJson.addProperty("fieldID", (Number)((SetCmd.ModifierFieldOnly)mod2).getFieldID());
                    break;
                }
                case STEP: {
                    SetCmd.Modifier mod2 = (SetCmd.ModifierStep)modifier;
                    modJson.addProperty("thread", (Number)((SetCmd.ModifierStep)mod2).getThreadID());
                    modJson.addProperty("size", (Number)((SetCmd.ModifierStep)mod2).getSize());
                    modJson.addProperty("depth", (Number)((SetCmd.ModifierStep)mod2).getDepth());
                    break;
                }
                case INSTANCE_ONLY: {
                    SetCmd.Modifier mod2 = (SetCmd.ModifierInstanceOnly)modifier;
                    modJson.addProperty("instance", (Number)((SetCmd.ModifierInstanceOnly)mod2).getInstance());
                    break;
                }
                case SOURCE_NAME_MATCH: {
                    SetCmd.Modifier mod2 = (SetCmd.ModifierSourceNameMatch)modifier;
                    modJson.addProperty("sourceNamePattern", ((SetCmd.ModifierSourceNameMatch)mod2).getSourceNameMatch());
                }
            }
        }
        return message;
    }
}

