/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwppacket;

import com.android.jdwppacket.IDSizes;
import com.android.jdwppacket.Location;
import com.android.jdwppacket.TaggedObjectID;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\r\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0005\n\u0002\b\u0004\n\u0002\u0010\n\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b&\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H&J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\tH&J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u001d\u001a\u00020\u001eH&J\u0010\u0010\u001f\u001a\u00020\u00172\u0006\u0010 \u001a\u00020!H&J\u0018\u0010\"\u001a\u00020\u00172\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020!H&J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020&H&J\u000e\u0010'\u001a\u00020\u00172\u0006\u0010$\u001a\u00020!J\u000e\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020!J\u000e\u0010*\u001a\u00020\u00172\u0006\u0010+\u001a\u00020\u0019J\u000e\u0010,\u001a\u00020\u00172\u0006\u0010-\u001a\u00020!J\u000e\u0010.\u001a\u00020\u00172\u0006\u0010/\u001a\u00020!J\u000e\u00100\u001a\u00020\u00172\u0006\u00101\u001a\u00020!J\u000e\u00102\u001a\u00020\u00172\u0006\u00101\u001a\u00020!J\u000e\u00103\u001a\u00020\u00172\u0006\u00101\u001a\u000204J\u000e\u00105\u001a\u00020\t2\u0006\u00106\u001a\u000207J\u000e\u00108\u001a\u00020\u00172\u0006\u00109\u001a\u00020:R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0014\u0010\u000e\u001a\u00020\tX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0010\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u000bR\u0011\u0010\u0012\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u000bR\u0011\u0010\u0014\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u000b\u00a8\u0006;"}, d2={"Lcom/android/jdwppacket/Writer;", "", "s", "Lcom/android/jdwppacket/IDSizes;", "<init>", "(Lcom/android/jdwppacket/IDSizes;)V", "getS", "()Lcom/android/jdwppacket/IDSizes;", "intSize", "", "getIntSize", "()I", "byteSize", "getByteSize", "longSize", "getLongSize", "locationSize", "getLocationSize", "threadIDSize", "getThreadIDSize", "classIDSize", "getClassIDSize", "putByte", "", "byte", "", "putInt", "int", "putShort", "short", "", "putLong", "long", "", "putID", "size", "value", "putString", "", "putFrameID", "putClassID", "classID", "putTypeTag", "typeTag", "putReferenceTypeID", "ref", "putMethodID", "methodID", "putObjectID", "id", "putThreadID", "putTaggedObjectID", "Lcom/android/jdwppacket/TaggedObjectID;", "putLocation", "location", "Lcom/android/jdwppacket/Location;", "putBoolean", "boolean", "", "android.sdktools.jdwppacket"})
public abstract class Writer {
    @NotNull
    private final IDSizes s;
    private final int intSize;
    private final int byteSize;
    private final int longSize;
    private final int locationSize;
    private final int threadIDSize;
    private final int classIDSize;

    public Writer(@NotNull IDSizes s) {
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        this.s = s;
        this.intSize = 4;
        this.byteSize = 1;
        this.longSize = 8;
        this.locationSize = this.byteSize + this.s.getReferenceTypeIDSize() + this.s.getMethodIDSize() + this.longSize;
        this.threadIDSize = this.s.getObjectIDSize();
        this.classIDSize = this.s.getReferenceTypeIDSize();
    }

    @NotNull
    public final IDSizes getS() {
        return this.s;
    }

    public final int getIntSize() {
        return this.intSize;
    }

    public final int getByteSize() {
        return this.byteSize;
    }

    public final int getLongSize() {
        return this.longSize;
    }

    public final int getLocationSize() {
        return this.locationSize;
    }

    public final int getThreadIDSize() {
        return this.threadIDSize;
    }

    public final int getClassIDSize() {
        return this.classIDSize;
    }

    public abstract void putByte(byte var1);

    public abstract void putInt(int var1);

    public abstract void putShort(short var1);

    public abstract void putLong(long var1);

    public abstract void putID(int var1, long var2);

    public abstract void putString(@NotNull String var1);

    public final void putFrameID(long value) {
        this.putID(this.s.getFrameIDSize(), value);
    }

    public final void putClassID(long classID) {
        this.putReferenceTypeID(classID);
    }

    public final void putTypeTag(byte typeTag) {
        this.putByte(typeTag);
    }

    public final void putReferenceTypeID(long ref) {
        this.putID(this.s.getReferenceTypeIDSize(), ref);
    }

    public final void putMethodID(long methodID) {
        this.putID(this.s.getMethodIDSize(), methodID);
    }

    public final void putObjectID(long id) {
        this.putID(this.s.getObjectIDSize(), id);
    }

    public final void putThreadID(long id) {
        this.putObjectID(id);
    }

    public final void putTaggedObjectID(@NotNull TaggedObjectID id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        this.putByte(id.getTag());
        this.putObjectID(id.getObjectID());
    }

    public final int putLocation(@NotNull Location location) {
        Intrinsics.checkNotNullParameter((Object)location, (String)"location");
        location.write(this);
        return this.locationSize;
    }

    public final void putBoolean(boolean bl) {
        if (bl) {
            this.putByte((byte)1);
        } else {
            this.putByte((byte)0);
        }
    }
}

