/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwppacket;

import com.android.jdwppacket.CmdSet;
import com.android.jdwppacket.MessageReader;
import kotlin.Metadata;
import kotlin.UByte;
import kotlin.UInt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0005\n\u0002\b\u0007\n\u0002\u0010\n\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 !2\u00020\u0001:\u0001!B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\u0006\u0010\u001c\u001a\u00020\u001dJ\u0006\u0010\u001e\u001a\u00020\u001dJ\u0016\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020\u000b2\u0006\u0010\u0012\u001a\u00020\u000bJ\u0016\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u0014\u001a\u00020 2\u0006\u0010\u0012\u001a\u00020\u000bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0012\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\rR\u0011\u0010\u0014\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\rR\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019\u00a8\u0006\""}, d2={"Lcom/android/jdwppacket/PacketHeader;", "", "reader", "Lcom/android/jdwppacket/MessageReader;", "<init>", "(Lcom/android/jdwppacket/MessageReader;)V", "length", "", "getLength", "()J", "id", "", "getId", "()I", "flags", "", "getFlags", "()B", "cmd", "getCmd", "cmdSet", "getCmdSet", "error", "", "getError", "()S", "toString", "", "isReply", "", "isCmd", "isA", "Lcom/android/jdwppacket/CmdSet;", "Companion", "android.sdktools.jdwppacket"})
public final class PacketHeader {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long length;
    private final int id;
    private final byte flags;
    private final int cmd;
    private final int cmdSet;
    private final short error;
    private static final int HEADER_SIZE = 11;
    private static final int REPLY_BIT = 128;

    public PacketHeader(@NotNull MessageReader reader) {
        Intrinsics.checkNotNullParameter((Object)reader, (String)"reader");
        if (reader.remaining() < HEADER_SIZE) {
            throw new IllegalStateException("Not enough byte to parse PacketHeader");
        }
        this.length = (long)UInt.constructor-impl((int)reader.getInt()) & 0xFFFFFFFFL;
        this.id = reader.getInt();
        this.flags = reader.getByte();
        if (this.isReply()) {
            this.error = reader.getShort();
            this.cmdSet = CmdSet.NoSet.getId();
            this.cmd = 0;
        } else {
            this.error = 0;
            this.cmdSet = UByte.constructor-impl((byte)reader.getByte()) & 0xFF;
            this.cmd = UByte.constructor-impl((byte)reader.getByte()) & 0xFF;
        }
    }

    public final long getLength() {
        return this.length;
    }

    public final int getId() {
        return this.id;
    }

    public final byte getFlags() {
        return this.flags;
    }

    public final int getCmd() {
        return this.cmd;
    }

    public final int getCmdSet() {
        return this.cmdSet;
    }

    public final short getError() {
        return this.error;
    }

    @NotNull
    public String toString() {
        if (this.isReply()) {
            return "reply(0x" + Integer.toHexString(this.id) + ')';
        }
        return "cmd(0x" + Integer.toHexString(this.id) + ") " + this.cmdSet + '-' + this.cmd;
    }

    public final boolean isReply() {
        return (this.flags & REPLY_BIT) == REPLY_BIT;
    }

    public final boolean isCmd() {
        return !this.isReply();
    }

    public final boolean isA(int cmdSet, int cmd) {
        return this.cmdSet == cmdSet && this.cmd == cmd;
    }

    public final boolean isA(@NotNull CmdSet cmdSet, int cmd) {
        Intrinsics.checkNotNullParameter((Object)((Object)cmdSet), (String)"cmdSet");
        return this.isA(cmdSet.getId(), cmd);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0005X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/android/jdwppacket/PacketHeader$Companion;", "", "<init>", "()V", "HEADER_SIZE", "", "REPLY_BIT", "getREPLY_BIT$android_sdktools_jdwppacket", "()I", "android.sdktools.jdwppacket"})
    public static final class Companion {
        private Companion() {
        }

        public final int getREPLY_BIT$android_sdktools_jdwppacket() {
            return REPLY_BIT;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

