/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwppacket;

import com.android.jdwppacket.IDSizes;
import com.android.jdwppacket.Location;
import com.android.jdwppacket.TaggedObjectID;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0005\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\n\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\f\u001a\u00020\u0000J\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u000f\u001a\u00020\u000eJ\u0006\u0010\u0010\u001a\u00020\u0011J\u0006\u0010\u0012\u001a\u00020\u0013J\u0006\u0010\u0014\u001a\u00020\u0015J\u0006\u0010\u0016\u001a\u00020\u0017J\u0006\u0010\u0018\u001a\u00020\u0019J\u0006\u0010\u001a\u001a\u00020\u0017J\u0006\u0010\u001b\u001a\u00020\u0017J\u0006\u0010\u001c\u001a\u00020\u0017J\u0006\u0010\u001d\u001a\u00020\u0017J\u0006\u0010\u001e\u001a\u00020\u0017J\u0006\u0010\u001f\u001a\u00020 J\u0006\u0010!\u001a\u00020\u0017J\u0006\u0010\"\u001a\u00020\u0017J\u0006\u0010#\u001a\u00020$J\u0010\u0010%\u001a\u00020\u00172\u0006\u0010&\u001a\u00020\u0015H\u0002J\u0006\u0010'\u001a\u00020\u0015J\u0006\u0010(\u001a\u00020\u0011J\u000e\u0010)\u001a\u00020$2\u0006\u0010*\u001a\u00020\u0015R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006+"}, d2={"Lcom/android/jdwppacket/MessageReader;", "", "idSizes", "Lcom/android/jdwppacket/IDSizes;", "buffer", "Ljava/nio/ByteBuffer;", "<init>", "(Lcom/android/jdwppacket/IDSizes;Ljava/nio/ByteBuffer;)V", "getIdSizes", "()Lcom/android/jdwppacket/IDSizes;", "getBuffer", "()Ljava/nio/ByteBuffer;", "duplicate", "getByte", "", "getTypeTag", "getBoolean", "", "getShort", "", "getInt", "", "getLong", "", "getLocation", "Lcom/android/jdwppacket/Location;", "getFieldID", "getMethodID", "getClassID", "getObjectID", "getThreadID", "getTaggedObjectID", "Lcom/android/jdwppacket/TaggedObjectID;", "getReferenceTypeID", "getFrameID", "getString", "", "getID", "size", "remaining", "hasRemaining", "getCharString", "len", "android.sdktools.jdwppacket"})
public final class MessageReader {
    @NotNull
    private final IDSizes idSizes;
    @NotNull
    private final ByteBuffer buffer;

    public MessageReader(@NotNull IDSizes idSizes, @NotNull ByteBuffer buffer) {
        Intrinsics.checkNotNullParameter((Object)idSizes, (String)"idSizes");
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        this.idSizes = idSizes;
        this.buffer = buffer;
    }

    @NotNull
    public final IDSizes getIdSizes() {
        return this.idSizes;
    }

    @NotNull
    public final ByteBuffer getBuffer() {
        return this.buffer;
    }

    @NotNull
    public final MessageReader duplicate() {
        ByteBuffer byteBuffer = this.buffer.duplicate();
        Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"duplicate(...)");
        return new MessageReader(this.idSizes, byteBuffer);
    }

    public final byte getByte() {
        return this.buffer.get();
    }

    public final byte getTypeTag() {
        return this.getByte();
    }

    public final boolean getBoolean() {
        return this.buffer.get() != 0;
    }

    public final short getShort() {
        return this.buffer.getShort();
    }

    public final int getInt() {
        return this.buffer.getInt();
    }

    public final long getLong() {
        return this.buffer.getLong();
    }

    @NotNull
    public final Location getLocation() {
        return Location.Companion.parse(this);
    }

    public final long getFieldID() {
        return this.getID(this.idSizes.getFieldIDSize());
    }

    public final long getMethodID() {
        return this.getID(this.idSizes.getMethodIDSize());
    }

    public final long getClassID() {
        return this.getReferenceTypeID();
    }

    public final long getObjectID() {
        return this.getID(this.idSizes.getObjectIDSize());
    }

    public final long getThreadID() {
        return this.getObjectID();
    }

    @NotNull
    public final TaggedObjectID getTaggedObjectID() {
        return new TaggedObjectID(this.getByte(), this.getObjectID());
    }

    public final long getReferenceTypeID() {
        return this.getID(this.idSizes.getReferenceTypeIDSize());
    }

    public final long getFrameID() {
        return this.getID(this.idSizes.getFrameIDSize());
    }

    @NotNull
    public final String getString() {
        byte[] bytes = new byte[this.getInt()];
        this.buffer.get(bytes);
        Charset charset = StandardCharsets.UTF_8;
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
        Charset charset2 = charset;
        return new String(bytes, charset2);
    }

    private final long getID(int size) {
        long l;
        switch (size) {
            case 1: {
                l = this.buffer.get();
                break;
            }
            case 2: {
                l = this.buffer.getShort();
                break;
            }
            case 4: {
                l = this.buffer.getInt();
                break;
            }
            case 8: {
                l = this.buffer.getLong();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported id size: " + size);
            }
        }
        return l;
    }

    public final int remaining() {
        return this.buffer.remaining();
    }

    public final boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    @NotNull
    public final String getCharString(int len) {
        int n = 0;
        char[] cArray = new char[len];
        while (n < len) {
            int n2 = n++;
            cArray[n2] = this.buffer.getChar();
        }
        char[] cArray2 = cArray;
        return new String(cArray2);
    }
}

