/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.CollectingOutputReceiver;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.InstallException;
import com.android.ddmlib.InstallMetrics;
import com.android.ddmlib.InstallReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.ServiceInfo;
import com.android.ddmlib.ServiceReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.SplitApkInstaller;
import com.android.ddmlib.SyncException;
import com.android.ddmlib.TimeoutException;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.AndroidVersionUtil;
import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

public class IDeviceSharedImpl {
    private final IDevice iDevice;
    private AndroidVersion mVersion;
    private String mName;
    private Boolean mHasScreenRecorder;
    private static final long LS_TIMEOUT_SEC = 2L;
    private static final char DEVICE_NAME_SEPARATOR = '-';
    private static final String SCREEN_RECORDER_DEVICE_PATH = "/system/bin/screenrecord";
    private static final String LOG_TAG = "Device";
    public static final long INSTALL_TIMEOUT_MINUTES;
    private InstallMetrics lastInstallMetrics;

    public IDeviceSharedImpl(IDevice iDevice2) {
        this.iDevice = iDevice2;
    }

    public String getName() {
        if (this.mName != null) {
            return this.mName;
        }
        if (this.iDevice.isOnline()) {
            this.mName = this.constructName();
            return this.mName;
        }
        return this.constructName();
    }

    private String constructName() {
        if (this.iDevice.isEmulator()) {
            String avdName2 = this.iDevice.getAvdName();
            if (avdName2 != null) {
                return String.format("%s [%s]", avdName2, this.iDevice.getSerialNumber());
            }
            return this.iDevice.getSerialNumber();
        }
        String manufacturer = null;
        String model = null;
        try {
            manufacturer = IDeviceSharedImpl.cleanupStringForDisplay(this.iDevice.getProperty("ro.product.manufacturer"));
            model = IDeviceSharedImpl.cleanupStringForDisplay(this.iDevice.getProperty("ro.product.model"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        StringBuilder sb = new StringBuilder(20);
        if (!(manufacturer == null || model != null && model.toUpperCase(Locale.US).startsWith(manufacturer.toUpperCase(Locale.US)))) {
            sb.append(manufacturer);
            sb.append('-');
        }
        if (model != null) {
            sb.append(model);
            sb.append('-');
        }
        sb.append(this.iDevice.getSerialNumber());
        return sb.toString();
    }

    public AndroidVersion getVersion() {
        if (this.mVersion == null) {
            String buildApi = this.iDevice.getProperty("ro.build.version.sdk");
            if (buildApi == null) {
                return AndroidVersion.DEFAULT;
            }
            Map<String, String> properties = this.iDevice.getProperties();
            this.mVersion = AndroidVersionUtil.androidVersionFromDeviceProperties(properties);
            if (this.mVersion == null) {
                this.mVersion = AndroidVersion.DEFAULT;
            }
        }
        return this.mVersion;
    }

    public boolean supportsFeature(IDevice.HardwareFeature feature) {
        try {
            return this.iDevice.getHardwareCharacteristics().contains(feature.getCharacteristic());
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean supportsFeature(IDevice.Feature feature, Set<String> adbFeatures) {
        switch (feature) {
            case SCREEN_RECORD: {
                if (this.supportsFeature(IDevice.HardwareFeature.WATCH) && !this.getVersion().isAtLeast(30)) {
                    return false;
                }
                if (!this.getVersion().isAtLeast(19)) {
                    return false;
                }
                if (this.mHasScreenRecorder == null) {
                    this.mHasScreenRecorder = this.hasBinary(SCREEN_RECORDER_DEVICE_PATH);
                }
                return this.mHasScreenRecorder;
            }
            case PROCSTATS: {
                return this.getVersion().isAtLeast(19);
            }
            case ABB_EXEC: {
                return adbFeatures.contains("abb_exec");
            }
            case REAL_PKG_NAME: {
                return this.getVersion().isAtLeast(29, "R");
            }
            case SKIP_VERIFICATION: {
                String sdkVersionString;
                if (this.getVersion().isAtLeast(30)) {
                    return true;
                }
                if (this.getVersion().isAtLeast(29, "R") && (sdkVersionString = this.iDevice.getProperty("ro.build.version.preview_sdk")) != null) {
                    try {
                        return Integer.parseInt(sdkVersionString) > 1;
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                return false;
            }
            case SHELL_V2: {
                return adbFeatures.contains("shell_v2");
            }
        }
        return false;
    }

    public int getDensity() {
        String densityValue = this.iDevice.getProperty("ro.sf.lcd_density");
        if (densityValue == null) {
            densityValue = this.iDevice.getProperty("qemu.sf.lcd_density");
        }
        if (densityValue != null) {
            try {
                return Integer.parseInt(densityValue);
            }
            catch (NumberFormatException e) {
                return -1;
            }
        }
        return -1;
    }

    public List<String> getAbis() {
        String abiList = this.iDevice.getProperty("ro.product.cpu.abilist");
        if (abiList != null) {
            return Lists.newArrayList((Object[])abiList.split(","));
        }
        ArrayList abis = Lists.newArrayListWithExpectedSize((int)2);
        String abi = this.iDevice.getProperty("ro.product.cpu.abi");
        if (abi != null) {
            abis.add(abi);
        }
        if ((abi = this.iDevice.getProperty("ro.product.cpu.abi2")) != null) {
            abis.add(abi);
        }
        return abis;
    }

    public Map<String, ServiceInfo> services() {
        ServiceReceiver receiver = new ServiceReceiver();
        try {
            this.iDevice.executeShellCommand("service list", receiver);
        }
        catch (Exception e) {
            Log.e(LOG_TAG, new RuntimeException("Error obtaining services: ", e));
            return new HashMap<String, ServiceInfo>();
        }
        return receiver.getRunningServices();
    }

    public void forceStop(String applicationName) {
        try {
            this.iDevice.executeShellCommand("am force-stop " + applicationName, new NullOutputReceiver());
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException exception) {
            // empty catch block
        }
    }

    public void kill(String applicationName) {
        try {
            this.iDevice.executeShellCommand("am kill " + applicationName, new NullOutputReceiver());
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException exception) {
            // empty catch block
        }
    }

    private boolean hasBinary(String path) {
        CountDownLatch latch = new CountDownLatch(1);
        CollectingOutputReceiver receiver = new CollectingOutputReceiver(latch);
        try {
            this.iDevice.executeShellCommand("ls " + path, receiver, 2L, TimeUnit.SECONDS);
        }
        catch (Exception e) {
            return false;
        }
        try {
            latch.await(2L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            return false;
        }
        String value = receiver.getOutput().trim();
        return !value.endsWith("No such file or directory");
    }

    private static String cleanupStringForDisplay(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c)) {
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    public void installRemotePackage(String remoteFilePath, boolean reinstall, InstallReceiver receiver, long maxTimeout, long maxTimeToOutputResponse, TimeUnit maxTimeUnits, String ... extraArgs) throws InstallException {
        try {
            StringBuilder optionString = new StringBuilder();
            if (reinstall) {
                optionString.append("-r ");
            }
            if (extraArgs != null) {
                optionString.append(Joiner.on((char)' ').join((Object[])extraArgs));
            }
            String cmd = String.format("pm install %1$s \"%2$s\"", optionString.toString(), remoteFilePath);
            this.iDevice.executeShellCommand(cmd, (IShellOutputReceiver)receiver, maxTimeout, maxTimeToOutputResponse, maxTimeUnits);
            String error = receiver.getErrorMessage();
            if (error != null) {
                throw new InstallException(error, receiver.getErrorCode());
            }
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
            throw new InstallException(e);
        }
    }

    public void installPackage(String packageFilePath, boolean reinstall, InstallReceiver receiver, long maxTimeout, long maxTimeToOutputResponse, TimeUnit maxTimeUnits, String ... extraArgs) throws InstallException {
        try {
            long uploadStartNs = System.nanoTime();
            String remoteFilePath = this.iDevice.syncPackageToDevice(packageFilePath);
            long uploadFinishNs = System.nanoTime();
            this.installRemotePackage(remoteFilePath, reinstall, receiver, maxTimeout, maxTimeToOutputResponse, maxTimeUnits, extraArgs);
            long installFinishNs = System.nanoTime();
            this.removeRemotePackage(remoteFilePath);
            this.lastInstallMetrics = new InstallMetrics(uploadStartNs, uploadFinishNs, uploadFinishNs, installFinishNs);
        }
        catch (AdbCommandRejectedException | SyncException | TimeoutException | IOException e) {
            throw new InstallException(e);
        }
    }

    public void installPackages(List<File> apks, boolean reinstall, List<String> installOptions, long timeout, TimeUnit timeoutUnit) throws InstallException {
        try {
            this.lastInstallMetrics = SplitApkInstaller.create(this.iDevice, apks, reinstall, installOptions).install(timeout, timeoutUnit);
        }
        catch (InstallException e) {
            throw e;
        }
        catch (Exception e) {
            throw new InstallException(e);
        }
    }

    public InstallMetrics getLastInstallMetrics() {
        return this.lastInstallMetrics;
    }

    public void removeRemotePackage(String remoteFilePath) throws InstallException {
        try {
            this.iDevice.executeShellCommand(String.format("rm \"%1$s\"", remoteFilePath), new NullOutputReceiver(), INSTALL_TIMEOUT_MINUTES, TimeUnit.MINUTES);
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
            throw new InstallException(e);
        }
    }

    public String uninstallApp(String applicationID, String ... extraArgs) throws InstallException {
        try {
            StringBuilder command = new StringBuilder("pm uninstall");
            if (extraArgs != null) {
                command.append(" ");
                Joiner.on((char)' ').appendTo(command, (Object[])extraArgs);
            }
            command.append(" ").append(applicationID);
            InstallReceiver receiver = new InstallReceiver();
            this.iDevice.executeShellCommand(command.toString(), receiver, INSTALL_TIMEOUT_MINUTES, TimeUnit.MINUTES);
            return receiver.getErrorMessage();
        }
        catch (AdbCommandRejectedException | ShellCommandUnresponsiveException | TimeoutException | IOException e) {
            throw new InstallException(e);
        }
    }

    static {
        String installTimeout = System.getenv("ADB_INSTALL_TIMEOUT");
        long time = 4L;
        if (installTimeout != null) {
            try {
                time = Long.parseLong(installTimeout);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        INSTALL_TIMEOUT_MINUTES = time;
    }
}

