/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.Log;
import com.google.common.collect.Sets;
import java.util.Set;

public class AndroidDebugBridgeChangeEvents {
    private static final String ADB = "adb";
    private final Set<AndroidDebugBridge.IDebugBridgeChangeListener> bridgeListeners = Sets.newCopyOnWriteArraySet();
    private final Set<AndroidDebugBridge.IDeviceChangeListener> deviceListeners = Sets.newCopyOnWriteArraySet();
    private final Set<AndroidDebugBridge.IClientChangeListener> clientListeners = Sets.newCopyOnWriteArraySet();

    public void addDebugBridgeChangeListener(AndroidDebugBridge.IDebugBridgeChangeListener listener2) {
        this.bridgeListeners.add(listener2);
    }

    public void removeDebugBridgeChangeListener(AndroidDebugBridge.IDebugBridgeChangeListener listener2) {
        this.bridgeListeners.remove(listener2);
    }

    public int debugBridgeChangeListenerCount() {
        return this.bridgeListeners.size();
    }

    public void notifyBridgeChanged(AndroidDebugBridge bridge) {
        for (AndroidDebugBridge.IDebugBridgeChangeListener listener2 : this.bridgeListeners) {
            try {
                listener2.bridgeChanged(bridge);
            }
            catch (Throwable t) {
                Log.e(ADB, t);
            }
        }
    }

    public void notifyBridgeRestartInitiated() {
        for (AndroidDebugBridge.IDebugBridgeChangeListener listener2 : this.bridgeListeners) {
            try {
                listener2.restartInitiated();
            }
            catch (Throwable t) {
                Log.e(ADB, t);
            }
        }
    }

    public void notifyBridgeRestartCompleted(boolean isSuccessful) {
        for (AndroidDebugBridge.IDebugBridgeChangeListener listener2 : this.bridgeListeners) {
            try {
                listener2.restartCompleted(isSuccessful);
            }
            catch (Throwable t) {
                Log.e(ADB, t);
            }
        }
    }

    public void notifyBridgeInitializationError(Exception e) {
        for (AndroidDebugBridge.IDebugBridgeChangeListener listener2 : this.bridgeListeners) {
            try {
                listener2.initializationError(e);
            }
            catch (Throwable t) {
                Log.e(ADB, t);
            }
        }
    }

    public void addDeviceChangeListener(AndroidDebugBridge.IDeviceChangeListener listener2) {
        this.deviceListeners.add(listener2);
    }

    public void removeDeviceChangeListener(AndroidDebugBridge.IDeviceChangeListener listener2) {
        this.deviceListeners.remove(listener2);
    }

    public int deviceChangeListenerCount() {
        return this.deviceListeners.size();
    }

    public void notifyDeviceChanged(IDevice device2, int changeMask) {
        for (AndroidDebugBridge.IDeviceChangeListener listener2 : this.deviceListeners) {
            try {
                listener2.deviceChanged(device2, changeMask);
            }
            catch (Throwable t) {
                Log.e(ADB, t);
            }
        }
    }

    public void notifyDeviceConnected(IDevice device2) {
        for (AndroidDebugBridge.IDeviceChangeListener listener2 : this.deviceListeners) {
            try {
                listener2.deviceConnected(device2);
            }
            catch (Throwable t) {
                Log.e(ADB, t);
            }
        }
    }

    public void notifyDeviceDisconnected(IDevice device2) {
        for (AndroidDebugBridge.IDeviceChangeListener listener2 : this.deviceListeners) {
            try {
                listener2.deviceDisconnected(device2);
            }
            catch (Throwable t) {
                Log.e(ADB, t);
            }
        }
    }

    public void addClientChangeListener(AndroidDebugBridge.IClientChangeListener listener2) {
        this.clientListeners.add(listener2);
    }

    public void removeClientChangeListener(AndroidDebugBridge.IClientChangeListener listener2) {
        this.clientListeners.remove(listener2);
    }

    public void notifyClientChanged(Client client, int changeMask) {
        for (AndroidDebugBridge.IClientChangeListener listener2 : this.clientListeners) {
            try {
                listener2.clientChanged(client, changeMask);
            }
            catch (Throwable t) {
                Log.e(ADB, t);
            }
        }
    }
}

