/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.tools.debugging.impl;

import com.android.adblib.AdbDeviceServicesKt;
import com.android.adblib.AdbLogger;
import com.android.adblib.AdbLoggerFactory;
import com.android.adblib.AdbLoggerKt;
import com.android.adblib.AdbSession;
import com.android.adblib.AdbSessionHost;
import com.android.adblib.AdbSessionKt;
import com.android.adblib.AppProcessEntry;
import com.android.adblib.ConnectedDevice;
import com.android.adblib.ConnectedDeviceKt;
import com.android.adblib.ConnectedDevicesTrackerKt;
import com.android.adblib.CoroutineScopeCache;
import com.android.adblib.ListWithErrors;
import com.android.adblib.tools.AdbLibToolsProperties;
import com.android.adblib.tools.debugging.AppProcessEntryList;
import com.android.adblib.tools.debugging.JdwpPacketReceiver;
import com.android.adblib.tools.debugging.JdwpProcessIdList;
import com.android.adblib.tools.debugging.SharedJdwpSession;
import com.android.adblib.tools.debugging.StateFlowStatus;
import com.android.adblib.tools.debugging.TrackAppKt;
import com.android.adblib.tools.debugging.TrackJdwpKt;
import com.android.adblib.tools.debugging.impl.AbstractJdwpProcess;
import com.android.adblib.tools.debugging.impl.AbstractJdwpProcessDelegateProvider;
import com.android.adblib.tools.debugging.impl.BlockActivationTracker;
import com.android.adblib.tools.debugging.impl.JdwpProcessImpl;
import com.android.adblib.tools.debugging.impl.JdwpProcessManager;
import com.android.adblib.tools.debugging.impl.JdwpProcessManagerImpl;
import com.android.adblib.tools.debugging.impl.JdwpProcessManagerImpl$JdwpProcessIdTracker$trackProcesses$2$invokeSuspend$;
import com.android.adblib.tools.debugging.impl.JdwpProcessManagerKt;
import com.android.adblib.tools.debugging.impl.JdwpProcessSessionFinder;
import com.android.adblib.tools.debugging.impl.JdwpProcessSessionFinderKt;
import com.android.adblib.tools.debugging.packets.JdwpPacketView;
import com.android.adblib.utils.AdbLoggerUtilsKt;
import com.android.adblib.utils.CoroutineUtilsKt;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import kotlin.KotlinNothingValueException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.coroutines.jvm.internal.ContinuationImpl;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.DelayKt;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.TimeoutKt;
import kotlinx.coroutines.flow.Flow;
import kotlinx.coroutines.flow.FlowCollector;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u0001\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003:\u000389:B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\"\u0010,\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110-2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00100/H\u0016J\u0016\u00100\u001a\u00020\u00112\u0006\u00101\u001a\u00020\u0010H\u0086@\u00a2\u0006\u0002\u00102J\b\u00103\u001a\u000204H\u0016J\u0016\u00105\u001a\u0002042\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00100/H\u0002J\u0010\u00106\u001a\u0002072\u0006\u00101\u001a\u00020\u0010H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u000e\u001a\u0014\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00110\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u001a\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u001b\u0010!\u001a\u00020\"8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b#\u0010$R\u001d\u0010'\u001a\u0004\u0018\u00010(8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b+\u0010&\u001a\u0004\b)\u0010*\u00a8\u0006;"}, d2={"Lcom/android/adblib/tools/debugging/impl/JdwpProcessManagerImpl;", "Lcom/android/adblib/tools/debugging/impl/JdwpProcessManager;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "device", "Lcom/android/adblib/ConnectedDevice;", "<init>", "(Lcom/android/adblib/ConnectedDevice;)V", "getDevice", "()Lcom/android/adblib/ConnectedDevice;", "logger", "Lcom/android/adblib/AdbLogger;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "processOrDelegateFactory", "Lkotlin/Function2;", "", "Lcom/android/adblib/tools/debugging/impl/AbstractJdwpProcess;", "jdwpProcessIdTracker", "Lcom/android/adblib/tools/debugging/impl/JdwpProcessManagerImpl$JdwpProcessIdTracker;", "lock", "", "jdwpProcessMap", "Lcom/android/adblib/tools/debugging/impl/JdwpProcessManagerImpl$AbstractJdwpProcessMap;", "jdwpProcessMapRefreshDelay", "Ljava/time/Duration;", "getJdwpProcessMapRefreshDelay", "()Ljava/time/Duration;", "processIdsStateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "Lcom/android/adblib/tools/debugging/JdwpProcessIdList;", "getProcessIdsStateFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "processIdsStateFlowUpdaterJob", "Lkotlinx/coroutines/Job;", "getProcessIdsStateFlowUpdaterJob", "()Lkotlinx/coroutines/Job;", "processIdsStateFlowUpdaterJob$delegate", "Lkotlin/Lazy;", "delegateSession", "Lcom/android/adblib/AdbSession;", "getDelegateSession", "()Lcom/android/adblib/AdbSession;", "delegateSession$delegate", "addProcesses", "", "processIds", "", "waitForProcess", "pid", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "", "setActiveProcessIds", "throwProcessNotFoundInternalError", "", "JdwpProcessIdTracker", "AbstractJdwpProcessMap", "JdwpProcessDelegate", "android.sdktools.adblib.tools"})
@SourceDebugExtension(value={"SMAP\nJdwpProcessManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdwpProcessManagerImpl.kt\ncom/android/adblib/tools/debugging/impl/JdwpProcessManagerImpl\n+ 2 AdbLogger.kt\ncom/android/adblib/AdbLoggerKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,507:1\n134#2:508\n127#2:509\n120#2:510\n1563#3:511\n1634#3,3:512\n1208#3,2:515\n1236#3,4:517\n1803#3,3:521\n*S KotlinDebug\n*F\n+ 1 JdwpProcessManagerImpl.kt\ncom/android/adblib/tools/debugging/impl/JdwpProcessManagerImpl\n*L\n68#1:508\n68#1:509\n68#1:510\n172#1:511\n172#1:512,3\n177#1:515,2\n177#1:517,4\n156#1:521,3\n*E\n"})
public final class JdwpProcessManagerImpl
implements JdwpProcessManager,
AutoCloseable {
    @NotNull
    private final ConnectedDevice device;
    @NotNull
    private final AdbLogger logger;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private final Function2<ConnectedDevice, Integer, AbstractJdwpProcess> processOrDelegateFactory;
    @NotNull
    private final JdwpProcessIdTracker jdwpProcessIdTracker;
    @NotNull
    private final Object lock;
    @NotNull
    private final AbstractJdwpProcessMap jdwpProcessMap;
    @NotNull
    private final Lazy processIdsStateFlowUpdaterJob$delegate;
    @NotNull
    private final Lazy delegateSession$delegate;

    /*
     * WARNING - void declaration
     */
    public JdwpProcessManagerImpl(@NotNull ConnectedDevice device2) {
        void $this$adbLogger$iv$iv;
        void $this$adbLogger$iv;
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        this.device = device2;
        JdwpProcessManagerImpl jdwpProcessManagerImpl = this;
        AdbSession session$iv = this.getDevice().getSession();
        boolean $i$f$adbLogger = false;
        void var5_5 = $this$adbLogger$iv;
        AdbSessionHost host$iv$iv = session$iv.getHost();
        boolean $i$f$adbLogger2 = false;
        void var8_8 = $this$adbLogger$iv$iv;
        AdbLoggerFactory loggerFactory$iv$iv$iv = host$iv$iv.getLoggerFactory();
        boolean $i$f$adbLogger3 = false;
        this.logger = AdbLoggerKt.withPrefix(loggerFactory$iv$iv$iv.createLogger(JdwpProcessManagerImpl.class), this.getDevice() + " - ");
        this.scope = CoroutineUtilsKt.createChildScope$default(ConnectedDeviceKt.getScope(this.getDevice()), true, null, 2, null);
        this.processOrDelegateFactory = (arg_0, arg_1) -> JdwpProcessManagerImpl.processOrDelegateFactory$lambda$0(this, arg_0, arg_1);
        this.jdwpProcessIdTracker = new JdwpProcessIdTracker(this.getDevice());
        this.lock = new Object();
        this.jdwpProcessMap = new AbstractJdwpProcessMap(this.getDevice(), this.processOrDelegateFactory);
        this.processIdsStateFlowUpdaterJob$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, () -> JdwpProcessManagerImpl.processIdsStateFlowUpdaterJob_delegate$lambda$1(this));
        this.delegateSession$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, () -> JdwpProcessManagerImpl.delegateSession_delegate$lambda$4(this));
    }

    @Override
    @NotNull
    public ConnectedDevice getDevice() {
        return this.device;
    }

    private final Duration getJdwpProcessMapRefreshDelay() {
        return (Duration)AdbSessionKt.property(this.getDevice().getSession(), AdbLibToolsProperties.INSTANCE.getJDWP_PROCESS_MANAGER_REFRESH_DELAY());
    }

    private final StateFlow<JdwpProcessIdList> getProcessIdsStateFlow() {
        return this.jdwpProcessIdTracker.getProcessIdsStateFlow();
    }

    private final Job getProcessIdsStateFlowUpdaterJob() {
        Lazy lazy = this.processIdsStateFlowUpdaterJob$delegate;
        return (Job)lazy.getValue();
    }

    private final AdbSession getDelegateSession() {
        Lazy lazy = this.delegateSession$delegate;
        return (AdbSession)lazy.getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public Map<Integer, AbstractJdwpProcess> addProcesses(@NotNull Set<Integer> processIds2) {
        Map map2;
        Intrinsics.checkNotNullParameter(processIds2, (String)"processIds");
        this.getProcessIdsStateFlowUpdaterJob();
        Object object = this.lock;
        synchronized (object) {
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            Object object2;
            void $this$mapTo$iv$iv;
            boolean bl = false;
            CoroutineScopeKt.ensureActive((CoroutineScope)this.scope);
            this.jdwpProcessMap.addProcesses(processIds2);
            Iterable $this$map$iv = processIds2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void pid;
                int n = ((Number)item$iv$iv).intValue();
                object2 = destination$iv$iv;
                boolean bl2 = false;
                AbstractJdwpProcess abstractJdwpProcess = this.jdwpProcessMap.getProcessOrNull((int)pid);
                if (abstractJdwpProcess == null) {
                    JdwpProcessManagerImpl $this$addProcesses_u24lambda_u248_u24lambda_u246_u24lambda_u245 = this;
                    boolean bl3 = false;
                    $this$addProcesses_u24lambda_u248_u24lambda_u246_u24lambda_u245.throwProcessNotFoundInternalError((int)pid);
                    throw new KotlinNothingValueException();
                }
                object2.add(abstractJdwpProcess);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            destination$iv$iv = $this$associateBy$iv;
            Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void process;
                AbstractJdwpProcess bl2 = (AbstractJdwpProcess)element$iv$iv;
                object2 = destination$iv$iv2;
                boolean bl4 = false;
                object2.put(process.getPid(), element$iv$iv);
            }
            map2 = destination$iv$iv2;
        }
        return map2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    @Nullable
    public final Object waitForProcess(int var1_1, @NotNull Continuation<? super AbstractJdwpProcess> $completion) {
        if (!($completion instanceof waitForProcess.1)) ** GOTO lbl-1000
        var12_3 = $completion;
        if ((var12_3.label & -2147483648) != 0) {
            var12_3.label -= -2147483648;
        } else lbl-1000:
        // 2 sources

        {
            $continuation = new ContinuationImpl(this, $completion){
                int I$0;
                /* synthetic */ Object result;
                final /* synthetic */ JdwpProcessManagerImpl this$0;
                int label;
                {
                    this.this$0 = this$0;
                    super($completion);
                }

                @Nullable
                public final Object invokeSuspend(@NotNull Object $result) {
                    this.result = $result;
                    this.label |= Integer.MIN_VALUE;
                    return this.this$0.waitForProcess(0, (Continuation<? super AbstractJdwpProcess>)((Continuation)this));
                }
            };
        }
        $result = $continuation.result;
        var13_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
        switch ($continuation.label) {
            case 0: {
                ResultKt.throwOnFailure((Object)$result);
                if (!(this.getDelegateSession() == null)) {
                    $i$a$-check-JdwpProcessManagerImpl$waitForProcess$2 = false;
                    var4_7 = "Nested delegate sessions are not supported yet";
                    throw new IllegalStateException(var4_7.toString());
                }
                this.getProcessIdsStateFlowUpdaterJob();
                $continuation.I$0 = pid;
                $continuation.label = 1;
                v0 = FlowKt.first((Flow)((Flow)this.getProcessIdsStateFlow()), (Function2)((Function2)new Function2<JdwpProcessIdList, Continuation<? super Boolean>, Object>(pid, null){
                    int label;
                    /* synthetic */ Object L$0;
                    final /* synthetic */ int $pid;
                    {
                        this.$pid = $pid;
                        super(2, $completion);
                    }

                    public final Object invokeSuspend(Object object) {
                        IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)object);
                                JdwpProcessIdList it = (JdwpProcessIdList)this.L$0;
                                return Boxing.boxBoolean((boolean)it.contains(Boxing.boxInt((int)this.$pid)));
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(JdwpProcessIdList p1, Continuation<? super Boolean> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (Continuation)$continuation);
                if (v0 == var13_5) {
                    return var13_5;
                }
                ** GOTO lbl28
            }
            case 1: {
                pid = $continuation.I$0;
                ResultKt.throwOnFailure((Object)$result);
                v0 = $result;
lbl28:
                // 2 sources

                processIds = CollectionsKt.toSet((Iterable)((Iterable)v0));
                var5_9 = this.lock;
                synchronized (var5_9) {
                    $i$a$-synchronized-JdwpProcessManagerImpl$waitForProcess$3 = false;
                    CoroutineScopeKt.ensureActive((CoroutineScope)this.scope);
                    var7_12 = processIds.contains(Boxing.boxInt((int)pid));
                    if (_Assertions.ENABLED && !var7_12) {
                        var8_14 = "Assertion failed";
                        throw new AssertionError((Object)var8_14);
                    }
                    this.jdwpProcessMap.addProcesses(processIds);
                    v1 = this.jdwpProcessMap.getProcessOrNull(pid);
                    if (v1 == null) {
                        $this$waitForProcess_u24lambda_u2411_u24lambda_u2410 = this;
                        $i$a$-run-JdwpProcessManagerImpl$waitForProcess$3$1 = false;
                        $this$waitForProcess_u24lambda_u2411_u24lambda_u2410.throwProcessNotFoundInternalError(pid);
                        throw new KotlinNothingValueException();
                    }
                    var6_11 = v1;
                }
                return var6_11;
            }
        }
        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            CoroutineScopeKt.cancel$default((CoroutineScope)this.scope, (String)(this.getClass().getSimpleName() + " has been closed"), null, (int)2, null);
            this.jdwpProcessMap.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void setActiveProcessIds(Set<Integer> processIds2) {
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            CoroutineScopeKt.ensureActive((CoroutineScope)this.scope);
            this.jdwpProcessMap.setActiveProcessIds(processIds2);
            Unit unit = Unit.INSTANCE;
        }
    }

    private final Void throwProcessNotFoundInternalError(int pid) {
        String message = "Internal error: A process (pid=" + pid + ") was not found in the process map";
        this.logger.error(message);
        throw new IllegalStateException(message);
    }

    private static final AbstractJdwpProcess processOrDelegateFactory$lambda$0(JdwpProcessManagerImpl this$0, ConnectedDevice device2, int pid) {
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        AdbSession localDelegateSession = this$0.getDelegateSession();
        return localDelegateSession == null ? (AbstractJdwpProcess)new JdwpProcessImpl(device2, pid) : (AbstractJdwpProcess)new JdwpProcessDelegate(device2, pid, localDelegateSession);
    }

    private static final Job processIdsStateFlowUpdaterJob_delegate$lambda$1(JdwpProcessManagerImpl this$0) {
        return BuildersKt.launch$default((CoroutineScope)this$0.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            private /* synthetic */ Object L$0;
            final /* synthetic */ JdwpProcessManagerImpl this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Exception decompiling
             */
            public final Object invokeSuspend(Object var1_1) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:139)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.CastExpression.dumpInner(CastExpression.java:114)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.StaticFunctionInvokation.dumpInner(StaticFunctionInvokation.java:143)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredReturn.dump(StructuredReturn.java:60)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.Block.dump(Block.java:564)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.dump(Op04StructuredStatement.java:220)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.dump(AttributeCode.java:135)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:627)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.AbstractClassFileDumper.dumpMethods(AbstractClassFileDumper.java:211)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:70)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                var var3_3 = new /* invalid duplicate definition of identical inner class */;
                var3_3.L$0 = value;
                return (Continuation)var3_3;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    private static final AdbSession delegateSession_delegate$lambda$4(JdwpProcessManagerImpl this$0) {
        void var3_3;
        void $this$fold$iv;
        AdbSession deviceSession = this$0.getDevice().getSession();
        Iterable iterable = JdwpProcessSessionFinderKt.getJdwpProcessSessionFinderList(this$0.getDevice().getSession());
        AdbSession initial$iv = deviceSession;
        boolean $i$f$fold = false;
        AdbSession accumulator$iv = initial$iv;
        for (Object element$iv : $this$fold$iv) {
            void finder;
            JdwpProcessSessionFinder jdwpProcessSessionFinder = (JdwpProcessSessionFinder)element$iv;
            AdbSession session2 = accumulator$iv;
            boolean bl = false;
            accumulator$iv = finder.findDelegateSession(session2);
        }
        AdbSession it = accumulator$iv;
        boolean bl = false;
        return it == deviceSession ? null : var3_3;
    }

    public static final /* synthetic */ JdwpProcessIdTracker access$getJdwpProcessIdTracker$p(JdwpProcessManagerImpl $this) {
        return $this.jdwpProcessIdTracker;
    }

    public static final /* synthetic */ Duration access$getJdwpProcessMapRefreshDelay(JdwpProcessManagerImpl $this) {
        return $this.getJdwpProcessMapRefreshDelay();
    }

    public static final /* synthetic */ void access$setActiveProcessIds(JdwpProcessManagerImpl $this, Set processIds2) {
        $this.setActiveProcessIds(processIds2);
    }

    public static final /* synthetic */ AdbLogger access$getLogger$p(JdwpProcessManagerImpl $this) {
        return $this.logger;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B)\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000f\u001a\u00020\u0006J\u0014\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013J\u0014\u0010\u0014\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013J\u0006\u0010\u0015\u001a\u00020\u0011J\u0016\u0010\u0016\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0007H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0004\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0006\u0012\u0004\u0018\u00010\u00070\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/android/adblib/tools/debugging/impl/JdwpProcessManagerImpl$AbstractJdwpProcessMap;", "", "device", "Lcom/android/adblib/ConnectedDevice;", "factory", "Lkotlin/Function2;", "", "Lcom/android/adblib/tools/debugging/impl/AbstractJdwpProcess;", "<init>", "(Lcom/android/adblib/ConnectedDevice;Lkotlin/jvm/functions/Function2;)V", "logger", "Lcom/android/adblib/AdbLogger;", "map", "", "getProcessOrNull", "pid", "addProcesses", "", "processIds", "", "setActiveProcessIds", "clear", "closeJdwpProcessList", "toClose", "", "closeJdwpProcess", "jdwpProcess", "android.sdktools.adblib.tools"})
    @SourceDebugExtension(value={"SMAP\nJdwpProcessManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdwpProcessManagerImpl.kt\ncom/android/adblib/tools/debugging/impl/JdwpProcessManagerImpl$AbstractJdwpProcessMap\n+ 2 AdbLogger.kt\ncom/android/adblib/AdbLoggerKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 AdbLogger.kt\ncom/android/adblib/AdbLogger\n+ 5 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,507:1\n134#2:508\n127#2:509\n120#2:510\n382#3,3:511\n385#3,4:529\n38#4:514\n26#4,14:515\n38#4:533\n26#4,14:534\n38#4:551\n26#4,14:552\n46#4:567\n26#4,4:568\n47#4:572\n38#4:574\n26#4,14:575\n1869#5,2:548\n1869#5:550\n1870#5:566\n1869#5:573\n1870#5:589\n*S KotlinDebug\n*F\n+ 1 JdwpProcessManagerImpl.kt\ncom/android/adblib/tools/debugging/impl/JdwpProcessManagerImpl$AbstractJdwpProcessMap\n*L\n323#1:508\n323#1:509\n323#1:510\n348#1:511,3\n348#1:529,4\n350#1:514\n350#1:515,14\n368#1:533\n368#1:534,14\n378#1:551\n378#1:552,14\n390#1:567\n390#1:568,4\n390#1:572\n398#1:574\n398#1:575,14\n372#1:548,2\n377#1:550\n377#1:566\n397#1:573\n397#1:589\n*E\n"})
    private static final class AbstractJdwpProcessMap {
        @NotNull
        private final ConnectedDevice device;
        @NotNull
        private final Function2<ConnectedDevice, Integer, AbstractJdwpProcess> factory;
        @NotNull
        private final AdbLogger logger;
        @NotNull
        private final Map<Integer, AbstractJdwpProcess> map;

        /*
         * WARNING - void declaration
         */
        public AbstractJdwpProcessMap(@NotNull ConnectedDevice device2, @NotNull Function2<? super ConnectedDevice, ? super Integer, ? extends AbstractJdwpProcess> factory) {
            void $this$adbLogger$iv$iv;
            void $this$adbLogger$iv;
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            Intrinsics.checkNotNullParameter(factory, (String)"factory");
            this.device = device2;
            this.factory = factory;
            AbstractJdwpProcessMap abstractJdwpProcessMap = this;
            AdbSession session$iv = this.device.getSession();
            boolean $i$f$adbLogger = false;
            void var6_6 = $this$adbLogger$iv;
            AdbSessionHost host$iv$iv = session$iv.getHost();
            boolean $i$f$adbLogger2 = false;
            void var9_9 = $this$adbLogger$iv$iv;
            AdbLoggerFactory loggerFactory$iv$iv$iv = host$iv$iv.getLoggerFactory();
            boolean $i$f$adbLogger3 = false;
            this.logger = AdbLoggerKt.withPrefix(loggerFactory$iv$iv$iv.createLogger(AbstractJdwpProcessMap.class), this.device.getSession() + " - " + this.device + " - ");
            this.map = new TreeMap();
        }

        /*
         * WARNING - void declaration
         */
        @Nullable
        public final AbstractJdwpProcess getProcessOrNull(int pid) {
            Object object;
            void $this$getOrPut$iv;
            if (!this.map.containsKey(pid)) {
                return null;
            }
            Map<Integer, AbstractJdwpProcess> map2 = this.map;
            Integer key$iv = pid;
            boolean $i$f$getOrPut = false;
            Object value$iv = $this$getOrPut$iv.get(key$iv);
            if (value$iv == null) {
                void this_$iv$iv;
                boolean bl = false;
                Object object2 = this.factory.invoke((Object)this.device, (Object)pid);
                AbstractJdwpProcess newProcess = (AbstractJdwpProcess)object2;
                boolean bl2 = false;
                AdbLogger this_$iv = this.logger;
                boolean $i$f$verbose = false;
                AdbLogger adbLogger = this_$iv;
                AdbLogger.Level level$iv$iv = AdbLogger.Level.VERBOSE;
                boolean $i$f$logIf = false;
                if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
                    AdbLogger.Level level = level$iv$iv;
                    void var16_16 = this_$iv$iv;
                    boolean bl3 = false;
                    String string2 = "Adding new process to map: '" + newProcess + "' ";
                    var16_16.log(level, string2);
                }
                AbstractJdwpProcess answer$iv = (AbstractJdwpProcess)object2;
                $this$getOrPut$iv.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            return (AbstractJdwpProcess)object;
        }

        public final void addProcesses(@NotNull Set<Integer> processIds2) {
            Intrinsics.checkNotNullParameter(processIds2, (String)"processIds");
            Set newSet = SetsKt.plus(this.map.keySet(), (Iterable)processIds2);
            this.setActiveProcessIds(newSet);
        }

        /*
         * WARNING - void declaration
         */
        public final void setActiveProcessIds(@NotNull Set<Integer> processIds2) {
            int pid;
            void this_$iv$iv;
            Intrinsics.checkNotNullParameter(processIds2, (String)"processIds");
            AdbLogger this_$iv = this.logger;
            boolean $i$f$verbose = false;
            AdbLogger adbLogger = this_$iv;
            AdbLogger.Level level$iv$iv = AdbLogger.Level.VERBOSE;
            boolean $i$f$logIf = false;
            if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
                AdbLogger.Level level = level$iv$iv;
                void var20_11 = this_$iv$iv;
                boolean bl = false;
                String string2 = "Setting list of active process ids: " + processIds2;
                var20_11.log(level, string2);
            }
            List toClose = new ArrayList();
            Set added = SetsKt.minus(processIds2, (Iterable)this.map.keySet());
            Set removed = SetsKt.minus(this.map.keySet(), (Iterable)processIds2);
            Iterable $this$forEach$iv = removed;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                AbstractJdwpProcess abstractJdwpProcess;
                pid = ((Number)element$iv).intValue();
                boolean bl = false;
                if (this.map.remove(pid) == null) continue;
                AbstractJdwpProcess it = abstractJdwpProcess;
                boolean bl2 = false;
                toClose.add(it);
            }
            $this$forEach$iv = added;
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void this_$iv$iv2;
                pid = ((Number)element$iv).intValue();
                boolean bl = false;
                AdbLogger this_$iv2 = this.logger;
                boolean $i$f$verbose2 = false;
                AdbLogger bl2 = this_$iv2;
                AdbLogger.Level level$iv$iv2 = AdbLogger.Level.VERBOSE;
                boolean $i$f$logIf2 = false;
                if (this_$iv$iv2.getMinLevel().compareTo((Enum)level$iv$iv2) <= 0) {
                    AdbLogger.Level level = level$iv$iv2;
                    void var17_26 = this_$iv$iv2;
                    boolean bl3 = false;
                    String string3 = "Adding `null` entry for pid=" + pid;
                    var17_26.log(level, string3);
                }
                this.map.put(pid, null);
            }
            boolean bl = Intrinsics.areEqual(processIds2, this.map.keySet());
            if (_Assertions.ENABLED && !bl) {
                String string4 = "Assertion failed";
                throw new AssertionError((Object)string4);
            }
            this.closeJdwpProcessList(toClose);
        }

        /*
         * WARNING - void declaration
         */
        public final void clear() {
            void this_$iv$iv;
            AdbLogger this_$iv = this.logger;
            boolean $i$f$debug = false;
            AdbLogger adbLogger = this_$iv;
            AdbLogger.Level level$iv$iv = AdbLogger.Level.DEBUG;
            boolean $i$f$logIf = false;
            if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
                AdbLogger.Level level = level$iv$iv;
                void var7_7 = this_$iv$iv;
                boolean bl = false;
                String string2 = "clear(): # of entries=" + this.map.size();
                var7_7.log(level, string2);
            }
            List toClose = CollectionsKt.filterNotNull((Iterable)this.map.values());
            this.map.clear();
            this.closeJdwpProcessList(toClose);
        }

        /*
         * WARNING - void declaration
         */
        private final void closeJdwpProcessList(List<? extends AbstractJdwpProcess> toClose) {
            Iterable $this$forEach$iv = toClose;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void this_$iv$iv;
                AbstractJdwpProcess jdwpProcess = (AbstractJdwpProcess)element$iv;
                boolean bl = false;
                AdbLogger this_$iv = this.logger;
                boolean $i$f$verbose = false;
                AdbLogger adbLogger = this_$iv;
                AdbLogger.Level level$iv$iv = AdbLogger.Level.VERBOSE;
                boolean $i$f$logIf = false;
                if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
                    AdbLogger.Level level = level$iv$iv;
                    void var14_14 = this_$iv$iv;
                    boolean bl2 = false;
                    String string2 = "Removing process from map: " + jdwpProcess;
                    var14_14.log(level, string2);
                }
                this.closeJdwpProcess(jdwpProcess);
            }
        }

        private final void closeJdwpProcess(AbstractJdwpProcess jdwpProcess) {
            long delayMillis = ((Duration)AdbSessionKt.property(this.device.getSession(), AdbLibToolsProperties.INSTANCE.getJDWP_PROCESS_TRACKER_CLOSE_NOTIFICATION_DELAY())).toMillis();
            if (delayMillis > 0L) {
                BuildersKt.launch$default((CoroutineScope)ConnectedDeviceKt.getScope(this.device), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(delayMillis, jdwpProcess, this, null){
                    int label;
                    private /* synthetic */ Object L$0;
                    final /* synthetic */ long $delayMillis;
                    final /* synthetic */ AbstractJdwpProcess $jdwpProcess;
                    final /* synthetic */ AbstractJdwpProcessMap this$0;
                    {
                        this.$delayMillis = $delayMillis;
                        this.$jdwpProcess = $jdwpProcess;
                        this.this$0 = $receiver;
                        super(2, $completion);
                    }

                    /*
                     * Unable to fully structure code
                     */
                    public final Object invokeSuspend(Object var1_1) {
                        var17_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                        switch (this.label) {
                            case 0: {
                                ResultKt.throwOnFailure((Object)var1_1);
                                $this$launch = (CoroutineScope)this.L$0;
                                this.L$0 = $this$launch;
                                this.label = 1;
                                v0 = TimeoutKt.withTimeoutOrNull((long)this.$delayMillis, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this.$jdwpProcess, null){
                                    int label;
                                    final /* synthetic */ AbstractJdwpProcess $jdwpProcess;
                                    {
                                        this.$jdwpProcess = $jdwpProcess;
                                        super(2, $completion);
                                    }

                                    /*
                                     * WARNING - void declaration
                                     * Enabled force condition propagation
                                     * Lifted jumps to return sites
                                     */
                                    public final Object invokeSuspend(Object object) {
                                        Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                        switch (this.label) {
                                            case 0: {
                                                ResultKt.throwOnFailure((Object)object);
                                                this.label = 1;
                                                Object object3 = this.$jdwpProcess.awaitReadyToClose((Continuation<? super Unit>)((Continuation)this));
                                                if (object3 != object2) return Unit.INSTANCE;
                                                return object2;
                                            }
                                            case 1: {
                                                void $result;
                                                ResultKt.throwOnFailure((Object)$result);
                                                Object object3 = $result;
                                                return Unit.INSTANCE;
                                            }
                                        }
                                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                    }

                                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                                        return (Continuation)new /* invalid duplicate definition of identical inner class */;
                                    }

                                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                                    }
                                }), (Continuation)((Continuation)this));
                                if (v0 == var17_2) {
                                    return var17_2;
                                }
                                ** GOTO lbl16
                            }
                            case 1: {
                                $this$launch = (CoroutineScope)this.L$0;
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl16:
                                // 2 sources

                                if ((Unit)v0 == null) {
                                    var3_4 = $this$launch;
                                    var4_5 = this.this$0;
                                    var5_6 = this.$delayMillis;
                                    $i$a$-run-JdwpProcessManagerImpl$AbstractJdwpProcessMap$closeJdwpProcess$1$2 = false;
                                    this_$iv = AbstractJdwpProcessMap.access$getLogger$p(var4_5);
                                    $i$f$info = false;
                                    var10_10 = this_$iv;
                                    level$iv$iv = AdbLogger.Level.INFO;
                                    $i$f$logIf = false;
                                    if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
                                        var13_13 = level$iv$iv;
                                        var14_14 = this_$iv$iv;
                                        $i$a$-info-JdwpProcessManagerImpl$AbstractJdwpProcessMap$closeJdwpProcess$1$2$1 = false;
                                        var16_16 = "JDWP process was not ready to close within " + var5_6 + " milliseconds";
                                        var14_14.log(var13_13, var16_16);
                                    }
                                }
                                return Unit.INSTANCE;
                            }
                        }
                        throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                    }

                    public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                        var var3_3 = new /* invalid duplicate definition of identical inner class */;
                        var3_3.L$0 = value;
                        return (Continuation)var3_3;
                    }

                    public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                        return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                    }
                }), (int)3, null).invokeOnCompletion(arg_0 -> AbstractJdwpProcessMap.closeJdwpProcess$lambda$11(jdwpProcess, arg_0));
            } else {
                jdwpProcess.close();
            }
        }

        private static final Unit closeJdwpProcess$lambda$11(AbstractJdwpProcess $jdwpProcess, Throwable it) {
            $jdwpProcess.close();
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ AdbLogger access$getLogger$p(AbstractJdwpProcessMap $this) {
            return $this.logger;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001.B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ\u000e\u0010\u001f\u001a\u00020\u0001H\u0096@\u00a2\u0006\u0002\u0010 J=\u0010!\u001a\u0002H\"\"\u0004\b\u0000\u0010\"2'\u0010#\u001a#\b\u0001\u0012\u0004\u0012\u00020%\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\"0&\u0012\u0006\u0012\u0004\u0018\u00010'0$\u00a2\u0006\u0002\b(H\u0096@\u00a2\u0006\u0002\u0010)J\u000e\u0010*\u001a\u00020+H\u0096@\u00a2\u0006\u0002\u0010 J\b\u0010,\u001a\u00020+H\u0016J\b\u0010-\u001a\u00020\u0010H\u0016R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00060\u00168VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0019\u001a\u00020\u001aX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00010\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006/"}, d2={"Lcom/android/adblib/tools/debugging/impl/JdwpProcessManagerImpl$JdwpProcessDelegate;", "Lcom/android/adblib/tools/debugging/impl/AbstractJdwpProcess;", "Lcom/android/adblib/tools/debugging/impl/AbstractJdwpProcessDelegateProvider;", "device", "Lcom/android/adblib/ConnectedDevice;", "pid", "", "delegateSession", "Lcom/android/adblib/AdbSession;", "<init>", "(Lcom/android/adblib/ConnectedDevice;ILcom/android/adblib/AdbSession;)V", "getDevice", "()Lcom/android/adblib/ConnectedDevice;", "getPid", "()I", "processDescription", "", "logger", "Lcom/android/adblib/AdbLogger;", "withJdwpSessionTracker", "Lcom/android/adblib/tools/debugging/impl/BlockActivationTracker;", "jdwpSessionActivationCount", "Lkotlinx/coroutines/flow/StateFlow;", "getJdwpSessionActivationCount", "()Lkotlinx/coroutines/flow/StateFlow;", "cache", "Lcom/android/adblib/CoroutineScopeCache;", "getCache", "()Lcom/android/adblib/CoroutineScopeCache;", "deferredDelegateProcess", "Lkotlinx/coroutines/Deferred;", "abstractJdwpProcess", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "withJdwpSession", "T", "block", "Lkotlin/Function2;", "Lcom/android/adblib/tools/debugging/SharedJdwpSession;", "Lkotlin/coroutines/Continuation;", "", "Lkotlin/ExtensionFunctionType;", "(Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "awaitReadyToClose", "", "close", "toString", "SharedJdwpSessionDelegate", "android.sdktools.adblib.tools"})
    @SourceDebugExtension(value={"SMAP\nJdwpProcessManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdwpProcessManagerImpl.kt\ncom/android/adblib/tools/debugging/impl/JdwpProcessManagerImpl$JdwpProcessDelegate\n+ 2 AdbLogger.kt\ncom/android/adblib/AdbLoggerKt\n+ 3 AdbLogger.kt\ncom/android/adblib/AdbLogger\n*L\n1#1,507:1\n134#2:508\n127#2:509\n120#2:510\n46#3:511\n26#3,4:512\n47#3:516\n46#3:517\n26#3,4:518\n47#3:522\n*S KotlinDebug\n*F\n+ 1 JdwpProcessManagerImpl.kt\ncom/android/adblib/tools/debugging/impl/JdwpProcessManagerImpl$JdwpProcessDelegate\n*L\n437#1:508\n437#1:509\n437#1:510\n484#1:511\n484#1:512,4\n484#1:516\n488#1:517\n488#1:518,4\n488#1:522\n*E\n"})
    private static final class JdwpProcessDelegate
    extends AbstractJdwpProcess
    implements AbstractJdwpProcessDelegateProvider {
        @NotNull
        private final ConnectedDevice device;
        private final int pid;
        @NotNull
        private final AdbSession delegateSession;
        @NotNull
        private final String processDescription;
        @NotNull
        private final AdbLogger logger;
        @NotNull
        private final BlockActivationTracker withJdwpSessionTracker;
        @NotNull
        private final CoroutineScopeCache cache;
        @NotNull
        private final Deferred<AbstractJdwpProcess> deferredDelegateProcess;

        /*
         * WARNING - void declaration
         */
        public JdwpProcessDelegate(@NotNull ConnectedDevice device2, int pid, @NotNull AdbSession delegateSession) {
            void $this$adbLogger$iv$iv;
            void $this$adbLogger$iv;
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            Intrinsics.checkNotNullParameter((Object)delegateSession, (String)"delegateSession");
            this.device = device2;
            this.pid = pid;
            this.delegateSession = delegateSession;
            this.processDescription = this.getDevice().getSession() + " - " + this.getDevice() + " - pid=" + this.getPid();
            JdwpProcessDelegate jdwpProcessDelegate = this;
            AdbSession session$iv = this.getDevice().getSession();
            boolean $i$f$adbLogger = false;
            void var7_7 = $this$adbLogger$iv;
            AdbSessionHost host$iv$iv = session$iv.getHost();
            boolean $i$f$adbLogger2 = false;
            void var10_10 = $this$adbLogger$iv$iv;
            AdbLoggerFactory loggerFactory$iv$iv$iv = host$iv$iv.getLoggerFactory();
            boolean $i$f$adbLogger3 = false;
            this.logger = AdbLoggerKt.withPrefix(loggerFactory$iv$iv$iv.createLogger(JdwpProcessDelegate.class), this.processDescription + " - ");
            this.withJdwpSessionTracker = new BlockActivationTracker();
            this.cache = CoroutineScopeCache.Companion.create(ConnectedDeviceKt.getScope(this.getDevice()), this.processDescription);
            this.deferredDelegateProcess = BuildersKt.async$default((CoroutineScope)this.getCache().getScope(), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super AbstractJdwpProcess>, Object>(this, null){
                int label;
                final /* synthetic */ JdwpProcessDelegate this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this.label = 1;
                            v0 = ConnectedDevicesTrackerKt.waitForDevice(AdbSessionKt.getConnectedDevicesTracker(JdwpProcessDelegate.access$getDelegateSession$p(this.this$0)), ConnectedDeviceKt.getSerialNumber(this.this$0.getDevice()), (Continuation<? super ConnectedDevice>)((Continuation)this));
                            if (v0 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl13
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl13:
                            // 2 sources

                            delegateDevice = (ConnectedDevice)v0;
                            this.label = 2;
                            v1 = JdwpProcessManagerKt.getJdwpProcessManagerImpl(delegateDevice).waitForProcess(this.this$0.getPid(), (Continuation<? super AbstractJdwpProcess>)((Continuation)this));
                            if (v1 == var3_2) {
                                return var3_2;
                            }
                            ** GOTO lbl22
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
lbl22:
                            // 2 sources

                            return v1;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super AbstractJdwpProcess> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        @Override
        @NotNull
        public ConnectedDevice getDevice() {
            return this.device;
        }

        @Override
        public int getPid() {
            return this.pid;
        }

        @Override
        @NotNull
        public StateFlow<Integer> getJdwpSessionActivationCount() {
            return this.withJdwpSessionTracker.getActivationCount();
        }

        @Override
        @NotNull
        public CoroutineScopeCache getCache() {
            return this.cache;
        }

        @Override
        @Nullable
        public Object abstractJdwpProcess(@NotNull Continuation<? super AbstractJdwpProcess> $completion) {
            return this.deferredDelegateProcess.await($completion);
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public <T> Object withJdwpSession(@NotNull Function2<? super SharedJdwpSession, ? super Continuation<? super T>, ? extends Object> var1_1, @NotNull Continuation<? super T> $completion) {
            if (!($completion instanceof withJdwpSession.1)) ** GOTO lbl-1000
            var4_3 = $completion;
            if ((var4_3.label & -2147483648) != 0) {
                var4_3.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    Object L$0;
                    /* synthetic */ Object result;
                    final /* synthetic */ JdwpProcessDelegate this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.withJdwpSession(null, (Continuation)this);
                    }
                };
            }
            $result = $continuation.result;
            var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.L$0 = block;
                    $continuation.label = 1;
                    v0 = this.deferredDelegateProcess.await($continuation);
                    if (v0 == var5_5) {
                        return var5_5;
                    }
                    ** GOTO lbl22
                }
                case 1: {
                    block = (Function2)$continuation.L$0;
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl22:
                    // 2 sources

                    $continuation.L$0 = null;
                    $continuation.label = 2;
                    v1 = ((AbstractJdwpProcess)v0).withJdwpSession((Function2)new Function2<SharedJdwpSession, Continuation<? super T>, Object>(this, block, null){
                        int label;
                        private /* synthetic */ Object L$0;
                        final /* synthetic */ JdwpProcessDelegate this$0;
                        final /* synthetic */ Function2<SharedJdwpSession, Continuation<? super T>, Object> $block;
                        {
                            this.this$0 = $receiver;
                            this.$block = $block;
                            super(2, $completion);
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object var1_1) {
                            var17_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)var1_1);
                                    $this$withJdwpSession = (SharedJdwpSession)this.L$0;
                                    this_$iv = JdwpProcessDelegate.access$getLogger$p(this.this$0);
                                    $i$f$debug = false;
                                    var5_7 = this_$iv;
                                    level$iv$iv = AdbLogger.Level.DEBUG;
                                    $i$f$logIf = false;
                                    if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
                                        var15_13 = level$iv$iv;
                                        var14_14 = this_$iv$iv;
                                        $i$a$-debug-JdwpProcessManagerImpl$JdwpProcessDelegate$withJdwpSession$2$1 = false;
                                        var16_18 = "Acquired delegate process JDWP session, calling 'block'";
                                        var14_14.log(var15_13, var16_18);
                                    }
                                    this_$iv = JdwpProcessDelegate.access$getWithJdwpSessionTracker$p(this.this$0);
                                    var4_6 = this.$block;
                                    $i$f$track = false;
                                    $this$update$iv$iv = BlockActivationTracker.access$getActivationCountStateFlow$p((BlockActivationTracker)this_$iv);
                                    $i$f$update = false;
                                    do {
                                        prevValue$iv$iv = $this$update$iv$iv.getValue();
                                        it$iv = ((Number)prevValue$iv$iv).intValue();
                                        $i$a$-update-BlockActivationTracker$track$1$iv = false;
                                    } while (!$this$update$iv$iv.compareAndSet(prevValue$iv$iv, (Object)(nextValue$iv$iv = Boxing.boxInt((int)(it$iv + 1)))));
                                    $i$a$-track-JdwpProcessManagerImpl$JdwpProcessDelegate$withJdwpSession$2$2 = false;
                                    this.L$0 = this_$iv;
                                    this.label = 1;
                                    v0 = var4_6.invoke((Object)new SharedJdwpSessionDelegate($this$withJdwpSession.getDevice(), $this$withJdwpSession), (Object)this);
                                    ** if (v0 != var17_2) goto lbl39
lbl38:
                                    // 1 sources

                                    return var17_2;
lbl39:
                                    // 1 sources

                                    ** GOTO lbl49
                                }
                                case 1: {
                                    $i$f$track = false;
                                    $i$a$-track-JdwpProcessManagerImpl$JdwpProcessDelegate$withJdwpSession$2$2 = false;
                                    this_$iv = (BlockActivationTracker)this.L$0;
                                    try {
                                        ResultKt.throwOnFailure((Object)$result);
                                        v0 = $result;
lbl49:
                                        // 2 sources

                                        var6_9 = v0;
                                    }
                                    catch (Throwable var7_12) {
                                        throw var7_12;
                                    }
                                    finally {
                                        $this$update$iv$iv = BlockActivationTracker.access$getActivationCountStateFlow$p((BlockActivationTracker)this_$iv);
                                        $i$f$update = false;
                                        do {
                                            prevValue$iv$iv = $this$update$iv$iv.getValue();
                                            it$iv = ((Number)prevValue$iv$iv).intValue();
                                            $i$a$-update-BlockActivationTracker$track$2$iv = false;
                                        } while (!$this$update$iv$iv.compareAndSet(prevValue$iv$iv, (Object)(nextValue$iv$iv = Boxing.boxInt((int)(it$iv - 1)))));
                                    }
                                    return var6_9;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            var var3_3 = new /* invalid duplicate definition of identical inner class */;
                            var3_3.L$0 = value;
                            return (Continuation)var3_3;
                        }

                        public final Object invoke(SharedJdwpSession p1, Continuation<? super T> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }, $continuation);
                    if (v1 == var5_5) {
                        return var5_5;
                    }
                    ** GOTO lbl31
                }
                case 2: {
                    ResultKt.throwOnFailure((Object)$result);
                    v1 = $result;
lbl31:
                    // 2 sources

                    return v1;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * Unable to fully structure code
         */
        @Override
        @Nullable
        public Object awaitReadyToClose(@NotNull Continuation<? super Unit> $completion) {
            if (!($completion instanceof awaitReadyToClose.1)) ** GOTO lbl-1000
            var12_2 = $completion;
            if ((var12_2.label & -2147483648) != 0) {
                var12_2.label -= -2147483648;
            } else lbl-1000:
            // 2 sources

            {
                $continuation = new ContinuationImpl(this, $completion){
                    /* synthetic */ Object result;
                    final /* synthetic */ JdwpProcessDelegate this$0;
                    int label;
                    {
                        this.this$0 = this$0;
                        super($completion);
                    }

                    @Nullable
                    public final Object invokeSuspend(@NotNull Object $result) {
                        this.result = $result;
                        this.label |= Integer.MIN_VALUE;
                        return this.this$0.awaitReadyToClose((Continuation<? super Unit>)((Continuation)this));
                    }
                };
            }
            $result = $continuation.result;
            var13_4 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
            switch ($continuation.label) {
                case 0: {
                    ResultKt.throwOnFailure((Object)$result);
                    $continuation.label = 1;
                    v0 = this.withJdwpSessionTracker.waitWhileActive((Continuation<? super Unit>)$continuation);
                    if (v0 == var13_4) {
                        return var13_4;
                    }
                    ** GOTO lbl20
                }
                case 1: {
                    ResultKt.throwOnFailure((Object)$result);
                    v0 = $result;
lbl20:
                    // 2 sources

                    this_$iv = this.logger;
                    $i$f$debug = false;
                    var4_7 = this_$iv;
                    level$iv$iv = AdbLogger.Level.DEBUG;
                    $i$f$logIf = false;
                    if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
                        var9_10 = level$iv$iv;
                        var8_11 = this_$iv$iv;
                        $i$a$-debug-JdwpProcessManagerImpl$JdwpProcessDelegate$awaitReadyToClose$2 = false;
                        var10_13 = "Ready to close";
                        var8_11.log(var9_10, var10_13);
                    }
                    return Unit.INSTANCE;
                }
            }
            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void close() {
            void this_$iv$iv;
            AdbLogger this_$iv = this.logger;
            boolean $i$f$debug = false;
            AdbLogger adbLogger = this_$iv;
            AdbLogger.Level level$iv$iv = AdbLogger.Level.DEBUG;
            boolean $i$f$logIf = false;
            if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
                AdbLogger.Level level = level$iv$iv;
                void var7_7 = this_$iv$iv;
                boolean bl = false;
                String string2 = "close()";
                var7_7.log(level, string2);
            }
            this.getCache().close();
            Job.DefaultImpls.cancel$default((Job)((Job)this.deferredDelegateProcess), null, (int)1, null);
        }

        @NotNull
        public String toString() {
            return Reflection.getOrCreateKotlinClass(this.getClass()).getSimpleName() + "(session=" + this.getDevice().getSession() + ", device=" + this.getDevice() + ", pid=" + this.getPid() + ")";
        }

        public static final /* synthetic */ AdbLogger access$getLogger$p(JdwpProcessDelegate $this) {
            return $this.logger;
        }

        public static final /* synthetic */ BlockActivationTracker access$getWithJdwpSessionTracker$p(JdwpProcessDelegate $this) {
            return $this.withJdwpSessionTracker;
        }

        public static final /* synthetic */ AdbSession access$getDelegateSession$p(JdwpProcessDelegate $this) {
            return $this.delegateSession;
        }

        @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0001\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0016\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096A\u00a2\u0006\u0002\u0010\rJ\u000e\u0010\u000e\u001a\u00020\u000fH\u0096A\u00a2\u0006\u0002\u0010\u0010J\t\u0010\u0011\u001a\u00020\u0012H\u0096\u0001J\u0016\u0010\u0013\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0096A\u00a2\u0006\u0002\u0010\rR\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0014\u001a\u00020\u0012X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/adblib/tools/debugging/impl/JdwpProcessManagerImpl$JdwpProcessDelegate$SharedJdwpSessionDelegate;", "Lcom/android/adblib/tools/debugging/SharedJdwpSession;", "device", "Lcom/android/adblib/ConnectedDevice;", "delegateJdwpSession", "<init>", "(Lcom/android/adblib/ConnectedDevice;Lcom/android/adblib/tools/debugging/SharedJdwpSession;)V", "getDevice", "()Lcom/android/adblib/ConnectedDevice;", "addReplayPacket", "", "packet", "Lcom/android/adblib/tools/debugging/packets/JdwpPacketView;", "(Lcom/android/adblib/tools/debugging/packets/JdwpPacketView;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "newPacketReceiver", "Lcom/android/adblib/tools/debugging/JdwpPacketReceiver;", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "nextPacketId", "", "sendPacket", "pid", "getPid", "()I", "android.sdktools.adblib.tools"})
        private static final class SharedJdwpSessionDelegate
        implements SharedJdwpSession {
            @NotNull
            private final ConnectedDevice device;
            @NotNull
            private final SharedJdwpSession delegateJdwpSession;

            public SharedJdwpSessionDelegate(@NotNull ConnectedDevice device2, @NotNull SharedJdwpSession delegateJdwpSession) {
                Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
                Intrinsics.checkNotNullParameter((Object)delegateJdwpSession, (String)"delegateJdwpSession");
                this.device = device2;
                this.delegateJdwpSession = delegateJdwpSession;
            }

            @Override
            @NotNull
            public ConnectedDevice getDevice() {
                return this.device;
            }

            @Override
            public int getPid() {
                return this.delegateJdwpSession.getPid();
            }

            @Override
            @Nullable
            public Object sendPacket(@NotNull JdwpPacketView packet, @NotNull Continuation<? super Unit> $completion) {
                return this.delegateJdwpSession.sendPacket(packet, $completion);
            }

            @Override
            @Nullable
            public Object newPacketReceiver(@NotNull Continuation<? super JdwpPacketReceiver> $completion) {
                return this.delegateJdwpSession.newPacketReceiver($completion);
            }

            @Override
            public int nextPacketId() {
                return this.delegateJdwpSession.nextPacketId();
            }

            @Override
            @Nullable
            public Object addReplayPacket(@NotNull JdwpPacketView packet, @NotNull Continuation<? super Unit> $completion) {
                return this.delegateJdwpSession.addReplayPacket(packet, $completion);
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0015\u001a\u00020\u0016H\u0082@\u00a2\u0006\u0002\u0010\u0017R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000b\u001a\u00020\f8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000eR\u0019\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00128F\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0018"}, d2={"Lcom/android/adblib/tools/debugging/impl/JdwpProcessManagerImpl$JdwpProcessIdTracker;", "", "device", "Lcom/android/adblib/ConnectedDevice;", "<init>", "(Lcom/android/adblib/ConnectedDevice;)V", "logger", "Lcom/android/adblib/AdbLogger;", "mutableFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/android/adblib/tools/debugging/JdwpProcessIdList;", "trackingJob", "Lkotlinx/coroutines/Job;", "getTrackingJob", "()Lkotlinx/coroutines/Job;", "trackingJob$delegate", "Lkotlin/Lazy;", "processIdsStateFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getProcessIdsStateFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "trackProcesses", "", "(Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "android.sdktools.adblib.tools"})
    @SourceDebugExtension(value={"SMAP\nJdwpProcessManagerImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JdwpProcessManagerImpl.kt\ncom/android/adblib/tools/debugging/impl/JdwpProcessManagerImpl$JdwpProcessIdTracker\n+ 2 AdbLogger.kt\ncom/android/adblib/AdbLoggerKt\n+ 3 AdbLogger.kt\ncom/android/adblib/AdbLogger\n*L\n1#1,507:1\n134#2:508\n127#2:509\n120#2:510\n46#3:511\n26#3,4:512\n47#3:516\n*S KotlinDebug\n*F\n+ 1 JdwpProcessManagerImpl.kt\ncom/android/adblib/tools/debugging/impl/JdwpProcessManagerImpl$JdwpProcessIdTracker\n*L\n250#1:508\n250#1:509\n250#1:510\n306#1:511\n306#1:512,4\n306#1:516\n*E\n"})
    private static final class JdwpProcessIdTracker {
        @NotNull
        private final ConnectedDevice device;
        @NotNull
        private final AdbLogger logger;
        @NotNull
        private final MutableStateFlow<JdwpProcessIdList> mutableFlow;
        @NotNull
        private final Lazy trackingJob$delegate;
        @NotNull
        private final StateFlow<JdwpProcessIdList> processIdsStateFlow;

        /*
         * WARNING - void declaration
         */
        public JdwpProcessIdTracker(@NotNull ConnectedDevice device2) {
            void $this$adbLogger$iv$iv;
            void $this$adbLogger$iv;
            Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
            this.device = device2;
            JdwpProcessIdTracker jdwpProcessIdTracker = this;
            AdbSession session$iv = this.device.getSession();
            boolean $i$f$adbLogger = false;
            void var5_5 = $this$adbLogger$iv;
            AdbSessionHost host$iv$iv = session$iv.getHost();
            boolean $i$f$adbLogger2 = false;
            void var8_8 = $this$adbLogger$iv$iv;
            AdbLoggerFactory loggerFactory$iv$iv$iv = host$iv$iv.getLoggerFactory();
            boolean $i$f$adbLogger3 = false;
            this.logger = ConnectedDeviceKt.withDevicePrefix(loggerFactory$iv$iv$iv.createLogger(JdwpProcessIdTracker.class), this.device);
            this.mutableFlow = StateFlowKt.MutableStateFlow((Object)new JdwpProcessIdList(AdbDeviceServicesKt.emptyProcessIdList(), StateFlowStatus.Companion.getStartOfFlow()));
            this.trackingJob$delegate = LazyKt.lazy((LazyThreadSafetyMode)LazyThreadSafetyMode.SYNCHRONIZED, () -> JdwpProcessIdTracker.trackingJob_delegate$lambda$0(this));
            this.processIdsStateFlow = FlowKt.asStateFlow(this.mutableFlow);
        }

        private final Job getTrackingJob() {
            Lazy lazy = this.trackingJob$delegate;
            return (Job)lazy.getValue();
        }

        @NotNull
        public final StateFlow<JdwpProcessIdList> getProcessIdsStateFlow() {
            this.getTrackingJob();
            return this.processIdsStateFlow;
        }

        private final Object trackProcesses(Continuation<? super Unit> $completion) {
            Object object = ConnectedDeviceKt.withScopeContext(this.device, (Function2<? super CoroutineScope, ? super Continuation<? super Unit>, ? extends Object>)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ JdwpProcessIdTracker this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var11_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            this_$iv = JdwpProcessIdTracker.access$getLogger$p(this.this$0);
                            $i$f$debug = false;
                            var4_5 = this_$iv;
                            level$iv$iv = AdbLogger.Level.DEBUG;
                            $i$f$logIf = false;
                            if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
                                var9_10 = level$iv$iv;
                                var8_11 = this_$iv$iv;
                                $i$a$-debug-JdwpProcessManagerImpl$JdwpProcessIdTracker$trackProcesses$2$1 = false;
                                var10_13 = "Starting process ID tracking";
                                var8_11.log(var9_10, var10_13);
                            }
                            this.label = 1;
                            v0 = TrackAppKt.isTrackAppSupported(JdwpProcessIdTracker.access$getDevice$p(this.this$0), (Continuation<? super Boolean>)((Continuation)this));
                            if (v0 == var11_2) {
                                return var11_2;
                            }
                            ** GOTO lbl26
                        }
                        case 1: {
                            ResultKt.throwOnFailure((Object)$result);
                            v0 = $result;
lbl26:
                            // 2 sources

                            if (!((Boolean)v0).booleanValue()) break;
                            $this$filter$iv = (Flow)TrackAppKt.getTrackApp(JdwpProcessIdTracker.access$getDevice$p(this.this$0)).getStateFlow();
                            $i$f$filter = false;
                            $this$unsafeTransform$iv$iv = $this$filter$iv;
                            $i$f$unsafeTransform = false;
                            $i$f$unsafeFlow = false;
                            this.label = 2;
                            v1 = ((Flow)new Flow<AppProcessEntryList>($this$unsafeTransform$iv$iv){
                                final /* synthetic */ Flow $this_unsafeTransform$inlined;
                                {
                                    this.$this_unsafeTransform$inlined = flow2;
                                }

                                public Object collect(FlowCollector collector, Continuation $completion) {
                                    Continuation continuation = $completion;
                                    FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                                    boolean bl = false;
                                    Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240){
                                        final /* synthetic */ FlowCollector $this_unsafeFlow;
                                        {
                                            this.$this_unsafeFlow = $receiver;
                                        }

                                        /*
                                         * Unable to fully structure code
                                         */
                                        public final Object emit(Object var1_1, Continuation $completion) {
                                            if (!($completion instanceof JdwpProcessIdTracker$trackProcesses$2$invokeSuspend$$inlined$filter$1$2$1)) ** GOTO lbl-1000
                                            var3_3 = $completion;
                                            if ((var3_3.label & -2147483648) != 0) {
                                                var3_3.label -= -2147483648;
                                            } else lbl-1000:
                                            // 2 sources

                                            {
                                                $continuation = new ContinuationImpl(this, $completion){
                                                    /* synthetic */ Object result;
                                                    int label;
                                                    Object L$0;
                                                    Object L$1;
                                                    final /* synthetic */ JdwpProcessIdTracker$trackProcesses$2$invokeSuspend$$inlined$filter$1$2 this$0;
                                                    {
                                                        this.this$0 = this$0;
                                                        super($completion);
                                                    }

                                                    public final Object invokeSuspend(Object $result) {
                                                        this.result = $result;
                                                        this.label |= Integer.MIN_VALUE;
                                                        return this.this$0.emit(null, (Continuation)this);
                                                    }
                                                };
                                            }
                                            $result = $continuation.result;
                                            var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                            switch ($continuation.label) {
                                                case 0: {
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    var6_6 = value;
                                                    $this$filter_u24lambda_u240 = this.$this_unsafeFlow;
                                                    $i$a$-unsafeTransform-FlowKt__TransformKt$filter$1 = false;
                                                    (Continuation)$continuation;
                                                    appProcessEntryList = (AppProcessEntryList)value;
                                                    $i$a$-filter-JdwpProcessManagerImpl$JdwpProcessIdTracker$trackProcesses$2$2 = false;
                                                    if (!(appProcessEntryList.getFlowStatus().isStartOfFlow() == false)) break;
                                                    $continuation.label = 1;
                                                    v0 = $this$filter_u24lambda_u240.emit((Object)value, (Continuation)$continuation);
                                                    if (v0 == var5_5) {
                                                        return var5_5;
                                                    }
                                                    break;
                                                }
                                                case 1: {
                                                    $i$a$-unsafeTransform-FlowKt__TransformKt$filter$1 = false;
                                                    ResultKt.throwOnFailure((Object)$result);
                                                    v0 = $result;
                                                    break;
                                                }
                                            }
                                            return Unit.INSTANCE;
                                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                        }
                                    }, $completion);
                                    if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                        return object;
                                    }
                                    return Unit.INSTANCE;
                                }
                            }).collect(new FlowCollector(this.this$0){
                                final /* synthetic */ JdwpProcessIdTracker this$0;
                                {
                                    this.this$0 = $receiver;
                                }

                                /*
                                 * WARNING - void declaration
                                 */
                                public final Object emit(AppProcessEntryList appProcessEntryList, Continuation<? super Unit> $completion) {
                                    void this_$iv$iv;
                                    Collection collection;
                                    AdbLogger $this$mapTo$iv$iv;
                                    void $this$map$iv;
                                    AppProcessEntry it;
                                    void $this$filterTo$iv$iv;
                                    Iterable $this$filter$iv;
                                    Iterable iterable = appProcessEntryList;
                                    boolean $i$f$filter = false;
                                    void var6_5 = $this$filter$iv;
                                    Collection destination$iv$iv = new ArrayList<E>();
                                    boolean $i$f$filterTo = false;
                                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                                        it = (AppProcessEntry)element$iv$iv;
                                        boolean bl = false;
                                        if (!it.getDebuggable()) continue;
                                        destination$iv$iv.add(element$iv$iv);
                                    }
                                    $this$filter$iv = (List)destination$iv$iv;
                                    boolean $i$f$map = false;
                                    $this$filterTo$iv$iv = $this$map$iv;
                                    destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                                    boolean $i$f$mapTo = false;
                                    Iterator<T> iterator = $this$mapTo$iv$iv.iterator();
                                    while (iterator.hasNext()) {
                                        T item$iv$iv = iterator.next();
                                        it = (AppProcessEntry)item$iv$iv;
                                        collection = destination$iv$iv;
                                        boolean bl = false;
                                        collection.add(Boxing.boxInt((int)it.getPid()));
                                    }
                                    List processIds2 = (List)destination$iv$iv;
                                    AdbLogger this_$iv = JdwpProcessIdTracker.access$getLogger$p(this.this$0);
                                    boolean $i$f$verbose = false;
                                    $this$mapTo$iv$iv = this_$iv;
                                    AdbLogger.Level level$iv$iv = AdbLogger.Level.VERBOSE;
                                    boolean $i$f$logIf = false;
                                    if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
                                        AdbLogger.Level level = level$iv$iv;
                                        collection = this_$iv$iv;
                                        boolean bl = false;
                                        String string2 = "Updating (track-app) state flow of process IDS: " + processIds2;
                                        ((AdbLogger)((Object)collection)).log(level, string2);
                                    }
                                    JdwpProcessIdTracker.access$getMutableFlow$p(this.this$0).setValue((Object)new JdwpProcessIdList(new ListWithErrors<Integer>(processIds2, CollectionsKt.emptyList()), appProcessEntryList.getFlowStatus()));
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            if (v1 == var11_2) {
                                return var11_2;
                            }
                            ** GOTO lbl58
                        }
                        case 2: {
                            ResultKt.throwOnFailure((Object)$result);
                            v1 = $result;
                            ** GOTO lbl58
                        }
                    }
                    $this$filter$iv = (Flow)TrackJdwpKt.getTrackJdwp(JdwpProcessIdTracker.access$getDevice$p(this.this$0)).getStateFlow();
                    $i$f$filter = false;
                    $this$unsafeTransform$iv$iv = $this$filter$iv;
                    $i$f$unsafeTransform = false;
                    $i$f$unsafeFlow = false;
                    this.label = 3;
                    v2 = ((Flow)new Flow<JdwpProcessIdList>($this$unsafeTransform$iv$iv){
                        final /* synthetic */ Flow $this_unsafeTransform$inlined;
                        {
                            this.$this_unsafeTransform$inlined = flow2;
                        }

                        public Object collect(FlowCollector collector, Continuation $completion) {
                            Continuation continuation = $completion;
                            FlowCollector $this$unsafeTransform_u24lambda_u240 = collector;
                            boolean bl = false;
                            Object object = this.$this_unsafeTransform$inlined.collect(new FlowCollector($this$unsafeTransform_u24lambda_u240){
                                final /* synthetic */ FlowCollector $this_unsafeFlow;
                                {
                                    this.$this_unsafeFlow = $receiver;
                                }

                                /*
                                 * Unable to fully structure code
                                 */
                                public final Object emit(Object var1_1, Continuation $completion) {
                                    if (!($completion instanceof JdwpProcessIdTracker$trackProcesses$2$invokeSuspend$$inlined$filter$2$2$1)) ** GOTO lbl-1000
                                    var3_3 = $completion;
                                    if ((var3_3.label & -2147483648) != 0) {
                                        var3_3.label -= -2147483648;
                                    } else lbl-1000:
                                    // 2 sources

                                    {
                                        $continuation = new ContinuationImpl(this, $completion){
                                            /* synthetic */ Object result;
                                            int label;
                                            Object L$0;
                                            Object L$1;
                                            final /* synthetic */ JdwpProcessIdTracker$trackProcesses$2$invokeSuspend$$inlined$filter$2$2 this$0;
                                            {
                                                this.this$0 = this$0;
                                                super($completion);
                                            }

                                            public final Object invokeSuspend(Object $result) {
                                                this.result = $result;
                                                this.label |= Integer.MIN_VALUE;
                                                return this.this$0.emit(null, (Continuation)this);
                                            }
                                        };
                                    }
                                    $result = $continuation.result;
                                    var5_5 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch ($continuation.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            var6_6 = value;
                                            $this$filter_u24lambda_u240 = this.$this_unsafeFlow;
                                            $i$a$-unsafeTransform-FlowKt__TransformKt$filter$1 = false;
                                            (Continuation)$continuation;
                                            processIds = (JdwpProcessIdList)value;
                                            $i$a$-filter-JdwpProcessManagerImpl$JdwpProcessIdTracker$trackProcesses$2$4 = false;
                                            if (!(processIds.getFlowStatus().isStartOfFlow() == false)) break;
                                            $continuation.label = 1;
                                            v0 = $this$filter_u24lambda_u240.emit((Object)value, (Continuation)$continuation);
                                            if (v0 == var5_5) {
                                                return var5_5;
                                            }
                                            break;
                                        }
                                        case 1: {
                                            $i$a$-unsafeTransform-FlowKt__TransformKt$filter$1 = false;
                                            ResultKt.throwOnFailure((Object)$result);
                                            v0 = $result;
                                            break;
                                        }
                                    }
                                    return Unit.INSTANCE;
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }
                            }, $completion);
                            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                                return object;
                            }
                            return Unit.INSTANCE;
                        }
                    }).collect(new FlowCollector(this.this$0){
                        final /* synthetic */ JdwpProcessIdTracker this$0;
                        {
                            this.this$0 = $receiver;
                        }

                        /*
                         * WARNING - void declaration
                         */
                        public final Object emit(JdwpProcessIdList processIds2, Continuation<? super Unit> $completion) {
                            void this_$iv$iv;
                            AdbLogger this_$iv = JdwpProcessIdTracker.access$getLogger$p(this.this$0);
                            boolean $i$f$verbose = false;
                            AdbLogger adbLogger = this_$iv;
                            AdbLogger.Level level$iv$iv = AdbLogger.Level.VERBOSE;
                            boolean $i$f$logIf = false;
                            if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
                                AdbLogger.Level level = level$iv$iv;
                                void var9_9 = this_$iv$iv;
                                boolean bl = false;
                                String string2 = "Updating (track-jdwp) state flow of process IDS: " + processIds2;
                                var9_9.log(level, string2);
                            }
                            JdwpProcessIdTracker.access$getMutableFlow$p(this.this$0).setValue((Object)processIds2);
                            return Unit.INSTANCE;
                        }
                    }, (Continuation)this);
                    if (v2 == var11_2) {
                        return var11_2;
                    }
                    ** GOTO lbl58
                    {
                        case 3: {
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl58:
                            // 4 sources

                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })).withRetry((Function2<? super Throwable, ? super Continuation<? super Boolean>, ? extends Object>)((Function2)new Function2<Throwable, Continuation<? super Boolean>, Object>(this, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ JdwpProcessIdTracker this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            Throwable throwable = (Throwable)this.L$0;
                            AdbLoggerUtilsKt.logIOCompletionErrors$default(JdwpProcessIdTracker.access$getLogger$p(this.this$0), throwable, null, 2, null);
                            Duration delay = (Duration)AdbSessionKt.property(JdwpProcessIdTracker.access$getDevice$p(this.this$0).getSession(), AdbLibToolsProperties.INSTANCE.getJDWP_PROCESS_TRACKER_RETRY_DELAY());
                            this.label = 1;
                            Object object3 = DelayKt.delay((long)delay.toMillis(), (Continuation)((Continuation)this));
                            if (object3 != object2) return Boxing.boxBoolean((boolean)true);
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Boxing.boxBoolean((boolean)true);
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(Throwable p1, Continuation<? super Boolean> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            })).withFinally((Function0<Unit>)((Function0)() -> JdwpProcessIdTracker.trackProcesses$lambda$2(this))).execute($completion);
            if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
                return object;
            }
            return Unit.INSTANCE;
        }

        private static final Job trackingJob_delegate$lambda$0(JdwpProcessIdTracker this$0) {
            return BuildersKt.launch$default((CoroutineScope)ConnectedDeviceKt.getScope(this$0.device), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
                int label;
                private /* synthetic */ Object L$0;
                final /* synthetic */ JdwpProcessIdTracker this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 * Could not resolve type clashes
                 */
                public final Object invokeSuspend(Object var1_1) {
                    var8_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            var3_4 /* !! */  = $this$launch = (CoroutineScope)this.L$0;
                            var4_5 = this.this$0;
                            $i$a$-runCatching-JdwpProcessManagerImpl$JdwpProcessIdTracker$trackingJob$2$1$1 = false;
                            this.label = 1;
                            v0 = JdwpProcessIdTracker.access$trackProcesses(var4_5, (Continuation)this);
                            ** if (v0 != var8_2) goto lbl15
lbl14:
                            // 1 sources

                            return var8_2;
lbl15:
                            // 1 sources

                            ** GOTO lbl22
                        }
                        case 1: {
                            $i$a$-runCatching-JdwpProcessManagerImpl$JdwpProcessIdTracker$trackingJob$2$1$1 = false;
                            try {
                                ResultKt.throwOnFailure((Object)$result);
                                v0 = $result;
lbl22:
                                // 2 sources

                                var5_9 = Result.constructor-impl((Object)Unit.INSTANCE);
                            }
                            catch (Throwable $i$a$-runCatching-JdwpProcessManagerImpl$JdwpProcessIdTracker$trackingJob$2$1$1) {
                                var5_9 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)$i$a$-runCatching-JdwpProcessManagerImpl$JdwpProcessIdTracker$trackingJob$2$1$1));
                            }
                            var3_4 /* !! */  = var5_9;
                            var4_5 = this.this$0;
                            v1 = Result.exceptionOrNull-impl((Object)var3_4 /* !! */ );
                            if (v1 != null) {
                                throwable = var5_9 = v1;
                                $i$a$-onFailure-JdwpProcessManagerImpl$JdwpProcessIdTracker$trackingJob$2$1$2 = false;
                                AdbLoggerUtilsKt.logIOCompletionErrors$default(JdwpProcessIdTracker.access$getLogger$p(var4_5), (Throwable)throwable, null, 2, null);
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    var var3_3 = new /* invalid duplicate definition of identical inner class */;
                    var3_3.L$0 = value;
                    return (Continuation)var3_3;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        /*
         * WARNING - void declaration
         */
        private static final Unit trackProcesses$lambda$2(JdwpProcessIdTracker this$0) {
            void this_$iv$iv;
            AdbLogger this_$iv = this$0.logger;
            boolean $i$f$debug = false;
            AdbLogger adbLogger = this_$iv;
            AdbLogger.Level level$iv$iv = AdbLogger.Level.DEBUG;
            boolean $i$f$logIf = false;
            if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
                AdbLogger.Level level = level$iv$iv;
                void var7_7 = this_$iv$iv;
                boolean bl = false;
                String string2 = "Exiting process ID tracking";
                var7_7.log(level, string2);
            }
            return Unit.INSTANCE;
        }

        public static final /* synthetic */ Object access$trackProcesses(JdwpProcessIdTracker $this, Continuation $completion) {
            return $this.trackProcesses((Continuation<? super Unit>)$completion);
        }

        public static final /* synthetic */ AdbLogger access$getLogger$p(JdwpProcessIdTracker $this) {
            return $this.logger;
        }

        public static final /* synthetic */ ConnectedDevice access$getDevice$p(JdwpProcessIdTracker $this) {
            return $this.device;
        }

        public static final /* synthetic */ MutableStateFlow access$getMutableFlow$p(JdwpProcessIdTracker $this) {
            return $this.mutableFlow;
        }
    }
}

