/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.tools.debugging.impl;

import com.android.adblib.AdbLogger;
import com.android.adblib.AdbLoggerFactory;
import com.android.adblib.AdbLoggerKt;
import com.android.adblib.AdbSession;
import com.android.adblib.AdbSessionHost;
import com.android.adblib.AppProcessEntry;
import com.android.adblib.ConnectedDevice;
import com.android.adblib.ConnectedDeviceKt;
import com.android.adblib.CoroutineScopeCache;
import com.android.adblib.InstructionSet;
import com.android.adblib.tools.debugging.AppProcess;
import com.android.adblib.tools.debugging.AppProcessProperties;
import com.android.adblib.tools.debugging.JdwpProcess;
import com.android.adblib.tools.debugging.JdwpProcessProperties;
import com.android.adblib.tools.debugging.OptionalValue;
import com.android.adblib.tools.debugging.OptionalValueKt;
import com.android.adblib.tools.debugging.impl.OptionalValueFactory;
import com.android.adblib.tools.debugging.impl.OptionalValueFactoryKt;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003B!\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b*J\b\u0010+\u001a\u00020(H\u0016J\b\u0010,\u001a\u00020\u0011H\u0016J\f\u0010-\u001a\u00020\u001e*\u00020\u0007H\u0002J\u0014\u0010.\u001a\u00020\u001e*\u00020\u001e2\u0006\u0010)\u001a\u00020\u0007H\u0002R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0016\u0010\b\u001a\u0004\u0018\u00010\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\u0015X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u00198BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001bR\u0014\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\u001e0 X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0014\u0010#\u001a\u00020$X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&\u00a8\u0006/"}, d2={"Lcom/android/adblib/tools/debugging/impl/AppProcessImpl;", "Lcom/android/adblib/tools/debugging/AppProcess;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "device", "Lcom/android/adblib/ConnectedDevice;", "appProcessEntry", "Lcom/android/adblib/AppProcessEntry;", "jdwpProcess", "Lcom/android/adblib/tools/debugging/JdwpProcess;", "<init>", "(Lcom/android/adblib/ConnectedDevice;Lcom/android/adblib/AppProcessEntry;Lcom/android/adblib/tools/debugging/JdwpProcess;)V", "getDevice", "()Lcom/android/adblib/ConnectedDevice;", "getJdwpProcess", "()Lcom/android/adblib/tools/debugging/JdwpProcess;", "processDescription", "", "logger", "Lcom/android/adblib/AdbLogger;", "cache", "Lcom/android/adblib/CoroutineScopeCache;", "getCache", "()Lcom/android/adblib/CoroutineScopeCache;", "optionalValueFactory", "Lcom/android/adblib/tools/debugging/impl/OptionalValueFactory;", "getOptionalValueFactory", "()Lcom/android/adblib/tools/debugging/impl/OptionalValueFactory;", "stateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "Lcom/android/adblib/tools/debugging/AppProcessProperties;", "propertiesFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getPropertiesFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "pid", "", "getPid", "()I", "onAppProcessEntryUpdated", "", "newEntry", "onAppProcessEntryUpdated$android_sdktools_adblib_tools", "close", "toString", "toAppProcessProperties", "mergeWith", "android.sdktools.adblib.tools"})
@SourceDebugExtension(value={"SMAP\nAppProcessImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppProcessImpl.kt\ncom/android/adblib/tools/debugging/impl/AppProcessImpl\n+ 2 AdbLogger.kt\ncom/android/adblib/AdbLoggerKt\n+ 3 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n+ 4 AdbLogger.kt\ncom/android/adblib/AdbLogger\n+ 5 OptionalValueFactory.kt\ncom/android/adblib/tools/debugging/impl/OptionalValueFactory\n*L\n1#1,116:1\n134#2:117\n127#2:118\n120#2:119\n230#3,5:120\n46#4:125\n26#4,4:126\n47#4:130\n111#5,4:131\n111#5,4:135\n111#5,4:139\n111#5,4:143\n111#5,4:147\n*S KotlinDebug\n*F\n+ 1 AppProcessImpl.kt\ncom/android/adblib/tools/debugging/impl/AppProcessImpl\n*L\n44#1:117\n44#1:118\n44#1:119\n64#1:120,5\n70#1:125\n70#1:126,4\n70#1:130\n89#1:131,4\n94#1:135,4\n101#1:139,4\n106#1:143,4\n111#1:147,4\n*E\n"})
public final class AppProcessImpl
implements AppProcess,
AutoCloseable {
    @NotNull
    private final ConnectedDevice device;
    @Nullable
    private final JdwpProcess jdwpProcess;
    @NotNull
    private final String processDescription;
    @NotNull
    private final AdbLogger logger;
    @NotNull
    private final CoroutineScopeCache cache;
    @NotNull
    private final MutableStateFlow<AppProcessProperties> stateFlow;
    @NotNull
    private final StateFlow<AppProcessProperties> propertiesFlow;
    private final int pid;

    /*
     * WARNING - void declaration
     */
    public AppProcessImpl(@NotNull ConnectedDevice device2, @NotNull AppProcessEntry appProcessEntry, @Nullable JdwpProcess jdwpProcess) {
        void $this$adbLogger$iv$iv;
        void $this$adbLogger$iv;
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        Intrinsics.checkNotNullParameter((Object)appProcessEntry, (String)"appProcessEntry");
        this.device = device2;
        this.jdwpProcess = jdwpProcess;
        this.processDescription = this.getDevice().getSession() + " - " + this.getDevice() + " - pid=" + appProcessEntry.getPid();
        AppProcessImpl appProcessImpl = this;
        AdbSession session$iv = this.getDevice().getSession();
        boolean $i$f$adbLogger = false;
        void var7_7 = $this$adbLogger$iv;
        AdbSessionHost host$iv$iv = session$iv.getHost();
        boolean $i$f$adbLogger2 = false;
        void var10_10 = $this$adbLogger$iv$iv;
        AdbLoggerFactory loggerFactory$iv$iv$iv = host$iv$iv.getLoggerFactory();
        boolean $i$f$adbLogger3 = false;
        this.logger = AdbLoggerKt.withPrefix(loggerFactory$iv$iv$iv.createLogger(AppProcessImpl.class), this.processDescription + " -");
        this.cache = CoroutineScopeCache.Companion.create(ConnectedDeviceKt.getScope(this.getDevice()), this.processDescription);
        this.stateFlow = StateFlowKt.MutableStateFlow((Object)this.toAppProcessProperties(appProcessEntry));
        this.propertiesFlow = FlowKt.asStateFlow(this.stateFlow);
        this.pid = ((AppProcessProperties)this.stateFlow.getValue()).getPid();
    }

    @Override
    @NotNull
    public ConnectedDevice getDevice() {
        return this.device;
    }

    @Override
    @Nullable
    public JdwpProcess getJdwpProcess() {
        return this.jdwpProcess;
    }

    @Override
    @NotNull
    public CoroutineScopeCache getCache() {
        return this.cache;
    }

    private final OptionalValueFactory getOptionalValueFactory() {
        return OptionalValueFactoryKt.getOptionalValueFactory(this.getDevice());
    }

    @Override
    @NotNull
    public StateFlow<AppProcessProperties> getPropertiesFlow() {
        return this.propertiesFlow;
    }

    @Override
    public int getPid() {
        return this.pid;
    }

    public final void onAppProcessEntryUpdated$android_sdktools_adblib_tools(@NotNull AppProcessEntry newEntry) {
        AppProcessProperties it;
        AppProcessProperties nextValue$iv;
        Object prevValue$iv;
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)newEntry, (String)"newEntry");
        boolean bl2 = bl = newEntry.getPid() == this.getPid();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        MutableStateFlow<AppProcessProperties> $this$update$iv = this.stateFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (AppProcessProperties)prevValue$iv;
            boolean bl3 = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = this.mergeWith(it, newEntry))));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        void this_$iv$iv;
        AdbLogger this_$iv = this.logger;
        boolean $i$f$debug = false;
        AdbLogger adbLogger = this_$iv;
        AdbLogger.Level level$iv$iv = AdbLogger.Level.DEBUG;
        boolean $i$f$logIf = false;
        if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
            AdbLogger.Level level = level$iv$iv;
            void var7_7 = this_$iv$iv;
            boolean bl = false;
            String string2 = "close()";
            var7_7.log(level, string2);
        }
        this.getCache().close();
    }

    @NotNull
    public String toString() {
        return "AppProcess(device=" + this.getDevice() + ", pid=" + this.getPid() + ", jdwpProcess=" + this.getJdwpProcess() + ", properties=" + this.stateFlow.getValue() + ")";
    }

    private final AppProcessProperties toAppProcessProperties(AppProcessEntry $this$toAppProcessProperties) {
        return this.mergeWith(new AppProcessProperties($this$toAppProcessProperties.getPid(), null, null, null, null, null, null, null, null, 510, null), $this$toAppProcessProperties);
    }

    private final AppProcessProperties mergeWith(AppProcessProperties $this$mergeWith, AppProcessEntry newEntry) {
        OptionalValue<Object> optionalValue;
        OptionalValue<Object> optionalValue2;
        OptionalValue<Object> optionalValue3;
        OptionalValue<Object> optionalValue4;
        OptionalValue<Object> optionalValue5;
        boolean bl;
        AppProcessProperties current = $this$mergeWith;
        boolean bl2 = bl = current.getPid() == newEntry.getPid();
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        OptionalValue<Boolean> optionalValue6 = OptionalValueKt.orElse(this.getOptionalValueFactory().of(newEntry.getDebuggable()), current.getDebuggable());
        OptionalValue<Boolean> optionalValue7 = OptionalValueKt.orElse(this.getOptionalValueFactory().of(newEntry.getProfileable()), current.getProfileable());
        Object object = this.getOptionalValueFactory();
        Object value$iv = newEntry.getProcessName();
        boolean $i$f$optionalOrErrorIfNull = false;
        if (value$iv == null) {
            optionalValue5 = JdwpProcessProperties.Companion.unsupportedByOlderApi(OptionalValue.Companion);
        } else {
            String processName = value$iv;
            boolean bl3 = false;
            optionalValue5 = this.getOptionalValueFactory().ofFilteredFakeName(processName);
        }
        OptionalValue<String> optionalValue8 = OptionalValueKt.orElse(optionalValue5, current.getProcessName());
        value$iv = this.getOptionalValueFactory();
        List<String> value$iv2 = newEntry.getPackageNames();
        boolean $i$f$optionalOrErrorIfNull22 = false;
        if (value$iv2 == null) {
            optionalValue4 = JdwpProcessProperties.Companion.unsupportedByOlderApi(OptionalValue.Companion);
        } else {
            List<String> packageNames = value$iv2;
            boolean bl4 = false;
            optionalValue4 = this.getOptionalValueFactory().ofFilteredFakeNames(packageNames);
        }
        object = OptionalValueKt.orElse(optionalValue4, current.getPackageNames());
        OptionalValue<InstructionSet> optionalValue9 = OptionalValueKt.orElse(this.getOptionalValueFactory().ofInstructionSet(newEntry.getInstructionSet()), current.getInstructionSet());
        OptionalValueFactory $i$f$optionalOrErrorIfNull22 = this.getOptionalValueFactory();
        Object value$iv3 = newEntry.getUserId();
        boolean $i$f$optionalOrErrorIfNull3 = false;
        if (value$iv3 == null) {
            optionalValue3 = JdwpProcessProperties.Companion.unsupportedByOlderApi(OptionalValue.Companion);
        } else {
            long userId = ((Number)value$iv3).longValue();
            boolean bl5 = false;
            optionalValue3 = this.getOptionalValueFactory().of(userId);
        }
        OptionalValue<Long> optionalValue10 = OptionalValueKt.orElse(optionalValue3, current.getUserId());
        value$iv3 = this.getOptionalValueFactory();
        Object value$iv4 = newEntry.getWaitingForDebugger();
        boolean $i$f$optionalOrErrorIfNull4 = false;
        if (value$iv4 == null) {
            optionalValue2 = JdwpProcessProperties.Companion.unsupportedByOlderApi(OptionalValue.Companion);
        } else {
            boolean waitingForDebugger = (Boolean)value$iv4;
            boolean bl6 = false;
            optionalValue2 = this.getOptionalValueFactory().of(waitingForDebugger);
        }
        OptionalValue<Boolean> optionalValue11 = OptionalValueKt.orElse(optionalValue2, current.getWaitingForDebugger());
        value$iv4 = this.getOptionalValueFactory();
        Long value$iv5 = newEntry.getUid();
        boolean $i$f$optionalOrErrorIfNull5 = false;
        if (value$iv5 == null) {
            optionalValue = JdwpProcessProperties.Companion.unsupportedByOlderApi(OptionalValue.Companion);
        } else {
            long uid = ((Number)value$iv5).longValue();
            boolean bl7 = false;
            optionalValue = this.getOptionalValueFactory().of(uid);
        }
        OptionalValue<Long> optionalValue12 = OptionalValueKt.orElse(optionalValue, current.getUid());
        return AppProcessProperties.copy$default(current, 0, optionalValue6, optionalValue7, optionalValue9, optionalValue10, optionalValue8, (OptionalValue)object, optionalValue11, optionalValue12, 1, null);
    }
}

