/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.setup.module;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkSetupContext;
import com.android.tools.idea.apk.sdk.AndroidSdkSetup;
import com.android.tools.idea.apk.setup.module.ApkModuleSetupStep;
import com.android.tools.idea.sdk.IdeSdks;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.externalSystem.service.project.IdeModifiableModelsProvider;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.List;
import org.jetbrains.android.dom.AndroidAttributeValue;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.dom.manifest.UsesSdk;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidSdkSetupStep
extends ApkModuleSetupStep {
    @NotNull
    private final IdeSdks myIdeSdks;
    @NotNull
    private final AndroidSdkSetup mySdkSetup;

    public AndroidSdkSetupStep() {
        this(IdeSdks.getInstance(), new AndroidSdkSetup());
    }

    @VisibleForTesting
    AndroidSdkSetupStep(@NotNull IdeSdks ideSdks, @NotNull AndroidSdkSetup sdkSetup) {
        this.myIdeSdks = ideSdks;
        this.mySdkSetup = sdkSetup;
    }

    @Override
    public void setUpModule(@NotNull IdeModifiableModelsProvider modelsProvider, @NotNull ApkSetupContext context) {
        File sdkPath = this.myIdeSdks.getAndroidSdkPath();
        if (sdkPath != null) {
            Manifest manifest = this.getManifest(context);
            this.setModuleSdk(context, modelsProvider, sdkPath, manifest);
        }
    }

    @VisibleForTesting
    void setModuleSdk(@NotNull ApkSetupContext context, @NotNull IdeModifiableModelsProvider modelsProvider, @NotNull File sdkPath, @NotNull Manifest manifest) {
        UsesSdk usesSdk;
        String sdkVersion;
        ModifiableRootModel rootModel = modelsProvider.getModifiableRootModel(context.getModule());
        List usesSdks = manifest.getUsesSdks();
        if (!usesSdks.isEmpty() && StringUtil.isNotEmpty((String)(sdkVersion = AndroidSdkSetupStep.getSdkVersion(usesSdk = (UsesSdk)usesSdks.get(0))))) {
            ApkFacet facet = context.getApkFacet();
            assert (facet != null);
            Sdk sdk = this.mySdkSetup.setUpSdk(sdkVersion, sdkPath, facet, rootModel);
            context.setAndroidSdk(sdk);
        }
    }

    @Nullable
    private static String getSdkVersion(@NotNull UsesSdk usesSdk) {
        String sdkVersion = AndroidSdkSetupStep.getTargetSdkVersion(usesSdk);
        if (StringUtil.isEmpty((String)sdkVersion)) {
            sdkVersion = AndroidSdkSetupStep.getMinSdkVersion(usesSdk);
        }
        return sdkVersion;
    }

    @Nullable
    private static String getTargetSdkVersion(@NotNull UsesSdk usesSdk) {
        AndroidAttributeValue targetSdkVersion = usesSdk.getTargetSdkVersion();
        return targetSdkVersion.exists() ? (String)targetSdkVersion.getValue() : null;
    }

    @Nullable
    private static String getMinSdkVersion(@NotNull UsesSdk usesSdk) {
        AndroidAttributeValue minSdkVersion = usesSdk.getMinSdkVersion();
        return minSdkVersion.exists() ? (String)minSdkVersion.getValue() : null;
    }
}

