/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.reload;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class ApkMessagesProvider {
    @NotNull
    private Project myProject;

    public ApkMessagesProvider(@NotNull Project project) {
        this.myProject = project;
    }

    public void showNotImplementedError() {
        String title = "Not Implemented";
        String message = "This feature is not implemented yet";
        Messages.showErrorDialog((Project)this.myProject, (String)message, (String)title);
    }

    public void showApkFromCurrentProjectError() {
        String title = "Invalid APK File Path";
        String message = "Selected APK file must be outside the current project directory";
        Messages.showErrorDialog((Project)this.myProject, (String)message, (String)title);
    }

    public int showFailedToReloadMessage() {
        String title = "Failed to Reload APK";
        String message = "An error occurred while reloading the APK. The current project may be in an inconsistent state.\nWould you like to import the APK as a new project?";
        String okText = "Yes";
        String cancelText = "No";
        return Messages.showOkCancelDialog((Project)this.myProject, (String)message, (String)title, (String)okText, (String)cancelText, (Icon)Messages.getQuestionIcon());
    }

    public void showApkFileNotFoundMessage() {
        String title = "Cannot find APK file";
        String message = "The APK file to import does not exist";
        Messages.showErrorDialog((Project)this.myProject, (String)message, (String)title);
    }
}

