/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.apk.issues;

import com.android.tools.idea.apk.ApkFacet;
import com.android.tools.idea.apk.ApkFacetConfiguration;
import com.android.tools.idea.apk.debugging.NativeLibrary;
import com.android.tools.idea.apk.debugging.SetupIssue;
import com.android.tools.idea.apk.issues.IssueCategory;
import com.android.tools.idea.apk.issues.SetupIssueReportStrategy;
import com.android.tools.idea.project.AndroidNotification;
import com.android.tools.idea.project.hyperlink.NotificationHyperlink;
import com.intellij.openapi.project.Project;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class DebugSymbolsMissingReporter
extends SetupIssueReportStrategy {
    DebugSymbolsMissingReporter() {
    }

    @Override
    @NotNull
    IssueCategory getSupportedCategory() {
        return IssueCategory.DEBUG_SYMBOLS_MISSING;
    }

    @Override
    protected void report(@NotNull Project project, @NotNull SetupIssue issue, @NotNull ApkFacet facet) {
        StringBuilder message = new StringBuilder();
        message.append("To debug the APK, native libraries (*.so files) must have debug symbols.<br/>");
        List libraries = ((ApkFacetConfiguration)facet.getConfiguration()).getLibrariesWithoutDebugSymbols();
        int libraryCount = libraries.size();
        message.append("The following libraries are missing debug symbols:<br/>");
        for (int i = 0; i < libraryCount; ++i) {
            NativeLibrary library = (NativeLibrary)libraries.get(i);
            message.append("&nbsp;*&nbsp;").append(library.name);
            if (i >= libraryCount - 1) continue;
            message.append("<br/>");
        }
        AndroidNotification.getInstance((Project)project).showBalloon("Missing debug symbols", message.toString(), this.getSeverity(issue.severity), this.getNotificationGroup(issue.severity), new NotificationHyperlink[0]);
    }
}

