/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.developerexperience.cloudcode.intellij.auth;

import com.google.api.client.auth.oauth2.ClientParametersAuthentication;
import com.google.api.client.http.HttpRequest;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u000b"}, d2={"Lcom/google/cloud/developerexperience/cloudcode/intellij/auth/StsClientParametersAuthentication;", "Lcom/google/api/client/auth/oauth2/ClientParametersAuthentication;", "oauthClientId", "", "oauthClientSecret", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "intercept", "", "req", "Lcom/google/api/client/http/HttpRequest;", "java.com.google.cloud.developerexperience.cloudcode.intellij.auth_google_auth_intellij_lib"})
public final class StsClientParametersAuthentication
extends ClientParametersAuthentication {
    public StsClientParametersAuthentication(@NotNull String oauthClientId, @NotNull String oauthClientSecret) {
        Intrinsics.checkNotNullParameter((Object)oauthClientId, (String)"oauthClientId");
        Intrinsics.checkNotNullParameter((Object)oauthClientSecret, (String)"oauthClientSecret");
        super(oauthClientId, oauthClientSecret);
    }

    public void intercept(@NotNull HttpRequest req) throws IOException {
        block2: {
            block3: {
                Intrinsics.checkNotNullParameter((Object)req, (String)"req");
                if (!Intrinsics.areEqual((Object)req.getUrl().getHost(), (Object)"sts.googleapis.com")) break block2;
                String string = req.getUrl().getRawPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getRawPath(...)");
                if (StringsKt.startsWith$default((String)string, (String)"/v1/oauthtoken", (boolean)false, (int)2, null)) break block3;
                String string2 = req.getUrl().getRawPath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRawPath(...)");
                if (!StringsKt.startsWith$default((String)string2, (String)"/v1/introspect", (boolean)false, (int)2, null)) break block2;
            }
            String key = this.getClientId() + ":" + this.getClientSecret();
            Base64.Encoder encoder = Base64.getEncoder().withoutPadding();
            String string = key;
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            String auth = encoder.encodeToString(byArray);
            req.getHeaders().setAuthorization("Basic " + auth);
            return;
        }
        super.intercept(req);
    }
}

