/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.xrActivity.src.app_package;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u00a8\u0006\u0005"}, d2={"mainActivityKt", "", "activityClass", "packageName", "themeName", "intellij.android.wizardTemplate.impl"})
public final class MainActivityKt {
    @NotNull
    public static final String mainActivityKt(@NotNull String activityClass, @NotNull String packageName, @NotNull String themeName) {
        Intrinsics.checkNotNullParameter((Object)activityClass, (String)"activityClass");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)themeName, (String)"themeName");
        return "\npackage " + TemplateHelpersKt.escapeKotlinIdentifier(packageName) + "\n\nimport android.annotation.SuppressLint\nimport android.os.Bundle\nimport androidx.activity.ComponentActivity\nimport androidx.activity.compose.setContent\nimport androidx.activity.enableEdgeToEdge\nimport androidx.compose.foundation.layout.Arrangement\nimport androidx.compose.foundation.layout.Row\nimport androidx.compose.foundation.layout.fillMaxSize\nimport androidx.compose.foundation.layout.padding\nimport androidx.compose.foundation.layout.size\nimport androidx.compose.foundation.shape.CornerSize\nimport androidx.compose.material3.FilledTonalIconButton\nimport androidx.compose.material3.Icon\nimport androidx.compose.material3.IconButton\nimport androidx.compose.material3.Surface\nimport androidx.compose.material3.Text\nimport androidx.compose.runtime.Composable\nimport androidx.compose.ui.Alignment\nimport androidx.compose.ui.Modifier\nimport androidx.compose.ui.platform.LocalInspectionMode\nimport androidx.compose.ui.res.painterResource\nimport androidx.compose.ui.res.stringResource\nimport androidx.compose.ui.tooling.preview.Preview\nimport androidx.compose.ui.tooling.preview.PreviewLightDark\nimport androidx.compose.ui.unit.dp\nimport androidx.xr.compose.platform.LocalSession\nimport androidx.xr.compose.platform.LocalSpatialCapabilities\nimport androidx.xr.compose.platform.LocalSpatialConfiguration\nimport androidx.xr.compose.spatial.ContentEdge\nimport androidx.xr.compose.spatial.Orbiter\nimport androidx.xr.compose.spatial.Subspace\nimport androidx.xr.compose.subspace.SpatialPanel\nimport androidx.xr.compose.subspace.layout.SpatialRoundedCornerShape\nimport androidx.xr.compose.subspace.layout.SubspaceModifier\nimport androidx.xr.compose.subspace.layout.height\nimport androidx.xr.compose.subspace.layout.movable\nimport androidx.xr.compose.subspace.layout.resizable\nimport androidx.xr.compose.subspace.layout.width\nimport " + TemplateHelpersKt.escapeKotlinIdentifier(packageName) + ".ui.theme." + TemplateHelpersKt.escapeKotlinIdentifier(themeName) + "\n\n\nclass " + activityClass + " : ComponentActivity() {\n\n    @SuppressLint(\"RestrictedApi\")\n    override fun onCreate(savedInstanceState: Bundle?) {\n        super.onCreate(savedInstanceState)\n        enableEdgeToEdge()\n\n        setContent {\n            " + TemplateHelpersKt.escapeKotlinIdentifier(themeName) + " {\n                val spatialConfiguration = LocalSpatialConfiguration.current\n                if (LocalSpatialCapabilities.current.isSpatialUiEnabled) {\n                    Subspace {\n                        MySpatialContent(\n                            onRequestHomeSpaceMode = spatialConfiguration::requestHomeSpaceMode\n                        )\n                    }\n                } else {\n                    My2DContent(onRequestFullSpaceMode = spatialConfiguration::requestFullSpaceMode)\n                }\n            }\n        }\n    }\n}\n\n@SuppressLint(\"RestrictedApi\")\n@Composable\nfun MySpatialContent(onRequestHomeSpaceMode: () -> Unit) {\n    SpatialPanel(SubspaceModifier.width(1280.dp).height(800.dp).resizable().movable()) {\n        Surface {\n            MainContent(\n                modifier = Modifier\n                    .fillMaxSize()\n                    .padding(48.dp)\n            )\n        }\n        Orbiter(\n            position = ContentEdge.Top,\n            offset = 20.dp,\n            alignment = Alignment.End,\n            shape = SpatialRoundedCornerShape(CornerSize(28.dp))\n        ) {\n            HomeSpaceModeIconButton(\n                onClick = onRequestHomeSpaceMode,\n                modifier = Modifier.size(56.dp)\n            )\n        }\n    }\n}\n\n@SuppressLint(\"RestrictedApi\")\n@Composable\nfun My2DContent(onRequestFullSpaceMode: () -> Unit) {\n    Surface {\n        Row(\n            modifier = Modifier.fillMaxSize(),\n            horizontalArrangement = Arrangement.SpaceBetween\n        ) {\n            MainContent(modifier = Modifier.padding(48.dp))\n            // Preview does not current support XR sessions.\n            if (!LocalInspectionMode.current && LocalSession.current != null) {\n                FullSpaceModeIconButton(\n                    onClick = onRequestFullSpaceMode,\n                    modifier = Modifier.padding(32.dp)\n                )\n            }\n        }\n    }\n}\n\n@Composable\nfun MainContent(modifier: Modifier = Modifier) {\n    Text(text = stringResource(R.string.hello_android_xr), modifier = modifier)\n}\n\n@Composable\nfun FullSpaceModeIconButton(onClick: () -> Unit, modifier: Modifier = Modifier) {\n    IconButton(onClick = onClick, modifier = modifier) {\n        Icon(\n            painter = painterResource(id = R.drawable.ic_full_space_mode_switch),\n            contentDescription = stringResource(R.string.switch_to_full_space_mode)\n        )\n    }\n}\n\n@Composable\nfun HomeSpaceModeIconButton(onClick: () -> Unit, modifier: Modifier = Modifier) {\n    FilledTonalIconButton(onClick = onClick, modifier = modifier) {\n        Icon(\n            painter = painterResource(id = R.drawable.ic_home_space_mode_switch),\n            contentDescription = stringResource(R.string.switch_to_home_space_mode)\n        )\n    }\n}\n\n@PreviewLightDark\n@Composable\nfun My2dContentPreview() {\n    " + TemplateHelpersKt.escapeKotlinIdentifier(themeName) + " {\n        My2DContent(onRequestFullSpaceMode = {})\n    }\n}\n\n@Preview(showBackground = true)\n@Composable\nfun FullSpaceModeButtonPreview() {\n    " + TemplateHelpersKt.escapeKotlinIdentifier(themeName) + " {\n        FullSpaceModeIconButton(onClick = {})\n    }\n}\n\n@PreviewLightDark\n@Composable\nfun HomeSpaceModeButtonPreview() {\n    " + TemplateHelpersKt.escapeKotlinIdentifier(themeName) + " {\n        HomeSpaceModeIconButton(onClick = {})\n    }\n}\n";
    }
}

