/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.cppGameActivity.src;

import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0006\u0010\u0000\u001a\u00020\u0001\u001a\u0006\u0010\u0002\u001a\u00020\u0001\u00a8\u0006\u0003"}, d2={"shaderCpp", "", "shaderH", "intellij.android.wizardTemplate.impl"})
public final class ShaderCppKt {
    @NotNull
    public static final String shaderCpp() {
        return "\n#include \"Shader.h\"\n\n#include \"AndroidOut.h\"\n#include \"Model.h\"\n#include \"Utility.h\"\n\nShader *Shader::loadShader(\n        const std::string &vertexSource,\n        const std::string &fragmentSource,\n        const std::string &positionAttributeName,\n        const std::string &uvAttributeName,\n        const std::string &projectionMatrixUniformName) {\n    Shader *shader = nullptr;\n\n    GLuint vertexShader = loadShader(GL_VERTEX_SHADER, vertexSource);\n    if (!vertexShader) {\n        return nullptr;\n    }\n\n    GLuint fragmentShader = loadShader(GL_FRAGMENT_SHADER, fragmentSource);\n    if (!fragmentShader) {\n        glDeleteShader(vertexShader);\n        return nullptr;\n    }\n\n    GLuint program = glCreateProgram();\n    if (program) {\n        glAttachShader(program, vertexShader);\n        glAttachShader(program, fragmentShader);\n\n        glLinkProgram(program);\n        GLint linkStatus = GL_FALSE;\n        glGetProgramiv(program, GL_LINK_STATUS, &linkStatus);\n        if (linkStatus != GL_TRUE) {\n            GLint logLength = 0;\n            glGetProgramiv(program, GL_INFO_LOG_LENGTH, &logLength);\n\n            // If we fail to link the shader program, log the result for debugging\n            if (logLength) {\n                GLchar *log = new GLchar[logLength];\n                glGetProgramInfoLog(program, logLength, nullptr, log);\n                aout << \"Failed to link program with:\\n\" << log << std::endl;\n                delete[] log;\n            }\n\n            glDeleteProgram(program);\n        } else {\n            // Get the attribute and uniform locations by name. You may also choose to hardcode\n            // indices with layout= in your shader, but it is not done in this sample\n            GLint positionAttribute = glGetAttribLocation(program, positionAttributeName.c_str());\n            GLint uvAttribute = glGetAttribLocation(program, uvAttributeName.c_str());\n            GLint projectionMatrixUniform = glGetUniformLocation(\n                    program,\n                    projectionMatrixUniformName.c_str());\n\n            // Only create a new shader if all the attributes are found.\n            if (positionAttribute != -1\n                && uvAttribute != -1\n                && projectionMatrixUniform != -1) {\n\n                shader = new Shader(\n                        program,\n                        positionAttribute,\n                        uvAttribute,\n                        projectionMatrixUniform);\n            } else {\n                glDeleteProgram(program);\n            }\n        }\n    }\n\n    // The shaders are no longer needed once the program is linked. Release their memory.\n    glDeleteShader(vertexShader);\n    glDeleteShader(fragmentShader);\n\n    return shader;\n}\n\nGLuint Shader::loadShader(GLenum shaderType, const std::string &shaderSource) {\n    Utility::assertGlError();\n    GLuint shader = glCreateShader(shaderType);\n    if (shader) {\n        auto *shaderRawString = (GLchar *) shaderSource.c_str();\n        GLint shaderLength = shaderSource.length();\n        glShaderSource(shader, 1, &shaderRawString, &shaderLength);\n        glCompileShader(shader);\n\n        GLint shaderCompiled = 0;\n        glGetShaderiv(shader, GL_COMPILE_STATUS, &shaderCompiled);\n\n        // If the shader doesn't compile, log the result to the terminal for debugging\n        if (!shaderCompiled) {\n            GLint infoLength = 0;\n            glGetShaderiv(shader, GL_INFO_LOG_LENGTH, &infoLength);\n\n            if (infoLength) {\n                auto *infoLog = new GLchar[infoLength];\n                glGetShaderInfoLog(shader, infoLength, nullptr, infoLog);\n                aout << \"Failed to compile with:\\n\" << infoLog << std::endl;\n                delete[] infoLog;\n            }\n\n            glDeleteShader(shader);\n            shader = 0;\n        }\n    }\n    return shader;\n}\n\nvoid Shader::activate() const {\n    glUseProgram(program_);\n}\n\nvoid Shader::deactivate() const {\n    glUseProgram(0);\n}\n\nvoid Shader::drawModel(const Model &model) const {\n    // The position attribute is 3 floats\n    glVertexAttribPointer(\n            position_, // attrib\n            3, // elements\n            GL_FLOAT, // of type float\n            GL_FALSE, // don't normalize\n            sizeof(Vertex), // stride is Vertex bytes\n            model.getVertexData() // pull from the start of the vertex data\n    );\n    glEnableVertexAttribArray(position_);\n\n    // The uv attribute is 2 floats\n    glVertexAttribPointer(\n            uv_, // attrib\n            2, // elements\n            GL_FLOAT, // of type float\n            GL_FALSE, // don't normalize\n            sizeof(Vertex), // stride is Vertex bytes\n            ((uint8_t *) model.getVertexData()) + sizeof(Vector3) // offset Vector3 from the start\n    );\n    glEnableVertexAttribArray(uv_);\n\n    // Setup the texture\n    glActiveTexture(GL_TEXTURE0);\n    glBindTexture(GL_TEXTURE_2D, model.getTexture().getTextureID());\n\n    // Draw as indexed triangles\n    glDrawElements(GL_TRIANGLES, model.getIndexCount(), GL_UNSIGNED_SHORT, model.getIndexData());\n\n    glDisableVertexAttribArray(uv_);\n    glDisableVertexAttribArray(position_);\n}\n\nvoid Shader::setProjectionMatrix(float *projectionMatrix) const {\n    glUniformMatrix4fv(projectionMatrix_, 1, false, projectionMatrix);\n}\n";
    }

    @NotNull
    public static final String shaderH() {
        return "\n#ifndef ANDROIDGLINVESTIGATIONS_SHADER_H\n#define ANDROIDGLINVESTIGATIONS_SHADER_H\n\n#include <string>\n#include <GLES3/gl3.h>\n\n\nclass Model;\n\n/*!\n * A class representing a simple shader program. It consists of vertex and fragment components. The\n * input attributes are a position (as a Vector3) and a uv (as a Vector2). It also takes a uniform\n * to be used as the entire model/view/projection matrix. The shader expects a single texture for\n * fragment shading, and does no other lighting calculations (thus no uniforms for lights or normal\n * attributes).\n */\nclass Shader {\npublic:\n    /*!\n     * Loads a shader given the full sourcecode and names for necessary attributes and uniforms to\n     * link to. Returns a valid shader on success or null on failure. Shader resources are\n     * automatically cleaned up on destruction.\n     *\n     * @param vertexSource The full source code for your vertex program\n     * @param fragmentSource The full source code of your fragment program\n     * @param positionAttributeName The name of the position attribute in your vertex program\n     * @param uvAttributeName The name of the uv coordinate attribute in your vertex program\n     * @param projectionMatrixUniformName The name of your model/view/projection matrix uniform\n     * @return a valid Shader on success, otherwise null.\n     */\n    static Shader *loadShader(\n            const std::string &vertexSource,\n            const std::string &fragmentSource,\n            const std::string &positionAttributeName,\n            const std::string &uvAttributeName,\n            const std::string &projectionMatrixUniformName);\n\n    inline ~Shader() {\n        if (program_) {\n            glDeleteProgram(program_);\n            program_ = 0;\n        }\n    }\n\n    /*!\n     * Prepares the shader for use, call this before executing any draw commands\n     */\n    void activate() const;\n\n    /*!\n     * Cleans up the shader after use, call this after executing any draw commands\n     */\n    void deactivate() const;\n\n    /*!\n     * Renders a single model\n     * @param model a model to render\n     */\n    void drawModel(const Model &model) const;\n\n    /*!\n     * Sets the model/view/projection matrix in the shader.\n     * @param projectionMatrix sixteen floats, column major, defining an OpenGL projection matrix.\n     */\n    void setProjectionMatrix(float *projectionMatrix) const;\n\nprivate:\n    /*!\n     * Helper function to load a shader of a given type\n     * @param shaderType The OpenGL shader type. Should either be GL_VERTEX_SHADER or GL_FRAGMENT_SHADER\n     * @param shaderSource The full source of the shader\n     * @return the id of the shader, as returned by glCreateShader, or 0 in the case of an error\n     */\n    static GLuint loadShader(GLenum shaderType, const std::string &shaderSource);\n\n    /*!\n     * Constructs a new instance of a shader. Use @a loadShader\n     * @param program the GL program id of the shader\n     * @param position the attribute location of the position\n     * @param uv the attribute location of the uv coordinates\n     * @param projectionMatrix the uniform location of the projection matrix\n     */\n    constexpr Shader(\n            GLuint program,\n            GLint position,\n            GLint uv,\n            GLint projectionMatrix)\n            : program_(program),\n              position_(position),\n              uv_(uv),\n              projectionMatrix_(projectionMatrix) {}\n\n    GLuint program_;\n    GLint position_;\n    GLint uv_;\n    GLint projectionMatrix_;\n};\n\n#endif //ANDROIDGLINVESTIGATIONS_SHADER_H\n";
    }
}

