/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.composeWearActivity.src.app_package.tile;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0001\u00a8\u0006\u0005"}, d2={"tileServiceKt", "", "tileServiceClass", "defaultPreview", "packageName", "intellij.android.wizardTemplate.impl"})
public final class TileServiceKt {
    @NotNull
    public static final String tileServiceKt(@NotNull String tileServiceClass, @NotNull String defaultPreview, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)tileServiceClass, (String)"tileServiceClass");
        Intrinsics.checkNotNullParameter((Object)defaultPreview, (String)"defaultPreview");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return "\npackage " + TemplateHelpersKt.escapeKotlinIdentifier(packageName) + ".tile\n\nimport android.content.Context\nimport androidx.wear.protolayout.ColorBuilders.argb\nimport androidx.wear.protolayout.LayoutElementBuilders\nimport androidx.wear.protolayout.ResourceBuilders\nimport androidx.wear.protolayout.TimelineBuilders\nimport androidx.wear.protolayout.material.Colors\nimport androidx.wear.protolayout.material.Text\nimport androidx.wear.protolayout.material.Typography\nimport androidx.wear.protolayout.material.layouts.PrimaryLayout\nimport androidx.wear.tiles.RequestBuilders\nimport androidx.wear.tiles.TileBuilders\nimport androidx.wear.tiles.tooling.preview.Preview\nimport androidx.wear.tiles.tooling.preview.TilePreviewData\nimport androidx.wear.tooling.preview.devices.WearDevices\nimport com.google.android.horologist.annotations.ExperimentalHorologistApi\nimport com.google.android.horologist.tiles.SuspendingTileService\n\nprivate const val RESOURCES_VERSION = \"0\"\n\n/**\n * Skeleton for a tile with no images.\n */\n@OptIn(ExperimentalHorologistApi::class)\nclass " + tileServiceClass + " : SuspendingTileService() {\n\n    override suspend fun resourcesRequest(\n        requestParams: RequestBuilders.ResourcesRequest\n    ) = resources(requestParams)\n\n    override suspend fun tileRequest(\n        requestParams: RequestBuilders.TileRequest\n    ) = tile(requestParams, this)\n}\n\nprivate fun resources(\n    requestParams: RequestBuilders.ResourcesRequest\n): ResourceBuilders.Resources {\n    return ResourceBuilders.Resources.Builder()\n        .setVersion(RESOURCES_VERSION)\n        .build()\n}\n\nprivate fun tile(\n    requestParams: RequestBuilders.TileRequest,\n    context: Context,\n): TileBuilders.Tile {\n    val singleTileTimeline = TimelineBuilders.Timeline.Builder()\n        .addTimelineEntry(\n            TimelineBuilders.TimelineEntry.Builder()\n                .setLayout(\n                    LayoutElementBuilders.Layout.Builder()\n                        .setRoot(tileLayout(requestParams, context))\n                        .build()\n                )\n                .build()\n        )\n        .build()\n\n    return TileBuilders.Tile.Builder()\n        .setResourcesVersion(RESOURCES_VERSION)\n        .setTileTimeline(singleTileTimeline)\n        .build()\n}\n\nprivate fun tileLayout(\n    requestParams: RequestBuilders.TileRequest,\n    context: Context,\n): LayoutElementBuilders.LayoutElement {\n    return PrimaryLayout.Builder(requestParams.deviceConfiguration)\n        .setResponsiveContentInsetEnabled(true)\n        .setContent(\n            Text.Builder(context, \"Hello World!\")\n                .setColor(argb(Colors.DEFAULT.onSurface))\n                .setTypography(Typography.TYPOGRAPHY_CAPTION1)\n                .build()\n        ).build()\n}\n\n@Preview(device = WearDevices.SMALL_ROUND)\n@Preview(device = WearDevices.LARGE_ROUND)\nfun " + defaultPreview + "(context: Context) = TilePreviewData(::resources) {\n    tile(it, context)\n}\n";
    }
}

