/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.wizard.template.impl.activities.composeWearActivity.complication;

import com.android.tools.idea.wizard.template.TemplateHelpersKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\n\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0001\u00a8\u0006\u0003"}, d2={"complicationServiceKt", "", "packageName", "intellij.android.wizardTemplate.impl"})
public final class ComplicationServiceKt {
    @NotNull
    public static final String complicationServiceKt(@NotNull String complicationServiceKt, @NotNull String packageName) {
        Intrinsics.checkNotNullParameter((Object)complicationServiceKt, (String)"complicationServiceKt");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        return "\npackage " + TemplateHelpersKt.escapeKotlinIdentifier(packageName) + ".complication\n\nimport androidx.wear.watchface.complications.data.ComplicationData\nimport androidx.wear.watchface.complications.data.ComplicationType\nimport androidx.wear.watchface.complications.data.PlainComplicationText\nimport androidx.wear.watchface.complications.data.ShortTextComplicationData\nimport androidx.wear.watchface.complications.datasource.ComplicationRequest\nimport androidx.wear.watchface.complications.datasource.SuspendingComplicationDataSourceService\nimport java.util.Calendar\n\n/**\n * Skeleton for complication data source that returns short text.\n */\nclass " + complicationServiceKt + " : SuspendingComplicationDataSourceService() {\n\n    override fun getPreviewData(type: ComplicationType): ComplicationData? {\n        if (type != ComplicationType.SHORT_TEXT) {\n            return null\n        }\n        return createComplicationData(\"Mon\", \"Monday\")\n    }\n\n    override suspend fun onComplicationRequest(request: ComplicationRequest): ComplicationData {\n        return when (Calendar.getInstance().get(Calendar.DAY_OF_WEEK)) {\n            Calendar.SUNDAY -> createComplicationData(\"Sun\", \"Sunday\")\n            Calendar.MONDAY -> createComplicationData(\"Mon\", \"Monday\")\n            Calendar.TUESDAY -> createComplicationData(\"Tue\", \"Tuesday\")\n            Calendar.WEDNESDAY -> createComplicationData(\"Wed\", \"Wednesday\")\n            Calendar.THURSDAY -> createComplicationData(\"Thu\", \"Thursday\")\n            Calendar.FRIDAY -> createComplicationData(\"Fri!\", \"Friday!\")\n            Calendar.SATURDAY -> createComplicationData(\"Sat\", \"Saturday\")\n            else -> throw IllegalArgumentException(\"too many days\")\n        }\n    }\n\n    private fun createComplicationData(text: String, contentDescription: String) =\n        ShortTextComplicationData.Builder(\n            text = PlainComplicationText.Builder(text).build(),\n            contentDescription = PlainComplicationText.Builder(contentDescription).build()\n        ).build()\n}\n";
    }
}

