/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.core.util.nodespacing.internal.algorithm;

import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeConstraint;
import org.eclipse.elk.core.options.SizeOptions;
import org.eclipse.elk.core.util.nodespacing.internal.NodeContext;
import org.eclipse.elk.core.util.nodespacing.internal.algorithm.NodeLabelAndSizeUtilities;

public final class NodeSizeCalculator {
    private NodeSizeCalculator() {
    }

    public static void setNodeWidth(NodeContext nodeContext) {
        double width;
        KVector nodeSize = nodeContext.nodeSize;
        if (NodeLabelAndSizeUtilities.areSizeConstraintsFixed(nodeContext)) {
            width = nodeSize.x;
        } else {
            KVector minNodeSize;
            width = nodeContext.nodeContainer.getMinimumWidth();
            if (nodeContext.sizeConstraints.contains((Object)SizeConstraint.NODE_LABELS) && !nodeContext.sizeOptions.contains((Object)SizeOptions.OUTSIDE_NODE_LABELS_OVERHANG)) {
                width = Math.max(width, nodeContext.outsideNodeLabelContainers.get((Object)PortSide.NORTH).getMinimumWidth());
                width = Math.max(width, nodeContext.outsideNodeLabelContainers.get((Object)PortSide.SOUTH).getMinimumWidth());
            }
            if ((minNodeSize = NodeLabelAndSizeUtilities.getMinimumNodeSize(nodeContext)) != null) {
                width = Math.max(width, minNodeSize.x);
            }
        }
        nodeSize.x = width;
        ElkRectangle nodeCellRectangle = nodeContext.nodeContainer.getCellRectangle();
        nodeCellRectangle.x = 0.0;
        nodeCellRectangle.width = width;
        nodeContext.nodeContainer.layoutChildrenHorizontally();
    }

    public static void setNodeHeight(NodeContext nodeContext) {
        double height;
        KVector nodeSize = nodeContext.nodeSize;
        if (NodeLabelAndSizeUtilities.areSizeConstraintsFixed(nodeContext)) {
            height = nodeSize.y;
        } else {
            KVector minNodeSize;
            height = nodeContext.nodeContainer.getMinimumHeight();
            if (nodeContext.sizeConstraints.contains((Object)SizeConstraint.NODE_LABELS) && !nodeContext.sizeOptions.contains((Object)SizeOptions.OUTSIDE_NODE_LABELS_OVERHANG)) {
                height = Math.max(height, nodeContext.outsideNodeLabelContainers.get((Object)PortSide.EAST).getMinimumHeight());
                height = Math.max(height, nodeContext.outsideNodeLabelContainers.get((Object)PortSide.WEST).getMinimumHeight());
            }
            if ((minNodeSize = NodeLabelAndSizeUtilities.getMinimumNodeSize(nodeContext)) != null) {
                height = Math.max(height, minNodeSize.y);
            }
            if (nodeContext.sizeConstraints.contains((Object)SizeConstraint.PORTS) && (nodeContext.portConstraints == PortConstraints.FIXED_RATIO || nodeContext.portConstraints == PortConstraints.FIXED_POS)) {
                height = Math.max(height, nodeContext.insidePortLabelCells.get((Object)PortSide.EAST).getMinimumHeight());
                height = Math.max(height, nodeContext.insidePortLabelCells.get((Object)PortSide.WEST).getMinimumHeight());
            }
        }
        nodeSize.y = height;
        ElkRectangle nodeCellRectangle = nodeContext.nodeContainer.getCellRectangle();
        nodeCellRectangle.y = 0.0;
        nodeCellRectangle.height = height;
        nodeContext.nodeContainer.layoutChildrenVertically();
    }
}

