/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.compose.formatting;

import com.android.tools.compose.formatting.ComposePostFormatProcessorKt;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PostFormatProcessorHelper;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.formatter.CodeStyleUtilsKt;
import org.jetbrains.kotlin.psi.KtDotQualifiedExpression;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtTreeVisitorVoid;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011J\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0014R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/compose/formatting/ComposeModifierProcessor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitorVoid;", "settings", "Lcom/intellij/psi/codeStyle/CodeStyleSettings;", "<init>", "(Lcom/intellij/psi/codeStyle/CodeStyleSettings;)V", "myPostProcessor", "Lcom/intellij/psi/impl/source/codeStyle/PostFormatProcessorHelper;", "updateResultRange", "", "oldTextLength", "", "newTextLength", "visitKtElement", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "process", "Lcom/intellij/psi/PsiElement;", "formatted", "processText", "Lcom/intellij/openapi/util/TextRange;", "source", "Lcom/intellij/psi/PsiFile;", "rangeToReformat", "intellij.android.compose-ide-plugin"})
public final class ComposeModifierProcessor
extends KtTreeVisitorVoid {
    @NotNull
    private final CodeStyleSettings settings;
    @NotNull
    private final PostFormatProcessorHelper myPostProcessor;

    public ComposeModifierProcessor(@NotNull CodeStyleSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
        this.myPostProcessor = new PostFormatProcessorHelper((CommonCodeStyleSettings)CodeStyleUtilsKt.getKotlinCommonSettings((CodeStyleSettings)this.settings));
    }

    private final void updateResultRange(int oldTextLength, int newTextLength) {
        this.myPostProcessor.updateResultRange(oldTextLength, newTextLength);
    }

    public void visitKtElement(@NotNull KtElement element) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super.visitElement((PsiElement)element);
        if (element.isPhysical() && ComposePostFormatProcessorKt.access$isModifierChainThatNeedToBeWrapped(element)) {
            int oldTextLength = element.getTextLength();
            ComposePostFormatProcessorKt.wrapModifierChain((KtDotQualifiedExpression)element, this.settings);
            this.updateResultRange(oldTextLength, ((KtDotQualifiedExpression)element).getTextLength());
        }
    }

    @NotNull
    public final PsiElement process(@NotNull PsiElement formatted) {
        Intrinsics.checkNotNullParameter((Object)formatted, (String)"formatted");
        formatted.accept((PsiElementVisitor)this);
        return formatted;
    }

    @NotNull
    public final TextRange processText(@NotNull PsiFile source, @NotNull TextRange rangeToReformat) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)rangeToReformat, (String)"rangeToReformat");
        this.myPostProcessor.setResultTextRange(rangeToReformat);
        source.accept((PsiElementVisitor)this);
        TextRange textRange = this.myPostProcessor.getResultTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"getResultTextRange(...)");
        return textRange;
    }
}

