/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.compose.debug;

import com.android.tools.compose.ComposeBundle;
import com.android.tools.compose.debug.ComposeDebuggerSettings;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.util.text.TextWithMnemonic;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;

public class ComposeDebuggerSettingsUi
implements ConfigurableUi<ComposeDebuggerSettings> {
    private JPanel myPanel;
    private JCheckBox filterComposeInternalClasses;

    public ComposeDebuggerSettingsUi() {
        this.setupUI();
    }

    public void reset(@NotNull ComposeDebuggerSettings settings) {
        this.filterComposeInternalClasses.setSelected(settings.getFilterComposeRuntimeClasses());
    }

    public boolean isModified(@NotNull ComposeDebuggerSettings settings) {
        return this.filterComposeInternalClasses.isSelected() != settings.getFilterComposeRuntimeClasses();
    }

    public void apply(@NotNull ComposeDebuggerSettings settings) {
        settings.setFilterComposeRuntimeClasses(this.filterComposeInternalClasses.isSelected());
    }

    @NotNull
    public JComponent getComponent() {
        return this.myPanel;
    }

    private void setupUI() {
        this.myPanel = new JPanel();
        this.myPanel.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1));
        this.filterComposeInternalClasses = new JCheckBox();
        this.loadButtonText(this.filterComposeInternalClasses, ComposeBundle.message("filter.ignore.compose.runtime.classes", new Object[0]));
        this.myPanel.add((Component)this.filterComposeInternalClasses, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null, 0, false));
        Spacer spacer1 = new Spacer();
        this.myPanel.add((Component)spacer1, new GridConstraints(1, 0, 1, 1, 0, 2, 1, 4, null, null, null, 0, false));
    }

    private void loadButtonText(AbstractButton component, String text) {
        TextWithMnemonic textWithMnemonic = TextWithMnemonic.parse((String)text);
        component.setText(text);
        if (textWithMnemonic.hasMnemonic()) {
            component.setMnemonic(textWithMnemonic.getMnemonicCode());
            component.setDisplayedMnemonicIndex(textWithMnemonic.getMnemonicIndex());
        }
    }
}

