/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.clangFormat.settings;

import com.intellij.application.options.CodeStyle;
import com.intellij.ide.actions.OpenFileAction;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.progress.util.ProgressIndicatorUtils;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.openapi.ui.popup.BalloonBuilder;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.CustomStatusBarWidget;
import com.intellij.openapi.wm.IdeFrame;
import com.intellij.openapi.wm.StatusBarWidget;
import com.intellij.openapi.wm.ex.WindowManagerEx;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.codeStyle.IndentStatusBarUIContributor;
import com.intellij.psi.codeStyle.modifier.TransientCodeStyleSettings;
import com.intellij.psi.codeStyle.statusbar.CodeStyleStatusBarWidgetFactory;
import com.intellij.util.Alarm;
import com.intellij.util.CoroutineScopeKt;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatChangeSettingsProvider;
import com.jetbrains.cidr.lang.daemon.clang.format.ClangFormatFileUtils;
import com.jetbrains.cidr.lang.ui.OCLongActionUtil;
import com.jetbrains.clangFormat.ClangFormatCoroutineScope;
import com.jetbrains.clangFormat.ClangFormatUtils;
import com.jetbrains.clangFormat.messages.ClangFormatBundle;
import com.jetbrains.clangFormat.settings.ClangFormatSettings;
import icons.CidrClangFormatCommonIcons;
import java.util.ArrayList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.PropertyKey;

public class ClangFormatStatusUIContributor
extends IndentStatusBarUIContributor {
    private final PsiFile myAnchorCodeFile;

    public ClangFormatStatusUIContributor(@NotNull TransientCodeStyleSettings transientSettings) {
        if (transientSettings == null) {
            ClangFormatStatusUIContributor.$$$reportNull$$$0(0);
        }
        super(ClangFormatFileUtils.getOverriddenIndentOptions(transientSettings));
        PsiFile codeFile = transientSettings.getPsiFile();
        PsiFile anchorFile = codeFile == null ? null : ClangFormatUtils.getAnchorFile(codeFile);
        this.myAnchorCodeFile = anchorFile != null ? anchorFile : codeFile;
    }

    public boolean areActionsAvailable(@NotNull VirtualFile codeFile) {
        if (codeFile == null) {
            ClangFormatStatusUIContributor.$$$reportNull$$$0(1);
        }
        return true;
    }

    public AnAction @Nullable [] getActions(@NotNull PsiFile codeFile) {
        if (codeFile == null) {
            ClangFormatStatusUIContributor.$$$reportNull$$$0(2);
        }
        if (this.myAnchorCodeFile == null) {
            return AnAction.EMPTY_ARRAY;
        }
        ClangFormatChangeSettingsProvider provider = ClangFormatUtils.findApplicableClangFormatProvider(this.myAnchorCodeFile);
        ArrayList<Object> actions = new ArrayList<Object>();
        Project project = this.myAnchorCodeFile.getProject();
        ClangFormatSettings clangFormatSettings = (ClangFormatSettings)CodeStyle.getCustomSettings((PsiFile)this.myAnchorCodeFile, ClangFormatSettings.class);
        if (clangFormatSettings.ENABLED && provider != null && provider.isActive(project, this.myAnchorCodeFile.getFileType())) {
            ClangFormatFileUtils.saveAllClangFormatDocuments();
            String content = StringUtil.notNullize((String)((String)ProgressIndicatorUtils.withTimeout((long)OCLongActionUtil.getTimeoutInMs(), () -> ClangFormatUtils.getContent(this.myAnchorCodeFile))));
            if (!content.isEmpty()) {
                VirtualFile creationDir;
                String fileName = this.myAnchorCodeFile.getName();
                VirtualFile vtClangFormat = ClangFormatFileUtils.getClangFormatFile(clangFormatSettings.SOURCE_URL, true);
                if (vtClangFormat != null) {
                    actions.add(DumbAwareAction.create((String)ClangFormatBundle.message("cf.action.open.file", new Object[0]), event -> OpenFileAction.openFile((VirtualFile)vtClangFormat, (Project)project)));
                } else if (!ClangFormatUtils.isErrorContent(content) && (creationDir = ClangFormatUtils.getDirectoryForCreationOfClangFormatFileIfPossible(project, this.myAnchorCodeFile.getVirtualFile())) != null) {
                    actions.add(DumbAwareAction.create((String)ClangFormatBundle.message("cf.action.create.file", new Object[0]), event -> ClangFormatUtils.exportSettingsToClangFormatFileInDirectoryAndUpdateSettingsFromIt(project, creationDir)));
                }
                actions.add(DumbAwareAction.create((String)ClangFormatBundle.message("cf.action.open.full.set", new Object[0]), event -> OpenFileAction.openFile((VirtualFile)ClangFormatUtils.getActualClangFormatOptionsFile(content, fileName), (Project)project)));
            }
            actions.add(DumbAwareAction.create((String)ClangFormatBundle.message("cf.action.disable", new Object[0]), e -> ClangFormatUtils.setClangFormatEnabled(project, false, true)));
        } else {
            actions.add(CodeStyleStatusBarWidgetFactory.createDefaultIndentConfigureAction((PsiFile)this.myAnchorCodeFile));
            if (provider != null) {
                actions.add(ClangFormatUtils.getActivatingAction(project));
            }
        }
        return actions.toArray(AnAction.EMPTY_ARRAY);
    }

    @Nullable
    public String getActionGroupTitle() {
        return this.getStringWithAdvertise(super.getActionGroupTitle(), ClangFormatBundle.message("cf.action.group.title", new Object[0]), false);
    }

    public Icon getIcon() {
        if (Registry.is((String)"editor.indentProviderUX.new")) {
            return CidrClangFormatCommonIcons.ClangFormat;
        }
        return null;
    }

    @NotNull
    public String getStatusText(@NotNull PsiFile codeFile) {
        if (codeFile == null) {
            ClangFormatStatusUIContributor.$$$reportNull$$$0(3);
        }
        String string = this.getStringWithAdvertise(super.getStatusText(this.myAnchorCodeFile == null ? codeFile : this.myAnchorCodeFile), (Registry.is((String)"editor.indentProviderUX.new") ? "" : "CF: ") + ClangFormatStatusUIContributor.getIndentInfo((CommonCodeStyleSettings.IndentOptions)this.getIndentOptions()), true);
        if (string == null) {
            ClangFormatStatusUIContributor.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NlsContexts.PopupTitle
    @Contract(value="null, _, _ -> null")
    public String getStringWithAdvertise(@NlsContexts.PopupTitle @Nullable String disabledText, @NlsContexts.PopupTitle @Nullable String enabledText, boolean withAdvertise) {
        ClangFormatSettings cf = (ClangFormatSettings)CodeStyle.getCustomSettings((PsiFile)this.myAnchorCodeFile, ClangFormatSettings.class);
        if (withAdvertise) {
            ClangFormatStatusUIContributor.advertise(this.myAnchorCodeFile.getProject(), cf);
        }
        if (cf.ENABLED && ClangFormatUtils.findActiveClangFormatProvider(this.myAnchorCodeFile) != null) {
            return enabledText;
        }
        return disabledText;
    }

    @Nullable
    public AnAction createDisableAction(@NotNull Project project) {
        if (project == null) {
            ClangFormatStatusUIContributor.$$$reportNull$$$0(5);
        }
        return null;
    }

    @Nullable
    public String getHint() {
        if (this.myAnchorCodeFile != null && ClangFormatUtils.findActiveClangFormatProvider(this.myAnchorCodeFile) != null) {
            return ClangFormatBundle.message("cf.hint.text.overridden", new Object[0]);
        }
        return null;
    }

    private static void advertise(@NotNull Project project, @NotNull ClangFormatSettings cf) {
        String message;
        if (project == null) {
            ClangFormatStatusUIContributor.$$$reportNull$$$0(6);
        }
        if (cf == null) {
            ClangFormatStatusUIContributor.$$$reportNull$$$0(7);
        }
        if ((message = ClangFormatStatusUIContributor.getAdvertisementText(project, cf)) != null) {
            CoroutineScope coroutineScope = ClangFormatCoroutineScope.getInstance(project).getCoroutineScope();
            Disposable disposable = CoroutineScopeKt.asDisposable((CoroutineScope)coroutineScope);
            Alarm alarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, disposable);
            alarm.addRequest(() -> {
                StatusBarWidget widget;
                BalloonBuilder builder = JBPopupFactory.getInstance().createBalloonBuilder((JComponent)new JLabel(message));
                IdeFrame frame = WindowManagerEx.getInstanceEx().findFrameFor(project);
                if (frame != null && frame.getStatusBar() != null && (widget = frame.getStatusBar().getWidget("CodeStyleStatusBarWidget")) instanceof CustomStatusBarWidget) {
                    JComponent statusBarComponent = ((CustomStatusBarWidget)widget).getComponent();
                    Balloon balloon = builder.setCalloutShift(statusBarComponent.getHeight() / 2).setDisposable(disposable).setHideOnClickOutside(true).createBalloon();
                    balloon.showInCenterOf(statusBarComponent);
                }
            }, 500, ModalityState.nonModal());
        }
    }

    @Nullable
    @Nls
    private static String getAdvertisementText(@NotNull Project project, @NotNull ClangFormatSettings cf) {
        if (project == null) {
            ClangFormatStatusUIContributor.$$$reportNull$$$0(8);
        }
        if (cf == null) {
            ClangFormatStatusUIContributor.$$$reportNull$$$0(9);
        }
        PropertiesComponent projectProperties = PropertiesComponent.getInstance((Project)project);
        if (cf.ENABLED) {
            return ClangFormatStatusUIContributor.getAdvertisementMessage(projectProperties, "cf.advertisement.text.overridden");
        }
        if (ClangFormatFileUtils.getClangFormatFile(cf.SOURCE_URL, true) != null) {
            return ClangFormatStatusUIContributor.getAdvertisementMessage(projectProperties, "cf.advertisement.text.has.clang-format");
        }
        return null;
    }

    @Nullable
    @Nls
    @NlsSafe
    private static String getAdvertisementMessage(@NotNull PropertiesComponent projectProperties, @PropertyKey(resourceBundle="messages.ClangFormatBundle") @NotNull @PropertyKey(resourceBundle="messages.ClangFormatBundle") @NotNull String messageId) {
        if (projectProperties == null) {
            ClangFormatStatusUIContributor.$$$reportNull$$$0(10);
        }
        if (messageId == null) {
            ClangFormatStatusUIContributor.$$$reportNull$$$0(11);
        }
        if (projectProperties.getBoolean(messageId)) {
            return null;
        }
        projectProperties.setValue(messageId, true);
        return ClangFormatBundle.message(messageId, new Object[0]);
    }

    public boolean isShowFileIndentOptionsEnabled() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 4 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "transientSettings";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFile";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/clangFormat/settings/ClangFormatStatusUIContributor";
                break;
            }
            case 5: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cf";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectProperties";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "messageId";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/clangFormat/settings/ClangFormatStatusUIContributor";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusText";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "areActionsAvailable";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getActions";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getStatusText";
                break;
            }
            case 4: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "createDisableAction";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "advertise";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getAdvertisementText";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "getAdvertisementMessage";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 4 -> new IllegalStateException(string);
        };
    }
}

