/*
 * Decompiled with CFR 0.152.
 */
package com.anthropic.helpers;

import com.anthropic.core.JsonObject;
import com.anthropic.core.ObjectMappers;
import com.anthropic.errors.AnthropicInvalidDataException;
import com.anthropic.helpers.BetaMessageAccumulator;
import com.anthropic.helpers.BetaMessageAccumulatorKt;
import com.anthropic.models.beta.messages.BetaBashCodeExecutionToolResultBlock;
import com.anthropic.models.beta.messages.BetaCitationCharLocation;
import com.anthropic.models.beta.messages.BetaCitationContentBlockLocation;
import com.anthropic.models.beta.messages.BetaCitationPageLocation;
import com.anthropic.models.beta.messages.BetaCitationSearchResultLocation;
import com.anthropic.models.beta.messages.BetaCitationsDelta;
import com.anthropic.models.beta.messages.BetaCitationsWebSearchResultLocation;
import com.anthropic.models.beta.messages.BetaCodeExecutionToolResultBlock;
import com.anthropic.models.beta.messages.BetaContainerUploadBlock;
import com.anthropic.models.beta.messages.BetaContentBlock;
import com.anthropic.models.beta.messages.BetaInputJsonDelta;
import com.anthropic.models.beta.messages.BetaMcpToolResultBlock;
import com.anthropic.models.beta.messages.BetaMcpToolUseBlock;
import com.anthropic.models.beta.messages.BetaMessage;
import com.anthropic.models.beta.messages.BetaMessageDeltaUsage;
import com.anthropic.models.beta.messages.BetaRawContentBlockDelta;
import com.anthropic.models.beta.messages.BetaRawContentBlockDeltaEvent;
import com.anthropic.models.beta.messages.BetaRawContentBlockStartEvent;
import com.anthropic.models.beta.messages.BetaRawContentBlockStopEvent;
import com.anthropic.models.beta.messages.BetaRawMessageDeltaEvent;
import com.anthropic.models.beta.messages.BetaRawMessageStartEvent;
import com.anthropic.models.beta.messages.BetaRawMessageStopEvent;
import com.anthropic.models.beta.messages.BetaRawMessageStreamEvent;
import com.anthropic.models.beta.messages.BetaRedactedThinkingBlock;
import com.anthropic.models.beta.messages.BetaServerToolUseBlock;
import com.anthropic.models.beta.messages.BetaSignatureDelta;
import com.anthropic.models.beta.messages.BetaStopReason;
import com.anthropic.models.beta.messages.BetaTextBlock;
import com.anthropic.models.beta.messages.BetaTextCitation;
import com.anthropic.models.beta.messages.BetaTextDelta;
import com.anthropic.models.beta.messages.BetaTextEditorCodeExecutionToolResultBlock;
import com.anthropic.models.beta.messages.BetaThinkingBlock;
import com.anthropic.models.beta.messages.BetaThinkingDelta;
import com.anthropic.models.beta.messages.BetaToolUseBlock;
import com.anthropic.models.beta.messages.BetaUsage;
import com.anthropic.models.beta.messages.BetaWebFetchToolResultBlock;
import com.anthropic.models.beta.messages.BetaWebSearchToolResultBlock;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0010J\u0006\u0010\u0003\u001a\u00020\u0004J\b\u0010\u0012\u001a\u00020\u0006H\u0002J\b\u0010\u0013\u001a\u00020\u000eH\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\f0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/anthropic/helpers/BetaMessageAccumulator;", "", "()V", "message", "Lcom/anthropic/models/beta/messages/BetaMessage;", "messageBuilder", "Lcom/anthropic/models/beta/messages/BetaMessage$Builder;", "messageContent", "", "", "Lcom/anthropic/models/beta/messages/BetaContentBlock;", "messageContentInputJson", "", "messageUsage", "Lcom/anthropic/models/beta/messages/BetaUsage;", "accumulate", "Lcom/anthropic/models/beta/messages/BetaRawMessageStreamEvent;", "event", "requireMessageBuilder", "requireMessageUsage", "Companion", "anthropic-java-core"})
@SourceDebugExtension(value={"SMAP\nBetaMessageAccumulator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BetaMessageAccumulator.kt\ncom/anthropic/helpers/BetaMessageAccumulator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,499:1\n1#2:500\n*E\n"})
public final class BetaMessageAccumulator {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private BetaMessage message;
    @Nullable
    private BetaMessage.Builder messageBuilder;
    @Nullable
    private BetaUsage messageUsage;
    @NotNull
    private final Map<Long, BetaContentBlock> messageContent = new LinkedHashMap();
    @NotNull
    private final Map<Long, String> messageContentInputJson = new LinkedHashMap();
    @NotNull
    private static final JsonMapper JSON_MAPPER = ObjectMappers.jsonMapper();

    private BetaMessageAccumulator() {
    }

    @NotNull
    public final BetaMessage message() {
        BetaMessage betaMessage = this.message;
        if (betaMessage == null) {
            boolean bl = false;
            String string = "'message_stop' event not yet received.";
            throw new IllegalStateException(string.toString());
        }
        return betaMessage;
    }

    @NotNull
    public final BetaRawMessageStreamEvent accumulate(@NotNull BetaRawMessageStreamEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.message != null) {
            throw new AnthropicInvalidDataException("'message_stop' event already received.", null, 2, null);
        }
        event.accept((BetaRawMessageStreamEvent.Visitor)new BetaRawMessageStreamEvent.Visitor<Unit>(this){
            final /* synthetic */ BetaMessageAccumulator this$0;
            {
                this.this$0 = $receiver;
            }

            public void visitMessageStart(@NotNull BetaRawMessageStartEvent start) {
                Intrinsics.checkNotNullParameter((Object)start, (String)"start");
                if (BetaMessageAccumulator.access$getMessageBuilder$p(this.this$0) != null) {
                    throw new AnthropicInvalidDataException("'message_start' event already received.", null, 2, null);
                }
                BetaMessageAccumulator.access$setMessageBuilder$p(this.this$0, start.message().toBuilder());
                BetaMessageAccumulator.access$setMessageUsage$p(this.this$0, start.message().usage());
            }

            public void visitMessageDelta(@NotNull BetaRawMessageDeltaEvent deltaEvent) {
                Intrinsics.checkNotNullParameter((Object)deltaEvent, (String)"deltaEvent");
                BetaRawMessageDeltaEvent.Delta delta = deltaEvent.delta();
                if (delta._stopReason().isNull()) {
                    BetaMessageAccumulator.access$requireMessageBuilder(this.this$0).stopReason((BetaStopReason)null);
                } else if (!delta._stopReason().isMissing()) {
                    BetaMessageAccumulator.access$requireMessageBuilder(this.this$0).stopReason(delta.stopReason());
                }
                if (delta._stopSequence().isNull()) {
                    BetaMessageAccumulator.access$requireMessageBuilder(this.this$0).stopSequence((String)null);
                } else if (!delta._stopSequence().isMissing()) {
                    BetaMessageAccumulator.access$requireMessageBuilder(this.this$0).stopSequence(delta.stopSequence().get());
                }
                if (delta.container().isPresent()) {
                    BetaMessageAccumulator.access$requireMessageBuilder(this.this$0).container(delta.container().get());
                }
                if (deltaEvent.contextManagement().isPresent()) {
                    BetaMessageAccumulator.access$requireMessageBuilder(this.this$0).contextManagement(deltaEvent.contextManagement().get());
                }
                BetaMessageAccumulator.access$setMessageUsage$p(this.this$0, BetaMessageAccumulator.Companion.mergeMessageUsage$anthropic_java_core(BetaMessageAccumulator.access$requireMessageUsage(this.this$0), deltaEvent.usage()));
            }

            /*
             * WARNING - void declaration
             */
            public void visitMessageStop(@NotNull BetaRawMessageStopEvent stop) {
                Collection<BetaContentBlock> collection;
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                Intrinsics.checkNotNullParameter((Object)stop, (String)"stop");
                Iterable $this$sortedBy$iv = BetaMessageAccumulator.access$getMessageContent$p(this.this$0).entrySet();
                boolean $i$f$sortedBy = false;
                $this$sortedBy$iv = CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        Map.Entry it = (Map.Entry)a;
                        boolean bl = false;
                        Comparable comparable = (Long)it.getKey();
                        it = (Map.Entry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Long)it.getKey()));
                    }
                });
                BetaMessage.Builder builder = BetaMessageAccumulator.access$requireMessageBuilder(this.this$0);
                BetaMessageAccumulator betaMessageAccumulator = this.this$0;
                boolean $i$f$map = false;
                void var4_6 = $this$map$iv;
                Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (T item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    Map.Entry entry = (Map.Entry)item$iv$iv;
                    collection = destination$iv$iv;
                    boolean bl = false;
                    collection.add((BetaContentBlock)it.getValue());
                }
                collection = (List)destination$iv$iv;
                BetaMessageAccumulator.access$setMessage$p(betaMessageAccumulator, builder.content((List<BetaContentBlock>)collection).usage(BetaMessageAccumulator.access$requireMessageUsage(this.this$0)).build());
                BetaMessageAccumulator.access$setMessageBuilder$p(this.this$0, null);
            }

            public void visitContentBlockStart(@NotNull BetaRawContentBlockStartEvent contentBlockStart) {
                Intrinsics.checkNotNullParameter((Object)contentBlockStart, (String)"contentBlockStart");
                long index = contentBlockStart.index();
                if (BetaMessageAccumulator.access$getMessageContent$p(this.this$0).get(index) != null) {
                    throw new AnthropicInvalidDataException("Content block already started for index " + index + '.', null, 2, null);
                }
                Long l = index;
                BetaMessageAccumulator.access$getMessageContent$p(this.this$0).put(l, contentBlockStart.contentBlock().accept((BetaRawContentBlockStartEvent.ContentBlock.Visitor)new BetaRawContentBlockStartEvent.ContentBlock.Visitor<BetaContentBlock>(){

                    @NotNull
                    public BetaContentBlock visitText(@NotNull BetaTextBlock betaText) {
                        Intrinsics.checkNotNullParameter((Object)betaText, (String)"betaText");
                        return BetaContentBlock.Companion.ofText(betaText);
                    }

                    @NotNull
                    public BetaContentBlock visitToolUse(@NotNull BetaToolUseBlock betaToolUse) {
                        Intrinsics.checkNotNullParameter((Object)betaToolUse, (String)"betaToolUse");
                        return BetaContentBlock.Companion.ofToolUse(betaToolUse);
                    }

                    @NotNull
                    public BetaContentBlock visitServerToolUse(@NotNull BetaServerToolUseBlock betaServerToolUse) {
                        Intrinsics.checkNotNullParameter((Object)betaServerToolUse, (String)"betaServerToolUse");
                        return BetaContentBlock.Companion.ofServerToolUse(betaServerToolUse);
                    }

                    @NotNull
                    public BetaContentBlock visitWebFetchToolResult(@NotNull BetaWebFetchToolResultBlock webFetchToolResult) {
                        Intrinsics.checkNotNullParameter((Object)webFetchToolResult, (String)"webFetchToolResult");
                        return BetaContentBlock.Companion.ofWebFetchToolResult(webFetchToolResult);
                    }

                    @NotNull
                    public BetaContentBlock visitWebSearchToolResult(@NotNull BetaWebSearchToolResultBlock betaWebSearchToolResult) {
                        Intrinsics.checkNotNullParameter((Object)betaWebSearchToolResult, (String)"betaWebSearchToolResult");
                        return BetaContentBlock.Companion.ofWebSearchToolResult(betaWebSearchToolResult);
                    }

                    @NotNull
                    public BetaContentBlock visitCodeExecutionToolResult(@NotNull BetaCodeExecutionToolResultBlock codeExecutionToolResult) {
                        Intrinsics.checkNotNullParameter((Object)codeExecutionToolResult, (String)"codeExecutionToolResult");
                        return BetaContentBlock.Companion.ofCodeExecutionToolResult(codeExecutionToolResult);
                    }

                    @NotNull
                    public BetaContentBlock visitBashCodeExecutionToolResult(@NotNull BetaBashCodeExecutionToolResultBlock bashCodeExecutionToolResult) {
                        Intrinsics.checkNotNullParameter((Object)bashCodeExecutionToolResult, (String)"bashCodeExecutionToolResult");
                        return BetaContentBlock.Companion.ofBashCodeExecutionToolResult(bashCodeExecutionToolResult);
                    }

                    @NotNull
                    public BetaContentBlock visitTextEditorCodeExecutionToolResult(@NotNull BetaTextEditorCodeExecutionToolResultBlock textEditorCodeExecutionToolResult) {
                        Intrinsics.checkNotNullParameter((Object)textEditorCodeExecutionToolResult, (String)"textEditorCodeExecutionToolResult");
                        return BetaContentBlock.Companion.ofTextEditorCodeExecutionToolResult(textEditorCodeExecutionToolResult);
                    }

                    @NotNull
                    public BetaContentBlock visitMcpToolUse(@NotNull BetaMcpToolUseBlock mcpToolUse) {
                        Intrinsics.checkNotNullParameter((Object)mcpToolUse, (String)"mcpToolUse");
                        return BetaContentBlock.Companion.ofMcpToolUse(mcpToolUse);
                    }

                    @NotNull
                    public BetaContentBlock visitMcpToolResult(@NotNull BetaMcpToolResultBlock mcpToolResult) {
                        Intrinsics.checkNotNullParameter((Object)mcpToolResult, (String)"mcpToolResult");
                        return BetaContentBlock.Companion.ofMcpToolResult(mcpToolResult);
                    }

                    @NotNull
                    public BetaContentBlock visitContainerUpload(@NotNull BetaContainerUploadBlock containerUpload) {
                        Intrinsics.checkNotNullParameter((Object)containerUpload, (String)"containerUpload");
                        return BetaContentBlock.Companion.ofContainerUpload(containerUpload);
                    }

                    @NotNull
                    public BetaContentBlock visitThinking(@NotNull BetaThinkingBlock betaThinking) {
                        Intrinsics.checkNotNullParameter((Object)betaThinking, (String)"betaThinking");
                        return BetaContentBlock.Companion.ofThinking(betaThinking);
                    }

                    @NotNull
                    public BetaContentBlock visitRedactedThinking(@NotNull BetaRedactedThinkingBlock betaRedactedThinking) {
                        Intrinsics.checkNotNullParameter((Object)betaRedactedThinking, (String)"betaRedactedThinking");
                        return BetaContentBlock.Companion.ofRedactedThinking(betaRedactedThinking);
                    }
                }));
            }

            public void visitContentBlockDelta(@NotNull BetaRawContentBlockDeltaEvent contentBlockDelta) {
                Intrinsics.checkNotNullParameter((Object)contentBlockDelta, (String)"contentBlockDelta");
                long index = contentBlockDelta.index();
                BetaContentBlock betaContentBlock = (BetaContentBlock)BetaMessageAccumulator.access$getMessageContent$p(this.this$0).get(index);
                if (betaContentBlock == null) {
                    throw new AnthropicInvalidDataException("Content block not started for index " + index + '.', null, 2, null);
                }
                BetaContentBlock oldContentBlock = betaContentBlock;
                Long l = index;
                BetaMessageAccumulator.access$getMessageContent$p(this.this$0).put(l, contentBlockDelta.delta().accept((BetaRawContentBlockDelta.Visitor)new BetaRawContentBlockDelta.Visitor<BetaContentBlock>(oldContentBlock, this.this$0, index){
                    final /* synthetic */ BetaContentBlock $oldContentBlock;
                    final /* synthetic */ BetaMessageAccumulator this$0;
                    final /* synthetic */ long $index;
                    {
                        this.$oldContentBlock = $oldContentBlock;
                        this.this$0 = $receiver;
                        this.$index = $index;
                    }

                    @NotNull
                    public BetaContentBlock visitText(@NotNull BetaTextDelta text) {
                        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                        return BetaMessageAccumulator.Companion.mergeTextDelta$anthropic_java_core(this.$oldContentBlock, text);
                    }

                    @NotNull
                    public BetaContentBlock visitInputJson(@NotNull BetaInputJsonDelta inputJson) {
                        Intrinsics.checkNotNullParameter((Object)inputJson, (String)"inputJson");
                        accumulate.visitContentBlockDelta.1 var2_2 = this;
                        BetaMessageAccumulator betaMessageAccumulator = this.this$0;
                        long l = this.$index;
                        BetaContentBlock betaContentBlock = this.$oldContentBlock;
                        accumulate.visitContentBlockDelta.1 $this$visitInputJson_u24lambda_u240 = var2_2;
                        boolean bl = false;
                        String oldInputJson = (String)BetaMessageAccumulator.access$getMessageContentInputJson$p(betaMessageAccumulator).get(l);
                        Long l2 = l;
                        Map map2 = BetaMessageAccumulator.access$getMessageContentInputJson$p(betaMessageAccumulator);
                        StringBuilder stringBuilder = new StringBuilder();
                        String string = oldInputJson;
                        if (string == null) {
                            string = "";
                        }
                        map2.put(l2, stringBuilder.append(string).append(inputJson.partialJson()).toString());
                        return betaContentBlock;
                    }

                    @NotNull
                    public BetaContentBlock visitCitations(@NotNull BetaCitationsDelta citations2) {
                        Intrinsics.checkNotNullParameter((Object)citations2, (String)"citations");
                        return BetaMessageAccumulator.Companion.mergeCitationsDelta$anthropic_java_core(this.$oldContentBlock, citations2);
                    }

                    @NotNull
                    public BetaContentBlock visitThinking(@NotNull BetaThinkingDelta thinking) {
                        Intrinsics.checkNotNullParameter((Object)thinking, (String)"thinking");
                        return BetaMessageAccumulator.Companion.mergeThinkingDelta$anthropic_java_core(this.$oldContentBlock, thinking);
                    }

                    @NotNull
                    public BetaContentBlock visitSignature(@NotNull BetaSignatureDelta signature) {
                        Intrinsics.checkNotNullParameter((Object)signature, (String)"signature");
                        return BetaMessageAccumulator.Companion.mergeSignatureDelta$anthropic_java_core(this.$oldContentBlock, signature);
                    }
                }));
            }

            public void visitContentBlockStop(@NotNull BetaRawContentBlockStopEvent contentBlockStop) {
                Intrinsics.checkNotNullParameter((Object)contentBlockStop, (String)"contentBlockStop");
                long index = contentBlockStop.index();
                BetaContentBlock betaContentBlock = (BetaContentBlock)BetaMessageAccumulator.access$getMessageContent$p(this.this$0).get(index);
                if (betaContentBlock == null) {
                    throw new AnthropicInvalidDataException("Content block not started for index " + index + '.', null, 2, null);
                }
                BetaContentBlock oldContentBlock = betaContentBlock;
                String inputJson = (String)BetaMessageAccumulator.access$getMessageContentInputJson$p(this.this$0).get(index);
                if (BetaMessageAccumulatorKt.tracksToolInput(oldContentBlock)) {
                    BetaContentBlock betaContentBlock2;
                    JsonObject jsonObject;
                    if (inputJson == null) {
                        throw new AnthropicInvalidDataException("Missing input JSON for index " + index + '.', null, 2, null);
                    }
                    try {
                        jsonObject = (JsonObject)BetaMessageAccumulator.access$getJSON_MAPPER$cp().readValue(inputJson, JsonObject.class);
                    }
                    catch (Exception e) {
                        throw new AnthropicInvalidDataException("Unable to parse tool parameter JSON from model. Please retry your request or adjust your prompt. Error: " + e + ". JSON: " + inputJson, null, 2, null);
                    }
                    JsonObject parsedInput = jsonObject;
                    Long l = index;
                    Map map2 = BetaMessageAccumulator.access$getMessageContent$p(this.this$0);
                    if (oldContentBlock.isToolUse()) {
                        BetaToolUseBlock.Builder builder = oldContentBlock.asToolUse().toBuilder();
                        Intrinsics.checkNotNullExpressionValue((Object)parsedInput, (String)"parsedInput");
                        betaContentBlock2 = BetaContentBlock.Companion.ofToolUse(builder.input(parsedInput).build());
                    } else if (oldContentBlock.isServerToolUse()) {
                        BetaServerToolUseBlock.Builder builder = oldContentBlock.asServerToolUse().toBuilder();
                        Intrinsics.checkNotNullExpressionValue((Object)parsedInput, (String)"parsedInput");
                        betaContentBlock2 = BetaContentBlock.Companion.ofServerToolUse(builder.input(parsedInput).build());
                    } else if (oldContentBlock.isMcpToolUse()) {
                        BetaMcpToolUseBlock.Builder builder = oldContentBlock.asMcpToolUse().toBuilder();
                        Intrinsics.checkNotNullExpressionValue((Object)parsedInput, (String)"parsedInput");
                        betaContentBlock2 = BetaContentBlock.Companion.ofMcpToolUse(builder.input(parsedInput).build());
                    } else {
                        betaContentBlock2 = oldContentBlock;
                    }
                    map2.put(l, betaContentBlock2);
                }
            }
        });
        return event;
    }

    private final BetaMessage.Builder requireMessageBuilder() {
        BetaMessage.Builder builder = this.messageBuilder;
        if (builder == null) {
            throw new AnthropicInvalidDataException("'message_start' event not received.", null, 2, null);
        }
        return builder;
    }

    private final BetaUsage requireMessageUsage() {
        BetaUsage betaUsage = this.messageUsage;
        if (betaUsage == null) {
            throw new AnthropicInvalidDataException("'message_start' event not received.", null, 2, null);
        }
        return betaUsage;
    }

    @JvmStatic
    @NotNull
    public static final BetaMessageAccumulator create() {
        return Companion.create();
    }

    public /* synthetic */ BetaMessageAccumulator(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    public static final /* synthetic */ BetaMessage.Builder access$getMessageBuilder$p(BetaMessageAccumulator $this) {
        return $this.messageBuilder;
    }

    public static final /* synthetic */ void access$setMessageBuilder$p(BetaMessageAccumulator $this, BetaMessage.Builder builder) {
        $this.messageBuilder = builder;
    }

    public static final /* synthetic */ void access$setMessageUsage$p(BetaMessageAccumulator $this, BetaUsage betaUsage) {
        $this.messageUsage = betaUsage;
    }

    public static final /* synthetic */ BetaMessage.Builder access$requireMessageBuilder(BetaMessageAccumulator $this) {
        return $this.requireMessageBuilder();
    }

    public static final /* synthetic */ BetaUsage access$requireMessageUsage(BetaMessageAccumulator $this) {
        return $this.requireMessageUsage();
    }

    public static final /* synthetic */ void access$setMessage$p(BetaMessageAccumulator $this, BetaMessage betaMessage) {
        $this.message = betaMessage;
    }

    public static final /* synthetic */ Map access$getMessageContent$p(BetaMessageAccumulator $this) {
        return $this.messageContent;
    }

    public static final /* synthetic */ Map access$getMessageContentInputJson$p(BetaMessageAccumulator $this) {
        return $this.messageContentInputJson;
    }

    public static final /* synthetic */ JsonMapper access$getJSON_MAPPER$cp() {
        return JSON_MAPPER;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\b\u0010\n\u001a\u00020\u000bH\u0007J\u001d\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u000fJ\u001d\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0000\u00a2\u0006\u0002\b\u0015J\u001d\u0010\u0016\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0017\u001a\u00020\u0018H\u0000\u00a2\u0006\u0002\b\u0019J\u001d\u0010\u001a\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0000\u00a2\u0006\u0002\b\u001dJ\u001d\u0010\u001e\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001f\u001a\u00020 H\u0000\u00a2\u0006\u0002\b!R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lcom/anthropic/helpers/BetaMessageAccumulator$Companion;", "", "()V", "JSON_MAPPER", "Lcom/fasterxml/jackson/databind/json/JsonMapper;", "citationsDeltaToTextCitation", "Lcom/anthropic/models/beta/messages/BetaTextCitation;", "citationsDelta", "Lcom/anthropic/models/beta/messages/BetaCitationsDelta;", "citationsDeltaToTextCitation$anthropic_java_core", "create", "Lcom/anthropic/helpers/BetaMessageAccumulator;", "mergeCitationsDelta", "Lcom/anthropic/models/beta/messages/BetaContentBlock;", "contentBlock", "mergeCitationsDelta$anthropic_java_core", "mergeMessageUsage", "Lcom/anthropic/models/beta/messages/BetaUsage;", "usage", "deltaUsage", "Lcom/anthropic/models/beta/messages/BetaMessageDeltaUsage;", "mergeMessageUsage$anthropic_java_core", "mergeSignatureDelta", "signatureDelta", "Lcom/anthropic/models/beta/messages/BetaSignatureDelta;", "mergeSignatureDelta$anthropic_java_core", "mergeTextDelta", "textDelta", "Lcom/anthropic/models/beta/messages/BetaTextDelta;", "mergeTextDelta$anthropic_java_core", "mergeThinkingDelta", "thinkingDelta", "Lcom/anthropic/models/beta/messages/BetaThinkingDelta;", "mergeThinkingDelta$anthropic_java_core", "anthropic-java-core"})
    @SourceDebugExtension(value={"SMAP\nBetaMessageAccumulator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BetaMessageAccumulator.kt\ncom/anthropic/helpers/BetaMessageAccumulator$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,499:1\n1#2:500\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final BetaMessageAccumulator create() {
            return new BetaMessageAccumulator(null);
        }

        public final /* synthetic */ BetaUsage mergeMessageUsage$anthropic_java_core(BetaUsage usage, BetaMessageDeltaUsage deltaUsage) {
            Intrinsics.checkNotNullParameter((Object)usage, (String)"usage");
            Intrinsics.checkNotNullParameter((Object)deltaUsage, (String)"deltaUsage");
            BetaUsage.Builder builder = usage.toBuilder();
            if (!deltaUsage._outputTokens().isMissing()) {
                builder.outputTokens(deltaUsage.outputTokens());
            }
            if (!deltaUsage._inputTokens().isMissing()) {
                Long l = deltaUsage.inputTokens().orElse(0L);
                Intrinsics.checkNotNullExpressionValue((Object)l, (String)"deltaUsage.inputTokens().orElse(0)");
                builder.inputTokens(((Number)l).longValue());
            }
            if (!deltaUsage._cacheCreationInputTokens().isMissing()) {
                builder.cacheCreationInputTokens(deltaUsage.cacheCreationInputTokens());
            }
            if (!deltaUsage._cacheReadInputTokens().isMissing()) {
                builder.cacheReadInputTokens(deltaUsage.cacheReadInputTokens());
            }
            if (!deltaUsage._serverToolUse().isMissing()) {
                builder.serverToolUse(deltaUsage.serverToolUse());
            }
            return builder.build();
        }

        public final /* synthetic */ BetaContentBlock mergeTextDelta$anthropic_java_core(BetaContentBlock contentBlock, BetaTextDelta textDelta) {
            Intrinsics.checkNotNullParameter((Object)contentBlock, (String)"contentBlock");
            Intrinsics.checkNotNullParameter((Object)textDelta, (String)"textDelta");
            if (!contentBlock.isText()) {
                boolean $i$a$-require-BetaMessageAccumulator$Companion$mergeTextDelta$22 = false;
                String $i$a$-require-BetaMessageAccumulator$Companion$mergeTextDelta$22 = "Content block is not a text block.";
                throw new IllegalArgumentException($i$a$-require-BetaMessageAccumulator$Companion$mergeTextDelta$22.toString());
            }
            BetaTextBlock oldTextBlock = contentBlock.asText();
            BetaTextBlock newTextBlock = oldTextBlock.toBuilder().text(oldTextBlock.text() + textDelta.text()).build();
            return BetaContentBlock.Companion.ofText(newTextBlock);
        }

        public final /* synthetic */ BetaContentBlock mergeCitationsDelta$anthropic_java_core(BetaContentBlock contentBlock, BetaCitationsDelta citationsDelta) {
            Intrinsics.checkNotNullParameter((Object)contentBlock, (String)"contentBlock");
            Intrinsics.checkNotNullParameter((Object)citationsDelta, (String)"citationsDelta");
            if (!contentBlock.isText()) {
                boolean $i$a$-require-BetaMessageAccumulator$Companion$mergeCitationsDelta$22 = false;
                String $i$a$-require-BetaMessageAccumulator$Companion$mergeCitationsDelta$22 = "Content block is not a text block.";
                throw new IllegalArgumentException($i$a$-require-BetaMessageAccumulator$Companion$mergeCitationsDelta$22.toString());
            }
            BetaTextBlock oldTextBlock = contentBlock.asText();
            BetaTextBlock newTextBlock = oldTextBlock.toBuilder().addCitation(this.citationsDeltaToTextCitation$anthropic_java_core(citationsDelta)).build();
            return BetaContentBlock.Companion.ofText(newTextBlock);
        }

        public final /* synthetic */ BetaContentBlock mergeThinkingDelta$anthropic_java_core(BetaContentBlock contentBlock, BetaThinkingDelta thinkingDelta) {
            Intrinsics.checkNotNullParameter((Object)contentBlock, (String)"contentBlock");
            Intrinsics.checkNotNullParameter((Object)thinkingDelta, (String)"thinkingDelta");
            if (!contentBlock.isThinking()) {
                boolean $i$a$-require-BetaMessageAccumulator$Companion$mergeThinkingDelta$22 = false;
                String $i$a$-require-BetaMessageAccumulator$Companion$mergeThinkingDelta$22 = "Content block is not a thinking block.";
                throw new IllegalArgumentException($i$a$-require-BetaMessageAccumulator$Companion$mergeThinkingDelta$22.toString());
            }
            BetaThinkingBlock oldThinkingBlock = contentBlock.asThinking();
            BetaThinkingBlock newThinkingBlock = oldThinkingBlock.toBuilder().thinking(oldThinkingBlock.thinking() + thinkingDelta.thinking()).build();
            return BetaContentBlock.Companion.ofThinking(newThinkingBlock);
        }

        public final /* synthetic */ BetaContentBlock mergeSignatureDelta$anthropic_java_core(BetaContentBlock contentBlock, BetaSignatureDelta signatureDelta) {
            Intrinsics.checkNotNullParameter((Object)contentBlock, (String)"contentBlock");
            Intrinsics.checkNotNullParameter((Object)signatureDelta, (String)"signatureDelta");
            if (!contentBlock.isThinking()) {
                boolean $i$a$-require-BetaMessageAccumulator$Companion$mergeSignatureDelta$22 = false;
                String $i$a$-require-BetaMessageAccumulator$Companion$mergeSignatureDelta$22 = "Content block is not a thinking block.";
                throw new IllegalArgumentException($i$a$-require-BetaMessageAccumulator$Companion$mergeSignatureDelta$22.toString());
            }
            BetaThinkingBlock oldThinkingBlock = contentBlock.asThinking();
            BetaThinkingBlock newThinkingBlock = oldThinkingBlock.toBuilder().signature(signatureDelta.signature()).build();
            return BetaContentBlock.Companion.ofThinking(newThinkingBlock);
        }

        public final /* synthetic */ BetaTextCitation citationsDeltaToTextCitation$anthropic_java_core(BetaCitationsDelta citationsDelta) {
            Intrinsics.checkNotNullParameter((Object)citationsDelta, (String)"citationsDelta");
            return (BetaTextCitation)citationsDelta.citation().accept((BetaCitationsDelta.Citation.Visitor)new BetaCitationsDelta.Citation.Visitor<BetaTextCitation>(){

                @NotNull
                public BetaTextCitation visitCharLocation(@NotNull BetaCitationCharLocation charLocation) {
                    Intrinsics.checkNotNullParameter((Object)charLocation, (String)"charLocation");
                    return BetaTextCitation.Companion.ofCharLocation(charLocation);
                }

                @NotNull
                public BetaTextCitation visitPageLocation(@NotNull BetaCitationPageLocation pageLocation) {
                    Intrinsics.checkNotNullParameter((Object)pageLocation, (String)"pageLocation");
                    return BetaTextCitation.Companion.ofPageLocation(pageLocation);
                }

                @NotNull
                public BetaTextCitation visitContentBlockLocation(@NotNull BetaCitationContentBlockLocation contentBlockLocation) {
                    Intrinsics.checkNotNullParameter((Object)contentBlockLocation, (String)"contentBlockLocation");
                    return BetaTextCitation.Companion.ofContentBlockLocation(contentBlockLocation);
                }

                @NotNull
                public BetaTextCitation visitWebSearchResultLocation(@NotNull BetaCitationsWebSearchResultLocation betaCitationsWebSearchResultLocation) {
                    Intrinsics.checkNotNullParameter((Object)betaCitationsWebSearchResultLocation, (String)"betaCitationsWebSearchResultLocation");
                    return BetaTextCitation.Companion.ofWebSearchResultLocation(betaCitationsWebSearchResultLocation);
                }

                @NotNull
                public BetaTextCitation visitSearchResultLocation(@NotNull BetaCitationSearchResultLocation searchResultLocation) {
                    Intrinsics.checkNotNullParameter((Object)searchResultLocation, (String)"searchResultLocation");
                    return BetaTextCitation.Companion.ofSearchResultLocation(searchResultLocation);
                }
            });
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

