/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.services.toolresults;

import com.google.api.client.googleapis.GoogleUtils;
import com.google.api.client.googleapis.services.AbstractGoogleClientRequest;
import com.google.api.client.googleapis.services.GoogleClientRequestInitializer;
import com.google.api.client.googleapis.services.json.AbstractGoogleJsonClient;
import com.google.api.client.http.HttpRequest;
import com.google.api.client.http.HttpRequestInitializer;
import com.google.api.client.http.HttpResponse;
import com.google.api.client.http.HttpTransport;
import com.google.api.client.json.JsonFactory;
import com.google.api.client.util.Key;
import com.google.api.client.util.Preconditions;
import com.google.api.services.toolresults.ToolResultsRequest;
import com.google.api.services.toolresults.ToolResultsRequestInitializer;
import com.google.api.services.toolresults.model.BatchCreatePerfSamplesRequest;
import com.google.api.services.toolresults.model.BatchCreatePerfSamplesResponse;
import com.google.api.services.toolresults.model.Environment;
import com.google.api.services.toolresults.model.Execution;
import com.google.api.services.toolresults.model.History;
import com.google.api.services.toolresults.model.ListEnvironmentsResponse;
import com.google.api.services.toolresults.model.ListExecutionsResponse;
import com.google.api.services.toolresults.model.ListHistoriesResponse;
import com.google.api.services.toolresults.model.ListPerfSampleSeriesResponse;
import com.google.api.services.toolresults.model.ListPerfSamplesResponse;
import com.google.api.services.toolresults.model.ListScreenshotClustersResponse;
import com.google.api.services.toolresults.model.ListStepAccessibilityClustersResponse;
import com.google.api.services.toolresults.model.ListStepThumbnailsResponse;
import com.google.api.services.toolresults.model.ListStepsResponse;
import com.google.api.services.toolresults.model.ListTestCasesResponse;
import com.google.api.services.toolresults.model.PerfMetricsSummary;
import com.google.api.services.toolresults.model.PerfSampleSeries;
import com.google.api.services.toolresults.model.ProjectSettings;
import com.google.api.services.toolresults.model.PublishXunitXmlFilesRequest;
import com.google.api.services.toolresults.model.ScreenshotCluster;
import com.google.api.services.toolresults.model.Step;
import com.google.api.services.toolresults.model.TestCase;
import java.io.IOException;
import java.util.List;
import java.util.regex.Pattern;

public class ToolResults
extends AbstractGoogleJsonClient {
    public static final String DEFAULT_ROOT_URL = "https://toolresults.googleapis.com/";
    public static final String DEFAULT_MTLS_ROOT_URL = "https://toolresults.mtls.googleapis.com/";
    public static final String DEFAULT_SERVICE_PATH = "";
    public static final String DEFAULT_BATCH_PATH = "batch";
    public static final String DEFAULT_BASE_URL = "https://toolresults.googleapis.com/";

    public ToolResults(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
        this(new Builder(transport, jsonFactory, httpRequestInitializer));
    }

    ToolResults(Builder builder) {
        super((AbstractGoogleJsonClient.Builder)builder);
    }

    protected void initialize(AbstractGoogleClientRequest<?> httpClientRequest) throws IOException {
        super.initialize(httpClientRequest);
    }

    public Projects projects() {
        return new Projects();
    }

    static {
        Preconditions.checkState((GoogleUtils.MAJOR_VERSION == 1 && (GoogleUtils.MINOR_VERSION >= 32 || GoogleUtils.MINOR_VERSION == 31 && GoogleUtils.BUGFIX_VERSION >= 1) || GoogleUtils.MAJOR_VERSION >= 2 ? 1 : 0) != 0, (String)"You are currently running with version %s of google-api-client. You need at least version 1.31.1 of google-api-client to run version 2.0.0 of the Cloud Tool Results API library.", (Object[])new Object[]{GoogleUtils.VERSION});
    }

    public static final class Builder
    extends AbstractGoogleJsonClient.Builder {
        private static String chooseEndpoint(HttpTransport transport) {
            String useMtlsEndpoint = System.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
            String string = useMtlsEndpoint = useMtlsEndpoint == null ? "auto" : useMtlsEndpoint;
            if ("always".equals(useMtlsEndpoint) || "auto".equals(useMtlsEndpoint) && transport != null && transport.isMtls()) {
                return ToolResults.DEFAULT_MTLS_ROOT_URL;
            }
            return "https://toolresults.googleapis.com/";
        }

        public Builder(HttpTransport transport, JsonFactory jsonFactory, HttpRequestInitializer httpRequestInitializer) {
            super(transport, jsonFactory, Builder.chooseEndpoint(transport), ToolResults.DEFAULT_SERVICE_PATH, httpRequestInitializer, false);
            this.setBatchPath(ToolResults.DEFAULT_BATCH_PATH);
        }

        public ToolResults build() {
            return new ToolResults(this);
        }

        public Builder setRootUrl(String rootUrl) {
            return (Builder)super.setRootUrl(rootUrl);
        }

        public Builder setServicePath(String servicePath) {
            return (Builder)super.setServicePath(servicePath);
        }

        public Builder setBatchPath(String batchPath) {
            return (Builder)super.setBatchPath(batchPath);
        }

        public Builder setHttpRequestInitializer(HttpRequestInitializer httpRequestInitializer) {
            return (Builder)super.setHttpRequestInitializer(httpRequestInitializer);
        }

        public Builder setApplicationName(String applicationName) {
            return (Builder)super.setApplicationName(applicationName);
        }

        public Builder setSuppressPatternChecks(boolean suppressPatternChecks) {
            return (Builder)super.setSuppressPatternChecks(suppressPatternChecks);
        }

        public Builder setSuppressRequiredParameterChecks(boolean suppressRequiredParameterChecks) {
            return (Builder)super.setSuppressRequiredParameterChecks(suppressRequiredParameterChecks);
        }

        public Builder setSuppressAllChecks(boolean suppressAllChecks) {
            return (Builder)super.setSuppressAllChecks(suppressAllChecks);
        }

        public Builder setToolResultsRequestInitializer(ToolResultsRequestInitializer toolresultsRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer((GoogleClientRequestInitializer)toolresultsRequestInitializer);
        }

        public Builder setGoogleClientRequestInitializer(GoogleClientRequestInitializer googleClientRequestInitializer) {
            return (Builder)super.setGoogleClientRequestInitializer(googleClientRequestInitializer);
        }
    }

    public class Projects {
        public GetSettings getSettings(String projectId) throws IOException {
            GetSettings result = new GetSettings(projectId);
            ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public InitializeSettings initializeSettings(String projectId) throws IOException {
            InitializeSettings result = new InitializeSettings(projectId);
            ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
            return result;
        }

        public Histories histories() {
            return new Histories();
        }

        public class Histories {
            public Create create(String projectId, History content) throws IOException {
                Create result = new Create(projectId, content);
                ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Get get(String projectId, String historyId) throws IOException {
                Get result = new Get(projectId, historyId);
                ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public List list(String projectId) throws IOException {
                List result = new List(projectId);
                ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                return result;
            }

            public Executions executions() {
                return new Executions();
            }

            public class Executions {
                public Create create(String projectId, String historyId, Execution content) throws IOException {
                    Create result = new Create(projectId, historyId, content);
                    ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Get get(String projectId, String historyId, String executionId) throws IOException {
                    Get result = new Get(projectId, historyId, executionId);
                    ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public List list(String projectId, String historyId) throws IOException {
                    List result = new List(projectId, historyId);
                    ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Patch patch(String projectId, String historyId, String executionId, Execution content) throws IOException {
                    Patch result = new Patch(projectId, historyId, executionId, content);
                    ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                    return result;
                }

                public Clusters clusters() {
                    return new Clusters();
                }

                public Environments environments() {
                    return new Environments();
                }

                public Steps steps() {
                    return new Steps();
                }

                public class Steps {
                    public AccessibilityClusters accessibilityClusters(String name) throws IOException {
                        AccessibilityClusters result = new AccessibilityClusters(name);
                        ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Create create(String projectId, String historyId, String executionId, Step content) throws IOException {
                        Create result = new Create(projectId, historyId, executionId, content);
                        ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Get get(String projectId, String historyId, String executionId, String stepId) throws IOException {
                        Get result = new Get(projectId, historyId, executionId, stepId);
                        ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public GetPerfMetricsSummary getPerfMetricsSummary(String projectId, String historyId, String executionId, String stepId) throws IOException {
                        GetPerfMetricsSummary result = new GetPerfMetricsSummary(projectId, historyId, executionId, stepId);
                        ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String projectId, String historyId, String executionId) throws IOException {
                        List result = new List(projectId, historyId, executionId);
                        ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public Patch patch(String projectId, String historyId, String executionId, String stepId, Step content) throws IOException {
                        Patch result = new Patch(projectId, historyId, executionId, stepId, content);
                        ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public PublishXunitXmlFiles publishXunitXmlFiles(String projectId, String historyId, String executionId, String stepId, PublishXunitXmlFilesRequest content) throws IOException {
                        PublishXunitXmlFiles result = new PublishXunitXmlFiles(projectId, historyId, executionId, stepId, content);
                        ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public PerfMetricsSummary perfMetricsSummary() {
                        return new PerfMetricsSummary();
                    }

                    public PerfSampleSeries perfSampleSeries() {
                        return new PerfSampleSeries();
                    }

                    public TestCases testCases() {
                        return new TestCases();
                    }

                    public Thumbnails thumbnails() {
                        return new Thumbnails();
                    }

                    public class Thumbnails {
                        public List list(String projectId, String historyId, String executionId, String stepId) throws IOException {
                            List result = new List(projectId, historyId, executionId, stepId);
                            ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public class List
                        extends ToolResultsRequest<ListStepThumbnailsResponse> {
                            private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories/{historyId}/executions/{executionId}/steps/{stepId}/thumbnails";
                            @Key
                            private String projectId;
                            @Key
                            private String historyId;
                            @Key
                            private String executionId;
                            @Key
                            private String stepId;
                            @Key
                            private Integer pageSize;
                            @Key
                            private String pageToken;

                            protected List(String projectId, String historyId, String executionId, String stepId) {
                                super(ToolResults.this, "GET", REST_PATH, null, ListStepThumbnailsResponse.class);
                                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                                this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                                this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                                this.stepId = (String)Preconditions.checkNotNull((Object)stepId, (Object)"Required parameter stepId must be specified.");
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public List set$Xgafv(String $Xgafv) {
                                return (List)super.set$Xgafv($Xgafv);
                            }

                            public List setAccessToken(String accessToken) {
                                return (List)super.setAccessToken(accessToken);
                            }

                            public List setAlt(String alt) {
                                return (List)super.setAlt(alt);
                            }

                            public List setCallback(String callback) {
                                return (List)super.setCallback(callback);
                            }

                            public List setFields(String fields) {
                                return (List)super.setFields(fields);
                            }

                            public List setKey(String key) {
                                return (List)super.setKey(key);
                            }

                            public List setOauthToken(String oauthToken) {
                                return (List)super.setOauthToken(oauthToken);
                            }

                            public List setPrettyPrint(Boolean prettyPrint) {
                                return (List)super.setPrettyPrint(prettyPrint);
                            }

                            public List setQuotaUser(String quotaUser) {
                                return (List)super.setQuotaUser(quotaUser);
                            }

                            public List setUploadType(String uploadType) {
                                return (List)super.setUploadType(uploadType);
                            }

                            public List setUploadProtocol(String uploadProtocol) {
                                return (List)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getProjectId() {
                                return this.projectId;
                            }

                            public List setProjectId(String projectId) {
                                this.projectId = projectId;
                                return this;
                            }

                            public String getHistoryId() {
                                return this.historyId;
                            }

                            public List setHistoryId(String historyId) {
                                this.historyId = historyId;
                                return this;
                            }

                            public String getExecutionId() {
                                return this.executionId;
                            }

                            public List setExecutionId(String executionId) {
                                this.executionId = executionId;
                                return this;
                            }

                            public String getStepId() {
                                return this.stepId;
                            }

                            public List setStepId(String stepId) {
                                this.stepId = stepId;
                                return this;
                            }

                            public Integer getPageSize() {
                                return this.pageSize;
                            }

                            public List setPageSize(Integer pageSize) {
                                this.pageSize = pageSize;
                                return this;
                            }

                            public String getPageToken() {
                                return this.pageToken;
                            }

                            public List setPageToken(String pageToken) {
                                this.pageToken = pageToken;
                                return this;
                            }

                            @Override
                            public List set(String parameterName, Object value) {
                                return (List)super.set(parameterName, value);
                            }
                        }
                    }

                    public class TestCases {
                        public Get get(String projectId, String historyId, String executionId, String stepId, String testCaseId) throws IOException {
                            Get result = new Get(projectId, historyId, executionId, stepId, testCaseId);
                            ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public List list(String projectId, String historyId, String executionId, String stepId) throws IOException {
                            List result = new List(projectId, historyId, executionId, stepId);
                            ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public class List
                        extends ToolResultsRequest<ListTestCasesResponse> {
                            private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories/{historyId}/executions/{executionId}/steps/{stepId}/testCases";
                            @Key
                            private String projectId;
                            @Key
                            private String historyId;
                            @Key
                            private String executionId;
                            @Key
                            private String stepId;
                            @Key
                            private Integer pageSize;
                            @Key
                            private String pageToken;

                            protected List(String projectId, String historyId, String executionId, String stepId) {
                                super(ToolResults.this, "GET", REST_PATH, null, ListTestCasesResponse.class);
                                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                                this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                                this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                                this.stepId = (String)Preconditions.checkNotNull((Object)stepId, (Object)"Required parameter stepId must be specified.");
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public List set$Xgafv(String $Xgafv) {
                                return (List)super.set$Xgafv($Xgafv);
                            }

                            public List setAccessToken(String accessToken) {
                                return (List)super.setAccessToken(accessToken);
                            }

                            public List setAlt(String alt) {
                                return (List)super.setAlt(alt);
                            }

                            public List setCallback(String callback) {
                                return (List)super.setCallback(callback);
                            }

                            public List setFields(String fields) {
                                return (List)super.setFields(fields);
                            }

                            public List setKey(String key) {
                                return (List)super.setKey(key);
                            }

                            public List setOauthToken(String oauthToken) {
                                return (List)super.setOauthToken(oauthToken);
                            }

                            public List setPrettyPrint(Boolean prettyPrint) {
                                return (List)super.setPrettyPrint(prettyPrint);
                            }

                            public List setQuotaUser(String quotaUser) {
                                return (List)super.setQuotaUser(quotaUser);
                            }

                            public List setUploadType(String uploadType) {
                                return (List)super.setUploadType(uploadType);
                            }

                            public List setUploadProtocol(String uploadProtocol) {
                                return (List)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getProjectId() {
                                return this.projectId;
                            }

                            public List setProjectId(String projectId) {
                                this.projectId = projectId;
                                return this;
                            }

                            public String getHistoryId() {
                                return this.historyId;
                            }

                            public List setHistoryId(String historyId) {
                                this.historyId = historyId;
                                return this;
                            }

                            public String getExecutionId() {
                                return this.executionId;
                            }

                            public List setExecutionId(String executionId) {
                                this.executionId = executionId;
                                return this;
                            }

                            public String getStepId() {
                                return this.stepId;
                            }

                            public List setStepId(String stepId) {
                                this.stepId = stepId;
                                return this;
                            }

                            public Integer getPageSize() {
                                return this.pageSize;
                            }

                            public List setPageSize(Integer pageSize) {
                                this.pageSize = pageSize;
                                return this;
                            }

                            public String getPageToken() {
                                return this.pageToken;
                            }

                            public List setPageToken(String pageToken) {
                                this.pageToken = pageToken;
                                return this;
                            }

                            @Override
                            public List set(String parameterName, Object value) {
                                return (List)super.set(parameterName, value);
                            }
                        }

                        public class Get
                        extends ToolResultsRequest<TestCase> {
                            private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories/{historyId}/executions/{executionId}/steps/{stepId}/testCases/{testCaseId}";
                            @Key
                            private String projectId;
                            @Key
                            private String historyId;
                            @Key
                            private String executionId;
                            @Key
                            private String stepId;
                            @Key
                            private String testCaseId;

                            protected Get(String projectId, String historyId, String executionId, String stepId, String testCaseId) {
                                super(ToolResults.this, "GET", REST_PATH, null, TestCase.class);
                                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                                this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                                this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                                this.stepId = (String)Preconditions.checkNotNull((Object)stepId, (Object)"Required parameter stepId must be specified.");
                                this.testCaseId = (String)Preconditions.checkNotNull((Object)testCaseId, (Object)"Required parameter testCaseId must be specified.");
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public Get set$Xgafv(String $Xgafv) {
                                return (Get)super.set$Xgafv($Xgafv);
                            }

                            public Get setAccessToken(String accessToken) {
                                return (Get)super.setAccessToken(accessToken);
                            }

                            public Get setAlt(String alt) {
                                return (Get)super.setAlt(alt);
                            }

                            public Get setCallback(String callback) {
                                return (Get)super.setCallback(callback);
                            }

                            public Get setFields(String fields) {
                                return (Get)super.setFields(fields);
                            }

                            public Get setKey(String key) {
                                return (Get)super.setKey(key);
                            }

                            public Get setOauthToken(String oauthToken) {
                                return (Get)super.setOauthToken(oauthToken);
                            }

                            public Get setPrettyPrint(Boolean prettyPrint) {
                                return (Get)super.setPrettyPrint(prettyPrint);
                            }

                            public Get setQuotaUser(String quotaUser) {
                                return (Get)super.setQuotaUser(quotaUser);
                            }

                            public Get setUploadType(String uploadType) {
                                return (Get)super.setUploadType(uploadType);
                            }

                            public Get setUploadProtocol(String uploadProtocol) {
                                return (Get)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getProjectId() {
                                return this.projectId;
                            }

                            public Get setProjectId(String projectId) {
                                this.projectId = projectId;
                                return this;
                            }

                            public String getHistoryId() {
                                return this.historyId;
                            }

                            public Get setHistoryId(String historyId) {
                                this.historyId = historyId;
                                return this;
                            }

                            public String getExecutionId() {
                                return this.executionId;
                            }

                            public Get setExecutionId(String executionId) {
                                this.executionId = executionId;
                                return this;
                            }

                            public String getStepId() {
                                return this.stepId;
                            }

                            public Get setStepId(String stepId) {
                                this.stepId = stepId;
                                return this;
                            }

                            public String getTestCaseId() {
                                return this.testCaseId;
                            }

                            public Get setTestCaseId(String testCaseId) {
                                this.testCaseId = testCaseId;
                                return this;
                            }

                            @Override
                            public Get set(String parameterName, Object value) {
                                return (Get)super.set(parameterName, value);
                            }
                        }
                    }

                    public class PerfSampleSeries {
                        public Create create(String projectId, String historyId, String executionId, String stepId, com.google.api.services.toolresults.model.PerfSampleSeries content) throws IOException {
                            Create result = new Create(projectId, historyId, executionId, stepId, content);
                            ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Get get(String projectId, String historyId, String executionId, String stepId, String sampleSeriesId) throws IOException {
                            Get result = new Get(projectId, historyId, executionId, stepId, sampleSeriesId);
                            ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public List list(String projectId, String historyId, String executionId, String stepId) throws IOException {
                            List result = new List(projectId, historyId, executionId, stepId);
                            ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public Samples samples() {
                            return new Samples();
                        }

                        public class Samples {
                            public BatchCreate batchCreate(String projectId, String historyId, String executionId, String stepId, String sampleSeriesId, BatchCreatePerfSamplesRequest content) throws IOException {
                                BatchCreate result = new BatchCreate(projectId, historyId, executionId, stepId, sampleSeriesId, content);
                                ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                                return result;
                            }

                            public List list(String projectId, String historyId, String executionId, String stepId, String sampleSeriesId) throws IOException {
                                List result = new List(projectId, historyId, executionId, stepId, sampleSeriesId);
                                ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                                return result;
                            }

                            public class List
                            extends ToolResultsRequest<ListPerfSamplesResponse> {
                                private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories/{historyId}/executions/{executionId}/steps/{stepId}/perfSampleSeries/{sampleSeriesId}/samples";
                                @Key
                                private String projectId;
                                @Key
                                private String historyId;
                                @Key
                                private String executionId;
                                @Key
                                private String stepId;
                                @Key
                                private String sampleSeriesId;
                                @Key
                                private Integer pageSize;
                                @Key
                                private String pageToken;

                                protected List(String projectId, String historyId, String executionId, String stepId, String sampleSeriesId) {
                                    super(ToolResults.this, "GET", REST_PATH, null, ListPerfSamplesResponse.class);
                                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                                    this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                                    this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                                    this.stepId = (String)Preconditions.checkNotNull((Object)stepId, (Object)"Required parameter stepId must be specified.");
                                    this.sampleSeriesId = (String)Preconditions.checkNotNull((Object)sampleSeriesId, (Object)"Required parameter sampleSeriesId must be specified.");
                                }

                                public HttpResponse executeUsingHead() throws IOException {
                                    return super.executeUsingHead();
                                }

                                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                    return super.buildHttpRequestUsingHead();
                                }

                                public List set$Xgafv(String $Xgafv) {
                                    return (List)super.set$Xgafv($Xgafv);
                                }

                                public List setAccessToken(String accessToken) {
                                    return (List)super.setAccessToken(accessToken);
                                }

                                public List setAlt(String alt) {
                                    return (List)super.setAlt(alt);
                                }

                                public List setCallback(String callback) {
                                    return (List)super.setCallback(callback);
                                }

                                public List setFields(String fields) {
                                    return (List)super.setFields(fields);
                                }

                                public List setKey(String key) {
                                    return (List)super.setKey(key);
                                }

                                public List setOauthToken(String oauthToken) {
                                    return (List)super.setOauthToken(oauthToken);
                                }

                                public List setPrettyPrint(Boolean prettyPrint) {
                                    return (List)super.setPrettyPrint(prettyPrint);
                                }

                                public List setQuotaUser(String quotaUser) {
                                    return (List)super.setQuotaUser(quotaUser);
                                }

                                public List setUploadType(String uploadType) {
                                    return (List)super.setUploadType(uploadType);
                                }

                                public List setUploadProtocol(String uploadProtocol) {
                                    return (List)super.setUploadProtocol(uploadProtocol);
                                }

                                public String getProjectId() {
                                    return this.projectId;
                                }

                                public List setProjectId(String projectId) {
                                    this.projectId = projectId;
                                    return this;
                                }

                                public String getHistoryId() {
                                    return this.historyId;
                                }

                                public List setHistoryId(String historyId) {
                                    this.historyId = historyId;
                                    return this;
                                }

                                public String getExecutionId() {
                                    return this.executionId;
                                }

                                public List setExecutionId(String executionId) {
                                    this.executionId = executionId;
                                    return this;
                                }

                                public String getStepId() {
                                    return this.stepId;
                                }

                                public List setStepId(String stepId) {
                                    this.stepId = stepId;
                                    return this;
                                }

                                public String getSampleSeriesId() {
                                    return this.sampleSeriesId;
                                }

                                public List setSampleSeriesId(String sampleSeriesId) {
                                    this.sampleSeriesId = sampleSeriesId;
                                    return this;
                                }

                                public Integer getPageSize() {
                                    return this.pageSize;
                                }

                                public List setPageSize(Integer pageSize) {
                                    this.pageSize = pageSize;
                                    return this;
                                }

                                public String getPageToken() {
                                    return this.pageToken;
                                }

                                public List setPageToken(String pageToken) {
                                    this.pageToken = pageToken;
                                    return this;
                                }

                                @Override
                                public List set(String parameterName, Object value) {
                                    return (List)super.set(parameterName, value);
                                }
                            }

                            public class BatchCreate
                            extends ToolResultsRequest<BatchCreatePerfSamplesResponse> {
                                private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories/{historyId}/executions/{executionId}/steps/{stepId}/perfSampleSeries/{sampleSeriesId}/samples:batchCreate";
                                @Key
                                private String projectId;
                                @Key
                                private String historyId;
                                @Key
                                private String executionId;
                                @Key
                                private String stepId;
                                @Key
                                private String sampleSeriesId;

                                protected BatchCreate(String projectId, String historyId, String executionId, String stepId, String sampleSeriesId, BatchCreatePerfSamplesRequest content) {
                                    super(ToolResults.this, "POST", REST_PATH, (Object)content, BatchCreatePerfSamplesResponse.class);
                                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                                    this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                                    this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                                    this.stepId = (String)Preconditions.checkNotNull((Object)stepId, (Object)"Required parameter stepId must be specified.");
                                    this.sampleSeriesId = (String)Preconditions.checkNotNull((Object)sampleSeriesId, (Object)"Required parameter sampleSeriesId must be specified.");
                                }

                                public BatchCreate set$Xgafv(String $Xgafv) {
                                    return (BatchCreate)super.set$Xgafv($Xgafv);
                                }

                                public BatchCreate setAccessToken(String accessToken) {
                                    return (BatchCreate)super.setAccessToken(accessToken);
                                }

                                public BatchCreate setAlt(String alt) {
                                    return (BatchCreate)super.setAlt(alt);
                                }

                                public BatchCreate setCallback(String callback) {
                                    return (BatchCreate)super.setCallback(callback);
                                }

                                public BatchCreate setFields(String fields) {
                                    return (BatchCreate)super.setFields(fields);
                                }

                                public BatchCreate setKey(String key) {
                                    return (BatchCreate)super.setKey(key);
                                }

                                public BatchCreate setOauthToken(String oauthToken) {
                                    return (BatchCreate)super.setOauthToken(oauthToken);
                                }

                                public BatchCreate setPrettyPrint(Boolean prettyPrint) {
                                    return (BatchCreate)super.setPrettyPrint(prettyPrint);
                                }

                                public BatchCreate setQuotaUser(String quotaUser) {
                                    return (BatchCreate)super.setQuotaUser(quotaUser);
                                }

                                public BatchCreate setUploadType(String uploadType) {
                                    return (BatchCreate)super.setUploadType(uploadType);
                                }

                                public BatchCreate setUploadProtocol(String uploadProtocol) {
                                    return (BatchCreate)super.setUploadProtocol(uploadProtocol);
                                }

                                public String getProjectId() {
                                    return this.projectId;
                                }

                                public BatchCreate setProjectId(String projectId) {
                                    this.projectId = projectId;
                                    return this;
                                }

                                public String getHistoryId() {
                                    return this.historyId;
                                }

                                public BatchCreate setHistoryId(String historyId) {
                                    this.historyId = historyId;
                                    return this;
                                }

                                public String getExecutionId() {
                                    return this.executionId;
                                }

                                public BatchCreate setExecutionId(String executionId) {
                                    this.executionId = executionId;
                                    return this;
                                }

                                public String getStepId() {
                                    return this.stepId;
                                }

                                public BatchCreate setStepId(String stepId) {
                                    this.stepId = stepId;
                                    return this;
                                }

                                public String getSampleSeriesId() {
                                    return this.sampleSeriesId;
                                }

                                public BatchCreate setSampleSeriesId(String sampleSeriesId) {
                                    this.sampleSeriesId = sampleSeriesId;
                                    return this;
                                }

                                @Override
                                public BatchCreate set(String parameterName, Object value) {
                                    return (BatchCreate)super.set(parameterName, value);
                                }
                            }
                        }

                        public class List
                        extends ToolResultsRequest<ListPerfSampleSeriesResponse> {
                            private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories/{historyId}/executions/{executionId}/steps/{stepId}/perfSampleSeries";
                            @Key
                            private String projectId;
                            @Key
                            private String historyId;
                            @Key
                            private String executionId;
                            @Key
                            private String stepId;
                            @Key
                            private java.util.List<String> filter;

                            protected List(String projectId, String historyId, String executionId, String stepId) {
                                super(ToolResults.this, "GET", REST_PATH, null, ListPerfSampleSeriesResponse.class);
                                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                                this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                                this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                                this.stepId = (String)Preconditions.checkNotNull((Object)stepId, (Object)"Required parameter stepId must be specified.");
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public List set$Xgafv(String $Xgafv) {
                                return (List)super.set$Xgafv($Xgafv);
                            }

                            public List setAccessToken(String accessToken) {
                                return (List)super.setAccessToken(accessToken);
                            }

                            public List setAlt(String alt) {
                                return (List)super.setAlt(alt);
                            }

                            public List setCallback(String callback) {
                                return (List)super.setCallback(callback);
                            }

                            public List setFields(String fields) {
                                return (List)super.setFields(fields);
                            }

                            public List setKey(String key) {
                                return (List)super.setKey(key);
                            }

                            public List setOauthToken(String oauthToken) {
                                return (List)super.setOauthToken(oauthToken);
                            }

                            public List setPrettyPrint(Boolean prettyPrint) {
                                return (List)super.setPrettyPrint(prettyPrint);
                            }

                            public List setQuotaUser(String quotaUser) {
                                return (List)super.setQuotaUser(quotaUser);
                            }

                            public List setUploadType(String uploadType) {
                                return (List)super.setUploadType(uploadType);
                            }

                            public List setUploadProtocol(String uploadProtocol) {
                                return (List)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getProjectId() {
                                return this.projectId;
                            }

                            public List setProjectId(String projectId) {
                                this.projectId = projectId;
                                return this;
                            }

                            public String getHistoryId() {
                                return this.historyId;
                            }

                            public List setHistoryId(String historyId) {
                                this.historyId = historyId;
                                return this;
                            }

                            public String getExecutionId() {
                                return this.executionId;
                            }

                            public List setExecutionId(String executionId) {
                                this.executionId = executionId;
                                return this;
                            }

                            public String getStepId() {
                                return this.stepId;
                            }

                            public List setStepId(String stepId) {
                                this.stepId = stepId;
                                return this;
                            }

                            public java.util.List<String> getFilter() {
                                return this.filter;
                            }

                            public List setFilter(java.util.List<String> filter) {
                                this.filter = filter;
                                return this;
                            }

                            @Override
                            public List set(String parameterName, Object value) {
                                return (List)super.set(parameterName, value);
                            }
                        }

                        public class Get
                        extends ToolResultsRequest<com.google.api.services.toolresults.model.PerfSampleSeries> {
                            private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories/{historyId}/executions/{executionId}/steps/{stepId}/perfSampleSeries/{sampleSeriesId}";
                            @Key
                            private String projectId;
                            @Key
                            private String historyId;
                            @Key
                            private String executionId;
                            @Key
                            private String stepId;
                            @Key
                            private String sampleSeriesId;

                            protected Get(String projectId, String historyId, String executionId, String stepId, String sampleSeriesId) {
                                super(ToolResults.this, "GET", REST_PATH, null, com.google.api.services.toolresults.model.PerfSampleSeries.class);
                                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                                this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                                this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                                this.stepId = (String)Preconditions.checkNotNull((Object)stepId, (Object)"Required parameter stepId must be specified.");
                                this.sampleSeriesId = (String)Preconditions.checkNotNull((Object)sampleSeriesId, (Object)"Required parameter sampleSeriesId must be specified.");
                            }

                            public HttpResponse executeUsingHead() throws IOException {
                                return super.executeUsingHead();
                            }

                            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                                return super.buildHttpRequestUsingHead();
                            }

                            public Get set$Xgafv(String $Xgafv) {
                                return (Get)super.set$Xgafv($Xgafv);
                            }

                            public Get setAccessToken(String accessToken) {
                                return (Get)super.setAccessToken(accessToken);
                            }

                            public Get setAlt(String alt) {
                                return (Get)super.setAlt(alt);
                            }

                            public Get setCallback(String callback) {
                                return (Get)super.setCallback(callback);
                            }

                            public Get setFields(String fields) {
                                return (Get)super.setFields(fields);
                            }

                            public Get setKey(String key) {
                                return (Get)super.setKey(key);
                            }

                            public Get setOauthToken(String oauthToken) {
                                return (Get)super.setOauthToken(oauthToken);
                            }

                            public Get setPrettyPrint(Boolean prettyPrint) {
                                return (Get)super.setPrettyPrint(prettyPrint);
                            }

                            public Get setQuotaUser(String quotaUser) {
                                return (Get)super.setQuotaUser(quotaUser);
                            }

                            public Get setUploadType(String uploadType) {
                                return (Get)super.setUploadType(uploadType);
                            }

                            public Get setUploadProtocol(String uploadProtocol) {
                                return (Get)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getProjectId() {
                                return this.projectId;
                            }

                            public Get setProjectId(String projectId) {
                                this.projectId = projectId;
                                return this;
                            }

                            public String getHistoryId() {
                                return this.historyId;
                            }

                            public Get setHistoryId(String historyId) {
                                this.historyId = historyId;
                                return this;
                            }

                            public String getExecutionId() {
                                return this.executionId;
                            }

                            public Get setExecutionId(String executionId) {
                                this.executionId = executionId;
                                return this;
                            }

                            public String getStepId() {
                                return this.stepId;
                            }

                            public Get setStepId(String stepId) {
                                this.stepId = stepId;
                                return this;
                            }

                            public String getSampleSeriesId() {
                                return this.sampleSeriesId;
                            }

                            public Get setSampleSeriesId(String sampleSeriesId) {
                                this.sampleSeriesId = sampleSeriesId;
                                return this;
                            }

                            @Override
                            public Get set(String parameterName, Object value) {
                                return (Get)super.set(parameterName, value);
                            }
                        }

                        public class Create
                        extends ToolResultsRequest<com.google.api.services.toolresults.model.PerfSampleSeries> {
                            private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories/{historyId}/executions/{executionId}/steps/{stepId}/perfSampleSeries";
                            @Key
                            private String projectId;
                            @Key
                            private String historyId;
                            @Key
                            private String executionId;
                            @Key
                            private String stepId;

                            protected Create(String projectId, String historyId, String executionId, String stepId, com.google.api.services.toolresults.model.PerfSampleSeries content) {
                                super(ToolResults.this, "POST", REST_PATH, (Object)content, com.google.api.services.toolresults.model.PerfSampleSeries.class);
                                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                                this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                                this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                                this.stepId = (String)Preconditions.checkNotNull((Object)stepId, (Object)"Required parameter stepId must be specified.");
                            }

                            public Create set$Xgafv(String $Xgafv) {
                                return (Create)super.set$Xgafv($Xgafv);
                            }

                            public Create setAccessToken(String accessToken) {
                                return (Create)super.setAccessToken(accessToken);
                            }

                            public Create setAlt(String alt) {
                                return (Create)super.setAlt(alt);
                            }

                            public Create setCallback(String callback) {
                                return (Create)super.setCallback(callback);
                            }

                            public Create setFields(String fields) {
                                return (Create)super.setFields(fields);
                            }

                            public Create setKey(String key) {
                                return (Create)super.setKey(key);
                            }

                            public Create setOauthToken(String oauthToken) {
                                return (Create)super.setOauthToken(oauthToken);
                            }

                            public Create setPrettyPrint(Boolean prettyPrint) {
                                return (Create)super.setPrettyPrint(prettyPrint);
                            }

                            public Create setQuotaUser(String quotaUser) {
                                return (Create)super.setQuotaUser(quotaUser);
                            }

                            public Create setUploadType(String uploadType) {
                                return (Create)super.setUploadType(uploadType);
                            }

                            public Create setUploadProtocol(String uploadProtocol) {
                                return (Create)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getProjectId() {
                                return this.projectId;
                            }

                            public Create setProjectId(String projectId) {
                                this.projectId = projectId;
                                return this;
                            }

                            public String getHistoryId() {
                                return this.historyId;
                            }

                            public Create setHistoryId(String historyId) {
                                this.historyId = historyId;
                                return this;
                            }

                            public String getExecutionId() {
                                return this.executionId;
                            }

                            public Create setExecutionId(String executionId) {
                                this.executionId = executionId;
                                return this;
                            }

                            public String getStepId() {
                                return this.stepId;
                            }

                            public Create setStepId(String stepId) {
                                this.stepId = stepId;
                                return this;
                            }

                            @Override
                            public Create set(String parameterName, Object value) {
                                return (Create)super.set(parameterName, value);
                            }
                        }
                    }

                    public class PerfMetricsSummary {
                        public Create create(String projectId, String historyId, String executionId, String stepId, com.google.api.services.toolresults.model.PerfMetricsSummary content) throws IOException {
                            Create result = new Create(projectId, historyId, executionId, stepId, content);
                            ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                            return result;
                        }

                        public class Create
                        extends ToolResultsRequest<com.google.api.services.toolresults.model.PerfMetricsSummary> {
                            private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories/{historyId}/executions/{executionId}/steps/{stepId}/perfMetricsSummary";
                            @Key
                            private String projectId;
                            @Key
                            private String historyId;
                            @Key
                            private String executionId;
                            @Key
                            private String stepId;

                            protected Create(String projectId, String historyId, String executionId, String stepId, com.google.api.services.toolresults.model.PerfMetricsSummary content) {
                                super(ToolResults.this, "POST", REST_PATH, (Object)content, com.google.api.services.toolresults.model.PerfMetricsSummary.class);
                                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                                this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                                this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                                this.stepId = (String)Preconditions.checkNotNull((Object)stepId, (Object)"Required parameter stepId must be specified.");
                            }

                            public Create set$Xgafv(String $Xgafv) {
                                return (Create)super.set$Xgafv($Xgafv);
                            }

                            public Create setAccessToken(String accessToken) {
                                return (Create)super.setAccessToken(accessToken);
                            }

                            public Create setAlt(String alt) {
                                return (Create)super.setAlt(alt);
                            }

                            public Create setCallback(String callback) {
                                return (Create)super.setCallback(callback);
                            }

                            public Create setFields(String fields) {
                                return (Create)super.setFields(fields);
                            }

                            public Create setKey(String key) {
                                return (Create)super.setKey(key);
                            }

                            public Create setOauthToken(String oauthToken) {
                                return (Create)super.setOauthToken(oauthToken);
                            }

                            public Create setPrettyPrint(Boolean prettyPrint) {
                                return (Create)super.setPrettyPrint(prettyPrint);
                            }

                            public Create setQuotaUser(String quotaUser) {
                                return (Create)super.setQuotaUser(quotaUser);
                            }

                            public Create setUploadType(String uploadType) {
                                return (Create)super.setUploadType(uploadType);
                            }

                            public Create setUploadProtocol(String uploadProtocol) {
                                return (Create)super.setUploadProtocol(uploadProtocol);
                            }

                            public String getProjectId() {
                                return this.projectId;
                            }

                            public Create setProjectId(String projectId) {
                                this.projectId = projectId;
                                return this;
                            }

                            public String getHistoryId() {
                                return this.historyId;
                            }

                            public Create setHistoryId(String historyId) {
                                this.historyId = historyId;
                                return this;
                            }

                            public String getExecutionId() {
                                return this.executionId;
                            }

                            public Create setExecutionId(String executionId) {
                                this.executionId = executionId;
                                return this;
                            }

                            public String getStepId() {
                                return this.stepId;
                            }

                            public Create setStepId(String stepId) {
                                this.stepId = stepId;
                                return this;
                            }

                            @Override
                            public Create set(String parameterName, Object value) {
                                return (Create)super.set(parameterName, value);
                            }
                        }
                    }

                    public class PublishXunitXmlFiles
                    extends ToolResultsRequest<Step> {
                        private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories/{historyId}/executions/{executionId}/steps/{stepId}:publishXunitXmlFiles";
                        @Key
                        private String projectId;
                        @Key
                        private String historyId;
                        @Key
                        private String executionId;
                        @Key
                        private String stepId;

                        protected PublishXunitXmlFiles(String projectId, String historyId, String executionId, String stepId, PublishXunitXmlFilesRequest content) {
                            super(ToolResults.this, "POST", REST_PATH, (Object)content, Step.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                            this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                            this.stepId = (String)Preconditions.checkNotNull((Object)stepId, (Object)"Required parameter stepId must be specified.");
                        }

                        public PublishXunitXmlFiles set$Xgafv(String $Xgafv) {
                            return (PublishXunitXmlFiles)super.set$Xgafv($Xgafv);
                        }

                        public PublishXunitXmlFiles setAccessToken(String accessToken) {
                            return (PublishXunitXmlFiles)super.setAccessToken(accessToken);
                        }

                        public PublishXunitXmlFiles setAlt(String alt) {
                            return (PublishXunitXmlFiles)super.setAlt(alt);
                        }

                        public PublishXunitXmlFiles setCallback(String callback) {
                            return (PublishXunitXmlFiles)super.setCallback(callback);
                        }

                        public PublishXunitXmlFiles setFields(String fields) {
                            return (PublishXunitXmlFiles)super.setFields(fields);
                        }

                        public PublishXunitXmlFiles setKey(String key) {
                            return (PublishXunitXmlFiles)super.setKey(key);
                        }

                        public PublishXunitXmlFiles setOauthToken(String oauthToken) {
                            return (PublishXunitXmlFiles)super.setOauthToken(oauthToken);
                        }

                        public PublishXunitXmlFiles setPrettyPrint(Boolean prettyPrint) {
                            return (PublishXunitXmlFiles)super.setPrettyPrint(prettyPrint);
                        }

                        public PublishXunitXmlFiles setQuotaUser(String quotaUser) {
                            return (PublishXunitXmlFiles)super.setQuotaUser(quotaUser);
                        }

                        public PublishXunitXmlFiles setUploadType(String uploadType) {
                            return (PublishXunitXmlFiles)super.setUploadType(uploadType);
                        }

                        public PublishXunitXmlFiles setUploadProtocol(String uploadProtocol) {
                            return (PublishXunitXmlFiles)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public PublishXunitXmlFiles setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getHistoryId() {
                            return this.historyId;
                        }

                        public PublishXunitXmlFiles setHistoryId(String historyId) {
                            this.historyId = historyId;
                            return this;
                        }

                        public String getExecutionId() {
                            return this.executionId;
                        }

                        public PublishXunitXmlFiles setExecutionId(String executionId) {
                            this.executionId = executionId;
                            return this;
                        }

                        public String getStepId() {
                            return this.stepId;
                        }

                        public PublishXunitXmlFiles setStepId(String stepId) {
                            this.stepId = stepId;
                            return this;
                        }

                        @Override
                        public PublishXunitXmlFiles set(String parameterName, Object value) {
                            return (PublishXunitXmlFiles)super.set(parameterName, value);
                        }
                    }

                    public class Patch
                    extends ToolResultsRequest<Step> {
                        private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories/{historyId}/executions/{executionId}/steps/{stepId}";
                        @Key
                        private String projectId;
                        @Key
                        private String historyId;
                        @Key
                        private String executionId;
                        @Key
                        private String stepId;
                        @Key
                        private String requestId;

                        protected Patch(String projectId, String historyId, String executionId, String stepId, Step content) {
                            super(ToolResults.this, "PATCH", REST_PATH, (Object)content, Step.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                            this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                            this.stepId = (String)Preconditions.checkNotNull((Object)stepId, (Object)"Required parameter stepId must be specified.");
                        }

                        public Patch set$Xgafv(String $Xgafv) {
                            return (Patch)super.set$Xgafv($Xgafv);
                        }

                        public Patch setAccessToken(String accessToken) {
                            return (Patch)super.setAccessToken(accessToken);
                        }

                        public Patch setAlt(String alt) {
                            return (Patch)super.setAlt(alt);
                        }

                        public Patch setCallback(String callback) {
                            return (Patch)super.setCallback(callback);
                        }

                        public Patch setFields(String fields) {
                            return (Patch)super.setFields(fields);
                        }

                        public Patch setKey(String key) {
                            return (Patch)super.setKey(key);
                        }

                        public Patch setOauthToken(String oauthToken) {
                            return (Patch)super.setOauthToken(oauthToken);
                        }

                        public Patch setPrettyPrint(Boolean prettyPrint) {
                            return (Patch)super.setPrettyPrint(prettyPrint);
                        }

                        public Patch setQuotaUser(String quotaUser) {
                            return (Patch)super.setQuotaUser(quotaUser);
                        }

                        public Patch setUploadType(String uploadType) {
                            return (Patch)super.setUploadType(uploadType);
                        }

                        public Patch setUploadProtocol(String uploadProtocol) {
                            return (Patch)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public Patch setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getHistoryId() {
                            return this.historyId;
                        }

                        public Patch setHistoryId(String historyId) {
                            this.historyId = historyId;
                            return this;
                        }

                        public String getExecutionId() {
                            return this.executionId;
                        }

                        public Patch setExecutionId(String executionId) {
                            this.executionId = executionId;
                            return this;
                        }

                        public String getStepId() {
                            return this.stepId;
                        }

                        public Patch setStepId(String stepId) {
                            this.stepId = stepId;
                            return this;
                        }

                        public String getRequestId() {
                            return this.requestId;
                        }

                        public Patch setRequestId(String requestId) {
                            this.requestId = requestId;
                            return this;
                        }

                        @Override
                        public Patch set(String parameterName, Object value) {
                            return (Patch)super.set(parameterName, value);
                        }
                    }

                    public class List
                    extends ToolResultsRequest<ListStepsResponse> {
                        private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories/{historyId}/executions/{executionId}/steps";
                        @Key
                        private String projectId;
                        @Key
                        private String historyId;
                        @Key
                        private String executionId;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String projectId, String historyId, String executionId) {
                            super(ToolResults.this, "GET", REST_PATH, null, ListStepsResponse.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                            this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public List setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getHistoryId() {
                            return this.historyId;
                        }

                        public List setHistoryId(String historyId) {
                            this.historyId = historyId;
                            return this;
                        }

                        public String getExecutionId() {
                            return this.executionId;
                        }

                        public List setExecutionId(String executionId) {
                            this.executionId = executionId;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class GetPerfMetricsSummary
                    extends ToolResultsRequest<com.google.api.services.toolresults.model.PerfMetricsSummary> {
                        private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories/{historyId}/executions/{executionId}/steps/{stepId}/perfMetricsSummary";
                        @Key
                        private String projectId;
                        @Key
                        private String historyId;
                        @Key
                        private String executionId;
                        @Key
                        private String stepId;

                        protected GetPerfMetricsSummary(String projectId, String historyId, String executionId, String stepId) {
                            super(ToolResults.this, "GET", REST_PATH, null, com.google.api.services.toolresults.model.PerfMetricsSummary.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                            this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                            this.stepId = (String)Preconditions.checkNotNull((Object)stepId, (Object)"Required parameter stepId must be specified.");
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public GetPerfMetricsSummary set$Xgafv(String $Xgafv) {
                            return (GetPerfMetricsSummary)super.set$Xgafv($Xgafv);
                        }

                        public GetPerfMetricsSummary setAccessToken(String accessToken) {
                            return (GetPerfMetricsSummary)super.setAccessToken(accessToken);
                        }

                        public GetPerfMetricsSummary setAlt(String alt) {
                            return (GetPerfMetricsSummary)super.setAlt(alt);
                        }

                        public GetPerfMetricsSummary setCallback(String callback) {
                            return (GetPerfMetricsSummary)super.setCallback(callback);
                        }

                        public GetPerfMetricsSummary setFields(String fields) {
                            return (GetPerfMetricsSummary)super.setFields(fields);
                        }

                        public GetPerfMetricsSummary setKey(String key) {
                            return (GetPerfMetricsSummary)super.setKey(key);
                        }

                        public GetPerfMetricsSummary setOauthToken(String oauthToken) {
                            return (GetPerfMetricsSummary)super.setOauthToken(oauthToken);
                        }

                        public GetPerfMetricsSummary setPrettyPrint(Boolean prettyPrint) {
                            return (GetPerfMetricsSummary)super.setPrettyPrint(prettyPrint);
                        }

                        public GetPerfMetricsSummary setQuotaUser(String quotaUser) {
                            return (GetPerfMetricsSummary)super.setQuotaUser(quotaUser);
                        }

                        public GetPerfMetricsSummary setUploadType(String uploadType) {
                            return (GetPerfMetricsSummary)super.setUploadType(uploadType);
                        }

                        public GetPerfMetricsSummary setUploadProtocol(String uploadProtocol) {
                            return (GetPerfMetricsSummary)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public GetPerfMetricsSummary setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getHistoryId() {
                            return this.historyId;
                        }

                        public GetPerfMetricsSummary setHistoryId(String historyId) {
                            this.historyId = historyId;
                            return this;
                        }

                        public String getExecutionId() {
                            return this.executionId;
                        }

                        public GetPerfMetricsSummary setExecutionId(String executionId) {
                            this.executionId = executionId;
                            return this;
                        }

                        public String getStepId() {
                            return this.stepId;
                        }

                        public GetPerfMetricsSummary setStepId(String stepId) {
                            this.stepId = stepId;
                            return this;
                        }

                        @Override
                        public GetPerfMetricsSummary set(String parameterName, Object value) {
                            return (GetPerfMetricsSummary)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends ToolResultsRequest<Step> {
                        private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories/{historyId}/executions/{executionId}/steps/{stepId}";
                        @Key
                        private String projectId;
                        @Key
                        private String historyId;
                        @Key
                        private String executionId;
                        @Key
                        private String stepId;

                        protected Get(String projectId, String historyId, String executionId, String stepId) {
                            super(ToolResults.this, "GET", REST_PATH, null, Step.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                            this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                            this.stepId = (String)Preconditions.checkNotNull((Object)stepId, (Object)"Required parameter stepId must be specified.");
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public Get setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getHistoryId() {
                            return this.historyId;
                        }

                        public Get setHistoryId(String historyId) {
                            this.historyId = historyId;
                            return this;
                        }

                        public String getExecutionId() {
                            return this.executionId;
                        }

                        public Get setExecutionId(String executionId) {
                            this.executionId = executionId;
                            return this;
                        }

                        public String getStepId() {
                            return this.stepId;
                        }

                        public Get setStepId(String stepId) {
                            this.stepId = stepId;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }

                    public class Create
                    extends ToolResultsRequest<Step> {
                        private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories/{historyId}/executions/{executionId}/steps";
                        @Key
                        private String projectId;
                        @Key
                        private String historyId;
                        @Key
                        private String executionId;
                        @Key
                        private String requestId;

                        protected Create(String projectId, String historyId, String executionId, Step content) {
                            super(ToolResults.this, "POST", REST_PATH, (Object)content, Step.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                            this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                        }

                        public Create set$Xgafv(String $Xgafv) {
                            return (Create)super.set$Xgafv($Xgafv);
                        }

                        public Create setAccessToken(String accessToken) {
                            return (Create)super.setAccessToken(accessToken);
                        }

                        public Create setAlt(String alt) {
                            return (Create)super.setAlt(alt);
                        }

                        public Create setCallback(String callback) {
                            return (Create)super.setCallback(callback);
                        }

                        public Create setFields(String fields) {
                            return (Create)super.setFields(fields);
                        }

                        public Create setKey(String key) {
                            return (Create)super.setKey(key);
                        }

                        public Create setOauthToken(String oauthToken) {
                            return (Create)super.setOauthToken(oauthToken);
                        }

                        public Create setPrettyPrint(Boolean prettyPrint) {
                            return (Create)super.setPrettyPrint(prettyPrint);
                        }

                        public Create setQuotaUser(String quotaUser) {
                            return (Create)super.setQuotaUser(quotaUser);
                        }

                        public Create setUploadType(String uploadType) {
                            return (Create)super.setUploadType(uploadType);
                        }

                        public Create setUploadProtocol(String uploadProtocol) {
                            return (Create)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public Create setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getHistoryId() {
                            return this.historyId;
                        }

                        public Create setHistoryId(String historyId) {
                            this.historyId = historyId;
                            return this;
                        }

                        public String getExecutionId() {
                            return this.executionId;
                        }

                        public Create setExecutionId(String executionId) {
                            this.executionId = executionId;
                            return this;
                        }

                        public String getRequestId() {
                            return this.requestId;
                        }

                        public Create setRequestId(String requestId) {
                            this.requestId = requestId;
                            return this;
                        }

                        @Override
                        public Create set(String parameterName, Object value) {
                            return (Create)super.set(parameterName, value);
                        }
                    }

                    public class AccessibilityClusters
                    extends ToolResultsRequest<ListStepAccessibilityClustersResponse> {
                        private static final String REST_PATH = "toolresults/v1beta3/{+name}:accessibilityClusters";
                        private final Pattern NAME_PATTERN;
                        @Key
                        private String name;
                        @Key
                        private String locale;

                        protected AccessibilityClusters(String name) {
                            super(ToolResults.this, "GET", REST_PATH, null, ListStepAccessibilityClustersResponse.class);
                            this.NAME_PATTERN = Pattern.compile("^projects/[^/]+/histories/[^/]+/executions/[^/]+/steps/[^/]+$");
                            this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"Required parameter name must be specified.");
                            if (!ToolResults.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/histories/[^/]+/executions/[^/]+/steps/[^/]+$");
                            }
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public AccessibilityClusters set$Xgafv(String $Xgafv) {
                            return (AccessibilityClusters)super.set$Xgafv($Xgafv);
                        }

                        public AccessibilityClusters setAccessToken(String accessToken) {
                            return (AccessibilityClusters)super.setAccessToken(accessToken);
                        }

                        public AccessibilityClusters setAlt(String alt) {
                            return (AccessibilityClusters)super.setAlt(alt);
                        }

                        public AccessibilityClusters setCallback(String callback) {
                            return (AccessibilityClusters)super.setCallback(callback);
                        }

                        public AccessibilityClusters setFields(String fields) {
                            return (AccessibilityClusters)super.setFields(fields);
                        }

                        public AccessibilityClusters setKey(String key) {
                            return (AccessibilityClusters)super.setKey(key);
                        }

                        public AccessibilityClusters setOauthToken(String oauthToken) {
                            return (AccessibilityClusters)super.setOauthToken(oauthToken);
                        }

                        public AccessibilityClusters setPrettyPrint(Boolean prettyPrint) {
                            return (AccessibilityClusters)super.setPrettyPrint(prettyPrint);
                        }

                        public AccessibilityClusters setQuotaUser(String quotaUser) {
                            return (AccessibilityClusters)super.setQuotaUser(quotaUser);
                        }

                        public AccessibilityClusters setUploadType(String uploadType) {
                            return (AccessibilityClusters)super.setUploadType(uploadType);
                        }

                        public AccessibilityClusters setUploadProtocol(String uploadProtocol) {
                            return (AccessibilityClusters)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getName() {
                            return this.name;
                        }

                        public AccessibilityClusters setName(String name) {
                            if (!ToolResults.this.getSuppressPatternChecks()) {
                                Preconditions.checkArgument((boolean)this.NAME_PATTERN.matcher(name).matches(), (Object)"Parameter name must conform to the pattern ^projects/[^/]+/histories/[^/]+/executions/[^/]+/steps/[^/]+$");
                            }
                            this.name = name;
                            return this;
                        }

                        public String getLocale() {
                            return this.locale;
                        }

                        public AccessibilityClusters setLocale(String locale) {
                            this.locale = locale;
                            return this;
                        }

                        @Override
                        public AccessibilityClusters set(String parameterName, Object value) {
                            return (AccessibilityClusters)super.set(parameterName, value);
                        }
                    }
                }

                public class Environments {
                    public Get get(String projectId, String historyId, String executionId, String environmentId) throws IOException {
                        Get result = new Get(projectId, historyId, executionId, environmentId);
                        ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String projectId, String historyId, String executionId) throws IOException {
                        List result = new List(projectId, historyId, executionId);
                        ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends ToolResultsRequest<ListEnvironmentsResponse> {
                        private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories/{historyId}/executions/{executionId}/environments";
                        @Key
                        private String projectId;
                        @Key
                        private String historyId;
                        @Key
                        private String executionId;
                        @Key
                        private Integer pageSize;
                        @Key
                        private String pageToken;

                        protected List(String projectId, String historyId, String executionId) {
                            super(ToolResults.this, "GET", REST_PATH, null, ListEnvironmentsResponse.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                            this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public List setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getHistoryId() {
                            return this.historyId;
                        }

                        public List setHistoryId(String historyId) {
                            this.historyId = historyId;
                            return this;
                        }

                        public String getExecutionId() {
                            return this.executionId;
                        }

                        public List setExecutionId(String executionId) {
                            this.executionId = executionId;
                            return this;
                        }

                        public Integer getPageSize() {
                            return this.pageSize;
                        }

                        public List setPageSize(Integer pageSize) {
                            this.pageSize = pageSize;
                            return this;
                        }

                        public String getPageToken() {
                            return this.pageToken;
                        }

                        public List setPageToken(String pageToken) {
                            this.pageToken = pageToken;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends ToolResultsRequest<Environment> {
                        private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories/{historyId}/executions/{executionId}/environments/{environmentId}";
                        @Key
                        private String projectId;
                        @Key
                        private String historyId;
                        @Key
                        private String executionId;
                        @Key
                        private String environmentId;

                        protected Get(String projectId, String historyId, String executionId, String environmentId) {
                            super(ToolResults.this, "GET", REST_PATH, null, Environment.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                            this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                            this.environmentId = (String)Preconditions.checkNotNull((Object)environmentId, (Object)"Required parameter environmentId must be specified.");
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public Get setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getHistoryId() {
                            return this.historyId;
                        }

                        public Get setHistoryId(String historyId) {
                            this.historyId = historyId;
                            return this;
                        }

                        public String getExecutionId() {
                            return this.executionId;
                        }

                        public Get setExecutionId(String executionId) {
                            this.executionId = executionId;
                            return this;
                        }

                        public String getEnvironmentId() {
                            return this.environmentId;
                        }

                        public Get setEnvironmentId(String environmentId) {
                            this.environmentId = environmentId;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }
                }

                public class Clusters {
                    public Get get(String projectId, String historyId, String executionId, String clusterId) throws IOException {
                        Get result = new Get(projectId, historyId, executionId, clusterId);
                        ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public List list(String projectId, String historyId, String executionId) throws IOException {
                        List result = new List(projectId, historyId, executionId);
                        ToolResults.this.initialize((AbstractGoogleClientRequest<?>)result);
                        return result;
                    }

                    public class List
                    extends ToolResultsRequest<ListScreenshotClustersResponse> {
                        private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories/{historyId}/executions/{executionId}/clusters";
                        @Key
                        private String projectId;
                        @Key
                        private String historyId;
                        @Key
                        private String executionId;

                        protected List(String projectId, String historyId, String executionId) {
                            super(ToolResults.this, "GET", REST_PATH, null, ListScreenshotClustersResponse.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                            this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public List set$Xgafv(String $Xgafv) {
                            return (List)super.set$Xgafv($Xgafv);
                        }

                        public List setAccessToken(String accessToken) {
                            return (List)super.setAccessToken(accessToken);
                        }

                        public List setAlt(String alt) {
                            return (List)super.setAlt(alt);
                        }

                        public List setCallback(String callback) {
                            return (List)super.setCallback(callback);
                        }

                        public List setFields(String fields) {
                            return (List)super.setFields(fields);
                        }

                        public List setKey(String key) {
                            return (List)super.setKey(key);
                        }

                        public List setOauthToken(String oauthToken) {
                            return (List)super.setOauthToken(oauthToken);
                        }

                        public List setPrettyPrint(Boolean prettyPrint) {
                            return (List)super.setPrettyPrint(prettyPrint);
                        }

                        public List setQuotaUser(String quotaUser) {
                            return (List)super.setQuotaUser(quotaUser);
                        }

                        public List setUploadType(String uploadType) {
                            return (List)super.setUploadType(uploadType);
                        }

                        public List setUploadProtocol(String uploadProtocol) {
                            return (List)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public List setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getHistoryId() {
                            return this.historyId;
                        }

                        public List setHistoryId(String historyId) {
                            this.historyId = historyId;
                            return this;
                        }

                        public String getExecutionId() {
                            return this.executionId;
                        }

                        public List setExecutionId(String executionId) {
                            this.executionId = executionId;
                            return this;
                        }

                        @Override
                        public List set(String parameterName, Object value) {
                            return (List)super.set(parameterName, value);
                        }
                    }

                    public class Get
                    extends ToolResultsRequest<ScreenshotCluster> {
                        private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories/{historyId}/executions/{executionId}/clusters/{clusterId}";
                        @Key
                        private String projectId;
                        @Key
                        private String historyId;
                        @Key
                        private String executionId;
                        @Key
                        private String clusterId;

                        protected Get(String projectId, String historyId, String executionId, String clusterId) {
                            super(ToolResults.this, "GET", REST_PATH, null, ScreenshotCluster.class);
                            this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                            this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                            this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                            this.clusterId = (String)Preconditions.checkNotNull((Object)clusterId, (Object)"Required parameter clusterId must be specified.");
                        }

                        public HttpResponse executeUsingHead() throws IOException {
                            return super.executeUsingHead();
                        }

                        public HttpRequest buildHttpRequestUsingHead() throws IOException {
                            return super.buildHttpRequestUsingHead();
                        }

                        public Get set$Xgafv(String $Xgafv) {
                            return (Get)super.set$Xgafv($Xgafv);
                        }

                        public Get setAccessToken(String accessToken) {
                            return (Get)super.setAccessToken(accessToken);
                        }

                        public Get setAlt(String alt) {
                            return (Get)super.setAlt(alt);
                        }

                        public Get setCallback(String callback) {
                            return (Get)super.setCallback(callback);
                        }

                        public Get setFields(String fields) {
                            return (Get)super.setFields(fields);
                        }

                        public Get setKey(String key) {
                            return (Get)super.setKey(key);
                        }

                        public Get setOauthToken(String oauthToken) {
                            return (Get)super.setOauthToken(oauthToken);
                        }

                        public Get setPrettyPrint(Boolean prettyPrint) {
                            return (Get)super.setPrettyPrint(prettyPrint);
                        }

                        public Get setQuotaUser(String quotaUser) {
                            return (Get)super.setQuotaUser(quotaUser);
                        }

                        public Get setUploadType(String uploadType) {
                            return (Get)super.setUploadType(uploadType);
                        }

                        public Get setUploadProtocol(String uploadProtocol) {
                            return (Get)super.setUploadProtocol(uploadProtocol);
                        }

                        public String getProjectId() {
                            return this.projectId;
                        }

                        public Get setProjectId(String projectId) {
                            this.projectId = projectId;
                            return this;
                        }

                        public String getHistoryId() {
                            return this.historyId;
                        }

                        public Get setHistoryId(String historyId) {
                            this.historyId = historyId;
                            return this;
                        }

                        public String getExecutionId() {
                            return this.executionId;
                        }

                        public Get setExecutionId(String executionId) {
                            this.executionId = executionId;
                            return this;
                        }

                        public String getClusterId() {
                            return this.clusterId;
                        }

                        public Get setClusterId(String clusterId) {
                            this.clusterId = clusterId;
                            return this;
                        }

                        @Override
                        public Get set(String parameterName, Object value) {
                            return (Get)super.set(parameterName, value);
                        }
                    }
                }

                public class Patch
                extends ToolResultsRequest<Execution> {
                    private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories/{historyId}/executions/{executionId}";
                    @Key
                    private String projectId;
                    @Key
                    private String historyId;
                    @Key
                    private String executionId;
                    @Key
                    private String requestId;

                    protected Patch(String projectId, String historyId, String executionId, Execution content) {
                        super(ToolResults.this, "PATCH", REST_PATH, (Object)content, Execution.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                        this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                    }

                    public Patch set$Xgafv(String $Xgafv) {
                        return (Patch)super.set$Xgafv($Xgafv);
                    }

                    public Patch setAccessToken(String accessToken) {
                        return (Patch)super.setAccessToken(accessToken);
                    }

                    public Patch setAlt(String alt) {
                        return (Patch)super.setAlt(alt);
                    }

                    public Patch setCallback(String callback) {
                        return (Patch)super.setCallback(callback);
                    }

                    public Patch setFields(String fields) {
                        return (Patch)super.setFields(fields);
                    }

                    public Patch setKey(String key) {
                        return (Patch)super.setKey(key);
                    }

                    public Patch setOauthToken(String oauthToken) {
                        return (Patch)super.setOauthToken(oauthToken);
                    }

                    public Patch setPrettyPrint(Boolean prettyPrint) {
                        return (Patch)super.setPrettyPrint(prettyPrint);
                    }

                    public Patch setQuotaUser(String quotaUser) {
                        return (Patch)super.setQuotaUser(quotaUser);
                    }

                    public Patch setUploadType(String uploadType) {
                        return (Patch)super.setUploadType(uploadType);
                    }

                    public Patch setUploadProtocol(String uploadProtocol) {
                        return (Patch)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Patch setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getHistoryId() {
                        return this.historyId;
                    }

                    public Patch setHistoryId(String historyId) {
                        this.historyId = historyId;
                        return this;
                    }

                    public String getExecutionId() {
                        return this.executionId;
                    }

                    public Patch setExecutionId(String executionId) {
                        this.executionId = executionId;
                        return this;
                    }

                    public String getRequestId() {
                        return this.requestId;
                    }

                    public Patch setRequestId(String requestId) {
                        this.requestId = requestId;
                        return this;
                    }

                    @Override
                    public Patch set(String parameterName, Object value) {
                        return (Patch)super.set(parameterName, value);
                    }
                }

                public class List
                extends ToolResultsRequest<ListExecutionsResponse> {
                    private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories/{historyId}/executions";
                    @Key
                    private String projectId;
                    @Key
                    private String historyId;
                    @Key
                    private Integer pageSize;
                    @Key
                    private String pageToken;

                    protected List(String projectId, String historyId) {
                        super(ToolResults.this, "GET", REST_PATH, null, ListExecutionsResponse.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public List set$Xgafv(String $Xgafv) {
                        return (List)super.set$Xgafv($Xgafv);
                    }

                    public List setAccessToken(String accessToken) {
                        return (List)super.setAccessToken(accessToken);
                    }

                    public List setAlt(String alt) {
                        return (List)super.setAlt(alt);
                    }

                    public List setCallback(String callback) {
                        return (List)super.setCallback(callback);
                    }

                    public List setFields(String fields) {
                        return (List)super.setFields(fields);
                    }

                    public List setKey(String key) {
                        return (List)super.setKey(key);
                    }

                    public List setOauthToken(String oauthToken) {
                        return (List)super.setOauthToken(oauthToken);
                    }

                    public List setPrettyPrint(Boolean prettyPrint) {
                        return (List)super.setPrettyPrint(prettyPrint);
                    }

                    public List setQuotaUser(String quotaUser) {
                        return (List)super.setQuotaUser(quotaUser);
                    }

                    public List setUploadType(String uploadType) {
                        return (List)super.setUploadType(uploadType);
                    }

                    public List setUploadProtocol(String uploadProtocol) {
                        return (List)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public List setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getHistoryId() {
                        return this.historyId;
                    }

                    public List setHistoryId(String historyId) {
                        this.historyId = historyId;
                        return this;
                    }

                    public Integer getPageSize() {
                        return this.pageSize;
                    }

                    public List setPageSize(Integer pageSize) {
                        this.pageSize = pageSize;
                        return this;
                    }

                    public String getPageToken() {
                        return this.pageToken;
                    }

                    public List setPageToken(String pageToken) {
                        this.pageToken = pageToken;
                        return this;
                    }

                    @Override
                    public List set(String parameterName, Object value) {
                        return (List)super.set(parameterName, value);
                    }
                }

                public class Get
                extends ToolResultsRequest<Execution> {
                    private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories/{historyId}/executions/{executionId}";
                    @Key
                    private String projectId;
                    @Key
                    private String historyId;
                    @Key
                    private String executionId;

                    protected Get(String projectId, String historyId, String executionId) {
                        super(ToolResults.this, "GET", REST_PATH, null, Execution.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                        this.executionId = (String)Preconditions.checkNotNull((Object)executionId, (Object)"Required parameter executionId must be specified.");
                    }

                    public HttpResponse executeUsingHead() throws IOException {
                        return super.executeUsingHead();
                    }

                    public HttpRequest buildHttpRequestUsingHead() throws IOException {
                        return super.buildHttpRequestUsingHead();
                    }

                    public Get set$Xgafv(String $Xgafv) {
                        return (Get)super.set$Xgafv($Xgafv);
                    }

                    public Get setAccessToken(String accessToken) {
                        return (Get)super.setAccessToken(accessToken);
                    }

                    public Get setAlt(String alt) {
                        return (Get)super.setAlt(alt);
                    }

                    public Get setCallback(String callback) {
                        return (Get)super.setCallback(callback);
                    }

                    public Get setFields(String fields) {
                        return (Get)super.setFields(fields);
                    }

                    public Get setKey(String key) {
                        return (Get)super.setKey(key);
                    }

                    public Get setOauthToken(String oauthToken) {
                        return (Get)super.setOauthToken(oauthToken);
                    }

                    public Get setPrettyPrint(Boolean prettyPrint) {
                        return (Get)super.setPrettyPrint(prettyPrint);
                    }

                    public Get setQuotaUser(String quotaUser) {
                        return (Get)super.setQuotaUser(quotaUser);
                    }

                    public Get setUploadType(String uploadType) {
                        return (Get)super.setUploadType(uploadType);
                    }

                    public Get setUploadProtocol(String uploadProtocol) {
                        return (Get)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Get setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getHistoryId() {
                        return this.historyId;
                    }

                    public Get setHistoryId(String historyId) {
                        this.historyId = historyId;
                        return this;
                    }

                    public String getExecutionId() {
                        return this.executionId;
                    }

                    public Get setExecutionId(String executionId) {
                        this.executionId = executionId;
                        return this;
                    }

                    @Override
                    public Get set(String parameterName, Object value) {
                        return (Get)super.set(parameterName, value);
                    }
                }

                public class Create
                extends ToolResultsRequest<Execution> {
                    private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories/{historyId}/executions";
                    @Key
                    private String projectId;
                    @Key
                    private String historyId;
                    @Key
                    private String requestId;

                    protected Create(String projectId, String historyId, Execution content) {
                        super(ToolResults.this, "POST", REST_PATH, (Object)content, Execution.class);
                        this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                        this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                    }

                    public Create set$Xgafv(String $Xgafv) {
                        return (Create)super.set$Xgafv($Xgafv);
                    }

                    public Create setAccessToken(String accessToken) {
                        return (Create)super.setAccessToken(accessToken);
                    }

                    public Create setAlt(String alt) {
                        return (Create)super.setAlt(alt);
                    }

                    public Create setCallback(String callback) {
                        return (Create)super.setCallback(callback);
                    }

                    public Create setFields(String fields) {
                        return (Create)super.setFields(fields);
                    }

                    public Create setKey(String key) {
                        return (Create)super.setKey(key);
                    }

                    public Create setOauthToken(String oauthToken) {
                        return (Create)super.setOauthToken(oauthToken);
                    }

                    public Create setPrettyPrint(Boolean prettyPrint) {
                        return (Create)super.setPrettyPrint(prettyPrint);
                    }

                    public Create setQuotaUser(String quotaUser) {
                        return (Create)super.setQuotaUser(quotaUser);
                    }

                    public Create setUploadType(String uploadType) {
                        return (Create)super.setUploadType(uploadType);
                    }

                    public Create setUploadProtocol(String uploadProtocol) {
                        return (Create)super.setUploadProtocol(uploadProtocol);
                    }

                    public String getProjectId() {
                        return this.projectId;
                    }

                    public Create setProjectId(String projectId) {
                        this.projectId = projectId;
                        return this;
                    }

                    public String getHistoryId() {
                        return this.historyId;
                    }

                    public Create setHistoryId(String historyId) {
                        this.historyId = historyId;
                        return this;
                    }

                    public String getRequestId() {
                        return this.requestId;
                    }

                    public Create setRequestId(String requestId) {
                        this.requestId = requestId;
                        return this;
                    }

                    @Override
                    public Create set(String parameterName, Object value) {
                        return (Create)super.set(parameterName, value);
                    }
                }
            }

            public class List
            extends ToolResultsRequest<ListHistoriesResponse> {
                private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories";
                @Key
                private String projectId;
                @Key
                private String filterByName;
                @Key
                private Integer pageSize;
                @Key
                private String pageToken;

                protected List(String projectId) {
                    super(ToolResults.this, "GET", REST_PATH, null, ListHistoriesResponse.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public List set$Xgafv(String $Xgafv) {
                    return (List)super.set$Xgafv($Xgafv);
                }

                public List setAccessToken(String accessToken) {
                    return (List)super.setAccessToken(accessToken);
                }

                public List setAlt(String alt) {
                    return (List)super.setAlt(alt);
                }

                public List setCallback(String callback) {
                    return (List)super.setCallback(callback);
                }

                public List setFields(String fields) {
                    return (List)super.setFields(fields);
                }

                public List setKey(String key) {
                    return (List)super.setKey(key);
                }

                public List setOauthToken(String oauthToken) {
                    return (List)super.setOauthToken(oauthToken);
                }

                public List setPrettyPrint(Boolean prettyPrint) {
                    return (List)super.setPrettyPrint(prettyPrint);
                }

                public List setQuotaUser(String quotaUser) {
                    return (List)super.setQuotaUser(quotaUser);
                }

                public List setUploadType(String uploadType) {
                    return (List)super.setUploadType(uploadType);
                }

                public List setUploadProtocol(String uploadProtocol) {
                    return (List)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public List setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getFilterByName() {
                    return this.filterByName;
                }

                public List setFilterByName(String filterByName) {
                    this.filterByName = filterByName;
                    return this;
                }

                public Integer getPageSize() {
                    return this.pageSize;
                }

                public List setPageSize(Integer pageSize) {
                    this.pageSize = pageSize;
                    return this;
                }

                public String getPageToken() {
                    return this.pageToken;
                }

                public List setPageToken(String pageToken) {
                    this.pageToken = pageToken;
                    return this;
                }

                @Override
                public List set(String parameterName, Object value) {
                    return (List)super.set(parameterName, value);
                }
            }

            public class Get
            extends ToolResultsRequest<History> {
                private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories/{historyId}";
                @Key
                private String projectId;
                @Key
                private String historyId;

                protected Get(String projectId, String historyId) {
                    super(ToolResults.this, "GET", REST_PATH, null, History.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                    this.historyId = (String)Preconditions.checkNotNull((Object)historyId, (Object)"Required parameter historyId must be specified.");
                }

                public HttpResponse executeUsingHead() throws IOException {
                    return super.executeUsingHead();
                }

                public HttpRequest buildHttpRequestUsingHead() throws IOException {
                    return super.buildHttpRequestUsingHead();
                }

                public Get set$Xgafv(String $Xgafv) {
                    return (Get)super.set$Xgafv($Xgafv);
                }

                public Get setAccessToken(String accessToken) {
                    return (Get)super.setAccessToken(accessToken);
                }

                public Get setAlt(String alt) {
                    return (Get)super.setAlt(alt);
                }

                public Get setCallback(String callback) {
                    return (Get)super.setCallback(callback);
                }

                public Get setFields(String fields) {
                    return (Get)super.setFields(fields);
                }

                public Get setKey(String key) {
                    return (Get)super.setKey(key);
                }

                public Get setOauthToken(String oauthToken) {
                    return (Get)super.setOauthToken(oauthToken);
                }

                public Get setPrettyPrint(Boolean prettyPrint) {
                    return (Get)super.setPrettyPrint(prettyPrint);
                }

                public Get setQuotaUser(String quotaUser) {
                    return (Get)super.setQuotaUser(quotaUser);
                }

                public Get setUploadType(String uploadType) {
                    return (Get)super.setUploadType(uploadType);
                }

                public Get setUploadProtocol(String uploadProtocol) {
                    return (Get)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Get setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getHistoryId() {
                    return this.historyId;
                }

                public Get setHistoryId(String historyId) {
                    this.historyId = historyId;
                    return this;
                }

                @Override
                public Get set(String parameterName, Object value) {
                    return (Get)super.set(parameterName, value);
                }
            }

            public class Create
            extends ToolResultsRequest<History> {
                private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/histories";
                @Key
                private String projectId;
                @Key
                private String requestId;

                protected Create(String projectId, History content) {
                    super(ToolResults.this, "POST", REST_PATH, (Object)content, History.class);
                    this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
                }

                public Create set$Xgafv(String $Xgafv) {
                    return (Create)super.set$Xgafv($Xgafv);
                }

                public Create setAccessToken(String accessToken) {
                    return (Create)super.setAccessToken(accessToken);
                }

                public Create setAlt(String alt) {
                    return (Create)super.setAlt(alt);
                }

                public Create setCallback(String callback) {
                    return (Create)super.setCallback(callback);
                }

                public Create setFields(String fields) {
                    return (Create)super.setFields(fields);
                }

                public Create setKey(String key) {
                    return (Create)super.setKey(key);
                }

                public Create setOauthToken(String oauthToken) {
                    return (Create)super.setOauthToken(oauthToken);
                }

                public Create setPrettyPrint(Boolean prettyPrint) {
                    return (Create)super.setPrettyPrint(prettyPrint);
                }

                public Create setQuotaUser(String quotaUser) {
                    return (Create)super.setQuotaUser(quotaUser);
                }

                public Create setUploadType(String uploadType) {
                    return (Create)super.setUploadType(uploadType);
                }

                public Create setUploadProtocol(String uploadProtocol) {
                    return (Create)super.setUploadProtocol(uploadProtocol);
                }

                public String getProjectId() {
                    return this.projectId;
                }

                public Create setProjectId(String projectId) {
                    this.projectId = projectId;
                    return this;
                }

                public String getRequestId() {
                    return this.requestId;
                }

                public Create setRequestId(String requestId) {
                    this.requestId = requestId;
                    return this;
                }

                @Override
                public Create set(String parameterName, Object value) {
                    return (Create)super.set(parameterName, value);
                }
            }
        }

        public class InitializeSettings
        extends ToolResultsRequest<ProjectSettings> {
            private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}:initializeSettings";
            @Key
            private String projectId;

            protected InitializeSettings(String projectId) {
                super(ToolResults.this, "POST", REST_PATH, null, ProjectSettings.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public InitializeSettings set$Xgafv(String $Xgafv) {
                return (InitializeSettings)super.set$Xgafv($Xgafv);
            }

            public InitializeSettings setAccessToken(String accessToken) {
                return (InitializeSettings)super.setAccessToken(accessToken);
            }

            public InitializeSettings setAlt(String alt) {
                return (InitializeSettings)super.setAlt(alt);
            }

            public InitializeSettings setCallback(String callback) {
                return (InitializeSettings)super.setCallback(callback);
            }

            public InitializeSettings setFields(String fields) {
                return (InitializeSettings)super.setFields(fields);
            }

            public InitializeSettings setKey(String key) {
                return (InitializeSettings)super.setKey(key);
            }

            public InitializeSettings setOauthToken(String oauthToken) {
                return (InitializeSettings)super.setOauthToken(oauthToken);
            }

            public InitializeSettings setPrettyPrint(Boolean prettyPrint) {
                return (InitializeSettings)super.setPrettyPrint(prettyPrint);
            }

            public InitializeSettings setQuotaUser(String quotaUser) {
                return (InitializeSettings)super.setQuotaUser(quotaUser);
            }

            public InitializeSettings setUploadType(String uploadType) {
                return (InitializeSettings)super.setUploadType(uploadType);
            }

            public InitializeSettings setUploadProtocol(String uploadProtocol) {
                return (InitializeSettings)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public InitializeSettings setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            @Override
            public InitializeSettings set(String parameterName, Object value) {
                return (InitializeSettings)super.set(parameterName, value);
            }
        }

        public class GetSettings
        extends ToolResultsRequest<ProjectSettings> {
            private static final String REST_PATH = "toolresults/v1beta3/projects/{projectId}/settings";
            @Key
            private String projectId;

            protected GetSettings(String projectId) {
                super(ToolResults.this, "GET", REST_PATH, null, ProjectSettings.class);
                this.projectId = (String)Preconditions.checkNotNull((Object)projectId, (Object)"Required parameter projectId must be specified.");
            }

            public HttpResponse executeUsingHead() throws IOException {
                return super.executeUsingHead();
            }

            public HttpRequest buildHttpRequestUsingHead() throws IOException {
                return super.buildHttpRequestUsingHead();
            }

            public GetSettings set$Xgafv(String $Xgafv) {
                return (GetSettings)super.set$Xgafv($Xgafv);
            }

            public GetSettings setAccessToken(String accessToken) {
                return (GetSettings)super.setAccessToken(accessToken);
            }

            public GetSettings setAlt(String alt) {
                return (GetSettings)super.setAlt(alt);
            }

            public GetSettings setCallback(String callback) {
                return (GetSettings)super.setCallback(callback);
            }

            public GetSettings setFields(String fields) {
                return (GetSettings)super.setFields(fields);
            }

            public GetSettings setKey(String key) {
                return (GetSettings)super.setKey(key);
            }

            public GetSettings setOauthToken(String oauthToken) {
                return (GetSettings)super.setOauthToken(oauthToken);
            }

            public GetSettings setPrettyPrint(Boolean prettyPrint) {
                return (GetSettings)super.setPrettyPrint(prettyPrint);
            }

            public GetSettings setQuotaUser(String quotaUser) {
                return (GetSettings)super.setQuotaUser(quotaUser);
            }

            public GetSettings setUploadType(String uploadType) {
                return (GetSettings)super.setUploadType(uploadType);
            }

            public GetSettings setUploadProtocol(String uploadProtocol) {
                return (GetSettings)super.setUploadProtocol(uploadProtocol);
            }

            public String getProjectId() {
                return this.projectId;
            }

            public GetSettings setProjectId(String projectId) {
                this.projectId = projectId;
                return this;
            }

            @Override
            public GetSettings set(String parameterName, Object value) {
                return (GetSettings)super.set(parameterName, value);
            }
        }
    }
}

