/*
 * Decompiled with CFR 0.152.
 */
package com.google.firebase.crashlytics.v1main;

import com.google.firebase.crashlytics.v1main.ErrorType;
import com.google.firebase.crashlytics.v1main.FirebaseCrashlyticsProto;
import com.google.firebase.crashlytics.v1main.IssueFilterOrBuilder;
import com.google.firebase.crashlytics.v1main.IssueSignals;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class IssueFilter
extends GeneratedMessageV3
implements IssueFilterOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int ID_FIELD_NUMBER = 1;
    private volatile Object id_ = "";
    public static final int VARIANT_ID_FIELD_NUMBER = 4;
    private volatile Object variantId_ = "";
    public static final int ERROR_TYPES_FIELD_NUMBER = 2;
    private List<Integer> errorTypes_;
    private static final Internal.ListAdapter.Converter<Integer, ErrorType> errorTypes_converter_ = new Internal.ListAdapter.Converter<Integer, ErrorType>(){

        public ErrorType convert(Integer from) {
            ErrorType result = ErrorType.forNumber(from);
            return result == null ? ErrorType.UNRECOGNIZED : result;
        }
    };
    private int errorTypesMemoizedSerializedSize;
    public static final int SIGNALS_FIELD_NUMBER = 3;
    private List<Integer> signals_;
    private static final Internal.ListAdapter.Converter<Integer, IssueSignals.Signal> signals_converter_ = new Internal.ListAdapter.Converter<Integer, IssueSignals.Signal>(){

        public IssueSignals.Signal convert(Integer from) {
            IssueSignals.Signal result = IssueSignals.Signal.forNumber(from);
            return result == null ? IssueSignals.Signal.UNRECOGNIZED : result;
        }
    };
    private int signalsMemoizedSerializedSize;
    private byte memoizedIsInitialized = (byte)-1;
    private static final IssueFilter DEFAULT_INSTANCE = new IssueFilter();
    private static final Parser<IssueFilter> PARSER = new AbstractParser<IssueFilter>(){

        public IssueFilter parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = IssueFilter.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private IssueFilter(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private IssueFilter() {
        this.id_ = "";
        this.variantId_ = "";
        this.errorTypes_ = Collections.emptyList();
        this.signals_ = Collections.emptyList();
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new IssueFilter();
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return FirebaseCrashlyticsProto.internal_static_google_firebase_crashlytics_v1alpha_IssueFilter_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return FirebaseCrashlyticsProto.internal_static_google_firebase_crashlytics_v1alpha_IssueFilter_fieldAccessorTable.ensureFieldAccessorsInitialized(IssueFilter.class, Builder.class);
    }

    @Override
    public String getId() {
        Object ref = this.id_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.id_ = s;
        return s;
    }

    @Override
    public ByteString getIdBytes() {
        Object ref = this.id_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.id_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getVariantId() {
        Object ref = this.variantId_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.variantId_ = s;
        return s;
    }

    @Override
    public ByteString getVariantIdBytes() {
        Object ref = this.variantId_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.variantId_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<ErrorType> getErrorTypesList() {
        return new Internal.ListAdapter(this.errorTypes_, errorTypes_converter_);
    }

    @Override
    public int getErrorTypesCount() {
        return this.errorTypes_.size();
    }

    @Override
    public ErrorType getErrorTypes(int index) {
        return (ErrorType)((Object)errorTypes_converter_.convert((Object)this.errorTypes_.get(index)));
    }

    @Override
    public List<Integer> getErrorTypesValueList() {
        return this.errorTypes_;
    }

    @Override
    public int getErrorTypesValue(int index) {
        return this.errorTypes_.get(index);
    }

    @Override
    public List<IssueSignals.Signal> getSignalsList() {
        return new Internal.ListAdapter(this.signals_, signals_converter_);
    }

    @Override
    public int getSignalsCount() {
        return this.signals_.size();
    }

    @Override
    public IssueSignals.Signal getSignals(int index) {
        return (IssueSignals.Signal)((Object)signals_converter_.convert((Object)this.signals_.get(index)));
    }

    @Override
    public List<Integer> getSignalsValueList() {
        return this.signals_;
    }

    @Override
    public int getSignalsValue(int index) {
        return this.signals_.get(index);
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if (!GeneratedMessageV3.isStringEmpty((Object)this.id_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.id_);
        }
        if (this.getErrorTypesList().size() > 0) {
            output.writeUInt32NoTag(18);
            output.writeUInt32NoTag(this.errorTypesMemoizedSerializedSize);
        }
        for (i = 0; i < this.errorTypes_.size(); ++i) {
            output.writeEnumNoTag(this.errorTypes_.get(i).intValue());
        }
        if (this.getSignalsList().size() > 0) {
            output.writeUInt32NoTag(26);
            output.writeUInt32NoTag(this.signalsMemoizedSerializedSize);
        }
        for (i = 0; i < this.signals_.size(); ++i) {
            output.writeEnumNoTag(this.signals_.get(i).intValue());
        }
        if (!GeneratedMessageV3.isStringEmpty((Object)this.variantId_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.variantId_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.id_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.id_);
        }
        int dataSize = 0;
        for (i = 0; i < this.errorTypes_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.errorTypes_.get(i));
        }
        size += dataSize;
        if (!this.getErrorTypesList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.errorTypesMemoizedSerializedSize = dataSize;
        dataSize = 0;
        for (i = 0; i < this.signals_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.signals_.get(i));
        }
        size += dataSize;
        if (!this.getSignalsList().isEmpty()) {
            ++size;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.signalsMemoizedSerializedSize = dataSize;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.variantId_)) {
            size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.variantId_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof IssueFilter)) {
            return super.equals(obj);
        }
        IssueFilter other = (IssueFilter)obj;
        if (!this.getId().equals(other.getId())) {
            return false;
        }
        if (!this.getVariantId().equals(other.getVariantId())) {
            return false;
        }
        if (!this.errorTypes_.equals(other.errorTypes_)) {
            return false;
        }
        if (!this.signals_.equals(other.signals_)) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + IssueFilter.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getId().hashCode();
        hash = 37 * hash + 4;
        hash = 53 * hash + this.getVariantId().hashCode();
        if (this.getErrorTypesCount() > 0) {
            hash = 37 * hash + 2;
            hash = 53 * hash + this.errorTypes_.hashCode();
        }
        if (this.getSignalsCount() > 0) {
            hash = 37 * hash + 3;
            hash = 53 * hash + this.signals_.hashCode();
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static IssueFilter parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (IssueFilter)PARSER.parseFrom(data);
    }

    public static IssueFilter parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (IssueFilter)PARSER.parseFrom(data, extensionRegistry);
    }

    public static IssueFilter parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (IssueFilter)PARSER.parseFrom(data);
    }

    public static IssueFilter parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (IssueFilter)PARSER.parseFrom(data, extensionRegistry);
    }

    public static IssueFilter parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (IssueFilter)PARSER.parseFrom(data);
    }

    public static IssueFilter parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (IssueFilter)PARSER.parseFrom(data, extensionRegistry);
    }

    public static IssueFilter parseFrom(InputStream input) throws IOException {
        return (IssueFilter)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static IssueFilter parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (IssueFilter)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static IssueFilter parseDelimitedFrom(InputStream input) throws IOException {
        return (IssueFilter)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static IssueFilter parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (IssueFilter)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static IssueFilter parseFrom(CodedInputStream input) throws IOException {
        return (IssueFilter)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static IssueFilter parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (IssueFilter)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return IssueFilter.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(IssueFilter prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static IssueFilter getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<IssueFilter> parser() {
        return PARSER;
    }

    public Parser<IssueFilter> getParserForType() {
        return PARSER;
    }

    public IssueFilter getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements IssueFilterOrBuilder {
        private int bitField0_;
        private Object id_ = "";
        private Object variantId_ = "";
        private List<Integer> errorTypes_ = Collections.emptyList();
        private List<Integer> signals_ = Collections.emptyList();

        public static final Descriptors.Descriptor getDescriptor() {
            return FirebaseCrashlyticsProto.internal_static_google_firebase_crashlytics_v1alpha_IssueFilter_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return FirebaseCrashlyticsProto.internal_static_google_firebase_crashlytics_v1alpha_IssueFilter_fieldAccessorTable.ensureFieldAccessorsInitialized(IssueFilter.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            this.id_ = "";
            this.variantId_ = "";
            this.errorTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFB;
            this.signals_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFF7;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return FirebaseCrashlyticsProto.internal_static_google_firebase_crashlytics_v1alpha_IssueFilter_descriptor;
        }

        public IssueFilter getDefaultInstanceForType() {
            return IssueFilter.getDefaultInstance();
        }

        public IssueFilter build() {
            IssueFilter result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public IssueFilter buildPartial() {
            IssueFilter result = new IssueFilter(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(IssueFilter result) {
            if ((this.bitField0_ & 4) != 0) {
                this.errorTypes_ = Collections.unmodifiableList(this.errorTypes_);
                this.bitField0_ &= 0xFFFFFFFB;
            }
            result.errorTypes_ = this.errorTypes_;
            if ((this.bitField0_ & 8) != 0) {
                this.signals_ = Collections.unmodifiableList(this.signals_);
                this.bitField0_ &= 0xFFFFFFF7;
            }
            result.signals_ = this.signals_;
        }

        private void buildPartial0(IssueFilter result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 1) != 0) {
                result.id_ = this.id_;
            }
            if ((from_bitField0_ & 2) != 0) {
                result.variantId_ = this.variantId_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof IssueFilter) {
                return this.mergeFrom((IssueFilter)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(IssueFilter other) {
            if (other == IssueFilter.getDefaultInstance()) {
                return this;
            }
            if (!other.getId().isEmpty()) {
                this.id_ = other.id_;
                this.bitField0_ |= 1;
                this.onChanged();
            }
            if (!other.getVariantId().isEmpty()) {
                this.variantId_ = other.variantId_;
                this.bitField0_ |= 2;
                this.onChanged();
            }
            if (!other.errorTypes_.isEmpty()) {
                if (this.errorTypes_.isEmpty()) {
                    this.errorTypes_ = other.errorTypes_;
                    this.bitField0_ &= 0xFFFFFFFB;
                } else {
                    this.ensureErrorTypesIsMutable();
                    this.errorTypes_.addAll(other.errorTypes_);
                }
                this.onChanged();
            }
            if (!other.signals_.isEmpty()) {
                if (this.signals_.isEmpty()) {
                    this.signals_ = other.signals_;
                    this.bitField0_ &= 0xFFFFFFF7;
                } else {
                    this.ensureSignalsIsMutable();
                    this.signals_.addAll(other.signals_);
                }
                this.onChanged();
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block14: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block14;
                        }
                        case 10: {
                            this.id_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 1;
                            continue block14;
                        }
                        case 16: {
                            int tmpRaw = input.readEnum();
                            this.ensureErrorTypesIsMutable();
                            this.errorTypes_.add(tmpRaw);
                            continue block14;
                        }
                        case 18: {
                            int tmpRaw;
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                tmpRaw = input.readEnum();
                                this.ensureErrorTypesIsMutable();
                                this.errorTypes_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block14;
                        }
                        case 24: {
                            int tmpRaw = input.readEnum();
                            this.ensureSignalsIsMutable();
                            this.signals_.add(tmpRaw);
                            continue block14;
                        }
                        case 26: {
                            int tmpRaw;
                            int length = input.readRawVarint32();
                            int oldLimit = input.pushLimit(length);
                            while (input.getBytesUntilLimit() > 0) {
                                tmpRaw = input.readEnum();
                                this.ensureSignalsIsMutable();
                                this.signals_.add(tmpRaw);
                            }
                            input.popLimit(oldLimit);
                            continue block14;
                        }
                        case 34: {
                            this.variantId_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block14;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public String getId() {
            Object ref = this.id_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.id_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getIdBytes() {
            Object ref = this.id_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.id_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.id_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        public Builder clearId() {
            this.id_ = IssueFilter.getDefaultInstance().getId();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        public Builder setIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            IssueFilter.checkByteStringIsUtf8((ByteString)value);
            this.id_ = value;
            this.bitField0_ |= 1;
            this.onChanged();
            return this;
        }

        @Override
        public String getVariantId() {
            Object ref = this.variantId_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.variantId_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getVariantIdBytes() {
            Object ref = this.variantId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.variantId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setVariantId(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.variantId_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        public Builder clearVariantId() {
            this.variantId_ = IssueFilter.getDefaultInstance().getVariantId();
            this.bitField0_ &= 0xFFFFFFFD;
            this.onChanged();
            return this;
        }

        public Builder setVariantIdBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            IssueFilter.checkByteStringIsUtf8((ByteString)value);
            this.variantId_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        private void ensureErrorTypesIsMutable() {
            if ((this.bitField0_ & 4) == 0) {
                this.errorTypes_ = new ArrayList<Integer>(this.errorTypes_);
                this.bitField0_ |= 4;
            }
        }

        @Override
        public List<ErrorType> getErrorTypesList() {
            return new Internal.ListAdapter(this.errorTypes_, errorTypes_converter_);
        }

        @Override
        public int getErrorTypesCount() {
            return this.errorTypes_.size();
        }

        @Override
        public ErrorType getErrorTypes(int index) {
            return (ErrorType)((Object)errorTypes_converter_.convert((Object)this.errorTypes_.get(index)));
        }

        public Builder setErrorTypes(int index, ErrorType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureErrorTypesIsMutable();
            this.errorTypes_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addErrorTypes(ErrorType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureErrorTypesIsMutable();
            this.errorTypes_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllErrorTypes(Iterable<? extends ErrorType> values) {
            this.ensureErrorTypesIsMutable();
            for (ErrorType errorType : values) {
                this.errorTypes_.add(errorType.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearErrorTypes() {
            this.errorTypes_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFB;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getErrorTypesValueList() {
            return Collections.unmodifiableList(this.errorTypes_);
        }

        @Override
        public int getErrorTypesValue(int index) {
            return this.errorTypes_.get(index);
        }

        public Builder setErrorTypesValue(int index, int value) {
            this.ensureErrorTypesIsMutable();
            this.errorTypes_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addErrorTypesValue(int value) {
            this.ensureErrorTypesIsMutable();
            this.errorTypes_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllErrorTypesValue(Iterable<Integer> values) {
            this.ensureErrorTypesIsMutable();
            for (int value : values) {
                this.errorTypes_.add(value);
            }
            this.onChanged();
            return this;
        }

        private void ensureSignalsIsMutable() {
            if ((this.bitField0_ & 8) == 0) {
                this.signals_ = new ArrayList<Integer>(this.signals_);
                this.bitField0_ |= 8;
            }
        }

        @Override
        public List<IssueSignals.Signal> getSignalsList() {
            return new Internal.ListAdapter(this.signals_, signals_converter_);
        }

        @Override
        public int getSignalsCount() {
            return this.signals_.size();
        }

        @Override
        public IssueSignals.Signal getSignals(int index) {
            return (IssueSignals.Signal)((Object)signals_converter_.convert((Object)this.signals_.get(index)));
        }

        public Builder setSignals(int index, IssueSignals.Signal value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureSignalsIsMutable();
            this.signals_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addSignals(IssueSignals.Signal value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureSignalsIsMutable();
            this.signals_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllSignals(Iterable<? extends IssueSignals.Signal> values) {
            this.ensureSignalsIsMutable();
            for (IssueSignals.Signal signal : values) {
                this.signals_.add(signal.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearSignals() {
            this.signals_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFF7;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getSignalsValueList() {
            return Collections.unmodifiableList(this.signals_);
        }

        @Override
        public int getSignalsValue(int index) {
            return this.signals_.get(index);
        }

        public Builder setSignalsValue(int index, int value) {
            this.ensureSignalsIsMutable();
            this.signals_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addSignalsValue(int value) {
            this.ensureSignalsIsMutable();
            this.signals_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllSignalsValue(Iterable<Integer> values) {
            this.ensureSignalsIsMutable();
            for (int value : values) {
                this.signals_.add(value);
            }
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }
}

