/*
 * Decompiled with CFR 0.152.
 */
package aida.io.opencensus.metrics;

import aida.io.opencensus.internal.Utils;
import aida.io.opencensus.metrics.LabelKey;
import aida.io.opencensus.metrics.LabelValue;
import java.util.List;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public abstract class LongCumulative {
    public abstract LongPoint getOrCreateTimeSeries(List<LabelValue> var1);

    public abstract LongPoint getDefaultTimeSeries();

    public abstract void removeTimeSeries(List<LabelValue> var1);

    public abstract void clear();

    static LongCumulative newNoopLongCumulative(String name, String description, String unit, List<LabelKey> labelKeys) {
        return NoopLongCumulative.create(name, description, unit, labelKeys);
    }

    private static final class NoopLongCumulative
    extends LongCumulative {
        private final int labelKeysSize;

        static NoopLongCumulative create(String name, String description, String unit, List<LabelKey> labelKeys) {
            return new NoopLongCumulative(name, description, unit, labelKeys);
        }

        NoopLongCumulative(String name, String description, String unit, List<LabelKey> labelKeys) {
            this.labelKeysSize = labelKeys.size();
        }

        @Override
        public NoopLongPoint getOrCreateTimeSeries(List<LabelValue> labelValues) {
            Utils.checkListElementNotNull(Utils.checkNotNull(labelValues, "labelValues"), "labelValue");
            Utils.checkArgument(this.labelKeysSize == labelValues.size(), "Label Keys and Label Values don't have same size.");
            return NoopLongPoint.INSTANCE;
        }

        @Override
        public NoopLongPoint getDefaultTimeSeries() {
            return NoopLongPoint.INSTANCE;
        }

        @Override
        public void removeTimeSeries(List<LabelValue> labelValues) {
            Utils.checkNotNull(labelValues, "labelValues");
        }

        @Override
        public void clear() {
        }

        private static final class NoopLongPoint
        extends LongPoint {
            private static final NoopLongPoint INSTANCE = new NoopLongPoint();

            private NoopLongPoint() {
            }

            @Override
            public void add(long delta) {
            }
        }
    }

    public static abstract class LongPoint {
        public abstract void add(long var1);
    }
}

