/*
 * Decompiled with CFR 0.152.
 */
package aida.io.grpc.okhttp;

import aida.io.grpc.internal.SerializingExecutor;
import aida.io.grpc.okhttp.ExceptionHandlingFrameWriter;
import aida.io.grpc.okhttp.ForwardingFrameWriter;
import aida.io.grpc.okhttp.internal.framed.ErrorCode;
import aida.io.grpc.okhttp.internal.framed.FrameWriter;
import aida.io.grpc.okhttp.internal.framed.Settings;
import aida.io.perfmark.Link;
import aida.io.perfmark.PerfMark;
import aida.io.perfmark.TaskCloseable;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.Socket;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import okio.Buffer;
import okio.Sink;
import okio.Timeout;

final class AsyncSink
implements Sink {
    private final Object lock = new Object();
    private final Buffer buffer = new Buffer();
    private final SerializingExecutor serializingExecutor;
    private final ExceptionHandlingFrameWriter.TransportExceptionHandler transportExceptionHandler;
    private final int maxQueuedControlFrames;
    @GuardedBy(value="lock")
    private boolean writeEnqueued = false;
    @GuardedBy(value="lock")
    private boolean flushEnqueued = false;
    private boolean closed = false;
    @Nullable
    private Sink sink;
    @Nullable
    private Socket socket;
    private boolean controlFramesExceeded;
    private int controlFramesInWrite;
    @GuardedBy(value="lock")
    private int queuedControlFrames;

    private AsyncSink(SerializingExecutor executor, ExceptionHandlingFrameWriter.TransportExceptionHandler exceptionHandler, int maxQueuedControlFrames) {
        this.serializingExecutor = (SerializingExecutor)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.transportExceptionHandler = (ExceptionHandlingFrameWriter.TransportExceptionHandler)Preconditions.checkNotNull((Object)exceptionHandler, (Object)"exceptionHandler");
        this.maxQueuedControlFrames = maxQueuedControlFrames;
    }

    static AsyncSink sink(SerializingExecutor executor, ExceptionHandlingFrameWriter.TransportExceptionHandler exceptionHandler, int maxQueuedControlFrames) {
        return new AsyncSink(executor, exceptionHandler, maxQueuedControlFrames);
    }

    void becomeConnected(Sink sink, Socket socket) {
        Preconditions.checkState((this.sink == null ? 1 : 0) != 0, (Object)"AsyncSink's becomeConnected should only be called once.");
        this.sink = (Sink)Preconditions.checkNotNull((Object)sink, (Object)"sink");
        this.socket = (Socket)Preconditions.checkNotNull((Object)socket, (Object)"socket");
    }

    FrameWriter limitControlFramesWriter(FrameWriter delegate) {
        return new LimitControlFramesWriter(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Buffer source, long byteCount) throws IOException {
        Preconditions.checkNotNull((Object)source, (Object)"source");
        if (this.closed) {
            throw new IOException("closed");
        }
        try (TaskCloseable ignore = PerfMark.traceTask("AsyncSink.write");){
            boolean closeSocket;
            block19: {
                closeSocket = false;
                Object object = this.lock;
                synchronized (object) {
                    block16: {
                        block18: {
                            this.buffer.write(source, byteCount);
                            this.queuedControlFrames += this.controlFramesInWrite;
                            this.controlFramesInWrite = 0;
                            if (this.controlFramesExceeded || this.queuedControlFrames <= this.maxQueuedControlFrames) break block18;
                            this.controlFramesExceeded = true;
                            closeSocket = true;
                            break block19;
                        }
                        if (!this.writeEnqueued && !this.flushEnqueued && this.buffer.completeSegmentByteCount() > 0L) break block16;
                        return;
                    }
                    this.writeEnqueued = true;
                }
            }
            if (closeSocket) {
                try {
                    this.socket.close();
                }
                catch (IOException e) {
                    this.transportExceptionHandler.onException(e);
                }
                return;
            }
            this.serializingExecutor.execute(new WriteRunnable(){
                final Link link = PerfMark.linkOut();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void doRun() throws IOException {
                    Buffer buf = new Buffer();
                    try (TaskCloseable ignore = PerfMark.traceTask("WriteRunnable.runWrite");){
                        int writingControlFrames;
                        PerfMark.linkIn(this.link);
                        Object object = AsyncSink.this.lock;
                        synchronized (object) {
                            buf.write(AsyncSink.this.buffer, AsyncSink.this.buffer.completeSegmentByteCount());
                            AsyncSink.this.writeEnqueued = false;
                            writingControlFrames = AsyncSink.this.queuedControlFrames;
                        }
                        AsyncSink.this.sink.write(buf, buf.size());
                        object = AsyncSink.this.lock;
                        synchronized (object) {
                            AsyncSink.this.queuedControlFrames -= writingControlFrames;
                        }
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() throws IOException {
        if (this.closed) {
            throw new IOException("closed");
        }
        try (TaskCloseable ignore = PerfMark.traceTask("AsyncSink.flush");){
            Object object = this.lock;
            synchronized (object) {
                block12: {
                    if (!this.flushEnqueued) break block12;
                    return;
                }
                this.flushEnqueued = true;
            }
            this.serializingExecutor.execute(new WriteRunnable(){
                final Link link = PerfMark.linkOut();

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void doRun() throws IOException {
                    Buffer buf = new Buffer();
                    try (TaskCloseable ignore = PerfMark.traceTask("WriteRunnable.runFlush");){
                        PerfMark.linkIn(this.link);
                        Object object = AsyncSink.this.lock;
                        synchronized (object) {
                            buf.write(AsyncSink.this.buffer, AsyncSink.this.buffer.size());
                            AsyncSink.this.flushEnqueued = false;
                        }
                        AsyncSink.this.sink.write(buf, buf.size());
                        AsyncSink.this.sink.flush();
                    }
                }
            });
        }
    }

    public Timeout timeout() {
        return Timeout.NONE;
    }

    public void close() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        this.serializingExecutor.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    if (AsyncSink.this.sink != null && AsyncSink.this.buffer.size() > 0L) {
                        AsyncSink.this.sink.write(AsyncSink.this.buffer, AsyncSink.this.buffer.size());
                    }
                }
                catch (IOException e) {
                    AsyncSink.this.transportExceptionHandler.onException(e);
                }
                AsyncSink.this.buffer.close();
                try {
                    if (AsyncSink.this.sink != null) {
                        AsyncSink.this.sink.close();
                    }
                }
                catch (IOException e) {
                    AsyncSink.this.transportExceptionHandler.onException(e);
                }
                try {
                    if (AsyncSink.this.socket != null) {
                        AsyncSink.this.socket.close();
                    }
                }
                catch (IOException e) {
                    AsyncSink.this.transportExceptionHandler.onException(e);
                }
            }
        });
    }

    private class LimitControlFramesWriter
    extends ForwardingFrameWriter {
        public LimitControlFramesWriter(FrameWriter delegate) {
            super(delegate);
        }

        @Override
        public void ackSettings(Settings peerSettings) throws IOException {
            AsyncSink.this.controlFramesInWrite++;
            super.ackSettings(peerSettings);
        }

        @Override
        public void rstStream(int streamId, ErrorCode errorCode) throws IOException {
            AsyncSink.this.controlFramesInWrite++;
            super.rstStream(streamId, errorCode);
        }

        @Override
        public void ping(boolean ack, int payload1, int payload2) throws IOException {
            if (ack) {
                AsyncSink.this.controlFramesInWrite++;
            }
            super.ping(ack, payload1, payload2);
        }
    }

    private abstract class WriteRunnable
    implements Runnable {
        private WriteRunnable() {
        }

        @Override
        public final void run() {
            try {
                if (AsyncSink.this.sink == null) {
                    throw new IOException("Unable to perform write due to unavailable sink.");
                }
                this.doRun();
            }
            catch (Exception e) {
                AsyncSink.this.transportExceptionHandler.onException(e);
            }
        }

        public abstract void doRun() throws IOException;
    }
}

