/*
 * Decompiled with CFR 0.152.
 */
package aida.io.grpc.netty.shaded.io.grpc.netty;

import aida.io.grpc.Internal;
import aida.io.grpc.NameResolver;
import aida.io.grpc.NameResolverProvider;
import aida.io.grpc.netty.shaded.io.grpc.netty.UdsNameResolver;
import aida.io.grpc.netty.shaded.io.netty.channel.unix.DomainSocketAddress;
import com.google.common.base.Preconditions;
import java.net.SocketAddress;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;

@Internal
public final class UdsNameResolverProvider
extends NameResolverProvider {
    private static final String SCHEME = "unix";

    @Override
    public UdsNameResolver newNameResolver(URI targetUri, NameResolver.Args args) {
        if (SCHEME.equals(targetUri.getScheme())) {
            return new UdsNameResolver(targetUri.getAuthority(), UdsNameResolverProvider.getTargetPathFromUri(targetUri), args);
        }
        return null;
    }

    static String getTargetPathFromUri(URI targetUri) {
        Preconditions.checkArgument((boolean)SCHEME.equals(targetUri.getScheme()), (Object)"scheme must be unix");
        String targetPath = targetUri.getPath();
        if (targetPath == null) {
            targetPath = (String)Preconditions.checkNotNull((Object)targetUri.getSchemeSpecificPart(), (Object)"targetPath");
        }
        return targetPath;
    }

    @Override
    public String getDefaultScheme() {
        return SCHEME;
    }

    @Override
    protected boolean isAvailable() {
        return true;
    }

    @Override
    protected int priority() {
        return 3;
    }

    @Override
    public Collection<Class<? extends SocketAddress>> getProducedSocketAddressTypes() {
        return Collections.singleton(DomainSocketAddress.class);
    }
}

