/*
 * Decompiled with CFR 0.152.
 */
package aida.io.grpc.internal;

import aida.io.grpc.CallOptions;
import aida.io.grpc.Channel;
import aida.io.grpc.ClientCall;
import aida.io.grpc.ClientStreamTracer;
import aida.io.grpc.Context;
import aida.io.grpc.InternalConfigSelector;
import aida.io.grpc.Metadata;
import aida.io.grpc.MethodDescriptor;
import aida.io.grpc.Status;
import aida.io.grpc.internal.CallTracer;
import aida.io.grpc.internal.ClientCallImpl;
import aida.io.grpc.internal.ClientStream;
import aida.io.grpc.internal.ClientStreamListener;
import aida.io.grpc.internal.ClientTransport;
import aida.io.grpc.internal.FailingClientTransport;
import aida.io.grpc.internal.GrpcUtil;
import aida.io.grpc.internal.InternalSubchannel;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicReference;

final class SubchannelChannel
extends Channel {
    @VisibleForTesting
    static final Status NOT_READY_ERROR = Status.UNAVAILABLE.withDescription("Subchannel is NOT READY");
    @VisibleForTesting
    static final Status WAIT_FOR_READY_ERROR = Status.UNAVAILABLE.withDescription("wait-for-ready RPC is not supported on Subchannel.asChannel()");
    private static final FailingClientTransport notReadyTransport = new FailingClientTransport(NOT_READY_ERROR, ClientStreamListener.RpcProgress.MISCARRIED);
    private final InternalSubchannel subchannel;
    private final Executor executor;
    private final ScheduledExecutorService deadlineCancellationExecutor;
    private final CallTracer callsTracer;
    private final AtomicReference<InternalConfigSelector> configSelector;
    private final ClientCallImpl.ClientStreamProvider transportProvider = new ClientCallImpl.ClientStreamProvider(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public ClientStream newStream(MethodDescriptor<?, ?> method, CallOptions callOptions, Metadata headers, Context context) {
            ClientTransport transport = SubchannelChannel.this.subchannel.getTransport();
            if (transport == null) {
                transport = notReadyTransport;
            }
            ClientStreamTracer[] tracers = GrpcUtil.getClientStreamTracers(callOptions, headers, 0, false);
            Context origContext = context.attach();
            try {
                ClientStream clientStream = transport.newStream(method, headers, callOptions, tracers);
                return clientStream;
            }
            finally {
                context.detach(origContext);
            }
        }
    };

    SubchannelChannel(InternalSubchannel subchannel, Executor executor, ScheduledExecutorService deadlineCancellationExecutor, CallTracer callsTracer, AtomicReference<InternalConfigSelector> configSelector) {
        this.subchannel = (InternalSubchannel)Preconditions.checkNotNull((Object)subchannel, (Object)"subchannel");
        this.executor = (Executor)Preconditions.checkNotNull((Object)executor, (Object)"executor");
        this.deadlineCancellationExecutor = (ScheduledExecutorService)Preconditions.checkNotNull((Object)deadlineCancellationExecutor, (Object)"deadlineCancellationExecutor");
        this.callsTracer = (CallTracer)Preconditions.checkNotNull((Object)callsTracer, (Object)"callsTracer");
        this.configSelector = (AtomicReference)Preconditions.checkNotNull(configSelector, (Object)"configSelector");
    }

    @Override
    public <RequestT, ResponseT> ClientCall<RequestT, ResponseT> newCall(MethodDescriptor<RequestT, ResponseT> methodDescriptor, CallOptions callOptions) {
        Executor effectiveExecutor;
        Executor executor = effectiveExecutor = callOptions.getExecutor() == null ? this.executor : callOptions.getExecutor();
        if (callOptions.isWaitForReady()) {
            return new ClientCall<RequestT, ResponseT>(){

                @Override
                public void start(final ClientCall.Listener<ResponseT> listener, Metadata headers) {
                    effectiveExecutor.execute(new Runnable(){

                        @Override
                        public void run() {
                            listener.onClose(WAIT_FOR_READY_ERROR, new Metadata());
                        }
                    });
                }

                @Override
                public void request(int numMessages) {
                }

                @Override
                public void cancel(String message, Throwable cause) {
                }

                @Override
                public void halfClose() {
                }

                @Override
                public void sendMessage(RequestT message) {
                }
            };
        }
        return new ClientCallImpl<RequestT, ResponseT>(methodDescriptor, effectiveExecutor, callOptions.withOption(GrpcUtil.CALL_OPTIONS_RPC_OWNED_BY_BALANCER, Boolean.TRUE), this.transportProvider, this.deadlineCancellationExecutor, this.callsTracer, this.configSelector.get());
    }

    @Override
    public String authority() {
        return this.subchannel.getAuthority();
    }
}

