/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.util;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.PathUtil;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;

public class StudioPathManager {
    private static final String ROOT_FROM_BUNDLED_SDK = "../../";
    private static final String ROOT_FROM_UNBUNDLED_SDK = "../../../../../../";

    public static boolean isRunningFromSources() {
        if (PluginManagerCore.isRunningFromSources()) {
            return true;
        }
        if (StudioPathManager.isRunningInBazelTest()) {
            return true;
        }
        return StudioPathManager.isRunningFromStudioSources();
    }

    @NotNull
    public static Path resolvePathFromSourcesRoot(@NotNull String relativePath) {
        return Paths.get(StudioPathManager.getSourcesRootInternal(), new String[0]).resolve(relativePath).normalize();
    }

    @Deprecated
    @NotNull
    public static String getSourcesRoot() {
        return StudioPathManager.getSourcesRootInternal();
    }

    @NotNull
    private static String getSourcesRootInternal() {
        assert (StudioPathManager.isRunningFromSources());
        if (PluginManagerCore.isRunningFromSources()) {
            return StudioPathManager.getSourcesRootBundled();
        }
        if (StudioPathManager.isRunningInBazelTest()) {
            if (PathManager.getHomePath().contains("/prebuilts/studio/intellij-sdk/") || PathManager.getHomePath().contains("\\prebuilts\\studio\\intellij-sdk\\")) {
                return StudioPathManager.getSourcesRootUnbundled();
            }
            return StudioPathManager.getSourcesRootBundled();
        }
        return StudioPathManager.getSourcesRootUnbundled();
    }

    public static String getBinariesRoot() {
        return StudioPathManager.isRunningInBazelTest() ? "" : StudioPathManager.getSourcesRootInternal() + "/bazel-bin";
    }

    private static boolean isRunningInBazelTest() {
        return System.getenv().containsKey("TEST_WORKSPACE");
    }

    private static boolean isRunningFromStudioSources() {
        return PathUtil.toSystemIndependentName((String)PathManager.getHomePath()).contains("/prebuilts/studio/intellij-sdk/");
    }

    private static String getSourcesRootBundled() {
        return Paths.get(PathManager.getHomePath(), ROOT_FROM_BUNDLED_SDK).normalize().toString();
    }

    private static String getSourcesRootUnbundled() {
        Object relative = ROOT_FROM_UNBUNDLED_SDK;
        if (SystemInfo.isMac) {
            relative = (String)relative + "../";
        }
        return Paths.get(PathManager.getHomePath(), new String[]{relative}).normalize().toString();
    }
}

