/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.perfetto;

import java.io.File;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CompletableJob;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.config.SocketConfig;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.FileEntity;
import org.apache.http.impl.bootstrap.ServerBootstrap;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u000b\u001a\u00020\fJ\u0016\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011R\u0016\u0010\b\u001a\n \n*\u0004\u0018\u00010\t0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/idea/perfetto/HttpServer;", "", "traceFile", "Ljava/io/File;", "requestReceivedLatch", "Lkotlinx/coroutines/CompletableJob;", "<init>", "(Ljava/io/File;Lkotlinx/coroutines/CompletableJob;)V", "server", "Lorg/apache/http/impl/bootstrap/HttpServer;", "kotlin.jvm.PlatformType", "start", "", "stop", "gracePeriod", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "intellij.android.common"})
final class HttpServer {
    private org.apache.http.impl.bootstrap.HttpServer server;

    public HttpServer(@NotNull File traceFile, @NotNull CompletableJob requestReceivedLatch) {
        Intrinsics.checkNotNullParameter((Object)traceFile, (String)"traceFile");
        Intrinsics.checkNotNullParameter((Object)requestReceivedLatch, (String)"requestReceivedLatch");
        this.server = ServerBootstrap.bootstrap().setListenerPort(9001).setSocketConfig(SocketConfig.custom().setSoReuseAddress(true).setSoKeepAlive(true).build()).registerHandler("/" + traceFile.getName(), (arg_0, arg_1, arg_2) -> HttpServer.server$lambda$0(traceFile, requestReceivedLatch, arg_0, arg_1, arg_2)).create();
    }

    public final void start() {
        this.server.start();
    }

    public final void stop(long gracePeriod, @NotNull TimeUnit timeUnit) {
        Intrinsics.checkNotNullParameter((Object)((Object)timeUnit), (String)"timeUnit");
        this.server.shutdown(gracePeriod, timeUnit);
    }

    private static final void server$lambda$0(File $traceFile, CompletableJob $requestReceivedLatch, HttpRequest request, HttpResponse response, HttpContext httpContext) {
        String string = request.getRequestLine().getMethod();
        if (Intrinsics.areEqual((Object)string, (Object)"OPTIONS")) {
            response.addHeader("Allow", "OPTIONS, GET");
        } else if (Intrinsics.areEqual((Object)string, (Object)"GET")) {
            response.setEntity((HttpEntity)new FileEntity($traceFile, ContentType.DEFAULT_BINARY));
            $requestReceivedLatch.complete();
        } else {
            response.setStatusCode(405);
            return;
        }
        response.setStatusCode(200);
        response.setHeader("Access-Control-Allow-Origin", "https://ui.perfetto.dev");
        response.setHeader("Cache-Control", "no-cache");
    }
}

