/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.ndk;

import com.android.tools.idea.serverflags.ServerFlagService;
import com.android.tools.idea.serverflags.protos.PageAlign16kb;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.Message;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u0017B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ\u001c\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fJ\u001c\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fJ\n\u0010\u0011\u001a\u0004\u0018\u00010\u0005H\u0002J\u0006\u0010\u0012\u001a\u00020\fJ$\u0010\u0013\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\f\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\f0\u000f2\u0006\u0010\u0015\u001a\u00020\u0016R\u001c\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/ndk/PageAlignConfig;", "", "<init>", "()V", "PROTO_TEMPLATE", "Lcom/android/tools/idea/serverflags/protos/PageAlign16kb;", "getPROTO_TEMPLATE$annotations", "getPROTO_TEMPLATE", "()Lcom/android/tools/idea/serverflags/protos/PageAlign16kb;", "isPageAlignMessageEnabled", "", "createSoNotAlignedInZipMessage", "", "apkLink", "files", "", "createSoUnalignedLoadSegmentsMessage", "readServerFlag", "createShortSoUnalignedLoadSegmentsMessage", "createMessage", "soFiles", "type", "Lcom/android/tools/idea/ndk/PageAlignConfig$Type;", "Type", "intellij.android.common"})
public final class PageAlignConfig {
    @NotNull
    public static final PageAlignConfig INSTANCE = new PageAlignConfig();
    @NotNull
    private static final PageAlign16kb PROTO_TEMPLATE;

    private PageAlignConfig() {
    }

    @NotNull
    public final PageAlign16kb getPROTO_TEMPLATE() {
        return PROTO_TEMPLATE;
    }

    @VisibleForTesting
    public static /* synthetic */ void getPROTO_TEMPLATE$annotations() {
    }

    public final boolean isPageAlignMessageEnabled() {
        return this.readServerFlag() != null;
    }

    @NotNull
    public final String createSoNotAlignedInZipMessage(@NotNull String apkLink, @NotNull List<String> files) {
        Intrinsics.checkNotNullParameter((Object)apkLink, (String)"apkLink");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        return this.createMessage(apkLink, files, Type.SO_UNALIGNED_IN_APK);
    }

    @NotNull
    public final String createSoUnalignedLoadSegmentsMessage(@NotNull String apkLink, @NotNull List<String> files) {
        Intrinsics.checkNotNullParameter((Object)apkLink, (String)"apkLink");
        Intrinsics.checkNotNullParameter(files, (String)"files");
        return this.createMessage(apkLink, files, Type.SO_UNALIGNED_LOAD_SEGMENTS);
    }

    private final PageAlign16kb readServerFlag() {
        return (PageAlign16kb)ServerFlagService.Companion.getInstance().getProtoOrNull("cxx/page_align_16kb", (Message)PROTO_TEMPLATE);
    }

    @NotNull
    public final String createShortSoUnalignedLoadSegmentsMessage() {
        PageAlign16kb pageAlign16kb = this.readServerFlag();
        if (pageAlign16kb == null) {
            throw new IllegalStateException("Check isPageAlignMessageEnabled() before calling create*Message() functions".toString());
        }
        PageAlign16kb flag = pageAlign16kb;
        String date = flag.getPlayStoreDeadlineDate();
        String url = "<a href=\"https://" + flag.getMessageUrl() + "\">" + flag.getMessageUrl() + "</a>";
        String string = flag.getMessagePostscript();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getMessagePostscript(...)");
        Intrinsics.checkNotNull((Object)date);
        return StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"[DATE]", (String)date, (boolean)false, (int)4, null), (String)"[URL]", (String)url, (boolean)false, (int)4, null);
    }

    @NotNull
    public final String createMessage(@NotNull String apkLink, @NotNull List<String> soFiles, @NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)apkLink, (String)"apkLink");
        Intrinsics.checkNotNullParameter(soFiles, (String)"soFiles");
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        if (soFiles.isEmpty()) {
            throw new IllegalStateException("Don't call create*Message() functions with empty SO-file list".toString());
        }
        PageAlign16kb pageAlign16kb = this.readServerFlag();
        if (pageAlign16kb == null) {
            throw new IllegalStateException("Check isPageAlignMessageEnabled() before calling create*Message() functions".toString());
        }
        PageAlign16kb flag = pageAlign16kb;
        String date = flag.getPlayStoreDeadlineDate();
        String url = "<a href=\"https://" + flag.getMessageUrl() + "\">" + flag.getMessageUrl() + "</a>";
        String prefix = switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1 -> flag.getSoUnalignedInApkMessage();
            case 2 -> flag.getUnalignedLoadSegmentsMessage();
            default -> throw new NoWhenBranchMatchedException();
        };
        String postscript = flag.getMessagePostscript();
        String string = StringsKt.replace$default((String)StringsKt.trimMargin$default((String)("\n    |" + prefix + " <ul>\n    |  " + CollectionsKt.joinToString$default((Iterable)CollectionsKt.sorted((Iterable)soFiles), (CharSequence)"</li><li>", (CharSequence)"<li>", null, (int)0, null, null, (int)60, null) + "\n    | </ul>\n    |" + postscript + "\n    "), null, (int)1, null), (String)"[APK]", (String)apkLink, (boolean)false, (int)4, null);
        Intrinsics.checkNotNull((Object)date);
        return StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"[DATE]", (String)date, (boolean)false, (int)4, null), (String)"[URL]", (String)url, (boolean)false, (int)4, null);
    }

    static {
        PageAlign16kb pageAlign16kb = PageAlign16kb.newBuilder().build();
        Intrinsics.checkNotNull((Object)pageAlign16kb);
        PROTO_TEMPLATE = pageAlign16kb;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/ndk/PageAlignConfig$Type;", "", "<init>", "(Ljava/lang/String;I)V", "SO_UNALIGNED_IN_APK", "SO_UNALIGNED_LOAD_SEGMENTS", "intellij.android.common"})
    public static final class Type
    extends Enum<Type> {
        public static final /* enum */ Type SO_UNALIGNED_IN_APK = new Type();
        public static final /* enum */ Type SO_UNALIGNED_LOAD_SEGMENTS = new Type();
        private static final /* synthetic */ Type[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static Type[] values() {
            return (Type[])$VALUES.clone();
        }

        public static Type valueOf(String value) {
            return Enum.valueOf(Type.class, value);
        }

        @NotNull
        public static EnumEntries<Type> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = typeArray = new Type[]{Type.SO_UNALIGNED_IN_APK, Type.SO_UNALIGNED_LOAD_SEGMENTS};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Type.values().length];
            try {
                nArray[Type.SO_UNALIGNED_IN_APK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Type.SO_UNALIGNED_LOAD_SEGMENTS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

