/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.log;

import com.android.utils.ILogger;
import com.intellij.openapi.diagnostic.Logger;

public class LogWrapper
implements ILogger {
    private final Logger myLog;
    private boolean myAlwaysLogAsDebug;
    private boolean myAllowVerboseLogging = true;

    public LogWrapper(Logger log) {
        this.myLog = log;
    }

    public LogWrapper(Class clz) {
        this.myLog = Logger.getInstance((Class)clz);
    }

    public LogWrapper(String category) {
        this.myLog = Logger.getInstance((String)category);
    }

    public LogWrapper alwaysLogAsDebug(boolean alwaysLogAsDebug) {
        this.myAlwaysLogAsDebug = alwaysLogAsDebug;
        return this;
    }

    public LogWrapper allowVerbose(boolean shouldAllowVerboseLogging) {
        this.myAllowVerboseLogging = shouldAllowVerboseLogging;
        return this;
    }

    public void error(Throwable t, String msgFormat, Object ... args) {
        if (msgFormat == null) {
            if (t != null) {
                if (this.myAlwaysLogAsDebug) {
                    this.myLog.debug(t);
                } else {
                    this.myLog.error(t);
                }
            }
            return;
        }
        if (this.myAlwaysLogAsDebug) {
            this.myLog.debug(String.format(msgFormat, args), t);
        } else {
            this.myLog.error(String.format(msgFormat, args), t);
        }
    }

    public void warning(String msgFormat, Object ... args) {
        if (this.myAlwaysLogAsDebug) {
            this.myLog.debug(String.format(msgFormat, args));
        } else {
            this.myLog.warn(String.format(msgFormat, args));
        }
    }

    public void info(String msgFormat, Object ... args) {
        if (this.myAlwaysLogAsDebug) {
            this.myLog.debug(String.format(msgFormat, args));
        } else {
            this.myLog.info(String.format(msgFormat, args));
        }
    }

    public void verbose(String msgFormat, Object ... args) {
        if (this.myAllowVerboseLogging) {
            this.myLog.debug(String.format(msgFormat, args));
        }
    }
}

