/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.flags.overrides;

import com.android.flags.Flag;
import com.android.flags.FlagValueProvider;
import com.android.tools.idea.flags.FeatureConfiguration;
import com.android.tools.idea.flags.StudioFlags;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0004\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u001d\b\u0002\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0017\u0010\u000b\u001a\u0004\u0018\u00010\u00042\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rH\u0096\u0002J\u0014\u0010\u000e\u001a\u0004\u0018\u00010\u00042\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\rJ\u000e\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00040\u0010H\u0007J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0012\u001a\u00020\u0004H\u0007R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\u00058BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/flags/overrides/FeatureConfigurationProvider;", "Lcom/android/flags/FlagValueProvider;", "values", "", "", "Lcom/android/tools/idea/flags/FeatureConfiguration;", "<init>", "(Ljava/util/Map;)V", "currentConfig", "getCurrentConfig", "()Lcom/android/tools/idea/flags/FeatureConfiguration;", "get", "flag", "Lcom/android/flags/Flag;", "getConfigurationExplanation", "getEntries", "", "getValueById", "flagId", "Companion", "intellij.android.common"})
@SourceDebugExtension(value={"SMAP\nFeatureConfigurationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureConfigurationProvider.kt\ncom/android/tools/idea/flags/overrides/FeatureConfigurationProvider\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1#2:132\n*E\n"})
public final class FeatureConfigurationProvider
implements FlagValueProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Map<String, FeatureConfiguration> values;
    @NotNull
    private static final Lazy<FeatureConfigurationProvider> currentFlags$delegate = LazyKt.lazy(FeatureConfigurationProvider::currentFlags_delegate$lambda$2);

    private FeatureConfigurationProvider(Map<String, ? extends FeatureConfiguration> values) {
        this.values = values;
    }

    private final FeatureConfiguration getCurrentConfig() {
        Object object = StudioFlags.FLAG_LEVEL.get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (FeatureConfiguration)((Object)object);
    }

    @Nullable
    public String get(@NotNull Flag<?> flag) {
        Intrinsics.checkNotNullParameter(flag, (String)"flag");
        return this.getValueById(flag.getId());
    }

    @Nullable
    public final String getConfigurationExplanation(@NotNull Flag<?> flag) {
        String string;
        Intrinsics.checkNotNullParameter(flag, (String)"flag");
        FeatureConfiguration featureConfiguration = this.values.get(flag.getId());
        if (featureConfiguration != null) {
            FeatureConfiguration flagConfiguration = featureConfiguration;
            boolean bl = false;
            String prefix = this.getCurrentConfig().getStabilityLevel() > flagConfiguration.getStabilityLevel() ? "Disabled by default. Enabled only in" : "Enabled only in";
            switch (WhenMappings.$EnumSwitchMapping$0[flagConfiguration.ordinal()]) {
                case 1: {
                    string = prefix + " internal builds";
                    break;
                }
                case 2: {
                    string = prefix + " internal and nightly builds";
                    break;
                }
                case 3: {
                    string = prefix + " internal, nightly and canary builds";
                    break;
                }
                case 4: {
                    string = null;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        } else {
            string = null;
        }
        return string;
    }

    @VisibleForTesting
    @NotNull
    public final Set<String> getEntries() {
        return this.values.keySet();
    }

    @VisibleForTesting
    @Nullable
    public final String getValueById(@NotNull String flagId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)flagId, (String)"flagId");
        FeatureConfiguration featureConfiguration = this.values.get(flagId);
        if (featureConfiguration != null) {
            FeatureConfiguration it = featureConfiguration;
            boolean bl = false;
            string = Boolean.valueOf(this.getCurrentConfig().getStabilityLevel() <= it.getStabilityLevel()).toString();
        } else {
            string = null;
        }
        return string;
    }

    private static final FeatureConfigurationProvider currentFlags_delegate$lambda$2() {
        return com.android.tools.idea.flags.overrides.FeatureConfigurationProvider$Companion.loadValues$default(Companion, null, 1, null);
    }

    @NotNull
    public static final FeatureConfigurationProvider getCurrentFlags() {
        return Companion.getCurrentFlags();
    }

    public /* synthetic */ FeatureConfigurationProvider(Map values, DefaultConstructorMarker $constructor_marker) {
        this(values);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0002J\u0012\u0010\r\u001a\u00020\u00072\b\b\u0002\u0010\u000e\u001a\u00020\u0005H\u0007J2\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0011\u0018\u00010\u00102\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0002\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\u0015\u001a\u00020\u0014H\u0007R!\u0010\u0006\u001a\u00020\u00078FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u000b\u0010\f\u0012\u0004\b\b\u0010\u0003\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/android/tools/idea/flags/overrides/FeatureConfigurationProvider$Companion;", "", "<init>", "()V", "featureFlagsResourceStream", "Ljava/io/InputStream;", "currentFlags", "Lcom/android/tools/idea/flags/overrides/FeatureConfigurationProvider;", "getCurrentFlags$annotations", "getCurrentFlags", "()Lcom/android/tools/idea/flags/overrides/FeatureConfigurationProvider;", "currentFlags$delegate", "Lkotlin/Lazy;", "loadValues", "inputStream", "parseLine", "Lkotlin/Pair;", "", "line", "removeDate", "", "throwOnInvalidValue", "intellij.android.common"})
    @SourceDebugExtension(value={"SMAP\nFeatureConfigurationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FeatureConfigurationProvider.kt\ncom/android/tools/idea/flags/overrides/FeatureConfigurationProvider$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 CollectionsUtils.kt\ncom/android/utils/CollectionsUtilsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,131:1\n1208#2,2:132\n1236#2,4:134\n774#2:138\n865#2,2:139\n1617#2,9:142\n1869#2:151\n1870#2:153\n1626#2:154\n47#3:141\n1#4:152\n*S KotlinDebug\n*F\n+ 1 FeatureConfigurationProvider.kt\ncom/android/tools/idea/flags/overrides/FeatureConfigurationProvider$Companion\n*L\n84#1:132,2\n84#1:134,4\n88#1:138\n88#1:139,2\n88#1:142,9\n88#1:151\n88#1:153\n88#1:154\n88#1:141\n88#1:152\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final InputStream featureFlagsResourceStream() {
            InputStream inputStream = FeatureConfigurationProvider.class.getResourceAsStream("/feature_flags.txt");
            if (inputStream == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            return inputStream;
        }

        @NotNull
        public final FeatureConfigurationProvider getCurrentFlags() {
            Lazy lazy = currentFlags$delegate;
            return (FeatureConfigurationProvider)lazy.getValue();
        }

        @JvmStatic
        public static /* synthetic */ void getCurrentFlags$annotations() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @VisibleForTesting
        @NotNull
        public final FeatureConfigurationProvider loadValues(@NotNull InputStream inputStream) {
            void $this$associateByTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
            Iterable $this$associateBy$iv = (Iterable)FeatureConfiguration.getEntries();
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            Object object = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void it;
                FeatureConfiguration featureConfiguration = (FeatureConfiguration)((Object)element$iv$iv);
                Map map2 = destination$iv$iv;
                boolean bl = false;
                map2.put(it.name(), element$iv$iv);
            }
            Map configsByName = destination$iv$iv;
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                Map map3;
                InputStream stream = (InputStream)closeable;
                boolean bl = false;
                Closeable closeable2 = new InputStreamReader(stream, Charsets.UTF_8);
                Object object2 = null;
                try {
                    void $this$mapNotNullTo$iv$iv$iv;
                    void $this$associateNotNull$iv;
                    void $this$filterTo$iv$iv;
                    InputStreamReader reader = (InputStreamReader)closeable2;
                    boolean bl2 = false;
                    Iterable $this$filter$iv = TextStreamsKt.readLines((Reader)reader);
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo22 = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        String it = (String)element$iv$iv;
                        boolean bl3 = false;
                        if (!(!StringsKt.startsWith$default((String)it, (String)"#", (boolean)false, (int)2, null))) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    $this$filter$iv = (List)destination$iv$iv2;
                    boolean $i$f$associateNotNull = false;
                    void $this$mapNotNull$iv$iv = $this$associateNotNull$iv;
                    boolean $i$f$mapNotNull = false;
                    void $i$f$filterTo22 = $this$mapNotNull$iv$iv;
                    Collection destination$iv$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv$iv = $this$mapNotNullTo$iv$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Pair pair;
                        Object element$iv$iv$iv$iv;
                        Object element$iv$iv$iv = element$iv$iv$iv$iv = iterator.next();
                        boolean bl4 = false;
                        Object it$iv = element$iv$iv$iv;
                        boolean bl5 = false;
                        String it = (String)it$iv;
                        boolean bl6 = false;
                        if (com.android.tools.idea.flags.overrides.FeatureConfigurationProvider$Companion.parseLine$default(Companion, it, false, false, 6, null) == null) {
                            pair = null;
                        } else {
                            FeatureConfiguration flagConfig;
                            Pair tokens;
                            if ((FeatureConfiguration)((Object)configsByName.get(tokens.getSecond())) == null) {
                                throw new RuntimeException("Invalid value '" + tokens.getSecond() + "' for flag '" + tokens.getFirst() + "'");
                            }
                            pair = TuplesKt.to((Object)tokens.getFirst(), (Object)((Object)flagConfig));
                        }
                        if (pair == null) continue;
                        Pair it$iv$iv$iv = pair;
                        boolean bl7 = false;
                        destination$iv$iv$iv.add(it$iv$iv$iv);
                    }
                    map3 = MapsKt.toMap((Iterable)((List)destination$iv$iv$iv));
                }
                catch (Throwable throwable2) {
                    try {
                        object2 = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        CloseableKt.closeFinally((Closeable)closeable2, object2);
                        throw throwable3;
                    }
                }
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)object2);
                object = map3;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Object map4 = object;
            return new FeatureConfigurationProvider((Map)map4, null);
        }

        public static /* synthetic */ FeatureConfigurationProvider loadValues$default(Companion companion, InputStream inputStream, int n, Object object) {
            if ((n & 1) != 0) {
                inputStream = companion.featureFlagsResourceStream();
            }
            return companion.loadValues(inputStream);
        }

        @VisibleForTesting
        @Nullable
        public final Pair<String, String> parseLine(@NotNull String line, boolean removeDate, boolean throwOnInvalidValue) {
            String string;
            Intrinsics.checkNotNullParameter((Object)line, (String)"line");
            int commentCharPos = StringsKt.indexOf$default((CharSequence)line, (char)'#', (int)0, (boolean)false, (int)6, null);
            if (commentCharPos == -1) {
                string = ((Object)StringsKt.trim((CharSequence)line)).toString();
            } else {
                String string2 = line.substring(0, commentCharPos);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                string = ((Object)StringsKt.trim((CharSequence)string2)).toString();
            }
            String lineWithoutComments = string;
            String[] stringArray = new String[]{"="};
            List tokens = StringsKt.split$default((CharSequence)lineWithoutComments, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
            if (tokens.size() != 2) {
                if (throwOnInvalidValue) {
                    throw new RuntimeException("line '" + lineWithoutComments + "' does not split in 2 components around =");
                }
                return null;
            }
            String flagValue = (String)tokens.get(1);
            return TuplesKt.to(tokens.get(0), (Object)(removeDate ? (StringsKt.startsWith$default((String)flagValue, (String)"COMPLETE:", (boolean)false, (int)2, null) ? "COMPLETE" : flagValue) : flagValue));
        }

        public static /* synthetic */ Pair parseLine$default(Companion companion, String string, boolean bl, boolean bl2, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            if ((n & 4) != 0) {
                bl2 = false;
            }
            return companion.parseLine(string, bl, bl2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[FeatureConfiguration.values().length];
            try {
                nArray[FeatureConfiguration.INTERNAL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureConfiguration.NIGHTLY.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureConfiguration.PREVIEW.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[FeatureConfiguration.COMPLETE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

