/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.memory;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerCommandExecutor;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLMemoryHunk;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import com.jetbrains.cidr.execution.debugger.memory.AddressRange;
import com.jetbrains.cidr.execution.debugger.memory.CidrDebuggerDataProvider;
import com.jetbrains.cidr.execution.debugger.memory.CidrHexdumpOptions;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryData;
import com.jetbrains.cidr.execution.debugger.memory.CidrMemoryDocOptions;
import com.jetbrains.cidr.execution.debugger.memory.hexdump.AbstractHexdumpDataProvider;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0005\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\u0018\u00002\u00020\u00012\b\u0012\u0004\u0012\u00020\u00030\u0002B\u000f\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J*\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0011J\b\u0010\u0012\u001a\u00020\u0013H\u0016J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0016J\u001e\u0010\u0016\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0017\u001a\u00020\u0018H\u0096@\u00a2\u0006\u0002\u0010\u0019R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001d\u00a8\u0006\u001e"}, d2={"Lcom/jetbrains/cidr/execution/debugger/memory/CidrDebuggerHexdumpDataProvider;", "Lcom/jetbrains/cidr/execution/debugger/memory/hexdump/AbstractHexdumpDataProvider;", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrDebuggerDataProvider;", "", "process", "Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "<init>", "(Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;)V", "getProcess", "()Lcom/jetbrains/cidr/execution/debugger/CidrDebugProcess;", "loadData", "", "Lcom/jetbrains/cidr/execution/debugger/memory/CidrMemoryData$DataBlock;", "address", "Lcom/jetbrains/cidr/execution/debugger/memory/Address;", "range", "Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;", "(Lcom/jetbrains/cidr/execution/debugger/memory/Address;Lcom/jetbrains/cidr/execution/debugger/memory/AddressRange;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "dispose", "", "readOnlyReason", "", "storeData", "bytes", "", "(Lcom/jetbrains/cidr/execution/debugger/memory/Address;[BLkotlin/coroutines/Continuation;)Ljava/lang/Object;", "blockSize", "", "getBlockSize", "()I", "intellij.cidr.debugger.core"})
public final class CidrDebuggerHexdumpDataProvider
extends AbstractHexdumpDataProvider
implements CidrDebuggerDataProvider<Byte> {
    @NotNull
    private final CidrDebugProcess process;

    public CidrDebuggerHexdumpDataProvider(@NotNull CidrDebugProcess process) {
        Intrinsics.checkNotNullParameter((Object)process, (String)"process");
        this.process = process;
        Disposer.register((Disposable)this.getProcess().getProcessDisposable(), (Disposable)this);
    }

    @Override
    @NotNull
    public CidrDebugProcess getProcess() {
        return this.process;
    }

    @Override
    @Nullable
    public Object loadData(@NotNull Address address, @NotNull AddressRange range, @NotNull Continuation<? super List<? extends CidrMemoryData.DataBlock<Byte>>> $completion) {
        return CidrDebuggerCommandExecutor.executeCommand$default(this.getProcess().getDebuggerCommandExecutor(), false, false, (Function3)new Function3<CoroutineScope, DebuggerDriver, Continuation<? super List<? extends AbstractHexdumpDataProvider.ByteData>>, Object>(range, this, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ AddressRange $range;
            final /* synthetic */ CidrDebuggerHexdumpDataProvider this$0;
            {
                this.$range = $range;
                this.this$0 = $receiver;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                DebuggerDriver debuggerDriver = (DebuggerDriver)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        List<LLMemoryHunk> list;
                        ResultKt.throwOnFailure((Object)$result);
                        try {
                            void driver;
                            list = driver.dumpMemory(this.$range);
                        }
                        catch (DebuggerCommandException e) {
                            String string;
                            String reason = e.getMessage();
                            if (reason == null || Intrinsics.areEqual((Object)reason, (Object)("Unable to read memory " + this.$range))) {
                                var10_6 = new Object[]{String.valueOf(this.$range)};
                                string = CidrDebuggerBundle.message("debug.error.failedToReadMemory.unknownReason", var10_6);
                            } else {
                                var10_6 = new Object[]{String.valueOf(this.$range), reason};
                                string = CidrDebuggerBundle.message("debug.error.failedToReadMemory", var10_6);
                            }
                            String string2 = string;
                            Intrinsics.checkNotNull((Object)string2);
                            String msg = string2;
                            throw new CidrMemoryData.DataLoadException(msg, e);
                        }
                        List<LLMemoryHunk> list2 = list;
                        Intrinsics.checkNotNull(list2);
                        List<LLMemoryHunk> memoryHunks = list2;
                        return this.this$0.fromMemoryHunkList(memoryHunks);
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(CoroutineScope p1, DebuggerDriver p2, Continuation<? super List<AbstractHexdumpDataProvider.ByteData>> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        }, $completion, 2, null);
    }

    public void dispose() {
    }

    @Override
    @Nullable
    public String readOnlyReason() {
        if (!this.getProcess().supportsMemoryWrite()) {
            Object[] objectArray = new Object[]{"memory"};
            return CidrDebuggerBundle.message("debug.memory.view.modify.not.supported", objectArray);
        }
        XDebugSession xDebugSession = this.getProcess().getSession();
        Intrinsics.checkNotNullExpressionValue((Object)xDebugSession, (String)"getSession(...)");
        XDebugSession session = xDebugSession;
        if (session.isStopped()) {
            return CidrDebuggerBundle.message("debug.memory.modify.in.stopped.session.is.not.supported", new Object[0]);
        }
        if (!session.isSuspended()) {
            return CidrDebuggerBundle.message("debug.memory.modify.in.running.session.is.not.supported", new Object[0]);
        }
        return null;
    }

    @Override
    @Nullable
    public Object storeData(@NotNull Address address, @NotNull byte[] bytes, @NotNull Continuation<? super Unit> $completion) {
        String readOnlyReason = this.readOnlyReason();
        if (readOnlyReason != null) {
            throw new CidrMemoryData.DataLoadException(readOnlyReason);
        }
        return CidrDebuggerCommandExecutor.executeCommand$default(this.getProcess().getDebuggerCommandExecutor(), false, false, (Function3)new Function3<CoroutineScope, DebuggerDriver, Continuation<? super Unit>, Object>(address, bytes, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ Address $address;
            final /* synthetic */ byte[] $bytes;
            {
                this.$address = $address;
                this.$bytes = $bytes;
                super(3, $completion);
            }

            /*
             * WARNING - void declaration
             */
            public final Object invokeSuspend(Object $result) {
                DebuggerDriver debuggerDriver = (DebuggerDriver)this.L$0;
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        try {
                            void driver;
                            driver.writeMemory(this.$address, this.$bytes);
                        }
                        catch (DebuggerCommandException e) {
                            String reason = e.getMessage();
                            Object object = reason;
                            if (object == null) {
                                object = "Failed to store data at " + this.$address;
                            }
                            throw new CidrMemoryData.DataLoadException((String)object, e);
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Object invoke(CoroutineScope p1, DebuggerDriver p2, Continuation<? super Unit> p3) {
                var var4_4 = new /* invalid duplicate definition of identical inner class */;
                var4_4.L$0 = p2;
                return var4_4.invokeSuspend(Unit.INSTANCE);
            }
        }, $completion, 2, null);
    }

    @Override
    public int getBlockSize() {
        CidrMemoryDocOptions cidrMemoryDocOptions = this.getProcess().getMemory().getHexdumpDoc().getOptions();
        Intrinsics.checkNotNull((Object)cidrMemoryDocOptions, (String)"null cannot be cast to non-null type com.jetbrains.cidr.execution.debugger.memory.CidrHexdumpOptions");
        return ((CidrHexdumpOptions)cidrMemoryDocOptions).getBlockSize();
    }
}

