/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.extensions.InternalIgnoreDependencyViolation;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerCommandException;
import com.jetbrains.cidr.execution.debugger.backend.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrElementValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.ValueRendererFactory;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.NSContainerValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.NSEnumerableCollectionValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NSCollectionValueRenderer
extends NSContainerValueRenderer {
    private static final List<Pattern> KNOWN_TYPES = Arrays.asList(Pattern.compile("(const )?_*NS(CF)?(Mutable)?Array\\w? \\*"), Pattern.compile("(const )?_*NS(CF)?(Mutable)?Set\\w? \\*"), Pattern.compile("(const )?_*NS(CF)?(Mutable)?Dictionary\\w? \\*"), Pattern.compile("(const )?_*NS(CF)?(Constant)?Array\\w? \\*"), Pattern.compile("(Foundation|__C)\\.NS(Mutable)?Array"), Pattern.compile("(Foundation|__C)\\.NS(Mutable)?Set"), Pattern.compile("(Foundation|__C)\\.NS(Mutable)?Dictionary"), Pattern.compile("(const )?CF(Mutable)?ArrayRef"), Pattern.compile("(const )?CF(Mutable)?SetRef"), Pattern.compile("(const )?CF(Mutable)?DictionaryRef"), Pattern.compile("CoreFoundation\\.CF(Mutable)?Array(Ref)?"), Pattern.compile("CoreFoundation\\.CF(Mutable)?Set(Ref)?"), Pattern.compile("CoreFoundation\\.CF(Mutable)?Dictionary(Ref)?"));
    private static final Pattern BROKEN_SWIFT_CF_TYPES = Pattern.compile("(const )?CF(Mutable)?((Array)|(Dictionary))Ref");
    private final Kind myKind;

    public NSCollectionValueRenderer(@NotNull CidrPhysicalValue value, @NotNull Kind kind) {
        if (value == null) {
            NSCollectionValueRenderer.$$$reportNull$$$0(0);
        }
        if (kind == null) {
            NSCollectionValueRenderer.$$$reportNull$$$0(1);
        }
        super(value);
        this.myKind = kind;
    }

    @Nullable
    public static Kind getNSCollectionKind(@NotNull ValueRendererFactory.FactoryContext context) {
        if (context == null) {
            NSCollectionValueRenderer.$$$reportNull$$$0(2);
        }
        LLValue var = context.getLLValue();
        LLValueData data = context.getLLValueData();
        if (!data.isValidPointer()) {
            return null;
        }
        String type = CidrDebuggerTypesHelper.unwrapSwiftOptionalTypeIfNecessary(var.getType());
        if (!ContainerUtil.exists(KNOWN_TYPES, each -> each.matcher(type).matches())) {
            return null;
        }
        if (type.contains("Dictionary")) {
            return Kind.DICTIONARY;
        }
        if (type.contains("Set")) {
            return Kind.SET;
        }
        return Kind.ARRAY;
    }

    @Override
    protected boolean mayHaveChildrenViaChildrenCount() {
        return true;
    }

    @Override
    @Nullable
    protected Integer doComputeChildrenCount(@NotNull EvaluationContext context) throws ExecutionException, DebuggerCommandException {
        String description;
        if (context == null) {
            NSCollectionValueRenderer.$$$reportNull$$$0(3);
        }
        if ("0 elements".equals(description = StringUtil.notNullize((String)this.myValue.getVarData(context).getDescription()).trim()) || "{\n}".equals(description)) {
            return 0;
        }
        return super.doComputeChildrenCount(context);
    }

    @Override
    protected void addChildrenTo(@NotNull List<LLValue> children, @NotNull EvaluationContext context, @NotNull XCompositeNode container, int startIndex, boolean modifiable) throws ExecutionException, DebuggerCommandException {
        if (children == null) {
            NSCollectionValueRenderer.$$$reportNull$$$0(4);
        }
        if (context == null) {
            NSCollectionValueRenderer.$$$reportNull$$$0(5);
        }
        if (container == null) {
            NSCollectionValueRenderer.$$$reportNull$$$0(6);
        }
        ArrayList<CidrValue> values = new ArrayList<CidrValue>(children.size());
        for (LLValue each : children) {
            Couple<LLValue> keyValue;
            if (container.isObsolete()) {
                return;
            }
            Couple<LLValue> couple = keyValue = this.myKind == Kind.DICTIONARY ? NSCollectionValueRenderer.getDictionaryEntryChildren(context, each) : null;
            if (keyValue != null) {
                values.add(this.createMapElementValue((LLValue)((Object)keyValue.first), (LLValue)((Object)keyValue.second), startIndex++));
                continue;
            }
            values.add(this.createElementValue(each, startIndex++));
        }
        CidrValue.addAllTo(values, container);
    }

    @Override
    @NotNull
    public String getChildEvaluationExpression(@NotNull CidrPhysicalValue child, boolean lvalue) {
        if (child == null) {
            NSCollectionValueRenderer.$$$reportNull$$$0(7);
        }
        return NSCollectionValueRenderer.getChildEvaluationExpression(this.myValue, this.myKind, child, lvalue);
    }

    @NotNull
    static String getChildEvaluationExpression(@NotNull CidrPhysicalValue self, @NotNull Kind kind, @NotNull CidrPhysicalValue child, boolean lvalue) {
        if (self == null) {
            NSCollectionValueRenderer.$$$reportNull$$$0(8);
        }
        if (kind == null) {
            NSCollectionValueRenderer.$$$reportNull$$$0(9);
        }
        if (child == null) {
            NSCollectionValueRenderer.$$$reportNull$$$0(10);
        }
        int childIndex = ((CidrElementValue)child).getIndex();
        StringBuilder sb = new StringBuilder();
        String propertyName = null;
        if (kind == Kind.SET) {
            propertyName = "allObjects";
        } else if (kind == Kind.DICTIONARY) {
            String string = propertyName = "key".equals(child.getName()) ? "allKeys" : "allValues";
        }
        if (self.isSwiftContext()) {
            String type = CidrDebuggerTypesHelper.unwrapSwiftOptionalTypeIfNecessary(self.getType());
            String castToType = null;
            if (type.startsWith("CoreFoundation.CF")) {
                castToType = type.replace("CoreFoundation.CF", "NS").replace("Ref", "");
            }
            if (castToType != null) {
                sb.append('(');
            }
            sb.append(self.getEvaluationExpression());
            if (self.isSwiftOptional()) {
                sb.append('!');
            }
            if (castToType != null) {
                sb.append(" as ").append(castToType).append(')');
            }
            if (propertyName != null) {
                sb.append('.').append(propertyName);
            }
            String string = sb.append("[").append(childIndex).append(']').toString();
            if (string == null) {
                NSCollectionValueRenderer.$$$reportNull$$$0(11);
            }
            return string;
        }
        sb.append("(id)[");
        String referenceExpression = self.getEvaluationExpression();
        if (propertyName != null) {
            sb.append('[').append(referenceExpression).append(' ').append(propertyName).append(']');
        } else {
            sb.append(referenceExpression);
        }
        String string = sb.append(" objectAtIndex:").append(childIndex).append(']').toString();
        if (string == null) {
            NSCollectionValueRenderer.$$$reportNull$$$0(12);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 11, 12 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "child";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "self";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSCollectionValueRenderer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSCollectionValueRenderer";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildEvaluationExpression";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getNSCollectionKind";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doComputeChildrenCount";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "addChildrenTo";
                break;
            }
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getChildEvaluationExpression";
                break;
            }
            case 11: 
            case 12: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 11, 12 -> new IllegalStateException(string);
        };
    }

    public static enum Kind {
        ARRAY,
        SET,
        DICTIONARY;

    }

    @InternalIgnoreDependencyViolation
    public static final class Factory
    implements ValueRendererFactory {
        @Override
        @Nullable
        public ValueRenderer createRenderer(@NotNull ValueRendererFactory.FactoryContext context) throws DebuggerCommandException {
            if (context == null) {
                Factory.$$$reportNull$$$0(0);
            }
            if (!context.getSettings().isCocoaRenderersEnabled()) {
                return null;
            }
            Kind kind = NSCollectionValueRenderer.getNSCollectionKind(context);
            if (kind == null) {
                return null;
            }
            if (!context.getLLValueData().isSynthetic() || BROKEN_SWIFT_CF_TYPES.matcher(context.getLLValue().getType()).matches()) {
                return new NSEnumerableCollectionValueRenderer(context.getPhysicalValue(), kind);
            }
            return new NSCollectionValueRenderer(context.getPhysicalValue(), kind);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/jetbrains/cidr/execution/debugger/evaluation/renderers/NSCollectionValueRenderer$Factory", "createRenderer"));
        }
    }
}

