/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.childProcessDebugging;

import com.intellij.openapi.project.Project;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.childProcessDebugging.ChildProcessDebuggingFileType;
import com.jetbrains.cidr.execution.debugger.childProcessDebugging.DebuggingRules;
import com.jetbrains.cidr.execution.debugger.childProcessDebugging.DebuggingRulesHandler;
import com.jetbrains.cidr.execution.debugger.childProcessDebugging.DefaultProjectAndDialogService;
import com.jetbrains.cidr.execution.debugger.childProcessDebugging.ParseResult;
import com.jetbrains.cidr.execution.debugger.childProcessDebugging.ProjectAndDialogService;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.SpillingKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u001a\n\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u0012H\u0002\u001a\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0014\u001a\u00020\u0012\u001a\u0006\u0010\u0016\u001a\u00020\u0017\u001a\u0006\u0010\u001a\u001a\u00020\u001b\u001a\b\u0010\u001c\u001a\u00020\u0001H\u0002\u001a\b\u0010\u001d\u001a\u00020\u0001H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\n\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u000b\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\f\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0018\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0019\u001a\u00020\u0001X\u0082T\u00a2\u0006\u0002\n\u0000\"\u001a\u0010\u001e\u001a\u00020\u001fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#\u00a8\u0006$"}, d2={"XmlTagDebuggingRules", "", "XmlTagDefaultRule", "XmlAttributeAttach", "XmlTagRule", "XmlAttributeProcessName", "XmlAttributeCommandLine", "XmlTagTabNameRules", "XmlTagTabRule", "XmlAttributeExecutable", "XmlAttributeCommandline", "XmlAttributeName", "XmlAttributeOrder", "parseChildProcessDebuggingFileFormat", "Lcom/jetbrains/cidr/execution/debugger/childProcessDebugging/ParseResult;", "filePath", "Ljava/nio/file/Path;", "getProject", "Lcom/intellij/openapi/project/Project;", "getIdeaPath", "project", "getRulesFilePath", "isProjectAvailable", "", "childProcDebuggerSchema", "childProcDebuggerSchemaFile", "createExampleFile", "", "generateExampleDebuggingRulesXmlContent", "generateChildProcDebuggerSchema", "integrationService", "Lcom/jetbrains/cidr/execution/debugger/childProcessDebugging/ProjectAndDialogService;", "getIntegrationService", "()Lcom/jetbrains/cidr/execution/debugger/childProcessDebugging/ProjectAndDialogService;", "setIntegrationService", "(Lcom/jetbrains/cidr/execution/debugger/childProcessDebugging/ProjectAndDialogService;)V", "intellij.cidr.debugger.core"})
public final class ChildProcessDebuggingFileFormatUtilsKt {
    @NotNull
    private static final String XmlTagDebuggingRules = "DebuggingRules";
    @NotNull
    private static final String XmlTagDefaultRule = "DefaultRule";
    @NotNull
    private static final String XmlAttributeAttach = "attach";
    @NotNull
    private static final String XmlTagRule = "Rule";
    @NotNull
    private static final String XmlAttributeProcessName = "processName";
    @NotNull
    private static final String XmlAttributeCommandLine = "commandLine";
    @NotNull
    private static final String XmlTagTabNameRules = "TabNameRules";
    @NotNull
    private static final String XmlTagTabRule = "TabRule";
    @NotNull
    private static final String XmlAttributeExecutable = "executable";
    @NotNull
    private static final String XmlAttributeCommandline = "commandline";
    @NotNull
    private static final String XmlAttributeName = "name";
    @NotNull
    private static final String XmlAttributeOrder = "order";
    @NotNull
    private static final String childProcDebuggerSchema = "https://jetbrains.com/schemas/cidr/debugger/child-proc-dbg/2024-10-14";
    @NotNull
    private static final String childProcDebuggerSchemaFile = "child-process-debugging-2024-10-14.xsd";
    @NotNull
    private static ProjectAndDialogService integrationService = new DefaultProjectAndDialogService();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final ParseResult parseChildProcessDebuggingFileFormat(@NotNull Path filePath) {
        ParseResult parseResult;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        try {
            ParseResult parseResult2;
            if (!Files.exists(filePath, new LinkOption[0])) {
                Object[] objectArray = new Object[]{filePath};
                String string = CidrDebuggerBundle.message("debug.childProcessDebugging.parseXml.FileNotFound", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                return new ParseResult.Error(string);
            }
            SAXParser saxParser = SAXParserFactory.newInstance().newSAXParser();
            DebuggingRulesHandler handler = new DebuggingRulesHandler(((Object)filePath).toString());
            Closeable closeable = Files.newInputStream(filePath, new OpenOption[0]);
            Throwable throwable = null;
            try {
                InputStream inputStream = (InputStream)closeable;
                boolean bl = false;
                saxParser.parse(new InputSource(inputStream), (DefaultHandler)handler);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            DebuggingRules debuggingRules = handler.getDebuggingRules();
            String error = handler.getFirstError();
            if (error != null) {
                parseResult2 = new ParseResult.Error(error);
            } else if (debuggingRules == null) {
                Object[] objectArray = new Object[]{filePath};
                String string = CidrDebuggerBundle.message("debug.childProcessDebugging.parseXml.NoRules", objectArray);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
                parseResult2 = new ParseResult.Error(string);
            } else {
                parseResult2 = new ParseResult.Success(debuggingRules);
            }
            parseResult = parseResult2;
        }
        catch (SAXException e) {
            Object[] objectArray = new Object[]{filePath, e.getMessage()};
            String string = CidrDebuggerBundle.message("debug.childProcessDebugging.parseXml.FailedToParse", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return new ParseResult.Error(string);
        }
        catch (Exception e) {
            CidrDebuggerLog.LOG.warn("Unexpected error while parsing " + filePath + ": " + e);
            Object[] objectArray = new Object[]{filePath, e.getMessage()};
            String string = CidrDebuggerBundle.message("debug.childProcessDebugging.parseXml.UnexpectedError", objectArray);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            return new ParseResult.Error(string);
        }
        return parseResult;
    }

    private static final Project getProject() {
        return integrationService.getActiveProject();
    }

    private static final Path getIdeaPath(Project project) {
        Path path;
        try {
            path = integrationService.getIdeaPath(project);
        }
        catch (IllegalStateException e) {
            CidrDebuggerLog.LOG.warn("ChildProcessDebugging project state store not found: " + e);
            return null;
        }
        Path ideaPath = path;
        if (ideaPath == null) {
            CidrDebuggerLog.LOG.warn("ChildProcessDebugging setting file not found: '.idea' path is null");
            return null;
        }
        return ideaPath;
    }

    @Nullable
    public static final Path getRulesFilePath(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Path path = ChildProcessDebuggingFileFormatUtilsKt.getIdeaPath(project);
        if (path == null) {
            return null;
        }
        Path ideaPath = path;
        Path rulesFile = ideaPath.resolve("." + ChildProcessDebuggingFileType.Companion.getINSTANCE().getDefaultExtension());
        return rulesFile;
    }

    public static final boolean isProjectAvailable() {
        Project project = ChildProcessDebuggingFileFormatUtilsKt.getProject();
        return project != null;
    }

    public static final void createExampleFile() {
        integrationService.edtAssert();
        Project project = ChildProcessDebuggingFileFormatUtilsKt.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        Path path = ChildProcessDebuggingFileFormatUtilsKt.getRulesFilePath(project2);
        if (path == null) {
            return;
        }
        Path rulesFilePath = path;
        Path xsdFilePath = rulesFilePath.getParent().resolve(childProcDebuggerSchemaFile);
        CoroutineScope coroutineScope = integrationService.getCoroutineScope(project2);
        BuildersKt.launch$default((CoroutineScope)coroutineScope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(rulesFilePath, project2, xsdFilePath, null){
            Object L$0;
            Object L$1;
            int label;
            final /* synthetic */ Path $rulesFilePath;
            final /* synthetic */ Project $project;
            final /* synthetic */ Path $xsdFilePath;
            {
                this.$rulesFilePath = $rulesFilePath;
                this.$project = $project;
                this.$xsdFilePath = $xsdFilePath;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object $result) {
                var5_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        if (!Files.exists(this.$rulesFilePath, new LinkOption[0])) ** GOTO lbl16
                        this.label = 1;
                        v0 = ChildProcessDebuggingFileFormatUtilsKt.getIntegrationService().showOverwriteConfirmation(this.$project, this.$rulesFilePath, (Continuation<? super Boolean>)((Continuation)this));
                        if (v0 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl14
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl14:
                        // 2 sources

                        if (!((Boolean)v0).booleanValue()) {
                            return Unit.INSTANCE;
                        }
lbl16:
                        // 3 sources

                        exampleFileContent = ChildProcessDebuggingFileFormatUtilsKt.access$generateExampleDebuggingRulesXmlContent();
                        schemaFileContent = ChildProcessDebuggingFileFormatUtilsKt.access$generateChildProcDebuggerSchema();
                        Files.createDirectories(this.$rulesFilePath.getParent(), new FileAttribute[0]);
                        Files.writeString(this.$rulesFilePath, (CharSequence)exampleFileContent, new OpenOption[0]);
                        Files.writeString(this.$xsdFilePath, (CharSequence)schemaFileContent, new OpenOption[0]);
                        v1 = ChildProcessDebuggingFileFormatUtilsKt.getIntegrationService();
                        var4_7 = this.$xsdFilePath;
                        Intrinsics.checkNotNull((Object)var4_7);
                        this.L$0 = SpillingKt.nullOutSpilledVariable((Object)exampleFileContent);
                        this.L$1 = SpillingKt.nullOutSpilledVariable((Object)schemaFileContent);
                        this.label = 2;
                        v2 = v1.openFileInEditor(this.$project, this.$rulesFilePath, var4_7, (Continuation<? super Unit>)((Continuation)this));
                        if (v2 == var5_2) {
                            return var5_2;
                        }
                        ** GOTO lbl39
                    }
                    case 2: {
                        schemaFileContent = (String)this.L$1;
                        exampleFileContent = (String)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl39:
                        // 2 sources

                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private static final String generateExampleDebuggingRulesXmlContent() {
        return "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<DebuggingRules xmlns=\"https://jetbrains.com/schemas/cidr/debugger/child-proc-dbg/2024-10-14\"\n              xsi:schemaLocation=\"https://jetbrains.com/schemas/cidr/debugger/child-proc-dbg/2024-10-14 child-process-debugging-2024-10-14.xsd\"\n              xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">\n\n  <!-- Default rule determines whether to attach to all child processes if no specific rules are matched -->\n  <DefaultRule attach=\"false\"/>\n\n  <!-- Specific rules can override the default behavior.\n\n      Attribute 'processName' refers to the executable command, not the exact path to the executable file.\n      This is the command used to start the process. For example, if you use 'cmd', it will execute 'cmd.exe'.\n      Thus, if you specify 'cmd.exe', the rule will not match the created process because the invoked command was 'cmd'.\n\n      Attribute 'commandLine' refers to the arguments that follow the process name.\n\n      Values are case-insensitive. Wildcards (*) and '?' are supported in both 'processName' and 'commandLine' values.\n      Note: Both 'processName' and 'commandLine' are implicitly surrounded by '*' on both sides. This means that an empty string\n      for these attributes will match any value.\n  -->\n\n  <!-- This rule matches commands where the executable's path contains 'part_of_path' and the executable name starts with 'my_app'.\n      It will match:\n          CreateProcess(\"c:/Programs/part_of_path/bin/my_app.exe\", \"app_command -arg1 -arg2\" ...)\n      But it will not match:\n          CreateProcess(\"c:/Programs/Game/bin/my_app.exe\", \"app_command -arg1 -arg2\" ...)\n          CreateProcess(\"my_app\", \"app_command -arg1 -arg2\" ...)\n  -->\n  <Rule processName=\"part_of_path*/my_app*\" commandLine=\"-arg1\" attach=\"true\"/>\n  <Rule processName=\"cm?\" attach=\"true\"/>\n\n  <TabNameRules>\n    <!--\n      Tab naming and ordering rules\n\n      The <TabNameRules> section allows you to define custom tab names and ordering for debugger tabs\n      based on the launched executable and its command-line arguments.\n\n      Each <TabRule> can specify:\n           - 'executable': a regular expression matched against the process executable name.\n                          This can be a full path or just the executable name. Matching is case-insensitive.\n                          Note: The entire string must be matched \u2014 use `.*` to match substrings if needed.\n           - 'commandline': a regular expression matched against the command-line string as provided to the process.\n                          This includes the executable and all arguments.\n                          Note: The entire string must be matched \u2014 use `.*` if matching substrings.\n\n                          Example:\n                            CommandLine: cmd /k echo Hello\n                            ExecutablePath: C:\\Windows\\System32\\cmd.exe\n                            Only cmd was typed, but full executable path differs.\n\n           - 'name': the custom name to display on the debugger tab.\n                    You can use captured groups from 'executable' and 'commandline' patterns as substitutions.\n           - 'order': optional integer value that defines the display order of debugger tabs.\n                     Lower values appear first.\n\n         Substitution:\n           If the 'executable' or 'commandline' regex contains capturing groups, you can use them in the 'name' attribute.\n           - Use ${exe1}, ${exe2}, ... for regex groups from 'executable' attribute\n           - Use ${arg1}, ${arg2}, ... for regex groups from 'commandline' attribute\n           - Use ${pid} to insert the numeric process ID\n           Group indices are 1-based, as in standard regular expressions\n\n      If both 'executable' and 'commandline' are omitted, the rule won't match anything.\n\n      Examples:\n\n        Match the editor mode of a game process:\n          <TabRule executable=\".*game.*\\.exe\" commandline=\".*-editor.*\" name=\"Editor\" order=\"1\"/>\n\n        Match any child of 'mytool.exe' with dynamic argument:\n          <TabRule executable=\".*mytool.*\\.exe\" commandline=\".*-mode (\\w+).*\" name=\"Tool mode: ${arg1}\"/>\n\n        Match a specific diagnostic tool by full path:\n          <TabRule executable=\"C:[\\\\/]tools[\\\\/]diagnostic\\.exe\" name=\"Diagnostics\"/>\n\n        Match client/server and set display order:\n          <TabRule executable=\".*game.*\\.exe\" commandline=\".*-server.*\" name=\"Server\" order=\"2\"/>\n          <TabRule executable=\".*game.*\\.exe\" commandline=\".*-client.*\" name=\"Client\" order=\"3\"/>\n\n        Match a numeric argument and include PID:\n          <TabRule executable=\".*calc.*\\.exe\" commandline=\".*(\\\\d+).*\" name=\"Calc PID ${pid} with ${arg1}\"/>\n    -->\n\n    <TabRule executable=\".*game.*\\.exe\" commandline=\".*-editor.*\" name=\"Editor\" order=\"1\"/>\n    <TabRule executable=\".*game.*\\.exe\" commandline=\".*-server.*\" name=\"Server\" order=\"2\"/>\n    <TabRule executable=\".*game.*\\.exe\" commandline=\".*-client.*\" name=\"Client\" order=\"3\"/>\n    <TabRule executable=\".*tools.*\\.exe\" commandline=\".*\" name=\"Tools\" order=\"4\"/>\n  </TabNameRules>\n\n</DebuggingRules>";
    }

    private static final String generateChildProcDebuggerSchema() {
        return "<xs:schema xmlns:xs=\"http://www.w3.org/2001/XMLSchema\"\n           targetNamespace=\"https://jetbrains.com/schemas/cidr/debugger/child-proc-dbg/2024-10-14\"\n           xmlns=\"https://jetbrains.com/schemas/cidr/debugger/child-proc-dbg/2024-10-14\"\n           elementFormDefault=\"qualified\">\n  <xs:element name=\"DebuggingRules\">\n    <xs:complexType>\n      <xs:sequence>\n        <xs:element name=\"DefaultRule\" type=\"DefaultRuleType\" minOccurs=\"1\" maxOccurs=\"1\" />\n        <xs:element name=\"Rule\" type=\"RuleDetailType\" maxOccurs=\"unbounded\" minOccurs=\"0\" />\n        <xs:element name=\"TabNameRules\" minOccurs=\"0\" maxOccurs=\"1\">\n          <xs:complexType>\n            <xs:sequence>\n              <xs:element name=\"TabRule\" type=\"TabRuleType\" maxOccurs=\"unbounded\" minOccurs=\"0\" />\n            </xs:sequence>\n          </xs:complexType>\n        </xs:element>\n      </xs:sequence>\n    </xs:complexType>\n  </xs:element>\n\n  <xs:complexType name=\"DefaultRuleType\">\n    <xs:attribute name=\"attach\" type=\"xs:boolean\" use=\"required\" />\n  </xs:complexType>\n\n  <xs:complexType name=\"RuleDetailType\">\n    <xs:attribute name=\"processName\" type=\"xs:string\" use=\"optional\" />\n    <xs:attribute name=\"commandLine\" type=\"xs:string\" use=\"optional\" />\n    <xs:attribute name=\"attach\" type=\"xs:boolean\" use=\"required\" />\n  </xs:complexType>\n\n  <xs:complexType name=\"TabRuleType\">\n    <xs:attribute name=\"executable\" type=\"xs:string\" use=\"optional\" />\n    <xs:attribute name=\"commandline\" type=\"xs:string\" use=\"optional\" />\n    <xs:attribute name=\"name\" type=\"xs:string\" use=\"required\" />\n    <xs:attribute name=\"order\" type=\"xs:integer\" use=\"optional\" />\n  </xs:complexType>\n</xs:schema>";
    }

    @NotNull
    public static final ProjectAndDialogService getIntegrationService() {
        return integrationService;
    }

    public static final void setIntegrationService(@NotNull ProjectAndDialogService projectAndDialogService) {
        Intrinsics.checkNotNullParameter((Object)projectAndDialogService, (String)"<set-?>");
        integrationService = projectAndDialogService;
    }

    public static final /* synthetic */ String access$generateExampleDebuggingRulesXmlContent() {
        return ChildProcessDebuggingFileFormatUtilsKt.generateExampleDebuggingRulesXmlContent();
    }

    public static final /* synthetic */ String access$generateChildProcDebuggerSchema() {
        return ChildProcessDebuggingFileFormatUtilsKt.generateChildProcDebuggerSchema();
    }
}

