/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.SetsKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0086\u0081\u0002\u0018\u0000 \u001b2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002\u001a\u001bB/\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u000b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u0012\u000f\b\u0002\u0010\u0007\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\b\u00a2\u0006\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0015\u0010\u0007\u001a\t\u0018\u00010\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0016\u001a\u00070\u0005\u00a2\u0006\u0002\b\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u000eR\u0011\u0010\u0018\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u000ej\u0002\b\u000fj\u0002\b\u0010j\u0002\b\u0011j\u0002\b\u0012j\u0002\b\u0013j\u0002\b\u0014j\u0002\b\u0015\u00a8\u0006\u001c"}, d2={"Lcom/jetbrains/cidr/execution/debugger/breakpoints/CidrLowLevelException;", "", "kind", "Lcom/jetbrains/cidr/execution/debugger/breakpoints/CidrLowLevelException$Kind;", "description", "", "Lorg/jetbrains/annotations/Nls;", "myRealName", "Lorg/jetbrains/annotations/NonNls;", "<init>", "(Ljava/lang/String;ILcom/jetbrains/cidr/execution/debugger/breakpoints/CidrLowLevelException$Kind;Ljava/lang/String;Ljava/lang/String;)V", "getKind", "()Lcom/jetbrains/cidr/execution/debugger/breakpoints/CidrLowLevelException$Kind;", "getDescription", "()Ljava/lang/String;", "WIN_0X80000003", "SIGINT", "SIGSTOP", "SIGTSTP", "SIGTRAP", "EXC_BREAKPOINT", "UNKNOWN", "identifier", "getIdentifier", "presentation", "getPresentation", "Kind", "Companion", "intellij.cidr.debugger.core"})
public final class CidrLowLevelException
extends Enum<CidrLowLevelException> {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Kind kind;
    @NotNull
    private final String description;
    @Nullable
    private final String myRealName;
    @NotNull
    private static final HashSet<CidrLowLevelException> myUserInitiatedInterruptions;
    @NotNull
    private static final HashSet<CidrLowLevelException> mySoftwareBreakpointExceptions;
    public static final /* enum */ CidrLowLevelException WIN_0X80000003;
    public static final /* enum */ CidrLowLevelException SIGINT;
    public static final /* enum */ CidrLowLevelException SIGSTOP;
    public static final /* enum */ CidrLowLevelException SIGTSTP;
    public static final /* enum */ CidrLowLevelException SIGTRAP;
    public static final /* enum */ CidrLowLevelException EXC_BREAKPOINT;
    public static final /* enum */ CidrLowLevelException UNKNOWN;
    private static final /* synthetic */ CidrLowLevelException[] $VALUES;
    private static final /* synthetic */ EnumEntries $ENTRIES;

    private CidrLowLevelException(Kind kind, String description, String myRealName) {
        this.kind = kind;
        this.description = description;
        this.myRealName = myRealName;
    }

    /* synthetic */ CidrLowLevelException(String string, int n, Kind kind, String string2, String string3, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            string3 = null;
        }
        this(kind, string2, string3);
    }

    @NotNull
    public final Kind getKind() {
        return this.kind;
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final String getIdentifier() {
        String string = this.myRealName;
        if (string == null) {
            string = this.name();
        }
        return string;
    }

    @NotNull
    public final String getPresentation() {
        return this.kind.getDescription() + " " + this.getIdentifier();
    }

    public static CidrLowLevelException[] values() {
        return (CidrLowLevelException[])$VALUES.clone();
    }

    public static CidrLowLevelException valueOf(String value) {
        return Enum.valueOf(CidrLowLevelException.class, value);
    }

    @NotNull
    public static EnumEntries<CidrLowLevelException> getEntries() {
        return $ENTRIES;
    }

    static {
        String string = CidrDebuggerBundle.message("debug.lowLevel.exception.win32.description.0x80000003", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        WIN_0X80000003 = new CidrLowLevelException(Kind.WIN32_EXCEPTION, string, "0x80000003");
        String string2 = CidrDebuggerBundle.message("debug.lowLevel.exception.unix.signal.description.SIGINT", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        SIGINT = new CidrLowLevelException("SIGINT", 1, Kind.UNIX_SIGNAL, string2, null, 4, null);
        String string3 = CidrDebuggerBundle.message("debug.lowLevel.exception.unix.signal.description.SIGSTOP", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        SIGSTOP = new CidrLowLevelException("SIGSTOP", 2, Kind.UNIX_SIGNAL, string3, null, 4, null);
        String string4 = CidrDebuggerBundle.message("debug.lowLevel.exception.unix.signal.description.SIGTSTP", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        SIGTSTP = new CidrLowLevelException("SIGTSTP", 3, Kind.UNIX_SIGNAL, string4, null, 4, null);
        String string5 = CidrDebuggerBundle.message("debug.lowLevel.exception.unix.signal.description.SIGTRAP", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        SIGTRAP = new CidrLowLevelException("SIGTRAP", 4, Kind.UNIX_SIGNAL, string5, null, 4, null);
        String string6 = CidrDebuggerBundle.message("debug.lowLevel.exception.mach.description.EXC_BREAKPOINT", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        EXC_BREAKPOINT = new CidrLowLevelException("EXC_BREAKPOINT", 5, Kind.MACH_EXCEPTION, string6, null, 4, null);
        UNKNOWN = new CidrLowLevelException("UNKNOWN", 6, Kind.UNKNOWN, "", null, 4, null);
        $VALUES = cidrLowLevelExceptionArray = new CidrLowLevelException[]{CidrLowLevelException.WIN_0X80000003, CidrLowLevelException.SIGINT, CidrLowLevelException.SIGSTOP, CidrLowLevelException.SIGTSTP, CidrLowLevelException.SIGTRAP, CidrLowLevelException.EXC_BREAKPOINT, CidrLowLevelException.UNKNOWN};
        $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        Companion = new Companion(null);
        CidrLowLevelException[] cidrLowLevelExceptionArray = new CidrLowLevelException[]{WIN_0X80000003, SIGINT, SIGSTOP, SIGTSTP, SIGTRAP, EXC_BREAKPOINT};
        myUserInitiatedInterruptions = SetsKt.hashSetOf((Object[])cidrLowLevelExceptionArray);
        cidrLowLevelExceptionArray = new CidrLowLevelException[]{WIN_0X80000003, SIGTRAP, EXC_BREAKPOINT};
        mySoftwareBreakpointExceptions = SetsKt.hashSetOf((Object[])cidrLowLevelExceptionArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rJ\u0010\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006J\u0010\u0010\u0011\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0006J\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00060\u0013R\u001e\u0010\u0004\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\b\u001a\u0012\u0012\u0004\u0012\u00020\u00060\u0005j\b\u0012\u0004\u0012\u00020\u0006`\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/cidr/execution/debugger/breakpoints/CidrLowLevelException$Companion;", "", "<init>", "()V", "myUserInitiatedInterruptions", "Ljava/util/HashSet;", "Lcom/jetbrains/cidr/execution/debugger/breakpoints/CidrLowLevelException;", "Lkotlin/collections/HashSet;", "mySoftwareBreakpointExceptions", "detectLowLevelException", "type", "Lcom/jetbrains/cidr/execution/debugger/CidrSuspensionCause$Type;", "reason", "", "isUserInitiatedInterruption", "", "lowLevelException", "isSoftwareBreakpointException", "getSupportedExceptions", "", "intellij.cidr.debugger.core"})
    @SourceDebugExtension(value={"SMAP\nCidrLowLevelException.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CidrLowLevelException.kt\ncom/jetbrains/cidr/execution/debugger/breakpoints/CidrLowLevelException$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,71:1\n295#2,2:72\n774#2:74\n865#2,2:75\n*S KotlinDebug\n*F\n+ 1 CidrLowLevelException.kt\ncom/jetbrains/cidr/execution/debugger/breakpoints/CidrLowLevelException$Companion\n*L\n48#1:72,2\n60#1:74\n60#1:75,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final CidrLowLevelException detectLowLevelException(@NotNull CidrSuspensionCause.Type type, @NotNull String reason) {
            Object v1;
            block2: {
                boolean isSupportedType;
                Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
                Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
                boolean bl = isSupportedType = type == CidrSuspensionCause.Type.EXCEPTION || type == CidrSuspensionCause.Type.SIGNAL;
                if (!isSupportedType) {
                    return null;
                }
                String withoutPrefix = StringsKt.removePrefix((String)reason, (CharSequence)"Exception ");
                Iterable $this$firstOrNull$iv = (Iterable)CidrLowLevelException.getEntries();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    CidrLowLevelException it = (CidrLowLevelException)((Object)element$iv);
                    boolean bl2 = false;
                    if (!StringsKt.startsWith((String)withoutPrefix, (String)it.getIdentifier(), (boolean)true)) continue;
                    v1 = element$iv;
                    break block2;
                }
                v1 = null;
            }
            return v1;
        }

        public final boolean isUserInitiatedInterruption(@Nullable CidrLowLevelException lowLevelException) {
            return lowLevelException != null && myUserInitiatedInterruptions.contains((Object)lowLevelException);
        }

        public final boolean isSoftwareBreakpointException(@Nullable CidrLowLevelException lowLevelException) {
            return lowLevelException != null && mySoftwareBreakpointExceptions.contains((Object)lowLevelException);
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final List<CidrLowLevelException> getSupportedExceptions() {
            void $this$filterTo$iv$iv;
            Iterable $this$filter$iv = (Iterable)CidrLowLevelException.getEntries();
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                CidrLowLevelException it = (CidrLowLevelException)((Object)element$iv$iv);
                boolean bl = false;
                if (!(switch (WhenMappings.$EnumSwitchMapping$0[it.getKind().ordinal()]) {
                    case 1 -> SystemInfo.isWindows;
                    case 2 -> true;
                    case 3 -> SystemInfo.isMac;
                    case 4 -> false;
                    default -> throw new NoWhenBranchMatchedException();
                })) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            return (List)destination$iv$iv;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 2, 0}, k=3, xi=48)
        public static final class WhenMappings {
            public static final /* synthetic */ int[] $EnumSwitchMapping$0;

            static {
                int[] nArray = new int[Kind.values().length];
                try {
                    nArray[Kind.WIN32_EXCEPTION.ordinal()] = 1;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Kind.UNIX_SIGNAL.ordinal()] = 2;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Kind.MACH_EXCEPTION.ordinal()] = 3;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                try {
                    nArray[Kind.UNKNOWN.ordinal()] = 4;
                }
                catch (NoSuchFieldError noSuchFieldError) {
                    // empty catch block
                }
                $EnumSwitchMapping$0 = nArray;
            }
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0016\b\u0002\u0012\u000b\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0016\u0010\u0002\u001a\u00070\u0003\u00a2\u0006\u0002\b\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bj\u0002\b\tj\u0002\b\nj\u0002\b\u000bj\u0002\b\f\u00a8\u0006\r"}, d2={"Lcom/jetbrains/cidr/execution/debugger/breakpoints/CidrLowLevelException$Kind;", "", "description", "", "Lorg/jetbrains/annotations/Nls;", "<init>", "(Ljava/lang/String;ILjava/lang/String;)V", "getDescription", "()Ljava/lang/String;", "WIN32_EXCEPTION", "UNIX_SIGNAL", "MACH_EXCEPTION", "UNKNOWN", "intellij.cidr.debugger.core"})
    public static final class Kind
    extends Enum<Kind> {
        @NotNull
        private final String description;
        public static final /* enum */ Kind WIN32_EXCEPTION;
        public static final /* enum */ Kind UNIX_SIGNAL;
        public static final /* enum */ Kind MACH_EXCEPTION;
        public static final /* enum */ Kind UNKNOWN;
        private static final /* synthetic */ Kind[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        private Kind(String description) {
            this.description = description;
        }

        @NotNull
        public final String getDescription() {
            return this.description;
        }

        public static Kind[] values() {
            return (Kind[])$VALUES.clone();
        }

        public static Kind valueOf(String value) {
            return Enum.valueOf(Kind.class, value);
        }

        @NotNull
        public static EnumEntries<Kind> getEntries() {
            return $ENTRIES;
        }

        static {
            String string = CidrDebuggerBundle.message("debug.lowLevel.exception.win32.kind", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            WIN32_EXCEPTION = new Kind(string);
            String string2 = CidrDebuggerBundle.message("debug.lowLevel.exception.unix.signal.kind", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
            UNIX_SIGNAL = new Kind(string2);
            String string3 = CidrDebuggerBundle.message("debug.lowLevel.exception.mach.kind", new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
            MACH_EXCEPTION = new Kind(string3);
            UNKNOWN = new Kind("");
            $VALUES = kindArray = new Kind[]{Kind.WIN32_EXCEPTION, Kind.UNIX_SIGNAL, Kind.MACH_EXCEPTION, Kind.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }
}

