/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.intellij.xdebugger.frame.XValue;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageViewer;
import com.jetbrains.cidr.execution.debugger.actions.CidrImageViewerProvider;
import com.jetbrains.cidr.execution.debugger.actions.CidrPointerImageViewer;
import com.jetbrains.cidr.execution.debugger.backend.LLValueData;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.memory.Address;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/jetbrains/cidr/execution/debugger/actions/CidrPointerImageViewerProvider;", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageViewerProvider;", "<init>", "()V", "getImageViewer", "Lcom/jetbrains/cidr/execution/debugger/actions/CidrImageViewer;", "value", "Lcom/intellij/xdebugger/frame/XValue;", "intellij.cidr.debugger.core"})
public final class CidrPointerImageViewerProvider
implements CidrImageViewerProvider {
    @Override
    @Nullable
    public CidrImageViewer getImageViewer(@NotNull XValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        if (value instanceof CidrPhysicalValue && ((CidrPhysicalValue)value).isValueDataAvailable()) {
            LLValueData lLValueData = ((CidrPhysicalValue)value).getPreparedVarData();
            Intrinsics.checkNotNullExpressionValue((Object)lLValueData, (String)"getPreparedVarData(...)");
            LLValueData data = lLValueData;
            if (data.isValidPointer()) {
                String string = data.getPointer();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPointer(...)");
                Address startAddress = Address.Companion.parseHexString(string);
                if (startAddress.isNull()) {
                    return null;
                }
                return new CidrPointerImageViewer((CidrPhysicalValue)value);
            }
        }
        return null;
    }
}

