/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputType;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.io.BaseDataReader;
import com.intellij.util.io.BaseOutputReader;
import com.intellij.util.system.OS;
import com.jetbrains.cidr.CidrLogService;
import com.jetbrains.cidr.NamedPipe;
import com.jetbrains.cidr.execution.WinPipe;
import com.jetbrains.cidr.system.CidrProcessBuilder;
import com.jetbrains.cidr.system.HostMachine;
import com.jetbrains.cidr.system.RemoteUnixPipe;
import com.pty4j.unix.Pty;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;

public abstract class ProcessOutputReaders {
    private final AtomicReference<ProcessOutputReader[]> myReaders;
    private final String myPresentableName;
    private final Charset myCharset;
    private final boolean myEmulateTerminal;

    public ProcessOutputReaders(@NotNull HostMachine host, @NotNull String presentableName, @NotNull Charset charset, boolean usePtyOnUnix) throws ExecutionException {
        if (host == null) {
            ProcessOutputReaders.$$$reportNull$$$0(0);
        }
        if (presentableName == null) {
            ProcessOutputReaders.$$$reportNull$$$0(1);
        }
        if (charset == null) {
            ProcessOutputReaders.$$$reportNull$$$0(2);
        }
        this(host, presentableName, charset, usePtyOnUnix, false);
    }

    public ProcessOutputReaders(@NotNull HostMachine host, @NotNull String presentableName, @NotNull Charset charset, boolean usePtyOnUnix, boolean emulateTerminal) throws ExecutionException {
        if (host == null) {
            ProcessOutputReaders.$$$reportNull$$$0(3);
        }
        if (presentableName == null) {
            ProcessOutputReaders.$$$reportNull$$$0(4);
        }
        if (charset == null) {
            ProcessOutputReaders.$$$reportNull$$$0(5);
        }
        this.myReaders = new AtomicReference<ProcessOutputReader[]>(new ProcessOutputReader[2]);
        this.myPresentableName = presentableName;
        this.myCharset = charset;
        this.myEmulateTerminal = emulateTerminal;
        OS osType = host.getOS();
        try {
            ProcessOutputReader[] readers = this.getReaders();
            if (osType == OS.Windows) {
                readers[0] = new MyWinPipeOutputReader(this, ProcessOutputTypes.STDOUT);
                if (!emulateTerminal) {
                    readers[1] = new MyWinPipeOutputReader(this, ProcessOutputTypes.STDERR);
                }
            } else if (usePtyOnUnix && host.isRemote()) {
                readers[0] = this.createRemoteUnixPipeReader(host.openNamedPipe(), ProcessOutputTypes.STDOUT);
                readers[1] = this.createRemoteUnixPipeReader(host.openNamedPipe(), ProcessOutputTypes.STDERR);
            } else if (usePtyOnUnix) {
                readers[0] = new MyUnixPtyOutputReader(this, ProcessOutputTypes.STDOUT);
                readers[1] = new MyUnixPtyOutputReader(this, ProcessOutputTypes.STDERR);
            } else {
                readers[0] = new MyFileOutputReader(this, ProcessOutputTypes.STDOUT);
                readers[1] = new MyFileOutputReader(this, ProcessOutputTypes.STDERR);
            }
            readers[0].start();
            if (readers[1] != null) {
                readers[1].start();
            }
        }
        catch (IOException e) {
            throw new ExecutionException("Cannot create output file", (Throwable)e);
        }
    }

    public String getOutFileAbsolutePath() throws ExecutionException {
        return this.getReader(0).getFileAbsolutePath();
    }

    public String getErrFileAbsolutePath() throws ExecutionException {
        return this.getReader(1).getFileAbsolutePath();
    }

    private ProcessOutputReader[] getReaders() {
        return this.myReaders.get();
    }

    private ProcessOutputReader getReader(int num) throws ExecutionException {
        Object[] readers = this.getReaders();
        if (ArrayUtil.isEmpty((Object[])readers)) {
            throw new ExecutionException("Reader is closed");
        }
        return readers[num];
    }

    private static boolean doWaitFor(ProcessOutputReader[] readers, long timeout, TimeUnit unit) {
        for (ProcessOutputReader each : readers) {
            try {
                if (each == null) continue;
                each.waitFor(timeout, unit);
            }
            catch (InterruptedException e) {
                Thread.interrupted();
                return false;
            }
            catch (TimeoutException e) {
                return false;
            }
        }
        return true;
    }

    public boolean waitFor(long timeout, TimeUnit unit) {
        return ProcessOutputReaders.doWaitFor(this.getReaders(), timeout, unit);
    }

    public void close() {
        ProcessOutputReader[] readers;
        for (ProcessOutputReader each : readers = this.myReaders.getAndSet(new ProcessOutputReader[0])) {
            if (each == null) continue;
            each.stop();
        }
        ProcessOutputReaders.doWaitFor(readers, Long.MAX_VALUE, TimeUnit.MILLISECONDS);
    }

    protected abstract void onTextAvailable(@NotNull String var1, @NotNull Key<?> var2);

    private void handleTextAvailable(@NotNull String text, @NotNull Key<?> type) {
        if (text == null) {
            ProcessOutputReaders.$$$reportNull$$$0(6);
        }
        if (type == null) {
            ProcessOutputReaders.$$$reportNull$$$0(7);
        }
        if (!this.myEmulateTerminal) {
            text = StringUtil.trimEnd((String)text, (String)"\r");
            text = StringUtil.convertLineSeparators((String)text);
        }
        this.onTextAvailable(text, type);
    }

    @NotNull
    private ProcessOutputReader createRemoteUnixPipeReader(@NotNull NamedPipe pipe, @NotNull Key<?> type) throws IOException, ExecutionException {
        if (pipe == null) {
            ProcessOutputReaders.$$$reportNull$$$0(8);
        }
        if (type == null) {
            ProcessOutputReaders.$$$reportNull$$$0(9);
        }
        if (pipe instanceof RemoteUnixPipe) {
            RemoteUnixPipe remoteUnixPipe = (RemoteUnixPipe)pipe;
            return new MyRemoteUnixPipeOutputReader(remoteUnixPipe, type);
        }
        throw new IllegalArgumentException("Unsupported named pipe: " + pipe.getClass().getName());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "host";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "presentableName";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "charset";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "text";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pipe";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/execution/ProcessOutputReaders";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "handleTextAvailable";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "createRemoteUnixPipeReader";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static interface ProcessOutputReader {
        public void start();

        public void stop();

        public void waitFor(long var1, TimeUnit var3) throws InterruptedException, TimeoutException;

        @NotNull
        public String getFileAbsolutePath();
    }

    protected class MyWinPipeOutputReader
    extends ProcessOutputStreamReader {
        @NotNull
        private final WinPipe myPipe;
        final /* synthetic */ ProcessOutputReaders this$0;

        protected MyWinPipeOutputReader(@NotNull ProcessOutputReaders this$0, Key type) throws IOException {
            if (type == null) {
                MyWinPipeOutputReader.$$$reportNull$$$0(0);
            }
            this(this$0, WinPipe.createInboundPipe(type.toString()), type);
        }

        protected MyWinPipeOutputReader(@NotNull ProcessOutputReaders this$0, @NotNull WinPipe pipe, Key type) {
            if (pipe == null) {
                MyWinPipeOutputReader.$$$reportNull$$$0(1);
            }
            if (type == null) {
                MyWinPipeOutputReader.$$$reportNull$$$0(2);
            }
            this.this$0 = this$0;
            super(type, pipe.getName(), pipe.getInputStream(), BaseDataReader.SleepingPolicy.BLOCKING);
            this.myPipe = pipe;
        }

        protected void doRun() {
            try {
                if (!this.myPipe.waitForConnection()) {
                    CidrLogService.LOG.error(String.format("Stream reading can't be initiated: couldn't connect to pipe %s. ", this.myPipe.getName()));
                    return;
                }
            }
            catch (IOException e) {
                CidrLogService.LOG.debug((Throwable)e);
                try {
                    this.close();
                }
                catch (IOException eClose) {
                    CidrLogService.LOG.error("Can't close stream", (Throwable)eClose);
                }
                return;
            }
            super.doRun();
        }

        protected void close() throws IOException {
            try {
                super.close();
            }
            finally {
                this.myPipe.close();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pipe";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/ProcessOutputReaders$MyWinPipeOutputReader";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class MyUnixPtyOutputReader
    extends ProcessOutputStreamReader {
        final /* synthetic */ ProcessOutputReaders this$0;

        protected MyUnixPtyOutputReader(@NotNull ProcessOutputReaders this$0, Key type) throws IOException {
            if (type == null) {
                MyUnixPtyOutputReader.$$$reportNull$$$0(0);
            }
            this(this$0, new Pty(), type);
        }

        protected MyUnixPtyOutputReader(@NotNull ProcessOutputReaders this$0, @NotNull Pty pty, Key type) {
            if (pty == null) {
                MyUnixPtyOutputReader.$$$reportNull$$$0(1);
            }
            if (type == null) {
                MyUnixPtyOutputReader.$$$reportNull$$$0(2);
            }
            this.this$0 = this$0;
            super(type, pty.getSlaveName(), pty.getInputStream(), BaseDataReader.SleepingPolicy.BLOCKING);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "pty";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/ProcessOutputReaders$MyUnixPtyOutputReader";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    protected class MyFileOutputReader
    extends ProcessOutputStreamReader {
        @NotNull
        private final File myFileToDelete;
        final /* synthetic */ ProcessOutputReaders this$0;

        protected MyFileOutputReader(@NotNull ProcessOutputReaders this$0, Key type) throws IOException {
            if (type == null) {
                MyFileOutputReader.$$$reportNull$$$0(0);
            }
            this(this$0, FileUtil.createTempFile((String)this$0.getClass().getSimpleName(), (String)type.toString(), (boolean)true), type);
        }

        protected MyFileOutputReader(@NotNull ProcessOutputReaders this$0, @NotNull File file, Key type) throws IOException {
            if (file == null) {
                MyFileOutputReader.$$$reportNull$$$0(1);
            }
            if (type == null) {
                MyFileOutputReader.$$$reportNull$$$0(2);
            }
            this.this$0 = this$0;
            super(type, file.getAbsolutePath(), new FileInputStream(file), BaseDataReader.SleepingPolicy.NON_BLOCKING);
            this.myFileToDelete = file;
        }

        protected void close() throws IOException {
            try {
                super.close();
            }
            finally {
                FileUtil.delete((File)this.myFileToDelete);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "type";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "file";
                    break;
                }
            }
            objectArray[1] = "com/jetbrains/cidr/execution/ProcessOutputReaders$MyFileOutputReader";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyRemoteUnixPipeOutputReader
    implements ProcessOutputReader {
        private final RemoteUnixPipe myPipe;
        private final BaseProcessHandler<?> myProcessHandler;

        private MyRemoteUnixPipeOutputReader(@NotNull RemoteUnixPipe pipe, final Key<?> type) throws ExecutionException {
            if (pipe == null) {
                MyRemoteUnixPipeOutputReader.$$$reportNull$$$0(0);
            }
            if (type == null) {
                MyRemoteUnixPipeOutputReader.$$$reportNull$$$0(1);
            }
            this.myPipe = pipe;
            Function<CidrProcessBuilder, CidrProcessBuilder> config = builder -> builder.withShortLived(true);
            this.myProcessHandler = pipe.createInputStreamHandler(config);
            this.myProcessHandler.addProcessListener(new ProcessListener(){

                public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                    if (event == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (outputType == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (outputType != ProcessOutputType.SYSTEM) {
                        ProcessOutputReaders.this.handleTextAvailable(event.getText(), type);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "event";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "outputType";
                            break;
                        }
                    }
                    objectArray[1] = "com/jetbrains/cidr/execution/ProcessOutputReaders$MyRemoteUnixPipeOutputReader$1";
                    objectArray[2] = "onTextAvailable";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            });
        }

        @Override
        public void start() {
            this.myProcessHandler.startNotify();
        }

        @Override
        public void stop() {
            this.myPipe.close();
        }

        @Override
        public void waitFor(long timeout, TimeUnit unit) {
            this.myProcessHandler.waitFor(unit.toMillis(timeout));
        }

        @Override
        @NotNull
        public String getFileAbsolutePath() {
            String string = this.myPipe.getName();
            if (string == null) {
                MyRemoteUnixPipeOutputReader.$$$reportNull$$$0(2);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pipe";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/ProcessOutputReaders$MyRemoteUnixPipeOutputReader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/ProcessOutputReaders$MyRemoteUnixPipeOutputReader";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileAbsolutePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    public static class ReaderOptions
    extends BaseOutputReader.Options {
        private final BaseDataReader.SleepingPolicy myPolicy;

        public ReaderOptions(BaseDataReader.SleepingPolicy policy) {
            this.myPolicy = policy;
        }

        public BaseDataReader.SleepingPolicy policy() {
            return this.myPolicy;
        }

        public boolean splitToLines() {
            return false;
        }
    }

    protected class ProcessOutputStreamReader
    extends BaseOutputReader
    implements ProcessOutputReader {
        @NotNull
        private final Key<?> myType;
        @NotNull
        private final String myFileAbsolutePath;

        protected ProcessOutputStreamReader(@NotNull Key<?> type, @NotNull String fileAbsolutePath, InputStream stream, BaseDataReader.SleepingPolicy policy) {
            if (type == null) {
                ProcessOutputStreamReader.$$$reportNull$$$0(0);
            }
            if (fileAbsolutePath == null) {
                ProcessOutputStreamReader.$$$reportNull$$$0(1);
            }
            if (stream == null) {
                ProcessOutputStreamReader.$$$reportNull$$$0(2);
            }
            super(stream, ProcessOutputReaders.this.myCharset, (BaseOutputReader.Options)new ReaderOptions(policy));
            this.myType = type;
            this.myFileAbsolutePath = fileAbsolutePath;
        }

        @Override
        public void start() {
            this.start(ProcessOutputReaders.this.myPresentableName);
        }

        protected void onTextAvailable(@NotNull String text) {
            if (text == null) {
                ProcessOutputStreamReader.$$$reportNull$$$0(3);
            }
            ProcessOutputReaders.this.handleTextAvailable(text, this.myType);
        }

        @NotNull
        protected Future<?> executeOnPooledThread(@NotNull Runnable runnable) {
            if (runnable == null) {
                ProcessOutputStreamReader.$$$reportNull$$$0(4);
            }
            Future future = ApplicationManager.getApplication().executeOnPooledThread(runnable);
            if (future == null) {
                ProcessOutputStreamReader.$$$reportNull$$$0(5);
            }
            return future;
        }

        @Override
        public void stop() {
            super.stop();
            if (this.mySleepingPolicy == BaseDataReader.SleepingPolicy.BLOCKING) {
                try {
                    this.waitFor(this.mySleepingPolicy.getTimeToSleep(false), TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException | TimeoutException ignored) {
                    try {
                        this.close();
                    }
                    catch (IOException e) {
                        CidrLogService.LOG.error((Throwable)e);
                    }
                }
            }
        }

        @Override
        @NotNull
        public String getFileAbsolutePath() {
            String string = this.myFileAbsolutePath;
            if (string == null) {
                ProcessOutputStreamReader.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 5, 6 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "type";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileAbsolutePath";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stream";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/cidr/execution/ProcessOutputReaders$ProcessOutputStreamReader";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/cidr/execution/ProcessOutputReaders$ProcessOutputStreamReader";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "executeOnPooledThread";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getFileAbsolutePath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "onTextAvailable";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "executeOnPooledThread";
                    break;
                }
                case 5: 
                case 6: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 5, 6 -> new IllegalStateException(string);
            };
        }
    }
}

