/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution;

import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.util.Map;
import java.util.StringTokenizer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CidrExecUtil {
    private static final int ERROR_MESSAGE_WRAP_LENGTH = 80;

    @NotNull
    public static Map<String, String> appendBuildPathVars(@NotNull Map<String, String> env, @Nullable String buildPath) {
        if (env == null) {
            CidrExecUtil.$$$reportNull$$$0(0);
        }
        CidrExecUtil.appendSearchPath(env, "DYLD_LIBRARY_PATH", buildPath);
        CidrExecUtil.appendSearchPath(env, "DYLD_FRAMEWORK_PATH", buildPath);
        CidrExecUtil.appendSearchPath(env, "__XPC_DYLD_LIBRARY_PATH", buildPath);
        CidrExecUtil.appendSearchPath(env, "__XPC_DYLD_FRAMEWORK_PATH", buildPath);
        Map<String, String> map = env;
        if (map == null) {
            CidrExecUtil.$$$reportNull$$$0(1);
        }
        return map;
    }

    public static void setIfAbsent(@NotNull Map<String, String> env, @NotNull String paramName, @Nullable String value) {
        if (env == null) {
            CidrExecUtil.$$$reportNull$$$0(2);
        }
        if (paramName == null) {
            CidrExecUtil.$$$reportNull$$$0(3);
        }
        if (value != null && !env.containsKey(paramName)) {
            env.put(paramName, value);
        }
    }

    public static void appendSearchPath(@NotNull Map<String, String> env, @NotNull @NonNls String paramName, @Nullable String appendPath) {
        if (env == null) {
            CidrExecUtil.$$$reportNull$$$0(4);
        }
        if (paramName == null) {
            CidrExecUtil.$$$reportNull$$$0(5);
        }
        if (appendPath == null) {
            return;
        }
        Object result = env.get(paramName);
        result = result != null ? (String)result + File.pathSeparator + appendPath : appendPath;
        env.put(paramName, (String)result);
    }

    @Contract(pure=true)
    public static String wrapErrorOutput(@NotNull String str) {
        if (str == null) {
            CidrExecUtil.$$$reportNull$$$0(6);
        }
        return CidrExecUtil.wrapErrorOutput(str, 80);
    }

    @Contract(pure=true)
    public static String wrapErrorOutput(@NotNull String str, int wrapLen) {
        if (str == null) {
            CidrExecUtil.$$$reportNull$$$0(7);
        }
        String[] lines = StringUtil.splitByLinesKeepSeparators((String)str);
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < lines.length; ++i) {
            StringTokenizer st = new StringTokenizer(lines[i], " \n\r");
            if (st.hasMoreTokens()) {
                String word = st.nextToken();
                result.append(word);
                int lineLen = word.length();
                while (st.hasMoreTokens()) {
                    word = st.nextToken();
                    int wordLen = word.length();
                    if (lineLen + wordLen > wrapLen) {
                        result.append('\n');
                        lineLen = wordLen;
                    } else {
                        result.append(' ');
                        lineLen += wordLen + 1;
                    }
                    result.append(word);
                }
            }
            if (i >= lines.length - 1) continue;
            result.append('\n');
        }
        return result.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "env";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/execution/CidrExecUtil";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramName";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/execution/CidrExecUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "appendBuildPathVars";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "appendBuildPathVars";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setIfAbsent";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "appendSearchPath";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "wrapErrorOutput";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

