/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.CLanguageKind;
import com.jetbrains.cidr.lang.CidrLangUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileLangBackendHandlerProvider;
import java.awt.Dimension;
import java.util.Collection;
import java.util.List;
import java.util.Properties;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCNewFileHelperUtil {
    private static final String PROJECT_TEMPLATE_PROPERTY1 = "PROJECT_NAME";
    private static final String PROJECT_TEMPLATE_PROPERTY2 = "PROJECTNAME";

    public static void addCreatedFiles(@NotNull PsiDirectory directory, String @NotNull [] fileNames, PsiFile @NotNull [] resultElements, @NotNull Project project, @NotNull Function<? super VirtualFile, Void> fileHandler) {
        if (directory == null) {
            OCNewFileHelperUtil.$$$reportNull$$$0(0);
        }
        if (project == null) {
            OCNewFileHelperUtil.$$$reportNull$$$0(1);
        }
        if (fileHandler == null) {
            OCNewFileHelperUtil.$$$reportNull$$$0(2);
        }
        if (fileNames == null) {
            OCNewFileHelperUtil.$$$reportNull$$$0(3);
        }
        if (resultElements == null) {
            OCNewFileHelperUtil.$$$reportNull$$$0(4);
        }
        for (int i = 0; i < resultElements.length; ++i) {
            PsiFile file = resultElements[i];
            file = file == null ? directory.createFile(fileNames[i]) : (PsiFile)directory.add((PsiElement)file);
            VirtualFile virtualFile = file.getVirtualFile();
            if (virtualFile != null) {
                CommandProcessor.getInstance().addAffectedFiles(project, new VirtualFile[]{virtualFile});
                fileHandler.fun((Object)virtualFile);
            }
            resultElements[i] = file;
            CodeStyleManager.getInstance((Project)project).reformat((PsiElement)file);
            OCNewFileLangBackendHandlerProvider.getHandler().handleCreatedFile(file);
        }
    }

    public static void fillCommonTemplateProperties(@NotNull Properties properties, @Nullable String projectName) {
        if (properties == null) {
            OCNewFileHelperUtil.$$$reportNull$$$0(5);
        }
        properties.setProperty(PROJECT_TEMPLATE_PROPERTY1, projectName);
        properties.setProperty(PROJECT_TEMPLATE_PROPERTY2, projectName);
    }

    public static <T extends OCNewFileActionBase.CreateFileDialogBase> void initPropertyField(final T dialog, final JTextField textEdit, final Ref<String> property) {
        textEdit.setMinimumSize(new Dimension(250, textEdit.getPreferredSize().height));
        textEdit.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(@NotNull DocumentEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                property.set((Object)textEdit.getText());
                dialog.validateOkAction();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/cidr/lang/actions/newFile/OCNewFileHelperUtil$1", "textChanged"));
            }
        });
    }

    public static <T extends OCNewFileActionBase.CreateFileDialogBase> void addTextEdit(T dialog, FormBuilder formBuilder, @NotNull @NonNls Ref<String> property, @NotNull @NonNls String defaultValue, @NlsContexts.Label @NotNull String label) {
        if (property == null) {
            OCNewFileHelperUtil.$$$reportNull$$$0(6);
        }
        if (defaultValue == null) {
            OCNewFileHelperUtil.$$$reportNull$$$0(7);
        }
        if (label == null) {
            OCNewFileHelperUtil.$$$reportNull$$$0(8);
        }
        JTextField textEdit = new JTextField();
        textEdit.setText(defaultValue);
        OCNewFileHelperUtil.initPropertyField(dialog, textEdit, property);
        formBuilder.addLabeledComponent(label, (JComponent)textEdit);
    }

    public static boolean isValidNamespaceName(@NotNull String namespaceName) {
        if (namespaceName == null) {
            OCNewFileHelperUtil.$$$reportNull$$$0(9);
        }
        if (!(namespaceName = namespaceName.trim()).isEmpty() && !CidrLangUtil.isIdentifier(namespaceName, (OCLanguageKind)CLanguageKind.CPP, null)) {
            @NotNull List subNamespaces = StringUtil.split((String)namespaceName, (String)"::", (boolean)true, (boolean)false);
            return ContainerUtil.all((Collection)subNamespaces, name -> !name.trim().isEmpty() && CidrLangUtil.isIdentifier(name.trim(), (OCLanguageKind)CLanguageKind.CPP, null));
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "directory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileHandler";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileNames";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resultElements";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "label";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "namespaceName";
                break;
            }
        }
        objectArray2[1] = "com/jetbrains/cidr/lang/actions/newFile/OCNewFileHelperUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "addCreatedFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "fillCommonTemplateProperties";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "addTextEdit";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "isValidNamespaceName";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

